/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicSliderUI
extends SliderUI {
    public static final int POSITIVE_SCROLL = 1;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int MIN_SCROLL = -2;
    public static final int MAX_SCROLL = 2;
    protected Timer scrollTimer;
    protected JSlider slider;
    protected Insets focusInsets = null;
    protected Insets insetCache = null;
    protected boolean leftToRightCache = true;
    protected Rectangle focusRect = null;
    protected Rectangle contentRect = null;
    protected Rectangle labelRect = null;
    protected Rectangle tickRect = null;
    protected Rectangle trackRect = null;
    protected Rectangle thumbRect = null;
    protected int trackBuffer = 0;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(200, 21);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(21, 200);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 21);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(21, 36);
    private transient boolean isDragging;
    protected TrackListener trackListener;
    protected ChangeListener changeListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    private Color shadowColor;
    private Color highlightColor;
    private Color focusColor;
    private static Rectangle unionRect = new Rectangle();

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSliderUI((JSlider)jComponent);
    }

    public BasicSliderUI(JSlider jSlider) {
    }

    public void installUI(JComponent jComponent) {
        this.slider = (JSlider)jComponent;
        this.slider.setEnabled(this.slider.isEnabled());
        this.slider.setOpaque(true);
        this.isDragging = false;
        this.trackListener = this.createTrackListener(this.slider);
        this.changeListener = this.createChangeListener(this.slider);
        this.componentListener = this.createComponentListener(this.slider);
        this.focusListener = this.createFocusListener(this.slider);
        this.scrollListener = this.createScrollListener(this.slider);
        this.propertyChangeListener = this.createPropertyChangeListener(this.slider);
        this.installDefaults(this.slider);
        this.installListeners(this.slider);
        this.installKeyboardActions(this.slider);
        this.scrollTimer = new Timer(100, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
        this.insetCache = this.slider.getInsets();
        this.leftToRightCache = BasicGraphicsUtils.isLeftToRight(this.slider);
        this.focusRect = new Rectangle();
        this.contentRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.tickRect = new Rectangle();
        this.trackRect = new Rectangle();
        this.thumbRect = new Rectangle();
        this.calculateGeometry();
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.slider) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this.slider + ".");
        }
        LookAndFeel.uninstallBorder(this.slider);
        this.scrollTimer.stop();
        this.scrollTimer = null;
        this.uninstallListeners(this.slider);
        this.uninstallKeyboardActions(this.slider);
        this.focusInsets = null;
        this.insetCache = null;
        this.leftToRightCache = true;
        this.focusRect = null;
        this.contentRect = null;
        this.labelRect = null;
        this.tickRect = null;
        this.trackRect = null;
        this.thumbRect = null;
        this.trackListener = null;
        this.changeListener = null;
        this.componentListener = null;
        this.focusListener = null;
        this.scrollListener = null;
        this.propertyChangeListener = null;
        this.slider = null;
    }

    protected void installDefaults(JSlider jSlider) {
        LookAndFeel.installBorder(jSlider, "Slider.border");
        LookAndFeel.installColors(jSlider, "Slider.background", "Slider.foreground");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.focusInsets = (Insets)UIManager.get("Slider.focusInsets");
    }

    protected TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener();
    }

    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler();
    }

    protected ComponentListener createComponentListener(JSlider jSlider) {
        return new ComponentHandler();
    }

    protected FocusListener createFocusListener(JSlider jSlider) {
        return new FocusHandler();
    }

    protected ScrollListener createScrollListener(JSlider jSlider) {
        return new ScrollListener();
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new PropertyChangeHandler();
    }

    protected void installListeners(JSlider jSlider) {
        jSlider.addMouseListener(this.trackListener);
        jSlider.addMouseMotionListener(this.trackListener);
        jSlider.addFocusListener(this.focusListener);
        jSlider.addComponentListener(this.componentListener);
        jSlider.addPropertyChangeListener(this.propertyChangeListener);
        jSlider.getModel().addChangeListener(this.changeListener);
    }

    protected void uninstallListeners(JSlider jSlider) {
        jSlider.removeMouseListener(this.trackListener);
        jSlider.removeMouseMotionListener(this.trackListener);
        jSlider.removeFocusListener(this.focusListener);
        jSlider.removeComponentListener(this.componentListener);
        jSlider.removePropertyChangeListener(this.propertyChangeListener);
        jSlider.getModel().removeChangeListener(this.changeListener);
    }

    protected void installKeyboardActions(JSlider jSlider) {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(jSlider, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jSlider, actionMap);
    }

    InputMap getInputMap(int n) {
        if (n == 0) {
            return (InputMap)UIManager.get("Slider.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Slider.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("Slider.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("positiveUnitIncrement", new SharedActionScroller(1, false));
        actionMapUIResource.put("positiveBlockIncrement", new SharedActionScroller(1, true));
        actionMapUIResource.put("negativeUnitIncrement", new SharedActionScroller(-1, false));
        actionMapUIResource.put("negativeBlockIncrement", new SharedActionScroller(-1, true));
        actionMapUIResource.put("minScroll", new SharedActionScroller(-2, true));
        actionMapUIResource.put("maxScroll", new SharedActionScroller(2, true));
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions(JSlider jSlider) {
        SwingUtilities.replaceUIActionMap(jSlider, null);
        SwingUtilities.replaceUIInputMap(jSlider, 0, null);
    }

    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getPreferredVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        } else {
            dimension = new Dimension(this.getPreferredHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getMinimumVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        } else {
            dimension = new Dimension(this.getMinimumHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.slider.getOrientation() == 1) {
            dimension.height = Short.MAX_VALUE;
        } else {
            dimension.width = Short.MAX_VALUE;
        }
        return dimension;
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        this.focusRect.x = this.insetCache.left;
        this.focusRect.y = this.insetCache.top;
        this.focusRect.width = this.slider.getWidth() - (this.insetCache.left + this.insetCache.right);
        this.focusRect.height = this.slider.getHeight() - (this.insetCache.top + this.insetCache.bottom);
    }

    protected void calculateThumbSize() {
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - (this.focusInsets.left + this.focusInsets.right);
        this.contentRect.height = this.focusRect.height - (this.focusInsets.top + this.focusInsets.bottom);
    }

    protected void calculateThumbLocation() {
        int n;
        if (this.slider.getSnapToTicks()) {
            int n2 = n = this.slider.getValue();
            int n3 = this.slider.getMajorTickSpacing();
            int n4 = this.slider.getMinorTickSpacing();
            int n5 = 0;
            if (n4 > 0) {
                n5 = n4;
            } else if (n3 > 0) {
                n5 = n3;
            }
            if (n5 != 0) {
                if ((n - this.slider.getMinimum()) % n5 != 0) {
                    float f = (float)(n - this.slider.getMinimum()) / (float)n5;
                    int n6 = Math.round(f);
                    n2 = this.slider.getMinimum() + n6 * n5;
                }
                if (n2 != n) {
                    this.slider.setValue(n2);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = n - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            n = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = n - this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Component component = this.getHighestValueLabel();
            Component component2 = this.getLowestValueLabel();
            if (this.slider.getOrientation() == 0) {
                this.trackBuffer = Math.max(component.getBounds().width, component2.getBounds().width) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.width / 2);
            } else {
                this.trackBuffer = Math.max(component.getBounds().height, component2.getBounds().height) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.height / 2);
            }
        } else {
            this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
            this.trackRect.height = this.thumbRect.height;
        } else {
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                this.trackRect.x = this.contentRect.x;
            } else {
                int n = 0;
                if (this.slider.getPaintTicks()) {
                    n = this.getTickLength();
                }
                this.trackRect.x = this.contentRect.x + n + this.getWidthOfWidestLabel();
            }
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    protected void calculateLabelRect() {
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    this.labelRect.x = this.tickRect.x + this.tickRect.width;
                    this.labelRect.width = this.getWidthOfWidestLabel();
                } else {
                    this.labelRect.width = this.getWidthOfWidestLabel();
                    this.labelRect.x = this.tickRect.x - this.labelRect.width;
                }
                this.labelRect.y = this.tickRect.y - this.trackBuffer;
                this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
            }
        } else if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.tickRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.tickRect.width;
            this.labelRect.height = 0;
        } else {
            this.labelRect.x = BasicGraphicsUtils.isLeftToRight(this.slider) ? this.tickRect.x + this.tickRect.width : this.tickRect.x;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = 20;
            dimension.height = 11;
        } else {
            dimension.width = 11;
            dimension.height = 20;
        }
        return dimension;
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n = Math.max(component.getPreferredSize().width, n);
            }
        }
        return n;
    }

    protected int getHeightOfTallestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n = Math.max(component.getPreferredSize().height, n);
            }
        }
        return n;
    }

    protected int getWidthOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int getWidthOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int getHeightOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().height;
        }
        return n;
    }

    protected int getHeightOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().height;
        }
        return n;
    }

    protected boolean drawInverted() {
        if (this.slider.getOrientation() == 0) {
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                return this.slider.getInverted();
            }
            return !this.slider.getInverted();
        }
        return this.slider.getInverted();
    }

    protected Component getLowestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n2 = (Integer)enumeration.nextElement();
                n = Math.min(n2, n);
            }
            component = (Component)dictionary.get(new Integer(n));
        }
        return component;
    }

    protected Component getHighestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n2 = (Integer)enumeration.nextElement();
                n = Math.max(n2, n);
            }
            component = (Component)dictionary.get(new Integer(n));
        }
        return component;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (this.slider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (this.slider.hasFocus() && rectangle.intersects(this.focusRect)) {
            this.paintFocus(graphics);
        }
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
    }

    protected void recalculateIfInsetsChanged() {
        Insets insets = this.slider.getInsets();
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
    }

    protected void recalculateIfOrientationChanged() {
        boolean bl = BasicGraphicsUtils.isLeftToRight(this.slider);
        if (bl != this.leftToRightCache) {
            this.leftToRightCache = bl;
            this.calculateGeometry();
        }
    }

    public void paintFocus(Graphics graphics) {
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
    }

    public void paintTrack(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n;
            int n2 = n = this.trackBuffer;
            int n3 = rectangle.height / 2 - 2;
            int n4 = rectangle.width;
            graphics.translate(rectangle.x, rectangle.y + n3);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, n4 - 1, 0);
            graphics.drawLine(0, 1, 0, 2);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(0, 3, n4, 3);
            graphics.drawLine(n4, 0, n4, 3);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, n4 - 2, 1);
            graphics.translate(-rectangle.x, -(rectangle.y + n3));
        } else {
            int n = this.trackBuffer;
            int n5 = rectangle.width / 2 - 2;
            int n6 = n;
            int n7 = rectangle.height;
            graphics.translate(rectangle.x + n5, rectangle.y);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, 0, n7 - 1);
            graphics.drawLine(1, 0, 2, 0);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(3, 0, 3, n7);
            graphics.drawLine(0, n7, 3, n7);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, 1, n7 - 2);
            graphics.translate(-(rectangle.x + n5), -rectangle.y);
        }
    }

    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.setColor(this.slider.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        int n3 = this.slider.getMajorTickSpacing();
        int n4 = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            graphics.translate(0, rectangle.y);
            int n5 = this.slider.getMinimum();
            int n6 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                while (n5 <= this.slider.getMaximum()) {
                    n6 = this.xPositionForValue(n5);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n6);
                    n5 += this.slider.getMinorTickSpacing();
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n5 = this.slider.getMinimum();
                while (n5 <= this.slider.getMaximum()) {
                    n6 = this.xPositionForValue(n5);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n6);
                    n5 += this.slider.getMajorTickSpacing();
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            graphics.translate(rectangle.x, 0);
            int n7 = this.slider.getMinimum();
            int n8 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int n9 = 0;
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    n9 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n9, 0);
                }
                while (n7 <= this.slider.getMaximum()) {
                    n8 = this.yPositionForValue(n7);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n8);
                    n7 += this.slider.getMinorTickSpacing();
                }
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(-n9, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n7 = this.slider.getMinimum();
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(2, 0);
                }
                while (n7 <= this.slider.getMaximum()) {
                    n8 = this.yPositionForValue(n7);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n8);
                    n7 += this.slider.getMajorTickSpacing();
                }
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width / 2 - 1, n);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width - 2, n);
    }

    public void paintLabels(Graphics graphics) {
        Rectangle rectangle = this.labelRect;
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                Component component = (Component)dictionary.get(n);
                if (this.slider.getOrientation() == 0) {
                    graphics.translate(0, rectangle.y);
                    this.paintHorizontalLabel(graphics, n, component);
                    graphics.translate(0, -rectangle.y);
                    continue;
                }
                int n2 = 0;
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    n2 = rectangle.width - component.getPreferredSize().width;
                }
                graphics.translate(rectangle.x + n2, 0);
                this.paintVerticalLabel(graphics, n, component);
                graphics.translate(-rectangle.x - n2, 0);
            }
        }
    }

    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.xPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().width / 2;
        graphics.translate(n3, 0);
        component.paint(graphics);
        graphics.translate(-n3, 0);
    }

    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.yPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().height / 2;
        graphics.translate(0, n3);
        component.paint(graphics);
        graphics.translate(0, -n3);
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.isEnabled()) {
            graphics.setColor(this.slider.getBackground());
        } else {
            graphics.setColor(this.slider.getBackground().darker());
        }
        if (!this.slider.getPaintTicks()) {
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.black);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
        } else if (this.slider.getOrientation() == 0) {
            int n3 = n / 2;
            graphics.fillRect(1, 1, n - 3, n2 - 1 - n3);
            Polygon polygon = new Polygon();
            polygon.addPoint(1, n2 - n3);
            polygon.addPoint(n3 - 1, n2 - 1);
            polygon.addPoint(n - 2, n2 - 1 - n3);
            graphics.fillPolygon(polygon);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(0, 1, 0, n2 - 1 - n3);
            graphics.drawLine(0, n2 - n3, n3 - 1, n2 - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 2 - n3);
            graphics.drawLine(n - 1, n2 - 1 - n3, n - 1 - n3, n2 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 2 - n3);
            graphics.drawLine(n - 2, n2 - 1 - n3, n - 1 - n3, n2 - 2);
        } else {
            int n4 = n2 / 2;
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                graphics.fillRect(1, 1, n - 1 - n4, n2 - 3);
                Polygon polygon = new Polygon();
                polygon.addPoint(n - n4 - 1, 0);
                polygon.addPoint(n - 1, n4);
                polygon.addPoint(n - 1 - n4, n2 - 2);
                graphics.fillPolygon(polygon);
                graphics.setColor(this.highlightColor);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(1, 0, n - 1 - n4, 0);
                graphics.drawLine(n - n4 - 1, 0, n - 1, n4);
                graphics.setColor(Color.black);
                graphics.drawLine(0, n2 - 1, n - 2 - n4, n2 - 1);
                graphics.drawLine(n - 1 - n4, n2 - 1, n - 1, n2 - 1 - n4);
                graphics.setColor(this.shadowColor);
                graphics.drawLine(1, n2 - 2, n - 2 - n4, n2 - 2);
                graphics.drawLine(n - 1 - n4, n2 - 2, n - 2, n2 - n4 - 1);
            } else {
                graphics.fillRect(5, 1, n - 1 - n4, n2 - 3);
                Polygon polygon = new Polygon();
                polygon.addPoint(n4, 0);
                polygon.addPoint(0, n4);
                polygon.addPoint(n4, n2 - 2);
                graphics.fillPolygon(polygon);
                graphics.setColor(this.highlightColor);
                graphics.drawLine(n4 - 1, 0, n - 2, 0);
                graphics.drawLine(0, n4, n4, 0);
                graphics.setColor(Color.black);
                graphics.drawLine(0, n2 - 1 - n4, n4, n2 - 1);
                graphics.drawLine(n4, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(this.shadowColor);
                graphics.drawLine(n4, n2 - 2, n - 2, n2 - 2);
                graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void setThumbLocation(int n, int n2) {
        unionRect.setBounds(this.thumbRect);
        this.thumbRect.setLocation(n, n2);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, unionRect);
        this.slider.repaint(BasicSliderUI.unionRect.x, BasicSliderUI.unionRect.y, BasicSliderUI.unionRect.width, BasicSliderUI.unionRect.height);
    }

    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = this.slider.getValue();
            int n3 = this.slider.getMaximum() / 10;
            int n4 = n3 * (n > 0 ? 1 : -1);
            this.slider.setValue(n2 + n4);
        }
    }

    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = this.slider.getValue();
            int n3 = 1 * (n > 0 ? 1 : -1);
            this.slider.setValue(n2 + n3);
        }
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollByBlock(n);
    }

    protected int xPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.width;
        int n6 = this.slider.getMaximum() - this.slider.getMinimum();
        double d = (double)n5 / (double)n6;
        int n7 = this.trackRect.x;
        int n8 = this.trackRect.x + (this.trackRect.width - 1);
        if (!this.drawInverted()) {
            n2 = n7;
            n2 = (int)((long)n2 + Math.round(d * (double)(n - n3)));
        } else {
            n2 = n8;
            n2 = (int)((long)n2 - Math.round(d * (double)(n - n3)));
        }
        n2 = Math.max(n7, n2);
        n2 = Math.min(n8, n2);
        return n2;
    }

    protected int yPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.height;
        int n6 = this.slider.getMaximum() - this.slider.getMinimum();
        double d = (double)n5 / (double)n6;
        int n7 = this.trackRect.y;
        int n8 = this.trackRect.y + (this.trackRect.height - 1);
        if (!this.drawInverted()) {
            n2 = n7;
            n2 = (int)((long)n2 + Math.round(d * (double)(n4 - n)));
        } else {
            n2 = n7;
            n2 = (int)((long)n2 + Math.round(d * (double)(n - n3)));
        }
        n2 = Math.max(n7, n2);
        n2 = Math.min(n8, n2);
        return n2;
    }

    public int valueForYPosition(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.height;
        int n6 = this.trackRect.y;
        int n7 = this.trackRect.y + (this.trackRect.height - 1);
        if (n <= n6) {
            n2 = this.drawInverted() ? n3 : n4;
        } else if (n >= n7) {
            n2 = this.drawInverted() ? n4 : n3;
        } else {
            int n8 = n - n6;
            int n9 = n4 - n3;
            double d = (double)n9 / (double)n5;
            int n10 = (int)Math.round((double)n8 * d);
            n2 = this.drawInverted() ? n3 + n10 : n4 - n10;
        }
        return n2;
    }

    public int valueForXPosition(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.width;
        int n6 = this.trackRect.x;
        int n7 = this.trackRect.x + (this.trackRect.width - 1);
        if (n <= n6) {
            n2 = this.drawInverted() ? n4 : n3;
        } else if (n >= n7) {
            n2 = this.drawInverted() ? n3 : n4;
        } else {
            int n8 = n - n6;
            int n9 = n4 - n3;
            double d = (double)n9 / (double)n5;
            int n10 = (int)Math.round((double)n8 * d);
            n2 = this.drawInverted() ? n4 - n10 : n3 + n10;
        }
        return n2;
    }

    static class SharedActionScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public SharedActionScroller(int n, boolean bl) {
            this.dir = n;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSlider jSlider = (JSlider)actionEvent.getSource();
            if (this.dir == -1 || this.dir == 1) {
                int n = this.dir;
                BasicSliderUI basicSliderUI = (BasicSliderUI)jSlider.getUI();
                if (jSlider.getInverted()) {
                    int n2 = n = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    basicSliderUI.scrollByBlock(n);
                } else {
                    basicSliderUI.scrollByUnit(n);
                }
            } else if (jSlider.getInverted()) {
                if (this.dir == -2) {
                    jSlider.setValue(jSlider.getMaximum());
                } else if (this.dir == 2) {
                    jSlider.setValue(jSlider.getMinimum());
                }
            } else if (this.dir == -2) {
                jSlider.setValue(jSlider.getMinimum());
            } else if (this.dir == 2) {
                jSlider.setValue(jSlider.getMaximum());
            }
        }
    }

    public class ActionScroller
    extends AbstractAction {
        int dir;
        boolean block;
        JSlider slider;

        public ActionScroller(JSlider jSlider, int n, boolean bl) {
            this.dir = n;
            this.block = bl;
            this.slider = jSlider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dir == -1 || this.dir == 1) {
                int n = this.dir;
                if (BasicSliderUI.this.drawInverted()) {
                    int n2 = n = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    BasicSliderUI.this.scrollByBlock(n);
                } else {
                    BasicSliderUI.this.scrollByUnit(n);
                }
            } else if (BasicSliderUI.this.drawInverted()) {
                if (this.dir == -2) {
                    this.slider.setValue(this.slider.getMaximum());
                } else if (this.dir == 2) {
                    this.slider.setValue(this.slider.getMinimum());
                }
            } else if (this.dir == -2) {
                this.slider.setValue(this.slider.getMinimum());
            } else if (this.dir == 2) {
                this.slider.setValue(this.slider.getMaximum());
            }
        }

        public boolean isEnabled() {
            boolean bl = true;
            if (this.slider != null) {
                bl = this.slider.isEnabled();
            }
            return bl;
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicSliderUI.this.slider.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicSliderUI.this.slider.repaint();
        }
    }

    public class ComponentHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            BasicSliderUI.this.calculateGeometry();
            BasicSliderUI.this.slider.repaint();
        }
    }

    public class ScrollListener
    implements ActionListener {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = true;
        }

        public ScrollListener(int n, boolean bl) {
            this.direction = n;
            this.useBlockIncrement = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.useBlockIncrement = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                BasicSliderUI.this.scrollByBlock(this.direction);
            } else {
                BasicSliderUI.this.scrollByUnit(this.direction);
            }
            if (!BasicSliderUI.this.trackListener.shouldScroll(this.direction)) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            BasicSliderUI.this.scrollTimer.stop();
            if (BasicSliderUI.this.slider.getSnapToTicks()) {
                BasicSliderUI.this.isDragging = false;
                BasicSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                BasicSliderUI.this.slider.setValueIsAdjusting(false);
                BasicSliderUI.this.isDragging = false;
            }
            BasicSliderUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            BasicSliderUI.this.slider.requestFocus();
            if (BasicSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (BasicSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BasicSliderUI.this.thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BasicSliderUI.this.thumbRect.x;
                    }
                }
                BasicSliderUI.this.isDragging = true;
                BasicSliderUI.this.slider.setValueIsAdjusting(true);
                return;
            }
            BasicSliderUI.this.isDragging = false;
            BasicSliderUI.this.slider.setValueIsAdjusting(true);
            Dimension dimension = BasicSliderUI.this.slider.getSize();
            int n = 1;
            switch (BasicSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2;
                    if (BasicSliderUI.this.thumbRect.isEmpty()) {
                        n2 = dimension.height / 2;
                        if (!BasicSliderUI.this.drawInverted()) {
                            n = this.currentMouseY < n2 ? 1 : -1;
                            break;
                        }
                        n = this.currentMouseY < n2 ? -1 : 1;
                        break;
                    }
                    n2 = BasicSliderUI.this.thumbRect.y;
                    if (!BasicSliderUI.this.drawInverted()) {
                        n = this.currentMouseY < n2 ? 1 : -1;
                        break;
                    }
                    n = this.currentMouseY < n2 ? -1 : 1;
                    break;
                }
                case 0: {
                    int n2;
                    if (BasicSliderUI.this.thumbRect.isEmpty()) {
                        n2 = dimension.width / 2;
                        if (!BasicSliderUI.this.drawInverted()) {
                            n = this.currentMouseX < n2 ? -1 : 1;
                            break;
                        }
                        n = this.currentMouseX < n2 ? 1 : -1;
                        break;
                    }
                    n2 = BasicSliderUI.this.thumbRect.x;
                    n = !BasicSliderUI.this.drawInverted() ? (this.currentMouseX < n2 ? -1 : 1) : (this.currentMouseX < n2 ? 1 : -1);
                }
            }
            BasicSliderUI.this.scrollDueToClickInTrack(n);
            Rectangle rectangle = BasicSliderUI.this.thumbRect;
            if (!rectangle.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(n)) {
                BasicSliderUI.this.scrollTimer.stop();
                BasicSliderUI.this.scrollListener.setDirection(n);
                BasicSliderUI.this.scrollTimer.start();
            }
        }

        public boolean shouldScroll(int n) {
            Rectangle rectangle = BasicSliderUI.this.thumbRect;
            if (BasicSliderUI.this.slider.getOrientation() == 1) {
                boolean bl = BasicSliderUI.this.drawInverted() ? n < 0 : n > 0;
                if (bl ? rectangle.y + rectangle.height <= this.currentMouseY : rectangle.y >= this.currentMouseY) {
                    return false;
                }
            } else {
                boolean bl = BasicSliderUI.this.drawInverted() ? n < 0 : n > 0;
                if (bl ? rectangle.x + rectangle.width >= this.currentMouseX : rectangle.x <= this.currentMouseX) {
                    return false;
                }
            }
            if (n > 0 && BasicSliderUI.this.slider.getValue() + BasicSliderUI.this.slider.getExtent() >= BasicSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return n >= 0 || BasicSliderUI.this.slider.getValue() > BasicSliderUI.this.slider.getMinimum();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = 0;
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!BasicSliderUI.this.isDragging) {
                return;
            }
            switch (BasicSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = BasicSliderUI.this.thumbRect.height / 2;
                    int n3 = mouseEvent.getY() - this.offset;
                    int n4 = BasicSliderUI.this.trackRect.y;
                    int n5 = BasicSliderUI.this.trackRect.y + (BasicSliderUI.this.trackRect.height - 1);
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    BasicSliderUI.this.setThumbLocation(BasicSliderUI.this.thumbRect.x, n3);
                    n = n3 + n2;
                    BasicSliderUI.this.slider.setValue(BasicSliderUI.this.valueForYPosition(n));
                    break;
                }
                case 0: {
                    int n6 = BasicSliderUI.this.thumbRect.width / 2;
                    int n7 = mouseEvent.getX() - this.offset;
                    int n8 = BasicSliderUI.this.trackRect.x;
                    int n9 = BasicSliderUI.this.trackRect.x + (BasicSliderUI.this.trackRect.width - 1);
                    n7 = Math.max(n7, n8 - n6);
                    n7 = Math.min(n7, n9 - n6);
                    BasicSliderUI.this.setThumbLocation(n7, BasicSliderUI.this.thumbRect.y);
                    n = n7 + n6;
                    BasicSliderUI.this.slider.setValue(BasicSliderUI.this.valueForXPosition(n));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            if (!BasicSliderUI.this.isDragging) {
                BasicSliderUI.this.calculateThumbLocation();
                BasicSliderUI.this.slider.repaint();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation") || string.equals("inverted") || string.equals("labelTable") || string.equals("majorTickSpacing") || string.equals("minorTickSpacing") || string.equals("paintTicks") || string.equals("paintTrack") || string.equals("paintLabels")) {
                BasicSliderUI.this.calculateGeometry();
            } else if (string.equals("model")) {
                ((BoundedRangeModel)propertyChangeEvent.getOldValue()).removeChangeListener(BasicSliderUI.this.changeListener);
                ((BoundedRangeModel)propertyChangeEvent.getNewValue()).addChangeListener(BasicSliderUI.this.changeListener);
                BasicSliderUI.this.calculateThumbLocation();
                BasicSliderUI.this.slider.repaint();
            }
        }
    }
}

