/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.VersionHelper;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;

public final class ResourceManager {
    private static final String PROVIDER_RESOURCE_FILE_NAME = "jndiprovider.properties";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final String JRELIB_PROPERTY_FILE_NAME = "jndi.properties";
    private static final String[] listProperties = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state", "java.naming.factory.control"};
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static final Hashtable propertiesCache = new Hashtable(11);
    private static final Hashtable factoryCache = new Hashtable(11);
    private static final Hashtable urlFactoryCache = new Hashtable(11);

    private ResourceManager() {
    }

    public static Hashtable getInitialEnvironment(Hashtable hashtable) throws NamingException {
        String[] stringArray = VersionHelper.PROPS;
        if (hashtable == null) {
            hashtable = new Hashtable(11);
        }
        Applet applet = (Applet)hashtable.get("java.naming.applet");
        String[] stringArray2 = helper.getJndiProperties();
        int n = 0;
        while (n < stringArray.length) {
            Object object = hashtable.get(stringArray[n]);
            if (object == null) {
                if (applet != null) {
                    object = applet.getParameter(stringArray[n]);
                }
                if (object == null) {
                    Object object2 = object = stringArray2 != null ? stringArray2[n] : helper.getJndiProperty(n);
                }
                if (object != null) {
                    hashtable.put(stringArray[n], object);
                }
            }
            ++n;
        }
        ResourceManager.mergeTables(hashtable, ResourceManager.getApplicationResources());
        return hashtable;
    }

    public static String getProperty(String string, Hashtable hashtable, Context context, boolean bl) throws NamingException {
        String string2;
        String string3 = string2 = hashtable != null ? (String)hashtable.get(string) : null;
        if (context == null || string2 != null && !bl) {
            return string2;
        }
        String string4 = (String)ResourceManager.getProviderResource(context).get(string);
        if (string2 == null) {
            return string4;
        }
        if (string4 == null || !bl) {
            return string2;
        }
        return string2 + ":" + string4;
    }

    public static FactoryEnumeration getFactories(String string, Hashtable hashtable, Context context) throws NamingException {
        String string2 = ResourceManager.getProperty(string, hashtable, context, true);
        if (string2 == null) {
            return null;
        }
        FactoryKey factoryKey = new FactoryKey(string2);
        Hashtable hashtable2 = factoryCache;
        synchronized (hashtable2) {
            Vector vector = (Vector)factoryCache.get(factoryKey);
            if (vector != null) {
                FactoryEnumeration factoryEnumeration = vector.size() == 0 ? null : new FactoryEnumeration(vector);
                return factoryEnumeration;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            vector = new Vector(5);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    vector.addElement(helper.loadClass(stringTokenizer.nextToken(), factoryKey.loader));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            factoryCache.put(factoryKey, vector);
            FactoryEnumeration factoryEnumeration = new FactoryEnumeration(vector);
            return factoryEnumeration;
        }
    }

    public static Object getFactory(String string, Hashtable hashtable, Context context, String string2, String string3) throws NamingException {
        String string4 = ResourceManager.getProperty(string, hashtable, context, true);
        string4 = string4 != null ? string4 + ":" + string3 : string3;
        FactoryKey factoryKey = new FactoryKey(string2 + string4);
        Hashtable hashtable2 = urlFactoryCache;
        synchronized (hashtable2) {
            Object object = urlFactoryCache.get(factoryKey);
            if (object != null) {
                Object object2 = object.equals("none") ? null : object;
                return object2;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
            while (object == null && stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken() + string2;
                try {
                    object = helper.loadClass(string5, factoryKey.loader).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    NamingException namingException = new NamingException("Cannot instantiate " + string5);
                    namingException.setRootCause(instantiationException);
                    throw namingException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    NamingException namingException = new NamingException("Cannot access " + string5);
                    namingException.setRootCause(illegalAccessException);
                    throw namingException;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object != null) {
                urlFactoryCache.put(factoryKey, object);
            } else {
                urlFactoryCache.put(factoryKey, "none");
            }
            Object object3 = object;
            return object3;
        }
    }

    private static Hashtable getProviderResource(Object object) throws NamingException {
        if (object == null) {
            return new Hashtable(1);
        }
        Hashtable hashtable = propertiesCache;
        synchronized (hashtable) {
            Class clazz = object.getClass();
            Hashtable hashtable2 = (Hashtable)propertiesCache.get(clazz);
            if (hashtable2 != null) {
                Hashtable hashtable3 = hashtable2;
                return hashtable3;
            }
            hashtable2 = new Properties();
            InputStream inputStream = helper.getResourceAsStream(clazz, PROVIDER_RESOURCE_FILE_NAME);
            if (inputStream != null) {
                try {
                    ((Properties)hashtable2).load(inputStream);
                }
                catch (IOException iOException) {
                    ConfigurationException configurationException = new ConfigurationException("Error reading provider resource file for " + clazz);
                    configurationException.setRootCause(iOException);
                    throw configurationException;
                }
            }
            propertiesCache.put(clazz, hashtable2);
            Hashtable hashtable4 = hashtable2;
            return hashtable4;
        }
    }

    private static Hashtable getApplicationResources() throws NamingException {
        ClassLoader classLoader;
        try {
            classLoader = helper.getContextClassLoader();
        }
        catch (SecurityException securityException) {
            return new Hashtable(1);
        }
        Object object = classLoader != null ? classLoader : "bootstrap";
        Hashtable hashtable = propertiesCache;
        synchronized (hashtable) {
            Object object2;
            Object object3 = (Hashtable)propertiesCache.get(object);
            if (object3 != null) {
                Hashtable hashtable2 = object3;
                return hashtable2;
            }
            try {
                Object object4;
                object2 = helper.getResources(classLoader, "jndi.properties");
                while (object2.hasMore()) {
                    object4 = new Properties();
                    ((Properties)object4).load((InputStream)object2.next());
                    if (object3 == null) {
                        object3 = object4;
                        continue;
                    }
                    ResourceManager.mergeTables((Hashtable)object3, (Hashtable)object4);
                }
                object4 = helper.getJavaHomeLibStream("jndi.properties");
                if (object4 != null) {
                    Properties properties = new Properties();
                    properties.load((InputStream)object4);
                    if (object3 == null) {
                        object3 = properties;
                    } else {
                        ResourceManager.mergeTables((Hashtable)object3, properties);
                    }
                }
            }
            catch (IOException iOException) {
                ConfigurationException configurationException = new ConfigurationException("Error reading application resource file");
                configurationException.setRootCause(iOException);
                throw configurationException;
            }
            if (object3 == null) {
                object3 = new Hashtable(11);
            }
            propertiesCache.put(object, object3);
            object2 = object3;
            return object2;
        }
    }

    private static void mergeTables(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = hashtable.get(string);
            if (object == null) {
                hashtable.put(string, hashtable2.get(string));
                continue;
            }
            if (!ResourceManager.isListProperty(string)) continue;
            String string2 = (String)hashtable2.get(string);
            hashtable.put(string, (String)object + ":" + string2);
        }
    }

    private static boolean isListProperty(String string) {
        string = string.intern();
        int n = 0;
        while (n < listProperties.length) {
            if (string == listProperties[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final class FactoryKey {
        private String propVal;
        private ClassLoader loader;

        FactoryKey(String string) {
            try {
                this.loader = helper.getContextClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.propVal = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FactoryKey)) {
                return false;
            }
            FactoryKey factoryKey = (FactoryKey)object;
            return this.propVal.equals(factoryKey.propVal) && (this.loader == factoryKey.loader || this.loader != null && this.loader.equals(factoryKey.loader));
        }

        public int hashCode() {
            return this.propVal.hashCode() + (this.loader != null ? this.loader.hashCode() : 0);
        }
    }
}

