/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Printer;
import java.util.EventObject;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

class EventDispatcher
extends Thread {
    private Vector eventQueue = new Vector();
    private boolean done = false;

    EventDispatcher() {
    }

    protected void processEvent(EventInfo eventInfo) {
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent lineEvent = (LineEvent)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            int n = 0;
            while (n < vector.size()) {
                ((LineListener)vector.elementAt(n)).update(lineEvent);
                ++n;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            int n = 0;
            while (n < vector.size()) {
                ((MetaEventListener)vector.elementAt(n)).meta(metaMessage);
                ++n;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)eventInfo.getEvent();
            int n = shortMessage.getStatus();
            if (n >> 4 == 11) {
                Vector vector = eventInfo.getListeners();
                int n2 = 0;
                while (n2 < vector.size()) {
                    ((ControllerEventListener)vector.elementAt(n2)).controlChange(shortMessage);
                    ++n2;
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    protected void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                while (!this.done && this.eventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (!this.done) {
                eventInfo = (EventInfo)this.eventQueue.elementAt(0);
                this.eventQueue.removeElementAt(0);
            }
        }
        if (eventInfo != null) {
            this.processEvent(eventInfo);
        }
    }

    synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.addElement(eventInfo);
        this.notifyAll();
    }

    synchronized void kill() {
        this.done = true;
        this.notifyAll();
    }

    public void run() {
        while (!this.done) {
            this.dispatchEvents();
        }
    }

    void sendAudioEvents(EventObject eventObject, Vector vector) {
        this.sendAudioEvents((Object)eventObject, vector);
    }

    void sendAudioEvents(Object object, Vector vector) {
        Vector vector2 = (Vector)vector.clone();
        EventInfo eventInfo = new EventInfo(object, vector2);
        this.postEvent(eventInfo);
    }

    class EventInfo {
        private Object event;
        private Vector listeners;

        EventInfo(Object object, Vector vector) {
            this.event = object;
            this.listeners = vector;
        }

        Object getEvent() {
            return this.event;
        }

        Vector getListeners() {
            return this.listeners;
        }
    }
}

