/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.util.BasicPrinter;

public class HelpDialog
extends JDialog
implements ActionListener {
    JTextArea textArea;
    JButton printButton;
    JButton okayButton;
    String buffer = "";
    private static final int WIDTH = 560;
    private static final int HEIGHT = 325;
    private static final String helpFileName = "readme.txt";

    public HelpDialog(Frame frame) {
        this(frame, ResourceHandler.getMessage("help_dialog.caption"), false);
    }

    public HelpDialog(Frame frame, boolean bl) {
        this(frame, ResourceHandler.getMessage("help_dialog.caption"), bl);
    }

    public HelpDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public HelpDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.majorLayout();
    }

    public void majorLayout() {
        ((Component)this).setSize(560, 325);
        this.setResizable(true);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setBackground(Color.white);
        this.textArea.setText(this.getHelpText());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.textArea);
        Dimension dimension = this.getToolkit().getScreenSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width / 2, dimension.height / 2));
        this.printButton = new JButton(ResourceHandler.getMessage("button.print"));
        this.printButton.addActionListener(this);
        this.okayButton = new JButton(ResourceHandler.getMessage("button.okay"));
        this.okayButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.printButton);
        jPanel.add(this.okayButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
    }

    public String getHelpText() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(helpFileName);
            byte[] byArray = new byte[2048];
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((n = inputStream.read(byArray, 0, 2048)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            this.buffer = stringBuffer.toString();
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.buffer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        if (component == this.okayButton) {
            this.setVisible(false);
            this.dispose();
        } else if (component == this.printButton) {
            BasicPrinter.printDocument(new Frame(), this.buffer, "Print Help Text");
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        }
        if (bl) {
            super.pack();
        }
        this.textArea.setCaretPosition(0);
        super.setVisible(bl);
    }
}

