/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;
import sun.plugin.platform.PlatformHandler;
import sun.plugin.platform.ServiceProvider;
import sun.plugin.protocol.CookieHandler;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

public class ActivatorCookieHandler
implements CookieHandler {
    private HashMap cookieTable = new HashMap();
    private boolean useCache = false;

    protected ActivatorCookieHandler() {
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.cachecookie", "false"));
        Trace.netPrintln("Cookie Cache: " + string, 2);
        if (string != null && string.equalsIgnoreCase("true")) {
            this.useCache = true;
        }
    }

    public synchronized void setCookieInfo(URL uRL, String string) {
        PlatformHandler platformHandler = ServiceProvider.getProvider();
        if (platformHandler != null) {
            Trace.netPrintln("Server " + uRL + " requesting to set-cookie with \"" + string + "\"", 2);
            platformHandler.SetCookie(uRL, string);
        }
    }

    public synchronized String getCookieInfo(URL uRL) {
        String string = null;
        if (this.useCache) {
            String string2 = uRL.getHost() + uRL.getFile();
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                return null;
            }
            string = (String)this.cookieTable.get(string2 = string2.substring(0, n));
            if (string == null) {
                string = this.findCookieForURL(uRL.toString());
                if (!(string == null || string.equals("") || string.equals("\n") || string.equals("\r\n"))) {
                    this.cookieTable.put(string2, string);
                } else {
                    this.cookieTable.put(string2, "");
                    string = null;
                }
            }
        } else {
            string = this.findCookieForURL(uRL.toString());
        }
        if (string != null && string.equals("")) {
            string = null;
        }
        if (string != null) {
            Trace.netPrintln("Connecting " + uRL + " with cookie \"" + string + "\"", 2);
        }
        return string;
    }

    private native String findCookieForURL(String var1);
}

