/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.code;

import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.util.Name;

public class Scope {
    public Scope next;
    public Symbol owner;
    public Entry[] table;
    int hashMask;
    public Entry elems;
    int nelems = 0;
    private static final Entry sentinel = new Entry(null, null, null, null);
    private static final int INITIAL_SIZE = 128;
    public static final Scope emptyScope = new Scope(null, null, new Entry[0]);
    public static final Scope errScope = new Scope(null);
    public static int count = 0;

    Scope(Scope scope, Symbol symbol, Entry[] entryArray) {
        this.next = scope;
        this.owner = symbol;
        this.table = entryArray;
        this.hashMask = entryArray.length - 1;
        this.elems = null;
        this.nelems = 0;
    }

    public Scope(Symbol symbol) {
        this(null, symbol, new Entry[128]);
        int n = 0;
        while (n < 128) {
            this.table[n] = sentinel;
            ++n;
        }
    }

    public Scope dup() {
        return new Scope(this, this.owner, this.table);
    }

    public Scope dupUnshared() {
        return new Scope(this, this.owner, (Entry[])this.table.clone());
    }

    public Scope leave() {
        while (this.elems != null) {
            int n = this.elems.sym.name.index & this.hashMask;
            Entry entry = this.table[n];
            if (entry != this.elems) {
                throw new InternalError(this.elems.sym.toString());
            }
            this.table[n] = this.elems.shadowed;
            this.elems = this.elems.sibling;
        }
        return this.next;
    }

    private void dble() {
        Entry[] entryArray = this.table;
        Entry[] entryArray2 = new Entry[entryArray.length * 2];
        Scope scope = this;
        do {
            scope.table = entryArray2;
            scope.hashMask = entryArray2.length - 1;
        } while ((scope = scope.next) != null);
        int n = 0;
        while (n < entryArray2.length) {
            entryArray2[n] = sentinel;
            ++n;
        }
        int n2 = 0;
        while (n2 < entryArray.length) {
            this.copy(entryArray[n2]);
            ++n2;
        }
    }

    private void copy(Entry entry) {
        if (entry.sym != null) {
            this.copy(entry.shadowed);
            int n = entry.sym.name.index & this.hashMask;
            entry.shadowed = this.table[n];
            this.table[n] = entry;
        }
    }

    public void enter(Symbol symbol) {
        this.enter(symbol, this);
    }

    public void enter(Symbol symbol, Scope scope) {
        Entry entry;
        if (this.nelems * 3 >= this.hashMask * 2) {
            this.dble();
        }
        int n = symbol.name.index & this.hashMask;
        this.table[n] = entry = new Entry(symbol, this.table[n], this.elems, scope);
        this.elems = entry;
        ++this.nelems;
    }

    public void enterIfAbsent(Symbol symbol) {
        Entry entry = this.lookup(symbol.name);
        while (entry.scope == this && entry.sym.kind != symbol.kind) {
            entry = entry.next();
        }
        if (entry.scope != this) {
            this.enter(symbol);
        }
    }

    public Entry lookup(Name name) {
        Entry entry = this.table[name.index & this.hashMask];
        while (entry.scope != null && entry.sym.name != name) {
            entry = entry.shadowed;
        }
        if (entry.scope == null && this == errScope) {
            return new Entry(Symbol.errSymbol, null, null, null);
        }
        return entry;
    }

    public static class Entry {
        public Symbol sym;
        public Entry shadowed;
        public Entry sibling;
        public Scope scope;
        public static int count = 0;

        public Entry(Symbol symbol, Entry entry, Entry entry2, Scope scope) {
            this.sym = symbol;
            this.shadowed = entry;
            this.sibling = entry2;
            this.scope = scope;
        }

        public Entry next() {
            Entry entry = this.shadowed;
            while (entry.scope != null && entry.sym.name != this.sym.name) {
                entry = entry.shadowed;
            }
            return entry;
        }
    }
}

