/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8;

import com.sun.tools.javac.v8.CommandLine;
import com.sun.tools.javac.v8.JavaCompiler;
import com.sun.tools.javac.v8.code.ClassFile;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.comp.Items;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.util.FatalError;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javac.v8.util.Util;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Main {
    static String[] forcedOpts = new String[0];
    String ownName;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    static String[][] standardOptions = new String[][]{{"-g", "", "opt.g"}, {"-g:none", "", "opt.g.none"}, {"-g:{lines,vars,source}", "", "opt.g.lines.vars.source"}, {"-O", "", "opt.O"}, {"-nowarn", "", "opt.nowarn"}, {"-verbose", "", "opt.verbose"}, {"-deprecation", "", "opt.deprecation"}, {"-classpath", "opt.arg.path", "opt.classpath"}, {"-sourcepath", "opt.arg.path", "opt.sourcepath"}, {"-bootclasspath", "opt.arg.path", "opt.bootclasspath"}, {"-extdirs", "opt.arg.dirs", "opt.extdirs"}, {"-d", "opt.arg.directory", "opt.d"}, {"-encoding", "opt.arg.encoding", "opt.encoding"}, {"-target", "opt.arg.release", "opt.target"}};
    String[][] enabledOptions;
    public Hashtable options = Hashtable.make();
    private static final String javacRB = "com.sun.tools.javac.v8.resources.javac";
    private static ResourceBundle messageRB;

    public Main(String string, boolean bl) {
        this.ownName = string;
        this.enabledOptions = standardOptions;
    }

    void help() {
        System.err.println(Main.getLocalizedString("msg.usage.header", this.ownName));
        int n = 0;
        while (n < this.enabledOptions.length) {
            if (!this.enabledOptions[n][0].startsWith("-X")) {
                String string = "  " + this.enabledOptions[n][0] + " ";
                if (!this.enabledOptions[n][1].equals("")) {
                    string = string + Main.getLocalizedString(this.enabledOptions[n][1]);
                }
                System.err.print(string);
                int n2 = string.length();
                while (n2 < 28) {
                    System.err.print(" ");
                    ++n2;
                }
                System.err.println(Main.getLocalizedString(this.enabledOptions[n][2]));
            }
            ++n;
        }
        System.err.println();
    }

    void error(String string, String string2) {
        System.err.println(this.ownName + ": " + Main.getLocalizedString(string, string2));
        this.help();
    }

    private boolean matches(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = Util.pos(string, ':', 0);
        int n4 = Util.pos(string2, ':', 0);
        if (string.substring(0, n3).equals(string2.substring(0, n4))) {
            if (n3 == n && n4 == n2) {
                return true;
            }
            if (n3 < n && n4 < n2) {
                ++n4;
                if (++n3 < n && string.charAt(n3) == '{') {
                    ++n3;
                    string = string.substring(0, string.length() - 1).concat(",");
                }
                int n5 = n4;
                boolean bl = true;
                while (bl & n5 < n2) {
                    int n6 = Util.pos(string2, ',', n5);
                    String string3 = string2.substring(n5, n6);
                    int n7 = n3;
                    bl = false;
                    while (!bl && n7 < n) {
                        int n8 = Util.pos(string, ',', n7);
                        if (string.substring(n7, n8).equals(string3)) {
                            bl = true;
                        }
                        n7 = n8 + 1;
                    }
                    n5 = n6 + 1;
                }
                return bl;
            }
        }
        return false;
    }

    public List processArgs(String[] stringArray) {
        ListBuffer listBuffer = new ListBuffer();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ++n;
            if (string.startsWith("-")) {
                int n2 = 0;
                while (n2 < this.enabledOptions.length && !this.matches(this.enabledOptions[n2][0], string)) {
                    ++n2;
                }
                if (n2 == this.enabledOptions.length) {
                    this.error("err.invalid.flag", string);
                    return null;
                }
                String string2 = this.enabledOptions[n2][1];
                if (string2.length() != 0) {
                    if (n == stringArray.length) {
                        this.error("err.req.arg", string);
                        return null;
                    }
                    string2 = stringArray[n];
                    ++n;
                }
                if (string.equals("-moreinfo")) {
                    Type.moreInfo = true;
                    continue;
                }
                if (string.equals("-version")) {
                    System.err.println(this.ownName + " " + JavaCompiler.version() + ", " + JavaCompiler.date());
                    continue;
                }
                if (string.equals("-target")) {
                    if (!ClassFile.isValidTargetRelease(string2)) {
                        this.error("err.invalid.target", string2);
                        return null;
                    }
                } else if (string.length() >= 3 && string.charAt(2) == ':') {
                    string2 = string.substring(3);
                    string = string.substring(0, 3);
                }
                this.options.put(string, string2);
                continue;
            }
            if (string.endsWith(".java")) {
                listBuffer.append(string);
                continue;
            }
            this.error("err.invalid.arg", string);
            return null;
        }
        return listBuffer.toList();
    }

    public int compile(String[] stringArray) {
        JavaCompiler javaCompiler = null;
        try {
            if (stringArray.length == 0) {
                this.help();
                return 2;
            }
            this.processArgs(forcedOpts);
            List list = this.processArgs(CommandLine.parse(stringArray));
            if (list == null) {
                return 2;
            }
            javaCompiler = JavaCompiler.make(this.options);
            if (javaCompiler == null) {
                return 3;
            }
            List list2 = javaCompiler.compile(list);
            System.err.flush();
            if (javaCompiler.errorCount() != 0) {
                return 1;
            }
        }
        catch (IOException iOException) {
            this.ioMessage(iOException);
            return 3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.resourceMessage(outOfMemoryError);
            return 3;
        }
        catch (FatalError fatalError) {
            this.feMessage(fatalError);
            return 3;
        }
        catch (Throwable throwable) {
            this.bugMessage(throwable);
            return 4;
        }
        return 0;
    }

    void bugMessage(Throwable throwable) {
        System.err.println(Main.getLocalizedString("msg.bug", JavaCompiler.version()));
        throwable.printStackTrace();
    }

    void feMessage(Throwable throwable) {
        System.err.println(throwable.getMessage());
    }

    void ioMessage(Throwable throwable) {
        System.err.println(Main.getLocalizedString("msg.io"));
        throwable.printStackTrace();
    }

    void resourceMessage(Throwable throwable) {
        System.err.println(Main.getLocalizedString("msg.resource"));
        throwable.printStackTrace();
    }

    private static void printStats() {
        String[][] stringArrayArray = new String[][]{{"stats.tree", Integer.toString(Tree.count)}, {"stats.symbol", Integer.toString(Symbol.count)}, {"stats.type", Integer.toString(Type.count)}, {"stats.scope", Integer.toString(Scope.count)}, {"stats.scope.entry", Integer.toString(Scope.Entry.count)}, {"stats.item", Integer.toString(Items.count)}};
    }

    private static String getLocalizedString(String string) {
        return Main.getText("javac." + string, null);
    }

    private static String getLocalizedString(String string, String string2) {
        return Main.getText("javac." + string, string2);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(javacRB);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
            System.out.println(missingResourceException.getClassName());
            throw new FatalError("Fatal Error: Resource for javac is missing");
        }
    }

    private static String getText(String string, String string2) {
        if (messageRB == null) {
            Main.initResource();
        }
        try {
            Object[] objectArray = new String[]{string2};
            return MessageFormat.format(messageRB.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                string2 = "null";
            }
            Object[] objectArray = new String[]{string, string2};
            String string3 = "javac message file broken: key={0} arguments={1}";
            return MessageFormat.format(string3, objectArray);
        }
    }
}

