/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8;

import com.sun.tools.javac.v8.code.ClassReader;
import com.sun.tools.javac.v8.code.ClassWriter;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.comp.Attr;
import com.sun.tools.javac.v8.comp.Check;
import com.sun.tools.javac.v8.comp.Enter;
import com.sun.tools.javac.v8.comp.Env;
import com.sun.tools.javac.v8.comp.Flow;
import com.sun.tools.javac.v8.comp.Gen;
import com.sun.tools.javac.v8.comp.Infer;
import com.sun.tools.javac.v8.comp.Resolve;
import com.sun.tools.javac.v8.comp.Symtab;
import com.sun.tools.javac.v8.comp.TransInner;
import com.sun.tools.javac.v8.comp.TransTypes;
import com.sun.tools.javac.v8.parser.Parser;
import com.sun.tools.javac.v8.parser.Scanner;
import com.sun.tools.javac.v8.tree.Pretty;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeMaker;
import com.sun.tools.javac.v8.util.Abort;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Set;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class JavaCompiler
implements ClassReader.SourceCompleter {
    Log log;
    Symtab syms;
    Check chk;
    Infer infer;
    Resolve rs;
    TreeMaker make;
    Enter enter;
    Attr attr;
    Gen gen;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean classOutput;
    public boolean printFlat;
    public boolean deprecation;
    public boolean warnunchecked;
    public boolean gj;
    public String encoding;
    ListBuffer todo = new ListBuffer();
    Set inputFiles = Set.make();

    public static String version() {
        return System.getProperty("java.version");
    }

    public static String date() {
        return "DD-MMMMM-YY";
    }

    public JavaCompiler(Log log, Symtab symtab, Hashtable hashtable) {
        this.log = log;
        this.syms = symtab;
        this.syms.reader.sourceCompleter = this;
        this.chk = new Check(log, symtab, hashtable);
        this.rs = new Resolve(log, symtab, this.chk, this.infer);
        this.make = new TreeMaker();
        this.enter = new Enter(log, symtab, this.rs, this.chk, this.make, null, this.todo);
        this.attr = new Attr(log, symtab, this.rs, this.chk, this.infer, this.make, this.enter, hashtable);
        this.gen = new Gen(log, symtab, this.chk, this.rs, this.make, hashtable);
        this.verbose = hashtable.get("-verbose") != null;
        this.sourceOutput = hashtable.get("-s") != null;
        this.classOutput = hashtable.get("-retrofit") == null;
        this.printFlat = hashtable.get("-printflat") != null;
        this.deprecation = hashtable.get("-deprecation") != null;
        this.warnunchecked = hashtable.get("-warnunchecked") != null;
        this.gj = hashtable.get("-gj") != null;
        this.encoding = (String)hashtable.get("-encoding");
    }

    public static JavaCompiler make(Log log, Hashtable hashtable) {
        try {
            return new JavaCompiler(log, new Symtab(new ClassReader(hashtable), new ClassWriter(hashtable)), hashtable);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            log.error(0, completionFailure.getMessage());
            return null;
        }
    }

    public static JavaCompiler make(Hashtable hashtable) {
        return JavaCompiler.make(new Log(hashtable.get("-prompt") != null, hashtable.get("-nowarn") == null), hashtable);
    }

    public static JavaCompiler make() {
        return JavaCompiler.make(Hashtable.make());
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    public InputStream openSource(String string) {
        try {
            File file = new File(string);
            this.inputFiles.put(file);
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            this.log.error(0, "cant.read.file", string);
            return null;
        }
    }

    public Tree.TopLevel parse(String string, InputStream inputStream) {
        long l = System.currentTimeMillis();
        Name name = this.log.useSource(Name.fromString(string));
        Tree.TopLevel topLevel = this.make.TopLevel(null, Tree.emptyList);
        if (inputStream != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", string);
            }
            try {
                Scanner scanner = new Scanner(inputStream, this.log, this.encoding);
                inputStream.close();
                Parser parser = new Parser(scanner, this.make, this.log, this.gj, this.sourceOutput);
                topLevel = parser.compilationUnit();
                if (this.verbose) {
                    this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - l));
                }
            }
            catch (IOException iOException) {
                this.log.error(0, "error.reading.file", string, iOException.toString());
            }
        }
        this.log.useSource(name);
        topLevel.sourcefile = Name.fromString(string);
        return topLevel;
    }

    public Tree.TopLevel parse(String string) {
        return this.parse(string, this.openSource(string));
    }

    void printSource(Env env, Tree.ClassDef classDef) throws IOException {
        File file = this.syms.writer.outputFile(classDef.sym, ".java");
        if (this.inputFiles.contains(file)) {
            this.log.error(classDef.pos, "source.cant.overwrite.input.file", file.toString());
        } else {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                new Pretty(printStream).printUnit(env.toplevel, classDef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", file.getPath());
                }
                Object var6_5 = null;
                printStream.close();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                printStream.close();
                throw throwable;
            }
        }
    }

    void genCode(Env env, Tree.ClassDef classDef) throws IOException {
        this.gen.genClass(env, classDef);
        this.writeClass(classDef.sym);
    }

    public void writeClass(Symbol.ClassSymbol classSymbol) throws IOException {
        File file = this.syms.writer.outputFile(classSymbol, ".class");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.syms.writer.writeClassFile(fileOutputStream, classSymbol);
            if (this.verbose) {
                this.printVerbose("wrote.file", file.getPath());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public void complete(Symbol.ClassSymbol classSymbol, String string, InputStream inputStream) throws Symbol.CompletionFailure {
        Tree.TopLevel topLevel = this.parse(string, inputStream);
        this.enter.main(List.make(topLevel));
        if (classSymbol.members() == null) {
            throw new ClassReader.BadClassFile(this.syms.reader, classSymbol, string, Log.getLocalizedString("file.doesnt.contain.class", classSymbol.fullname.toJava()));
        }
    }

    public List compile(List list) throws Throwable {
        int n;
        long l = System.currentTimeMillis();
        ListBuffer listBuffer = new ListBuffer();
        try {
            Object object;
            Object object2;
            Object object3;
            this.inputFiles.reset();
            Symbol.reset();
            this.chk.compiled.reset();
            ListBuffer listBuffer2 = new ListBuffer();
            List list2 = list;
            while (list2.nonEmpty()) {
                listBuffer2.append(this.parse((String)list2.head));
                list2 = list2.tail;
            }
            List list3 = listBuffer2.toList();
            this.enter.main(list3);
            List list4 = null;
            if (this.sourceOutput) {
                object3 = new ListBuffer();
                object2 = list3;
                while (((List)object2).nonEmpty()) {
                    object = ((Tree.TopLevel)((List)object2).head).defs;
                    while (((List)object).nonEmpty()) {
                        if (((List)object).head instanceof Tree.ClassDef) {
                            ((ListBuffer)object3).append((Tree.ClassDef)((List)object).head);
                        }
                        object = ((List)object).tail;
                    }
                    object2 = ((List)object2).tail;
                }
                list4 = ((ListBuffer)object3).toList();
            }
            while (this.todo.nonEmpty()) {
                object3 = (Env)this.todo.first();
                this.todo.remove();
                object2 = ((Env)object3).tree;
                if (this.verbose) {
                    this.printVerbose("checking.attribution", ((Env)object3).enclClass.sym.toJava());
                }
                object = this.log.useSource(((Env)object3).enclClass.sym.sourcefile);
                this.attr.attribClass(((Env)object3).enclClass.sym);
                if (this.errorCount() == 0) {
                    new Flow(this.log, this.syms, this.chk).analyzeDef(((Env)object3).tree);
                }
                TreeMaker treeMaker = new TreeMaker(((Env)object3).toplevel);
                if (this.errorCount() == 0) {
                    ((Env)object3).tree = new TransTypes(this.log, this.syms, treeMaker).translateTopLevelClass(((Env)object3).tree);
                }
                if (this.errorCount() == 0) {
                    Tree.ClassDef classDef = null;
                    try {
                        if (this.sourceOutput) {
                            classDef = (Tree.ClassDef)((Env)object3).tree;
                            if (list4.contains(object2)) {
                                this.printSource((Env)object3, classDef);
                            }
                        } else {
                            List list5;
                            List list6 = list5 = new TransInner(this.log, this.syms, this.rs, this.chk, this.attr, treeMaker).translateTopLevelClass((Env)object3, ((Env)object3).tree);
                            while (this.errorCount() == 0 && list6.nonEmpty()) {
                                classDef = (Tree.ClassDef)list6.head;
                                if (this.printFlat) {
                                    this.printSource((Env)object3, classDef);
                                } else if (this.classOutput) {
                                    this.genCode((Env)object3, classDef);
                                }
                                listBuffer.append(classDef.sym);
                                list6 = list6.tail;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        this.log.error(classDef.pos, "class.cant.write", classDef.sym.toJava(), iOException.getMessage());
                    }
                }
                this.log.useSource((Name)object);
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - l));
        }
        if (this.chk.deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(this.chk.deprecatedSource.toString());
        }
        if (this.chk.uncheckedSource != null && !this.warnunchecked) {
            this.noteUnchecked(this.chk.uncheckedSource.toString());
        }
        if ((n = this.errorCount()) == 1) {
            this.printCount("error", n);
        } else {
            this.printCount("error.plural", n);
        }
        if (this.log.nwarnings == 1) {
            this.printCount("warn", this.log.nwarnings);
        } else {
            this.printCount("warn.plural", this.log.nwarnings);
        }
        return listBuffer.toList();
    }

    private void printVerbose(String string, String string2) {
        System.err.println(Log.getLocalizedString("verbose." + string, string2));
    }

    private void noteDeprecated(String string) {
        if (string.equals("*")) {
            this.log.note("deprecated.plural");
        } else {
            this.log.note("deprecated.filename", string);
        }
        this.log.note("deprecated.recompile");
    }

    void noteUnchecked(String string) {
        if (string.equals("*")) {
            this.log.note("unchecked.plural");
        } else {
            this.log.note("unchecked.filename", string);
        }
        this.log.note("unchecked.recompile");
    }

    void printCount(String string, int n) {
        if (n != 0) {
            this.log.println(Log.getLocalizedString("count." + string, Integer.toString(n)));
        }
    }
}

