/*
 * Decompiled with CFR 0.152.
 */
package demos.Transforms;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Rotate
extends ControlsSurface {
    protected double increment = 5.0;
    protected int emphasis = 9;

    public Rotate() {
        this.setBackground(Color.white);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        int n3 = Math.min(n, n2);
        float f = n3 / 4;
        float f2 = n3 - 20;
        Ellipse2D.Float float_ = new Ellipse2D.Float(-f / 2.0f, -f2 / 2.0f, f, f2);
        double d = 0.0;
        while (d < 360.0) {
            if (d % (double)this.emphasis == 0.0) {
                graphics2D.setColor(Color.gray);
                graphics2D.setStroke(new BasicStroke(2.0f));
            } else {
                graphics2D.setColor(Color.lightGray);
                graphics2D.setStroke(new BasicStroke(0.5f));
            }
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n / 2, n2 / 2);
            affineTransform.rotate(Math.toRadians(d));
            graphics2D.draw(affineTransform.createTransformedShape(float_));
            d += this.increment;
        }
        graphics2D.setColor(Color.blue);
        ((RectangularShape)float_).setFrame(n / 2 - 10, n2 / 2 - 10, 20.0, 20.0);
        graphics2D.fill(float_);
        graphics2D.setColor(Color.gray);
        graphics2D.setStroke(new BasicStroke(6.0f));
        graphics2D.draw(float_);
        graphics2D.setColor(Color.yellow);
        graphics2D.setStroke(new BasicStroke(4.0f));
        graphics2D.draw(float_);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("Rotate", 5, 15);
    }

    public static void main(String[] stringArray) {
        Surface.createDemoFrame(new Rotate());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Rotate demo;
        JTextField tf1;
        JTextField tf2;

        public DemoControls(Rotate rotate) {
            super(rotate.name);
            this.demo = rotate;
            this.setBackground(Color.gray);
            JLabel jLabel = new JLabel("Increment:");
            jLabel.setForeground(Color.black);
            this.add(jLabel);
            this.tf1 = new JTextField("5.0");
            this.add(this.tf1);
            this.tf1.setPreferredSize(new Dimension(30, 24));
            this.tf1.addActionListener(this);
            jLabel = new JLabel("  Emphasis:");
            this.add(jLabel);
            jLabel.setForeground(Color.black);
            this.tf2 = new JTextField("9");
            this.add(this.tf2);
            this.tf2.setPreferredSize(new Dimension(30, 24));
            this.tf2.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource().equals(this.tf1)) {
                    this.demo.increment = Double.parseDouble(this.tf1.getText().trim());
                    if (this.demo.increment < 1.0) {
                        this.demo.increment = 1.0;
                    }
                } else {
                    this.demo.emphasis = Integer.parseInt(this.tf2.getText().trim());
                }
                this.demo.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 36);
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                int n = 3;
                while (n < 13) {
                    try {
                        Thread.sleep(4444L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    this.tf1.setText(String.valueOf(n));
                    this.demo.increment = n;
                    this.demo.repaint();
                    n += 3;
                }
            }
            this.thread = null;
        }
    }
}

