/*
 * Decompiled with CFR 0.152.
 */
package demos.Arcs_Curves;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

public class Ellipses
extends AnimatingSurface {
    private static Color[] colors = new Color[]{Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.red, Color.yellow, Color.lightGray, Color.white};
    private Ellipse2D.Float[] ellipses;
    private double[] esize;
    private float[] estroke;
    private double maxSize;

    public Ellipses() {
        this.setBackground(Color.black);
        this.ellipses = new Ellipse2D.Float[25];
        this.esize = new double[this.ellipses.length];
        this.estroke = new float[this.ellipses.length];
        int n = 0;
        while (n < this.ellipses.length) {
            this.ellipses[n] = new Ellipse2D.Float();
            this.getRandomXY(n, 20.0 * Math.random(), 200, 200);
            ++n;
        }
    }

    public void getRandomXY(int n, double d, int n2, int n3) {
        this.esize[n] = d;
        this.estroke[n] = 1.0f;
        double d2 = Math.random() * ((double)n2 - this.maxSize / 2.0);
        double d3 = Math.random() * ((double)n3 - this.maxSize / 2.0);
        this.ellipses[n].setFrame(d2, d3, d, d);
    }

    public void reset(int n, int n2) {
        this.maxSize = n / 10;
        int n3 = 0;
        while (n3 < this.ellipses.length) {
            this.getRandomXY(n3, this.maxSize * Math.random(), n, n2);
            ++n3;
        }
    }

    public void step(int n, int n2) {
        int n3 = 0;
        while (n3 < this.ellipses.length) {
            int n4 = n3;
            this.estroke[n4] = this.estroke[n4] + 0.025f;
            int n5 = n3;
            this.esize[n5] = this.esize[n5] + 1.0;
            if (this.esize[n3] > this.maxSize) {
                this.getRandomXY(n3, 1.0, n, n2);
            } else {
                this.ellipses[n3].setFrame(this.ellipses[n3].getX(), this.ellipses[n3].getY(), this.esize[n3], this.esize[n3]);
            }
            ++n3;
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        int n3 = 0;
        while (n3 < this.ellipses.length) {
            graphics2D.setColor(colors[n3 % colors.length]);
            graphics2D.setStroke(new BasicStroke(this.estroke[n3]));
            graphics2D.draw(this.ellipses[n3]);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        Surface.createDemoFrame(new Ellipses());
    }
}

