/* symbols_dectlk.h - header file for speakups DecTalk Express driver. */
#define VERSION_DECTLK 07
#define NUM_STATIC_DECTLK 7
#define NUM_XTEND_DECTLK 2
#define NUM_ALIAS_DECTLK 1

/* note the trailing comma... */
#define DEFAULT_STATIC_DECTLK \
	"\x03", "[:dv ap 100]", "[:ra 300]", "", "",\
	"[:dv ap 222]", "[:dv ap 100]",

/* if empty, should *not* have a trailing comma... */
#define DEFAULT_XTEND_DECTLK \
	"[:np]","[:pu n]",

/* required settings and functionality */
#define STATIC_STR_DECTLK \
	{ "#flush", "\x03", "_", (BUILDER | HARD_DIRECT | USE_RANGE | NO_USER), { -1 } },\
	{ "pitch", "100", "[:dv ap _]", (NUMERIC | HARD_DIRECT | USE_RANGE), "50,300" }, \
	{ "rate", "300", "[:ra _]", (NUMERIC | HARD_DIRECT | USE_RANGE), "75,650" }, \
	{ "tone", "", "_", (NO_USER), { -1 } }, \
	{ "volume", "65", "[:dv gv _]", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,80" }, \
	{ "caps_start", "[:dv ap 222]", "_", 0, { -1 } }, \
	{ "caps_stop", "[:dv ap 100]", "_", 0, { -1 } }

/* additional settings and functionality */
#define XTEND_STR_DECTLK \
	{ "voice", "p", "[:n_]", (HARD_DIRECT), "phfdburwkv\xff" }, \
	{ "punct", "n", "[:pu _]", (HARD_DIRECT), { "nsa\xff" } }

#define ALIAS_STR_DECTLK ZILCH
