.TH GROFF_MARKUP @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.\" Copyright (C) 2000 Free Software Foundation, Inc.
.\"      Written by Gaius Mulley (gaius@glam.ac.uk)
.\"
.\" This file is part of groff.
.\" 
.\" groff is free software; you can redistribute it and/or modify it under
.\" the terms of the GNU General Public License as published by the Free
.\" Software Foundation; either version 2, or (at your option) any later
.\" version.
.\" 
.\" groff is distributed in the hope that it will be useful, but WITHOUT ANY
.\" WARRANTY; without even the implied warranty of MERCHANTABILITY or
.\" FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
.\" for more details.
.\" 
.\" You should have received a copy of the GNU General Public License along
.\" with groff; see the file COPYING.  If not, write to the Free Software
.\" Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
.\"
.\" user level guide to using the -markup macroset
.\"
.do mso tmac.arkup
.LINE
.SH NAME
groff_markup \- groff macros for authoring web pages
.LINE
.SH SYNOPSIS
.B "groff \-markup"
[ options ]
file ... 
.SH DESCRIPTION
This manual page describes the GNU \-markup macros, which is part of the
groff document formatting system.
The manual page is very a basic guide, and the html device driver
.RB ( grohtml )
is still very alpha.
It has been included into the distribution so that a lot of people have a
chance to test it.
Note that this macro file will be automatically called (via the
\fCtroffrc\fP file) if you use \fC-Thtml\fP.
.PP
To see the hyperlinks in action, please format this man page with the
.B grohtml
device.
.PP
Here is a summary of the functions found in this macro set.
.SH SYNPOSIS
.ta 2iL
\&.HTMLINDEX	determine automatic link cut off
.br
	point for sections/headers
.br
\&.BODYCOLOR	specify colours on a web page
.br
\&.BACKGROUND	specify background image
.br
\&.URL	create a url using two parameters
.br
\&.MAILTO	create a html email address
.br
\&.FTP	create an ftp reference
.br
\&.IMAGE	include an image file
.br
\&.HTML	pass an html raw request to the
.br
	device driver
.br
\&.TAG	generate an html name tag from $1
.br
.\"\&.CDFTP	optionally create two different links
.\".br
.\"	depending on hostname
.\".br
\&.LINE	create a full width horizontal rule
.br
.PP
Output of the
.IR pic ,
.IR eqn ,
.IR refer ,
and
.I tbl
preprocessors is acceptable as input.
.SH REQUESTS 
.TP
.B HTMLINDEX
determines the cut off point for automatic link generation to headings.
By default all headings found in a troff document have links created to them
at the top of the html web page.
It maybe that many of the lower heading levels do not require links.
Alternatively some web pages may not need any heading links at all, in which
case:
.sp
.nf
\fC\&.HTMLINDEX 0\fP
.fi
.sp
will tell
.B grohtml
not to generate links.
An \fCHTMLINDEX\fP of 2 will mean that a heading
.sp
.B "1.1.1 Some Title"
.sp
will not be included in the links either as it is said to have a heading
level of three.
.TP
.B BODYCOLOR
takes five parameters: foreground, background, active hypertext link,
hypertext link not yet visited, and visited hypertext link colour.
.TP
.B BACKGROUND
the only parameter to this macro is the background image file.
.TP
.B URL
generates
.TAG URL
a URL using either two or three arguments.
$1 is the name of the link, $2 is the actual URL, and $3 is optional stuff
to be printed immediately after $2.
Here is how to encode
.URL "homepage for groff" http://groff.ffii.org/ :
.sp
.nf
\s-2\fC\&.URL "homepage for groff" http://groff.ffii.org/ :\fP\s+2
.fi
.sp
If this is processed by a device other than \fC-Thtml\fP
it appears as:
homepage for groff \(lahttp://groff.ffii.org\(ra.
The URL macro can be of any type; for example we can reference
.URL "Eric Raymond's pic guide" pic.html
by:
.sp
.nf
\s-2\fC\&.URL "Eric Raymond's pic guide" pic.html\fP\s+2
.fi
.sp
.TP
.B MAILTO
generates an email html reference.
The first argument is mandatory as the email address.
The optional second argument is the text you see in your browser, and
an optional third argument is stuff printed immediately after the
second argument.
For example, the groff maintainers are
.MAILTO wl@gnu.org "Werner Lemberg"
and
.MAILTO Ted.Harding@nessie.mcc.ac.uk "Ted Harding" .
This is achieved by the following macros:
.sp
.nf
\s-2\fC\&.MAILTO wl@gnu.org "Werner Lemberg"\fP
.sp
\fC\&.MAILTO Ted.Harding@nessie.mcc.ac.uk \\
.br
"Ted Harding" .\s+2\fP
.fi
.sp
Note that all the urls actually are treated as consuming no textual space
in groff.
This could be considered as a bug since it causes some problems.
To circumvent this, \fCtmac.arkup\fP inserts a zero-width character which
expands to a harmless space (only if in HTML mode)
.TP
.B FTP
indicates that data can be obtained via ftp.
The first argument is the browser text and the second is the url.
A third argument, similar to the macros above, is intended for stuff printed
immediately after the second argument.
The second and the third parameter are optional.
As an example, here the location of the
.FTP "current groff development distribution" \
ftp://ftp.ffii.org/pub/groff/devel/groff-current.tar.gz .
The macro example above was specified by:
.sp
\s-2\fC\&.FTP "current groff development distribution" \\
.br
ftp://ftp.ffii.org/pub/groff/devel/groff-current.tar.gz .\fP\s+2
.sp
.TP
.B IMAGE
allows the document to include pictures.
The first argument is the image file.
The next two arguments are optional:
Argument two is the width in pixels (default is 400 pixels if absent).
The third argument is the height in pixels (default is the width value if
absent).
.sp
.TP
.B HTML
all text after this macro is treated as raw html.
If the document is processed \fIwithout\fP \fC-Thtml\fP then
the macro is ignored.
This macro is a building block for other higher level macros.
.sp
For example, the \fCBACKGROUND\fP macro is defined as:
.nf
\fC\&.de BACKGROUND
\&.   HTML <body background=\\$1>
\&..
\fP
.fi
.TP
.B TAG
generates an html name tag from its argument.
This can then be referenced using the
.URL URL #URL
macro.
As you can see, you must precede the tag name with `\fC#\fP' since it is
a local reference.
This link was achieved via placing a TAG in the URL description above;
the source looks like this:
.sp
\s-2\fC\&.TP
.br
\&.B URL
.br
generates
.br
\&.TAG URL
.br
a URL using either two or three
.br
arguments.
.br
$1 is the name of the link, $2 is the actual URL
.br
\fP\s+2etc.
.sp
.\".TP
.\".B CDFTP
.\"takes four arguments.
.\"Basically it is the FTP macro with optional local reference.
.\"It was designed to allow the same groff source to be built on two different
.\"machines and access the ftp data differently.
.\"For example, on a web server you might wish for the web page to reference
.\"a web site.
.\"However, if you were producing a CDROM of your information you might wish
.\"for the ftp data to be also stored on your CDROM and referenced as a file.
.\"An example to get the current groff development distribution
.\".CDFTP merlin "click here." \
.\"ftp://ftp.ffii.org/pub/groff/devel/groff-current.tar.gz \
.\"../../groff.tar.gz
.\"The source for this CDFTP invocation is
.\".sp
.\"\fC\s-2\&.CDFTP merlin "click here." \
.\"ftp://ftp.ffii.org/pub/groff/devel/groff-current.tar.gz \
.\"../../groff.tar.gz\fP\s+2
.\".sp
.\"which means if the html is generated on machine \fCmerlin\fP
.\"then generate a URL to \fC../../groff.tar.gz\fP.
.\"Otherwise construct an FTP URL to 
.\"\fCftp://ftp.ffii.org/pub/groff/devel/groff-current.tar.gz\fP.
.TP
.B LINE
generates a full width horizontal rule.
Example:
.sp
\fC\s-2\&.LINE\fP\s+2
.sp
.SH
SECTION HEADING LINKS
.LP
By default
.B grohtml
generates links to all section headings and places these at the top of the
html document.
.B Grohtml
has to guess what a section heading looks like \(em remember that all
.B grohtml
actually sees is a device independent language telling it where to place
text, draw lines, change font sizes and faces etc.
It believes a section heading to be a line of bold text which starts at the
left most margin.
Consequently it may misinterpret.
Users can turn off all heading and title guessing by giving invoking groff
with \fCgroff -P-g\fP.
.SH
LIMITATIONS OF GROHTML
.LP
Although basic text can be translated in a straightforward fashion there are
some areas where
.B grohtml
has to try and guess text relationship.
In particular, whenever
.B grohtml
encounters text tables and indented paragraphs or two column mode it will
try and utilize the html table construct to preserve columns.
.B Grohtml
also attempts to work out which lines should be automatically formatted by
the browser.
Ultimately in trying to make reasonable guesses most of the time it will
make mistakes.
Hopefully these mistakes will happen less and less as we get bug reports
and patches :-).
.PP
Tbl, pic, eqn's are also generated using images which may be
considered a limitation.
.SH FILES
@MACRODIR@/tmac.arkup
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@)
.BR grohtml (@MAN1EXT@),
.LP
.SH AUTHOR
.B Grohtml
is written by
.MAILTO gaius@glam.ac.uk "Gaius Mulley"
.LINE
.SH BUGS
Report bugs to the
.MAILTO bug-groff@gnu.org "Groff Bug Mailing List" .
Include a complete, self-contained example that will allow the bug to be
reproduced, and say which version of groff you are using.
.LINE
