/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;

class LDAPConnSetupMgr
implements Cloneable {
    private static final int SERIAL = 0;
    private static final int PARALLEL = 1;
    private static final int CONNECTED = 0;
    private static final int DISCONNECTED = 1;
    private static final int NEVER_USED = 2;
    private static final int FAILED = 3;
    private Socket m_socket;
    private LDAPException m_connException;
    ServerEntry[] m_dsList;
    private int m_dsIdx = -1;
    LDAPSocketFactory m_factory;
    int m_policy;
    int m_connSetupDelay;

    LDAPConnSetupMgr(String[] stringArray, int[] nArray, LDAPSocketFactory lDAPSocketFactory, int n) {
        this.m_dsList = new ServerEntry[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.m_dsList[n2] = new ServerEntry(stringArray[n2], nArray[n2], 2);
            ++n2;
        }
        this.m_factory = lDAPSocketFactory;
        this.m_policy = n < 0 ? 0 : 1;
        this.m_connSetupDelay = n * 1000;
    }

    private LDAPConnSetupMgr() {
    }

    Socket openConnection() throws LDAPException {
        this.m_socket = null;
        this.m_connException = null;
        this.sortDsList();
        if (this.m_policy == 0 || this.m_dsList.length == 1) {
            this.openSerial();
        } else {
            this.openParallel();
        }
        if (this.m_socket != null) {
            return this.m_socket;
        }
        if (this.m_connException != null) {
            throw this.m_connException;
        }
        return null;
    }

    void invalidateConnection() {
        if (this.m_socket != null) {
            this.m_dsList[this.m_dsIdx].connSetupStatus = 3;
            int n = this.m_dsList.length;
            int n2 = 0;
            ServerEntry[] serverEntryArray = new ServerEntry[this.m_dsList.length];
            int n3 = 0;
            while (n3 < n) {
                if (n3 != this.m_dsIdx) {
                    serverEntryArray[n2++] = this.m_dsList[n3];
                }
                ++n3;
            }
            serverEntryArray[n2] = this.m_dsList[this.m_dsIdx];
            this.m_dsList = serverEntryArray;
            this.m_dsIdx = n2;
        }
        this.m_socket = null;
    }

    void disconnect() {
        if (this.m_socket != null) {
            this.m_dsList[this.m_dsIdx].connSetupStatus = 1;
        }
        this.m_socket = null;
    }

    Socket getSocket() {
        return this.m_socket;
    }

    String getHost() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].host;
        }
        return this.m_dsList[0].host;
    }

    int getPort() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].port;
        }
        return this.m_dsList[0].port;
    }

    boolean isUserDisconnected() {
        return this.m_dsIdx >= 0 && this.m_dsList[this.m_dsIdx].connSetupStatus == 1;
    }

    private void openSerial() {
        int n = 0;
        while (n < this.m_dsList.length) {
            this.m_dsList[n].connSetupThread = Thread.currentThread();
            this.connectServer(n);
            if (this.m_socket != null) {
                return;
            }
            ++n;
        }
    }

    private synchronized void openParallel() {
        int n;
        int n2 = 0;
        while (this.m_socket == null && n2 < this.m_dsList.length) {
            Thread thread;
            n = n2;
            String string = "ConnSetupMgr " + this.m_dsList[n].host + ":" + this.m_dsList[n].port;
            this.m_dsList[n].connSetupThread = thread = new Thread((Runnable)new 1(n, this), string);
            thread.setDaemon(true);
            thread.start();
            if (this.m_connSetupDelay != 0 && n2 < this.m_dsList.length - 1) {
                try {
                    this.wait(this.m_connSetupDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++n2;
        }
        while (this.m_socket == null) {
            n = 0;
            int n3 = 0;
            while (n3 < this.m_dsList.length) {
                if (this.m_dsList[n3].connSetupThread != null) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void connectServer(int n) {
        ServerEntry serverEntry = this.m_dsList[n];
        Thread thread = Thread.currentThread();
        Socket socket = null;
        LDAPException lDAPException = null;
        try {
            socket = this.m_factory == null ? new Socket(serverEntry.host, serverEntry.port) : this.m_factory.makeSocket(serverEntry.host, serverEntry.port);
        }
        catch (IOException iOException) {
            lDAPException = new LDAPException("failed to connect to server " + serverEntry.host + ":" + serverEntry.port, 91);
        }
        catch (LDAPException lDAPException2) {
            lDAPException = lDAPException2;
        }
        if (thread.isInterrupted()) {
            return;
        }
        LDAPConnSetupMgr lDAPConnSetupMgr = this;
        synchronized (lDAPConnSetupMgr) {
            if (this.m_socket == null && serverEntry.connSetupThread == thread) {
                serverEntry.connSetupThread = null;
                if (socket != null) {
                    serverEntry.connSetupStatus = 0;
                    this.m_socket = socket;
                    this.m_dsIdx = n;
                    this.cleanup();
                } else {
                    serverEntry.connSetupStatus = 3;
                    this.m_connException = lDAPException;
                }
                this.notifyAll();
            }
            return;
        }
    }

    private synchronized void cleanup() {
        Thread thread = Thread.currentThread();
        int n = 0;
        while (n < this.m_dsList.length) {
            ServerEntry serverEntry = this.m_dsList[n];
            if (serverEntry.connSetupThread != null && serverEntry.connSetupThread != thread) {
                serverEntry.connSetupStatus = 3;
                serverEntry.connSetupThread.interrupt();
                serverEntry.connSetupThread = null;
            }
            ++n;
        }
    }

    private void sortDsList() {
        int n = this.m_dsList.length;
        int n2 = 1;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_dsList[n2].connSetupStatus < this.m_dsList[n3].connSetupStatus) {
                    ServerEntry serverEntry = this.m_dsList[n3];
                    this.m_dsList[n3] = this.m_dsList[n2];
                    this.m_dsList[n2] = serverEntry;
                }
                ++n3;
            }
            ++n2;
        }
    }

    boolean breakConnection() {
        try {
            this.m_socket.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        String string = "dsIdx=" + this.m_dsIdx + " dsList=";
        int n = 0;
        while (n < this.m_dsList.length) {
            string = String.valueOf(string) + this.m_dsList[n] + " ";
            ++n;
        }
        return string;
    }

    public Object clone() {
        LDAPConnSetupMgr lDAPConnSetupMgr = new LDAPConnSetupMgr();
        lDAPConnSetupMgr.m_factory = this.m_factory;
        lDAPConnSetupMgr.m_policy = this.m_policy;
        lDAPConnSetupMgr.m_connSetupDelay = this.m_connSetupDelay;
        lDAPConnSetupMgr.m_dsIdx = this.m_dsIdx;
        lDAPConnSetupMgr.m_dsList = new ServerEntry[this.m_dsList.length];
        lDAPConnSetupMgr.m_socket = this.m_socket;
        int n = 0;
        while (n < this.m_dsList.length) {
            ServerEntry serverEntry = this.m_dsList[n];
            lDAPConnSetupMgr.m_dsList[n] = new ServerEntry(serverEntry.host, serverEntry.port, serverEntry.connSetupStatus);
            ++n;
        }
        return lDAPConnSetupMgr;
    }

    class ServerEntry {
        String host;
        int port;
        int connSetupStatus;
        Thread connSetupThread;

        ServerEntry(String string, int n, int n2) {
            LDAPConnSetupMgr.this = LDAPConnSetupMgr.this;
            this.host = string;
            this.port = n;
            this.connSetupStatus = n2;
            this.connSetupThread = null;
        }

        public String toString() {
            return "{" + this.host + ":" + this.port + " status=" + this.connSetupStatus + "}";
        }
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ LDAPConnSetupMgr this$LDAPConnSetupMgr;
        private final /* synthetic */ int val$dsIdx;

        public void run() {
            this.this$LDAPConnSetupMgr.connectServer(this.val$dsIdx);
        }

        /* synthetic */ 1(int n, LDAPConnSetupMgr lDAPConnSetupMgr) {
            this.val$dsIdx = n;
            this.this$LDAPConnSetupMgr = lDAPConnSetupMgr;
        }
    }
}

