/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;

public class Introspector {
    private BeanInfo informant;
    private boolean propertyChangeSource = false;
    private Class beanClass;
    private BeanInfo superBeanInfo;
    private BeanInfo[] additionalBeanInfo;
    private static Hashtable cache = new Hashtable();
    private static Class eventListenerType = Introspector.getClassForName("java.util.EventListener.class");
    private String defaultEventName;
    private String defaultPropertyName;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private Hashtable methods = new Hashtable();
    private Hashtable properties = new Hashtable();
    private Hashtable events = new Hashtable();
    private static String[] searchPath = new String[]{"sun.beans.infos"};

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = (BeanInfo)cache.get(clazz);
        if (beanInfo == null) {
            beanInfo = new Introspector(clazz, null).getBeanInfo();
            cache.put(clazz, beanInfo);
        }
        return beanInfo;
    }

    public static BeanInfo getBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        return new Introspector(clazz, clazz2).getBeanInfo();
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static String[] getBeanInfoSearchPath() {
        return searchPath;
    }

    public static void setBeanInfoSearchPath(String[] stringArray) {
        searchPath = stringArray;
    }

    private Introspector(Class clazz, Class clazz2) throws IntrospectionException {
        this.beanClass = clazz;
        if (clazz2 != null) {
            boolean bl = false;
            Class clazz3 = clazz.getSuperclass();
            while (clazz3 != null) {
                if (clazz3 == clazz2) {
                    bl = true;
                }
                clazz3 = clazz3.getSuperclass();
            }
            if (!bl) {
                throw new IntrospectionException(String.valueOf(clazz2.getName()) + " not superclass of " + clazz.getName());
            }
        }
        this.informant = this.findInformant(clazz);
        if (clazz.getSuperclass() != clazz2) {
            this.superBeanInfo = clazz2 == null ? Introspector.getBeanInfo(clazz.getSuperclass()) : Introspector.getBeanInfo(clazz.getSuperclass(), clazz2);
        }
        if (this.informant != null) {
            this.additionalBeanInfo = this.informant.getAdditionalBeanInfo();
        }
        if (this.additionalBeanInfo == null) {
            this.additionalBeanInfo = new BeanInfo[0];
        }
    }

    private BeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor beanDescriptor = this.getTargetBeanDescriptor();
        EventSetDescriptor[] eventSetDescriptorArray = this.getTargetEventInfo();
        int n = this.getTargetDefaultEventIndex();
        PropertyDescriptor[] propertyDescriptorArray = this.getTargetPropertyInfo();
        int n2 = this.getTargetDefaultPropertyIndex();
        MethodDescriptor[] methodDescriptorArray = this.getTargetMethodInfo();
        return new GenericBeanInfo(beanDescriptor, eventSetDescriptorArray, n, propertyDescriptorArray, n2, methodDescriptorArray, this.informant);
    }

    /*
     * Unable to fully structure code
     */
    private BeanInfo findInformant(Class var1_1) {
        var2_2 = String.valueOf(var1_1.getName()) + "BeanInfo";
        try {
            var3_3 = var1_1.getClassLoader();
            var4_5 = null;
            var4_5 = var3_3 == null ? Class.forName(var2_2) : var3_3.loadClass(var2_2);
            return (BeanInfo)var4_5.newInstance();
        }
        catch (Exception v0) {
            ** while (var2_2.indexOf((int)46) > 0)
        }
lbl-1000:
        // 1 sources

        {
            var2_2 = var2_2.substring(var2_2.indexOf(46) + 1);
            continue;
        }
lbl11:
        // 1 sources

        var3_4 = 0;
        while (var3_4 < Introspector.searchPath.length) {
            try {
                var4_6 = String.valueOf(Introspector.searchPath[var3_4]) + "." + var2_2;
                var5_7 = Class.forName(var4_6);
                return (BeanInfo)var5_7.newInstance();
            }
            catch (Exception v1) {
                ++var3_4;
            }
        }
        return null;
    }

    private PropertyDescriptor[] getTargetPropertyInfo() throws IntrospectionException {
        int n;
        int n2;
        PropertyDescriptor[] propertyDescriptorArray = null;
        if (this.informant != null) {
            propertyDescriptorArray = this.informant.getPropertyDescriptors();
            n2 = this.informant.getDefaultPropertyIndex();
            if (n2 >= 0 && n2 < propertyDescriptorArray.length) {
                this.defaultPropertyName = propertyDescriptorArray[n2].getName();
            }
        }
        if (propertyDescriptorArray == null && this.superBeanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray2 = this.superBeanInfo.getPropertyDescriptors();
            int n3 = 0;
            while (n3 < propertyDescriptorArray2.length) {
                this.addProperty(propertyDescriptorArray2[n3]);
                ++n3;
            }
            n = this.superBeanInfo.getDefaultPropertyIndex();
            if (n >= 0 && n < propertyDescriptorArray2.length) {
                this.defaultPropertyName = propertyDescriptorArray2[n].getName();
            }
        }
        n2 = 0;
        while (n2 < this.additionalBeanInfo.length) {
            PropertyDescriptor[] propertyDescriptorArray3 = this.additionalBeanInfo[n2].getPropertyDescriptors();
            if (propertyDescriptorArray3 != null) {
                n = 0;
                while (n < propertyDescriptorArray3.length) {
                    this.addProperty(propertyDescriptorArray3[n]);
                    ++n;
                }
            }
            ++n2;
        }
        if (propertyDescriptorArray != null) {
            int n4 = 0;
            while (n4 < propertyDescriptorArray.length) {
                this.addProperty(propertyDescriptorArray[n4]);
                ++n4;
            }
        } else {
            Method[] methodArray = this.beanClass.getDeclaredMethods();
            n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                if (Modifier.isPublic(method.getModifiers())) {
                    String string = method.getName();
                    Class<?>[] classArray = method.getParameterTypes();
                    Class<?> clazz = method.getReturnType();
                    PropertyDescriptor propertyDescriptor = null;
                    if (string.startsWith("get") && classArray.length == 0) {
                        propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), method, null);
                    } else if (string.startsWith("get") && classArray.length == 1 && classArray[0] == Integer.TYPE) {
                        propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, method, null);
                    } else if (string.startsWith("set") && classArray.length == 1 && clazz == Void.TYPE) {
                        propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, method);
                        if (this.throwsException(method, Introspector.getClassForName("PropertyVetoException.class"))) {
                            propertyDescriptor.setConstrained(true);
                        }
                    } else if (string.startsWith("set") && classArray.length == 2 && classArray[0] == Integer.TYPE) {
                        propertyDescriptor = new IndexedPropertyDescriptor(Introspector.decapitalize(string.substring(3)), null, null, null, method);
                        if (this.throwsException(method, Introspector.getClassForName("PropertyVetoException.class"))) {
                            propertyDescriptor.setConstrained(true);
                        }
                    } else if (string.startsWith("is") && classArray.length == 0 && clazz == Boolean.TYPE) {
                        propertyDescriptor = new PropertyDescriptor(Introspector.decapitalize(string.substring(2)), method, null);
                    }
                    if (propertyDescriptor != null) {
                        if (this.propertyChangeSource) {
                            propertyDescriptor.setBound(true);
                        }
                        this.addProperty(propertyDescriptor);
                    }
                }
                ++n;
            }
        }
        PropertyDescriptor[] propertyDescriptorArray4 = new PropertyDescriptor[this.properties.size()];
        Enumeration enumeration = this.properties.elements();
        int n5 = 0;
        while (n5 < propertyDescriptorArray4.length) {
            propertyDescriptorArray4[n5] = (PropertyDescriptor)enumeration.nextElement();
            if (this.defaultPropertyName != null && this.defaultPropertyName.equals(propertyDescriptorArray4[n5].getName())) {
                this.defaultPropertyIndex = n5;
            }
            ++n5;
        }
        return propertyDescriptorArray4;
    }

    void addProperty(PropertyDescriptor propertyDescriptor) {
        String string = propertyDescriptor.getName();
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)this.properties.get(string);
        if (propertyDescriptor2 == null) {
            this.properties.put(string, propertyDescriptor);
            return;
        }
        Class clazz = propertyDescriptor2.getPropertyType();
        Class clazz2 = propertyDescriptor.getPropertyType();
        if (clazz != null && clazz2 != null && clazz != clazz2) {
            this.properties.put(string, propertyDescriptor);
            return;
        }
        PropertyDescriptor propertyDescriptor3 = propertyDescriptor2 instanceof IndexedPropertyDescriptor || propertyDescriptor instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor(propertyDescriptor2, propertyDescriptor) : new PropertyDescriptor(propertyDescriptor2, propertyDescriptor);
        this.properties.put(string, propertyDescriptor3);
    }

    private EventSetDescriptor[] getTargetEventInfo() throws IntrospectionException {
        int n;
        int n2;
        EventSetDescriptor[] eventSetDescriptorArray = null;
        if (this.informant != null) {
            eventSetDescriptorArray = this.informant.getEventSetDescriptors();
            n2 = this.informant.getDefaultEventIndex();
            if (n2 >= 0 && n2 < eventSetDescriptorArray.length) {
                this.defaultEventName = eventSetDescriptorArray[n2].getName();
            }
        }
        if (eventSetDescriptorArray == null && this.superBeanInfo != null) {
            EventSetDescriptor[] eventSetDescriptorArray2 = this.superBeanInfo.getEventSetDescriptors();
            int n3 = 0;
            while (n3 < eventSetDescriptorArray2.length) {
                this.addEvent(eventSetDescriptorArray2[n3]);
                ++n3;
            }
            n = this.superBeanInfo.getDefaultEventIndex();
            if (n >= 0 && n < eventSetDescriptorArray2.length) {
                this.defaultEventName = eventSetDescriptorArray2[n].getName();
            }
        }
        n2 = 0;
        while (n2 < this.additionalBeanInfo.length) {
            EventSetDescriptor[] eventSetDescriptorArray3 = this.additionalBeanInfo[n2].getEventSetDescriptors();
            if (eventSetDescriptorArray3 != null) {
                n = 0;
                while (n < eventSetDescriptorArray3.length) {
                    this.addEvent(eventSetDescriptorArray3[n]);
                    ++n;
                }
            }
            ++n2;
        }
        if (eventSetDescriptorArray != null) {
            int n4 = 0;
            while (n4 < eventSetDescriptorArray.length) {
                this.addEvent(eventSetDescriptorArray[n4]);
                ++n4;
            }
        } else {
            Object object;
            Object object2;
            Object object3;
            String string;
            Object object4;
            Method[] methodArray = this.beanClass.getDeclaredMethods();
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            int n5 = 0;
            while (n5 < methodArray.length) {
                object4 = methodArray[n5];
                if (Modifier.isPublic(((Method)object4).getModifiers())) {
                    string = ((Method)object4).getName();
                    object3 = ((Method)object4).getParameterTypes();
                    object2 = ((Method)object4).getReturnType();
                    if (string.startsWith("add") && ((Class<?>[])object3).length == 1 && object2 == Void.TYPE) {
                        object = String.valueOf(string.substring(3)) + ":" + object3[0];
                        hashtable.put(object, object4);
                    } else if (string.startsWith("remove") && ((Class<?>[])object3).length == 1 && object2 == Void.TYPE) {
                        object = String.valueOf(string.substring(6)) + ":" + object3[0];
                        hashtable2.put(object, object4);
                    }
                }
                ++n5;
            }
            object4 = hashtable.keys();
            this.beanClass.getName();
            while (object4.hasMoreElements()) {
                string = (String)object4.nextElement();
                if (hashtable2.get(string) == null || string.indexOf("Listener:") <= 0) continue;
                object3 = string.substring(0, string.indexOf(58));
                object2 = Introspector.decapitalize(((String)object3).substring(0, ((String)object3).length() - 8));
                object = (Method)hashtable.get(string);
                Method method = (Method)hashtable2.get(string);
                Class<?> clazz = ((Method)object).getParameterTypes()[0];
                if (!Introspector.isSubclass(clazz, eventListenerType)) continue;
                Method[] methodArray2 = clazz.getMethods();
                int n6 = 0;
                int n7 = 0;
                while (n7 < methodArray2.length) {
                    if (this.isEventHandler(methodArray2[n7])) {
                        ++n6;
                    } else {
                        methodArray2[n7] = null;
                    }
                    ++n7;
                }
                Method[] methodArray3 = new Method[n6];
                int n8 = 0;
                int n9 = 0;
                while (n9 < methodArray2.length) {
                    if (methodArray2[n9] != null) {
                        methodArray3[n8++] = methodArray2[n9];
                    }
                    ++n9;
                }
                EventSetDescriptor eventSetDescriptor = new EventSetDescriptor((String)object2, clazz, methodArray3, (Method)object, method);
                if (this.throwsException((Method)object, Introspector.getClassForName("java.util.TooManyListenersException.class"))) {
                    eventSetDescriptor.setUnicast(true);
                }
                this.addEvent(eventSetDescriptor);
            }
        }
        EventSetDescriptor[] eventSetDescriptorArray4 = new EventSetDescriptor[this.events.size()];
        Enumeration enumeration = this.events.elements();
        int n10 = 0;
        while (n10 < eventSetDescriptorArray4.length) {
            eventSetDescriptorArray4[n10] = (EventSetDescriptor)enumeration.nextElement();
            if (this.defaultEventName != null && this.defaultEventName.equals(eventSetDescriptorArray4[n10].getName())) {
                this.defaultEventIndex = n10;
            }
            ++n10;
        }
        return eventSetDescriptorArray4;
    }

    void addEvent(EventSetDescriptor eventSetDescriptor) {
        EventSetDescriptor eventSetDescriptor2;
        String string = eventSetDescriptor.getName();
        if (string.equals("propertyChange")) {
            this.propertyChangeSource = true;
        }
        if ((eventSetDescriptor2 = (EventSetDescriptor)this.events.get(string)) == null) {
            this.events.put(string, eventSetDescriptor);
            return;
        }
        EventSetDescriptor eventSetDescriptor3 = new EventSetDescriptor(eventSetDescriptor2, eventSetDescriptor);
        this.events.put(string, eventSetDescriptor3);
    }

    private MethodDescriptor[] getTargetMethodInfo() throws IntrospectionException {
        int n;
        MethodDescriptor[] methodDescriptorArray = null;
        if (this.informant != null) {
            methodDescriptorArray = this.informant.getMethodDescriptors();
        }
        if (methodDescriptorArray == null && this.superBeanInfo != null) {
            MethodDescriptor[] methodDescriptorArray2 = this.superBeanInfo.getMethodDescriptors();
            int n2 = 0;
            while (n2 < methodDescriptorArray2.length) {
                this.addMethod(methodDescriptorArray2[n2]);
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < this.additionalBeanInfo.length) {
            MethodDescriptor[] methodDescriptorArray3 = this.additionalBeanInfo[n3].getMethodDescriptors();
            if (methodDescriptorArray3 != null) {
                n = 0;
                while (n < methodDescriptorArray3.length) {
                    this.addMethod(methodDescriptorArray3[n]);
                    ++n;
                }
            }
            ++n3;
        }
        if (methodDescriptorArray != null) {
            int n4 = 0;
            while (n4 < methodDescriptorArray.length) {
                this.addMethod(methodDescriptorArray[n4]);
                ++n4;
            }
        } else {
            Method[] methodArray = this.beanClass.getDeclaredMethods();
            n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                if (Modifier.isPublic(method.getModifiers())) {
                    MethodDescriptor methodDescriptor = new MethodDescriptor(method);
                    this.addMethod(methodDescriptor);
                }
                ++n;
            }
        }
        MethodDescriptor[] methodDescriptorArray4 = new MethodDescriptor[this.methods.size()];
        Enumeration enumeration = this.methods.elements();
        int n5 = 0;
        while (n5 < methodDescriptorArray4.length) {
            methodDescriptorArray4[n5] = (MethodDescriptor)enumeration.nextElement();
            ++n5;
        }
        return methodDescriptorArray4;
    }

    private void addMethod(MethodDescriptor methodDescriptor) {
        Method method = methodDescriptor.getMethod();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(":");
            stringBuffer.append(classArray[n].getName());
            ++n;
        }
        String string = stringBuffer.toString();
        MethodDescriptor methodDescriptor2 = (MethodDescriptor)this.methods.get(string);
        if (methodDescriptor2 == null) {
            this.methods.put(string, methodDescriptor);
            return;
        }
        MethodDescriptor methodDescriptor3 = new MethodDescriptor(methodDescriptor2, methodDescriptor);
        this.methods.put(string, methodDescriptor3);
    }

    private int getTargetDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    private int getTargetDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    private BeanDescriptor getTargetBeanDescriptor() throws IntrospectionException {
        BeanDescriptor beanDescriptor;
        if (this.informant != null && (beanDescriptor = this.informant.getBeanDescriptor()) != null) {
            return beanDescriptor;
        }
        return new BeanDescriptor(this.beanClass);
    }

    private boolean isEventHandler(Method method) throws IntrospectionException {
        try {
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            String string = String.valueOf(classArray[0]);
            return string.indexOf("Event") >= 0;
        }
        catch (Exception exception) {
            throw new IntrospectionException("Unexpected reflection exception: " + exception);
        }
    }

    static Method findMethod(Class clazz, String string, int n) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method[] methodArray = clazz.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            Method method = methodArray[n2];
            if (method.getName().equals(string) && method.getParameterTypes().length == n) {
                return method;
            }
            ++n2;
        }
        return Introspector.findDirectMethod(clazz, string, n);
    }

    static Method findDirectMethod(Class clazz, String string, int n) throws IntrospectionException {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            Method method = methodArray[n2];
            if (method.getName().equals(string) && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == n) {
                return method;
            }
            ++n2;
        }
        throw new IntrospectionException("No direct method \"" + string + "\" with " + n + " arg");
    }

    static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        Class clazz3 = clazz;
        while (clazz3 != null) {
            if (clazz3 == clazz2) {
                return true;
            }
            if (clazz2.isInterface()) {
                Class<?>[] classArray = clazz3.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    if (classArray[n] == clazz2) {
                        return true;
                    }
                    ++n;
                }
            }
            clazz3 = clazz3.getSuperclass();
        }
        return false;
    }

    private boolean throwsException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n] == clazz) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Class getClassForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

