/* vi:set ts=8 sts=0 sw=8:
 * $Id: about.c,v 1.7 1998/10/18 03:54:49 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include "main.h"
#include "about.h"
#include "dialog.h"


#define APP_COPYRIGHT		"Copyright (C) 1998"
#define APP_AUTHOR_NAME		"Andy Kahn"
#define APP_AUTHOR_EMAIL	"<kahn@zk3.dec.com>"


/*** global function definitions ***/
/*
 * PUBLIC: about_cb
 *
 * menu callback to create and show the about box
 */
void
about_cb(GtkWidget *wgt, gpointer cbdata)
{
	char *title, *msg;
	int len;

	title = (char *)g_malloc(strlen(APP_NAME) + 9);
	g_snprintf(title, strlen(APP_NAME) + 9, " About %s ", APP_NAME);

	len = strlen(APP_NAME) + strlen(APP_VERSION) + strlen(APP_URL) +
	      strlen(APP_COPYRIGHT) + strlen(APP_AUTHOR_NAME) +
	      strlen(APP_AUTHOR_EMAIL) + 32;
	msg = (char *)g_malloc(len);
	g_snprintf(msg, len,
		" %s %s \n"	/* APP_NAME, APP_VERSION */
		" %s \n"	/* APP_URL */
		"\n"
		" %s \n"	/* APP_COPYRIGHT */
		" %s \n"	/* APP_AUTHOR_NAME */
		" %s ",		/* APP_AUTHOR_EMAIL */
		APP_NAME, APP_VERSION,
		APP_URL,
		APP_COPYRIGHT,
		APP_AUTHOR_NAME, APP_AUTHOR_EMAIL
	);

	(void)do_dialog_ok(title, msg);
	g_free(msg);
	g_free(title);
} /* about_cb */


/* the end */
