/*
 * mkraid.c : Utility for the Linux Multiple Devices driver
 *            Copyright (C) 1997 Ingo Molnar, Miguel de Icaza, Gadi Oxman
 *
 * This utility reads a Linux MD raid1/4/5 configuration file, writes a
 * raid superblock on the devices in the raid set, and initializes the
 * set for first time use, depending on command line switches and
 * configuration file settings.
 *
 * This source is covered by the GNU GPL, the same as all Linux kernel
 * sources.
 */

#include "common.h"
#include "parser.h"
#include "raid_sb.h"


md_cfg_entry_t *cfg_head = NULL, *cfg = NULL;
int force_flag = 0;
static int no_clear_flag = 0;
static int asked_for_usage_flag = 0;

void usage() {
	fprintf(stderr, "usage: mkraid [-f] [--only-superblock] conf_file\n");
}

int parse_switches(int argc, char *argv[])
{
	int i, name_index = 0;

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			if(argv[i][1] == 'f') {
				force_flag = 1;
				continue;
			}
			if((argv[i][1] == 'h') ||
				(!(strncmp(argv[i], "--h",3)))) {
				usage();
				exit(EXIT_USAGE);
			}
			if(strcmp(argv[i], "--only-superblock") == 0) {
				no_clear_flag = 1;
				continue;
			}
			return 0;
		} else {
			if (name_index)
				return 0;
			name_index = i;
		}
	}
	return name_index;
}

int main (int argc, char *argv[])
{
	FILE *fp = NULL;
	int name_index;
	md_cfg_entry_t *p;
	int exit_status=0;

	name_index = parse_switches(argc, argv);
	if (!name_index) { usage(); goto abort; }
	fp = fopen(argv[name_index], "r");
	if (fp == NULL) {
		fprintf(stderr, "Couldn't open %s -- %s\n", argv[name_index], strerror(errno));
		goto abort;
	}
	srand((unsigned int) time(NULL));
	printf("mkraid version %d.%d.%d\n", MKRAID_MAJOR_VERSION, MKRAID_MINOR_VERSION, MKRAID_PATCHLEVEL_VERSION);
	if (parse_config(fp))
		goto abort;
	if (analyze_sb())
		goto abort;
	for (p = cfg_head; p; p = p->next)
		if (check_active(p)) goto abort;
	if (!no_clear_flag && init_set())
		goto abort;
	if (write_sb(0))
		goto abort;
	printf("mkraid: completed\n");
	fclose(fp);
	return 0;
abort:
	fprintf(stderr, "mkraid: aborted\n");
	exit_status = 1;
end:
	if (fp)
		fclose(fp);
	return exit_status;
}
