#ifndef _X286EMUL_H_
#define _X286EMUL_H_

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif

#if LINUX_VERSION_CODE > 0x020144
#define sigcontext_struct sigcontext
#endif
#include <asm/sigcontext.h>

extern unsigned long init_entry, init_cs, init_ds, limit_stk, init_stk;

extern struct xexec *xexec;
extern struct xext *xext;

extern volatile struct sigcontext_struct *prog_sc;
extern unsigned long SEGV_STACK;
extern int LDATA,LTEXT;

#ifdef DEBUG
extern void dump_state(unsigned char *, unsigned short *,
			struct sigcontext_struct *);
#endif

void x286syscall(struct sigcontext_struct *);

int verify_area(int , unsigned long , unsigned long , unsigned long );
#define VERIFY_WRITE 1
#define VERIFY_READ 2
#define VERIFY_EXEC 3

#endif /* _X286EMUL_H_ */
