/* Save the initial execution environment details for the 286
 * executable and invoke the emulator.
 */

		.text
		.align 4
.globl ___START___
.globl _start
___START___:
_start:
		movl %eax,_init_entry
		movl %ebx,_init_cs
		movl %ecx,_init_ds
		movl %ecx,_init_ss
		movl %edx,_limit_stk
		movl $__boot_crt0,%eax
		jmp *%eax

#ifdef NEW_SYSCALL
/* Routine called by x286 program to do a syscall */
		.align 4
.globl ___x286syscall
___x286syscall:
		fs/movl %esp,__em_tesp	/* Save stack pointer */
		fs/movl %ss,__em_tss	/* Save stack segment reg */
		fs/lss __em_esp,%esp	/* Load emulator stack pointer */
		pushfl
		fs/addl $4,__em_tesp	/* remove the return loc. from the prog stack */
		popfl
/* now make the stack look like a trap was hit */
		fs/pushl __em_tss
		fs/pushl __em_tesp
		pushfl
		pushl $0		/* Space for cs */
		pushl $0  		/* Space for eip */
		pushl $0		/* err */
		pushl $0		/* trapno */
		pushl %eax
		pushl %ecx
		pushl %edx
		pushl %ebx
		fs/pushl __em_tesp
		pushl %ebp
		pushl %esi
		pushl %edi
		pushl %ds
		pushl %es
		pushl %fs
		pushl %gs
		fs/mov __em_ss,%ds	/* assume ss = ds = es in 386 prog ? */
		fs/mov __em_ss,%es
		mov %esp,%ebp
		call __x286syscall
		popl %gs
		popl %fs
		popl %es
		popl %ds
		popl %edi
		popl %esi
		popl %ebp
		fs/popl __em_tesp
		popl %ebx
		popl %edx
		popl %ecx
		popl %eax
		addl $8,%esp		/* err and trapno */
		addl $8,%esp		/* eip and cs */
		fs/subl $4,__em_tesp	/* put return loc. back */
		popfl
		fs/popl __em_tss	/* get rid of esp at signal */
		fs/popl __em_tss
		fs/lss __em_tesp,%esp	/* back to 286 stack */
		.byte 0x66		/* operand-size override */
		lret
#endif
		

/* lcall7(function,...) */
/* returns result in eax and poss edx */
		.align 4
.globl _lcall7
_lcall7:
		popl %edx
		popl %eax
		pushl %edx
		movl %eax,%ebx
		.byte 0x9a,0,0,0,0,7,0	/* lcall $7,0 */
		jnc L1
		movl %eax,_errno
		movl $-1,%eax
L1:
		popl %ecx
		pushl %ebx
		pushl %ecx
		ret


/* Set the initial execution state and enter the 286 program. */
		.align 4
.globl _x286boot
_x286boot:
#ifdef NEW_SYSCALL
		movl %esp,__em_esp	/* save emulator stack */
		movl %ss,__em_ss
#endif
		mov  %ds,%ax		/* ensure %fs == %ds */
		mov  %ax,%fs
		subl %eax,%eax
		movl %eax,%ebx
		movl %eax,%ecx
		movl %eax,%edx
		movl %eax,%ebp
		movl %eax,%esi
		movl %eax,%edi
		push %eax
		popfl

		lss _init_stk,%esp
		movl %esp,%ebp
		movl _init_ds,%eax
		mov  %ax,%ds
		mov  %ax,%es

		fs/ljmp _init_entry

		.fill 1024,1,0xf4
__boot_crt0:

		.data
		.align 4
		.globl _init_cs
		.globl _init_entry
		.globl _init_ds
		.globl _limit_stk
		.globl _init_ss
		.globl _init_stk
_init_entry:	.long 0
_init_cs:	.long 0
_limit_stk:	.long 0
_init_ds:	.long 0
_init_stk:	.long 0
_init_ss:	.long 0

#ifdef NEW_SYSCALL
__em_esp:	.long 0
__em_ss:	.long 0
__em_tesp:	.long 0
__em_tss:	.long 0
#endif
