/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.ResponseControl;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.client.JDAPControl;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResult;
import netscape.ldap.client.opers.JDAPSearchResultReference;
import netscape.ldap.client.opers.JDAPUnbindRequest;

class LDAPConnThread
extends Thread {
    private static final int MAXMSGID = Integer.MAX_VALUE;
    private transient int m_highMsgId = 0;
    private transient InputStream m_serverInput;
    private transient OutputStream m_serverOutput;
    private transient Hashtable m_requests = new Hashtable();
    private transient Hashtable m_messages;
    private transient Vector m_registered = new Vector();
    private transient boolean m_disconnected = false;
    private transient LDAPCache m_cache;
    private transient boolean m_failed = false;
    private Object m_securityLayer;
    private Socket m_socket;
    private int m_maxBacklog = 100;

    public LDAPConnThread(String string, int n, LDAPSocketFactory lDAPSocketFactory, LDAPCache lDAPCache) throws LDAPException {
        this.m_cache = lDAPCache;
        if (this.m_cache != null) {
            this.m_messages = new Hashtable();
        }
        try {
            this.m_socket = lDAPSocketFactory == null ? new Socket(string, n) : lDAPSocketFactory.makeSocket(string, n);
            this.m_serverInput = new BufferedInputStream(this.m_socket.getInputStream());
            this.m_serverOutput = new BufferedOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.m_failed = true;
            this.start();
            throw new LDAPException("failed to connect to server " + string, 91);
        }
        this.start();
    }

    synchronized void sendRequest(JDAPProtocolOp jDAPProtocolOp, LDAPResponseListener lDAPResponseListener, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        JDAPMessage jDAPMessage;
        if (this.m_serverOutput == null) {
            throw new LDAPException("not connected to a server", 80);
        }
        LDAPControl[] lDAPControlArray = lDAPSearchConstraints.getServerControls();
        if (lDAPControlArray != null && lDAPControlArray.length > 0) {
            JDAPControl[] jDAPControlArray = new JDAPControl[lDAPControlArray.length];
            int n = 0;
            while (n < lDAPControlArray.length) {
                jDAPControlArray[n] = new JDAPControl(lDAPControlArray[n].getID(), lDAPControlArray[n].isCritical(), lDAPControlArray[n].getValue());
                ++n;
            }
            jDAPMessage = new JDAPMessage(this.allocateId(), jDAPProtocolOp, jDAPControlArray);
        } else {
            jDAPMessage = new JDAPMessage(this.allocateId(), jDAPProtocolOp);
        }
        if (lDAPResponseListener != null) {
            if (!(jDAPProtocolOp instanceof JDAPAbandonRequest) && !(jDAPProtocolOp instanceof JDAPUnbindRequest)) {
                this.m_requests.put(new Integer(jDAPMessage.getId()), lDAPResponseListener);
                this.resultRetrieved();
            }
            lDAPResponseListener.setID(jDAPMessage.getId());
        }
        try {
            jDAPMessage.write(this.m_serverOutput);
            this.m_serverOutput.flush();
            return;
        }
        catch (IOException iOException) {
            this.networkError(iOException);
            return;
        }
    }

    public synchronized void register(LDAPConnection lDAPConnection) {
        if (!this.m_registered.contains(lDAPConnection)) {
            this.m_registered.addElement(lDAPConnection);
        }
    }

    void setSecurityLayer(Object object) {
        this.m_securityLayer = object;
    }

    synchronized int getClientCount() {
        return this.m_registered.size();
    }

    public synchronized void deregister(LDAPConnection lDAPConnection) {
        this.m_registered.removeElement(lDAPConnection);
        if (this.m_registered.size() == 0) {
            try {
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                this.sendRequest(new JDAPUnbindRequest(), null, lDAPSearchConstraints);
                this.cleanUp();
                this.stop();
                Thread.sleep(100L);
                return;
            }
            catch (Exception exception) {
                LDAPConnection.printDebug(exception.toString());
                return;
            }
        }
    }

    private void cleanUp() {
        if (!this.m_disconnected) {
            Enumeration enumeration;
            try {
                try {
                    this.m_serverOutput.close();
                }
                catch (Exception exception) {
                }
                enumeration = null;
                this.m_serverOutput = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.m_serverOutput = null;
                throw throwable;
            }
            try {
                try {
                    this.m_serverInput.close();
                }
                catch (Exception exception) {
                }
                enumeration = null;
                this.m_serverInput = null;
            }
            catch (Throwable throwable) {
                enumeration = null;
                this.m_serverInput = null;
                throw throwable;
            }
            try {
                try {
                    this.m_socket.close();
                }
                catch (Exception exception) {
                }
                enumeration = null;
                this.m_socket = null;
            }
            catch (Throwable throwable) {
                enumeration = null;
                this.m_socket = null;
                throw throwable;
            }
            this.m_disconnected = true;
            if (this.m_registered != null) {
                Vector vector = (Vector)this.m_registered.clone();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    LDAPConnection lDAPConnection = (LDAPConnection)enumeration.nextElement();
                    lDAPConnection.deregisterConnection();
                }
            }
            this.m_registered = null;
            this.m_messages = null;
            this.m_requests.clear();
        }
    }

    void setMaxBacklog(int n) {
        this.m_maxBacklog = n;
    }

    int getMaxBacklog() {
        return this.m_maxBacklog;
    }

    private void checkBacklog() {
        boolean bl;
        do {
            Object object;
            bl = false;
            Enumeration enumeration = this.m_requests.elements();
            while (enumeration.hasMoreElements()) {
                object = (LDAPResponseListener)enumeration.nextElement();
                if (!(object instanceof LDAPSearchListener)) {
                    bl = false;
                    break;
                }
                LDAPSearchListener lDAPSearchListener = (LDAPSearchListener)object;
                if (lDAPSearchListener.getConstraints().getBatchSize() == 0 || lDAPSearchListener.getCount() < this.m_maxBacklog) continue;
                bl = true;
            }
            if (!bl) continue;
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (bl);
    }

    synchronized void resultRetrieved() {
        this.notifyAll();
    }

    public void run() {
        if (this.m_failed) {
            this.stop();
        }
        JDAPMessage jDAPMessage = null;
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        do {
            Thread.yield();
            int[] nArray = new int[]{0};
            this.checkBacklog();
            try {
                BERElement bERElement = BERElement.getElement(jDAPBERTagDecoder, this.m_serverInput, nArray);
                jDAPMessage = new JDAPMessage(bERElement);
                this.processResponse(jDAPMessage, nArray[0]);
            }
            catch (Exception exception) {
                this.networkError(exception);
            }
        } while (!this.m_disconnected);
    }

    private synchronized int allocateId() {
        this.m_highMsgId = (this.m_highMsgId + 1) % Integer.MAX_VALUE;
        return this.m_highMsgId;
    }

    private synchronized void processResponse(JDAPMessage jDAPMessage, int n) {
        Integer n2 = new Integer(jDAPMessage.getId());
        LDAPResponseListener lDAPResponseListener = (LDAPResponseListener)this.m_requests.get(n2);
        if (lDAPResponseListener == null) {
            return;
        }
        LDAPControl[] lDAPControlArray = this.checkControls(jDAPMessage);
        ResponseControl responseControl = null;
        if (lDAPControlArray != null) {
            responseControl = new ResponseControl(lDAPResponseListener.getConnection(), jDAPMessage.getId(), lDAPControlArray);
        }
        lDAPResponseListener.getConnection().setResponseControls(this, responseControl);
        JDAPProtocolOp jDAPProtocolOp = jDAPMessage.getProtocolOp();
        Vector<LDAPEntry> vector = null;
        if (jDAPProtocolOp instanceof JDAPSearchResponse || jDAPProtocolOp instanceof JDAPSearchResultReference) {
            ((LDAPSearchListener)lDAPResponseListener).addSearchResult(jDAPMessage);
            Long l = ((LDAPSearchListener)lDAPResponseListener).getKey();
            if (this.m_cache != null && l != null) {
                vector = (Vector<LDAPEntry>)this.m_messages.get(n2);
                if (vector == null) {
                    vector = new Vector<LDAPEntry>();
                    vector.addElement((LDAPEntry)((Object)new Long(0L)));
                }
                long l2 = (Long)vector.firstElement() + (long)n;
                vector.setElementAt((LDAPEntry)((Object)new Long(l2)), 0);
                vector.addElement(this.constructLDAPEntry(jDAPMessage));
                this.m_messages.put(n2, vector);
                return;
            }
        } else {
            Long l;
            lDAPResponseListener.setResponse(jDAPMessage);
            if (lDAPResponseListener instanceof LDAPSearchListener && (l = ((LDAPSearchListener)lDAPResponseListener).getKey()) != null) {
                JDAPResult jDAPResult;
                boolean bl = false;
                JDAPProtocolOp jDAPProtocolOp2 = jDAPMessage.getProtocolOp();
                if (jDAPProtocolOp2 instanceof JDAPSearchResult && (jDAPResult = (JDAPResult)((Object)jDAPProtocolOp2)).getResultCode() > 0) {
                    bl = true;
                }
                if (!bl && this.m_cache != null) {
                    vector = (Vector<LDAPEntry>)this.m_messages.remove(n2);
                    if (vector == null) {
                        vector = new Vector<LDAPEntry>();
                        vector.addElement((LDAPEntry)((Object)new Long(0L)));
                    }
                    try {
                        this.m_cache.addEntry(l, vector);
                    }
                    catch (LDAPException lDAPException) {
                        System.out.println("Exception: " + lDAPException.toString());
                    }
                }
            }
            this.m_requests.remove(n2);
        }
    }

    private LDAPEntry constructLDAPEntry(JDAPMessage jDAPMessage) {
        JDAPProtocolOp jDAPProtocolOp = jDAPMessage.getProtocolOp();
        JDAPSearchResponse jDAPSearchResponse = (JDAPSearchResponse)jDAPProtocolOp;
        LDAPAttribute[] lDAPAttributeArray = jDAPSearchResponse.getAttributes();
        LDAPAttributeSet lDAPAttributeSet = lDAPAttributeArray != null ? new LDAPAttributeSet(lDAPAttributeArray) : new LDAPAttributeSet();
        String string = jDAPSearchResponse.getObjectName();
        return new LDAPEntry(string, lDAPAttributeSet);
    }

    private LDAPControl[] checkControls(JDAPMessage jDAPMessage) {
        JDAPControl[] jDAPControlArray;
        LDAPControl[] lDAPControlArray = null;
        if (jDAPMessage != null && (jDAPControlArray = jDAPMessage.getControls()) != null && jDAPControlArray.length > 0) {
            lDAPControlArray = new LDAPControl[jDAPControlArray.length];
            int n = 0;
            while (n < jDAPControlArray.length) {
                lDAPControlArray[n] = new LDAPControl(jDAPControlArray[n].getID(), jDAPControlArray[n].isCritical(), jDAPControlArray[n].getValue());
                ++n;
            }
        }
        return lDAPControlArray;
    }

    void abandon(int n) {
        this.m_requests.remove(new Integer(n));
    }

    private synchronized void networkError(Exception exception) {
        Object object;
        Object object2;
        try {
            object2 = this.m_requests.elements();
            while (object2.hasMoreElements()) {
                object = (LDAPResponseListener)object2.nextElement();
                ((LDAPResponseListener)object).setException(new LDAPException("Server down", 80));
            }
            this.cleanUp();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Exception: " + nullPointerException.toString());
        }
        if (this.m_registered != null) {
            object2 = (Vector)this.m_registered.clone();
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                LDAPConnection lDAPConnection = (LDAPConnection)object.nextElement();
                lDAPConnection.deregisterConnection();
            }
        }
    }
}

