!include <win32.mak>

MESALIB = ..\..\lib

CFLAGS= /Ox /G5 /D__MSC__ /DFX /D__WIN32__ /DWIN32 \
        /I..\..\include \

LINK=   /link $(MESALIB)\OpenGL32.lib $(MESALIB)\GLU32.lib \
        $(MESALIB)\GLUT32.lib \
        glide2x.lib kernel32.lib user32.lib gdi32.lib winmm.lib

EXES =  teapot.exe fire.exe terrain.exe tunnel.exe  \
        paltex.exe glbpaltx.exe ray.exe tunnel2.exe \
	gltest.exe ipers.exe

all: copydll $(EXES)

copydll:
        copy $(MESALIB)\*.dll .

gltest.exe: gltest.c
        $(CC) $(CFLAGS) gltest.c $(LINK)

ipers.exe: ipers.c image.c
        $(CC) $(CFLAGS) ipers.c image.c $(LINK)

ray.exe: ray.c
        $(CC) $(CFLAGS) ray.c $(LINK)

teapot.exe: teapot.c image.c dteapot.c shadow.c
        $(CC) $(CFLAGS) teapot.c image.c dteapot.c shadow.c $(LINK)

fire.exe: fire.c image.c
        $(CC) $(CFLAGS) fire.c image.c $(LINK)

terrain.exe: mesaland.c
        $(CC) $(CFLAGS) /oterrain.exe mesaland.c $(LINK)

tunnel.exe: tunnel.c sources.c image.c
        $(CC) $(CFLAGS) tunnel.c sources.c image.c $(LINK)

tunnel2.exe: tunnel2.c sources.c image.c
        $(CC) $(CFLAGS) tunnel2.c sources.c image.c $(LINK)

paltex.exe: paltex.c
        $(CC) $(CFLAGS) paltex.c $(LINK)

glbpaltx.exe: glbpaltx.c
        $(CC) $(CFLAGS) glbpaltx.c $(LINK)

