#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>

/***************************************************************************
 *
 * Function:    vfprintf
 *
 * Description:
 *     Formatted print data to the stream using variable arguments.
 *
 * Input:
 *     stream   - pointer to the output stream
 *     format   - pointer to the format string
 *     ap       - variable arg list pointer
 *
 * Result:
 *     The number of characters written to the output.
 */

int vfprintf (FILE *fpStream, const char *pszFormat, va_list ap)
    {
    int     fBuffering;
    int     nAnswer;
    FUNC_ENTRY ("vfprintf");
/*
 *  Ensure that the file is fully buffered and edit the output stream.
 */
    fBuffering = _stbuf (fpStream);
/*
 *  Output the stream
 */
    nAnswer = _doprnt (pszFormat, ap, fpStream);
/*
 *  Restore the buffering state and return the number of characters
 *  written to the output file.
 */
    _ftbuf (fBuffering, fpStream);
    FUNC_EXIT ("vfprintf");
    return(nAnswer);
    }



