#include <stdio.h>
#include <errno.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/*************************************************************************
 *
 * Function:     _getstream
 *
 * Description:
 *   Locate an empty stream to be used for the new file.
 *
 * Entry:
 *   none.
 *
 * Returns:
 *    A pointer to the stream or NULL to indicate that the file table is
 *    full. (The errno will have been set prior to the error return.)
 */

FILE *_getstream (void)
    {
    FILE   *fpStream;
    FUNC_ENTRY ("_getstream");
/*
 *  Find the next available file table
 */
    for (fpStream = &_iob[0];; ++fpStream)
        {
	if (fpStream == _lastiob)
	    {
	    fpStream = NULL;
	    errno    = EBADF;
	    break;
	    }

	if (!inuse (fpStream))
	    {
            fpStream->_flag =
	    fpStream->_cnt  = 0;
            fpStream->_ptr  =
            fpStream->_base = NULL;
            fpStream->_file = -1;
	    break;
	    }
        }
/*
 *  Return the pointer to the resulting stream
 */
    FUNC_EXIT ("_getstream");
    return (fpStream);
    }
