/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.DragDestination;
import netscape.application.DragSession;
import netscape.application.Event;
import netscape.application.EventFilter;
import netscape.application.ExtendedTarget;
import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.HTMLElement;
import netscape.application.HTMLParser;
import netscape.application.HTMLParsingException;
import netscape.application.HTMLParsingRules;
import netscape.application.Image;
import netscape.application.ImageAttachment;
import netscape.application.JDK11AirLock;
import netscape.application.KeyEvent;
import netscape.application.MouseEvent;
import netscape.application.ObjectPool;
import netscape.application.Point;
import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.TextAttachment;
import netscape.application.TextFilter;
import netscape.application.TextParagraph;
import netscape.application.TextParagraphFormat;
import netscape.application.TextPositionInfo;
import netscape.application.TextSelection;
import netscape.application.TextStyleRun;
import netscape.application.TextViewHTMLElement;
import netscape.application.TextViewOwner;
import netscape.application.Timer;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class TextView
extends View
implements ExtendedTarget,
EventFilter,
DragDestination,
FormElement {
    public static final String TEXT_ATTACHMENT_STRING = "@";
    public static final String PARAGRAPH_FORMAT_KEY = "ParagraphFormatKey";
    public static final String FONT_KEY = "FontKey";
    public static final String TEXT_COLOR_KEY = "TextColorKey";
    public static final String TEXT_ATTACHMENT_KEY = "TextAttachmentKey";
    public static final String TEXT_ATTACHMENT_BASELINE_OFFSET_KEY = "TextAttachmentBaselineOffsetKey";
    public static final String CARET_COLOR_KEY = "CaretColorKey";
    public static final String LINK_KEY = "LinkKey";
    public static final String LINK_DESTINATION_KEY = "LinkDestinationKey";
    public static final String LINK_COLOR_KEY = "LinkColorKey";
    public static final String PRESSED_LINK_COLOR_KEY = "PressedLinkColorKey";
    static final String LINK_IS_PRESSED_KEY = "_IFCLinkPressedKey";
    static Vector attributesChangingFormatting = new Vector();
    Vector _paragraphVector;
    Color _backgroundColor;
    Color _selectionColor;
    TextParagraph _updateParagraph;
    TextPositionInfo _anchorInfo;
    TextPositionInfo _upInfo;
    TextSelection _selection;
    TextFilter _filter;
    TextViewOwner _owner;
    Hashtable _defaultAttributes;
    Hashtable _typingAttributes;
    Timer _updateTimer;
    Vector _eventVector = new Vector();
    int _charCount;
    int _paragraphSpacing = 0;
    int _updateLine;
    int _downY;
    int _clickCount;
    int _resizeDisabled;
    int _formattingDisabled;
    boolean _drawText = true;
    boolean _editing;
    boolean _useSingleFont = false;
    boolean _editable = true;
    boolean _selectable = true;
    boolean _drawNextParagraph;
    boolean _resizing = false;
    boolean insertionPointVisible = false;
    boolean transparent = false;
    boolean selectLineBreak;
    private Range _selectedRange;
    private Range _wasSelectedRange;
    private TextAttachment _mouseDownTextAttachment;
    private Point _mouseDownTextAttachmentOrigin;
    private FontMetrics _defaultFontMetricsCache;
    private URL _baseURL;
    private Range _clickedRange;
    private Range _firstRange;
    private HTMLParsingRules _htmlParsingRules;
    private int notifyAttachmentDisabled;
    private Range invalidAttachmentRange;
    private static Vector _rectCache;
    private static Vector _vectorCache;
    private static boolean _shouldCache;
    private static boolean _cacheVectors;
    static ObjectPool hashtablePool;
    static ObjectPool rangePool;
    static final String PARAGRAPHVECTOR_KEY = "paragraphVector";
    static final String BACKGROUNDCOLOR_KEY = "backgroundColor";
    static final String SELECTIONCOLOR_KEY = "selectionColor";
    static final String FILTER_KEY = "filter";
    static final String DEFAULTATTRIBUTES_KEY = "defaultAttributes";
    static final String PARASPACING_KEY = "paragraphSpacing";
    static final String USESINGLEFONT_KEY = "useSingleFont";
    static final String EDITABLE_KEY = "editable";
    static final String SELECTABLE_KEY = "selectable";
    static final String TRANSPARENT_KEY = "transparent";
    static final String HTML_PARSING_RULES_KEY = "htmlParsingRules";
    static final String OWNER_KEY = "owner";

    public TextView() {
        this(0, 0, 0, 0);
    }

    public TextView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public TextView(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this._selection = new TextSelection(this);
        this._paragraphVector = new Vector();
        this._backgroundColor = Color.white;
        this._selectionColor = Color.lightGray;
        this._defaultAttributes = new Hashtable();
        this._defaultAttributes.put((Object)FONT_KEY, (Object)Font.defaultFont());
        this._defaultAttributes.put((Object)TEXT_COLOR_KEY, (Object)Color.black);
        this._defaultAttributes.put((Object)LINK_COLOR_KEY, (Object)Color.blue);
        this._defaultAttributes.put((Object)CARET_COLOR_KEY, (Object)Color.black);
        this._defaultAttributes.put((Object)PRESSED_LINK_COLOR_KEY, (Object)Color.red);
        TextParagraphFormat textParagraphFormat = new TextParagraphFormat();
        textParagraphFormat.setLeftMargin(3);
        textParagraphFormat.setRightMargin(3);
        textParagraphFormat.setJustification(0);
        int n5 = 30;
        int n6 = 0;
        while (n6 < 20) {
            textParagraphFormat.addTabPosition(n5);
            n5 += 30;
            ++n6;
        }
        this._defaultAttributes.put((Object)PARAGRAPH_FORMAT_KEY, (Object)textParagraphFormat);
        this._wasSelectedRange = new Range(this.selectedRange());
        TextParagraph textParagraph = new TextParagraph(this);
        textParagraph.addRun(new TextStyleRun(textParagraph, "", null));
        this.addParagraph(textParagraph);
        this.reformatAll();
        this._typingAttributes = new Hashtable();
    }

    public void didMoveBy(int n, int n2) {
        if (n == 0 && n2 == 0 && this._updateTimer != null) {
            this._updateTimer.stop();
            this._updateTimer = null;
            this._updateParagraph = null;
        }
        super.didMoveBy(n, n2);
    }

    public void sizeBy(int n, int n2) {
        if (!this.isResizingEnabled()) {
            return;
        }
        int n3 = this.bounds.width;
        this._resizing = true;
        super.sizeBy(n, n2);
        this._resizing = false;
        if (this.bounds.width != n3 + n) {
            this.disableResizing();
            this.reformatAll();
            this.enableResizing();
            this.setDirty(true);
            return;
        }
        if (n != 0 || n2 != 0) {
            this.setDirty(true);
        }
    }

    public void didSizeBy(int n, int n2) {
        if (!this._resizing) {
            this.reformatAll();
        }
        super.didSizeBy(n, n2);
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean wantsAutoscrollEvents() {
        return true;
    }

    public void drawView(Graphics graphics) {
        if (!this._drawText) {
            if (this._updateParagraph != null) {
                this._updateParagraph.drawLine(graphics, this._updateLine);
            }
        } else {
            int n = this._paragraphVector.count();
            int n2 = graphics.clipRect().y;
            int n3 = graphics.clipRect().maxY();
            Rect rect = Rect.newRect(0, 0, this.width(), this.height());
            int n4 = 0;
            while (n4 < n) {
                TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n4);
                if (textParagraph._y <= n3 && textParagraph._y + textParagraph._height >= n2) {
                    textParagraph.drawView(graphics, rect);
                }
                ++n4;
            }
            Rect.returnRect(rect);
        }
        if (this._selection._insertionPointShowing) {
            Rect rect = this._selection.insertionPointRect();
            Color color = null;
            if (graphics.clipRect().intersects(rect)) {
                TextPositionInfo textPositionInfo = this._selection.insertionPointInfo();
                TextStyleRun textStyleRun = this._runForIndex(textPositionInfo._absPosition);
                Hashtable hashtable = textStyleRun.attributes();
                if (hashtable != null) {
                    color = (Color)hashtable.get((Object)CARET_COLOR_KEY);
                }
                if (color == null) {
                    color = (Color)this._defaultAttributes.get((Object)CARET_COLOR_KEY);
                }
                if (color == null) {
                    color = Color.black;
                }
                graphics.setColor(color);
                graphics.fillRect(rect);
            }
        }
    }

    public Object filterEvents(Vector vector) {
        int n = 0;
        while (n < vector.count()) {
            Event event = (Event)vector.elementAt(n);
            if (event instanceof KeyEvent && event.type() == -11) {
                if (this._filter != null) {
                    if (this._filter.acceptsEvent(this, (KeyEvent)event, this._eventVector)) {
                        this._eventVector.addElement((Object)event);
                    }
                } else {
                    this._eventVector.addElement((Object)event);
                }
                vector.removeElementAt(n);
                --n;
            }
            ++n;
        }
        return null;
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        Hashtable hashtable;
        Object object;
        this._mouseDownTextAttachment = null;
        this._clickedRange = null;
        if (this.isEditable() || this.isSelectable()) {
            this.setFocusedView();
        }
        if (!this.rootView().mouseStillDown()) {
            this.rootView().adjustForExpectedMouseDownCount();
            if (!this.rootView().mouseStillDown()) {
                return true;
            }
        }
        this._selection.hideInsertionPoint();
        this._clickCount = mouseEvent.clickCount();
        this._anchorInfo = this.positionForPoint(mouseEvent.x, mouseEvent.y, false);
        TextPositionInfo textPositionInfo = this.positionForPoint(mouseEvent.x, mouseEvent.y, true);
        this.selectLineBreak = this._anchorInfo != null && this._anchorInfo._endOfLine ? ((Rect)(object = new Rect(this._anchorInfo._x, this._anchorInfo._y, this.bounds.width, this._anchorInfo._lineHeight))).contains(mouseEvent.x, mouseEvent.y) : false;
        if (textPositionInfo != null && (object = this._runForIndex(textPositionInfo._absPosition)) != null && (hashtable = ((TextStyleRun)object).attributes()) != null) {
            boolean bl;
            Rect rect;
            TextAttachment textAttachment = (TextAttachment)hashtable.get((Object)TEXT_ATTACHMENT_KEY);
            if (textAttachment != null && ((TextStyleRun)object).rangeIndex() == textPositionInfo._absPosition && (rect = ((TextStyleRun)object).textAttachmentBoundsForOrigin(textPositionInfo._x, textPositionInfo._y, ((TextStyleRun)object)._paragraph._baselines[textPositionInfo._lineNumber])) != null && rect.contains(mouseEvent.x, mouseEvent.y) && (bl = textAttachment.mouseDown(new MouseEvent(mouseEvent.timeStamp, mouseEvent.type, mouseEvent.x - rect.x, mouseEvent.y - rect.y, mouseEvent.modifiers)))) {
                this._mouseDownTextAttachment = textAttachment;
                this._mouseDownTextAttachmentOrigin = new Point(rect.x, rect.y);
                return true;
            }
            if (!this.isEditable() && hashtable.get((Object)LINK_KEY) != null && this.runUnderMouse((TextStyleRun)object, mouseEvent.x, mouseEvent.y) && this._clickCount == 1) {
                this._clickedRange = this.linkRangeForPosition(textPositionInfo._absPosition);
                this.highlightLinkWithRange(this._clickedRange, true);
            }
        }
        if (!this.isSelectable() && this._clickedRange == null) {
            return false;
        }
        this._firstRange = null;
        if (this._clickCount > 1) {
            if (!this.selectLineBreak) {
                switch (this._clickCount) {
                    case 2: {
                        this._firstRange = this.groupForIndex(this._anchorInfo._absPosition);
                        break;
                    }
                    default: {
                        this._firstRange = this.paragraphForIndex(this._anchorInfo._absPosition);
                    }
                }
                if (this._firstRange != null && !this._firstRange.isNullRange()) {
                    if (mouseEvent.isShiftKeyDown()) {
                        object = new Range(this.selectedRange());
                        ((Range)object).unionWith(this._firstRange.index, this._firstRange.length);
                        this._selection.setRange(((Range)object).index, ((Range)object).index + ((Range)object).length, null, false);
                    } else {
                        this._selection.setRange(this._firstRange.index, this._firstRange.lastIndex() + 1, null, false);
                    }
                    this._selectionChanged();
                }
                return true;
            }
            this._firstRange = new Range(this._anchorInfo._absPosition, 0);
        }
        if (mouseEvent.isShiftKeyDown()) {
            this._selection.setRange(this._selection.orderedSelectionStart(), this._anchorInfo._absPosition, null, false);
        } else {
            this._selection.setInsertionPoint(this._anchorInfo);
        }
        this._selectionChanged();
        this._upInfo = null;
        this._downY = this._anchorInfo._y + this._anchorInfo._lineHeight;
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Object object;
        if (this._mouseDownTextAttachment != null) {
            this._mouseDownTextAttachment.mouseDragged(new MouseEvent(mouseEvent.timeStamp, mouseEvent.type, mouseEvent.x - this._mouseDownTextAttachmentOrigin.x, mouseEvent.y - this._mouseDownTextAttachmentOrigin.y, mouseEvent.modifiers));
            return;
        }
        Point point = new Point(mouseEvent.x, mouseEvent.y);
        if (point.x >= this.bounds.width) {
            point.x = this.bounds.width - 1;
        } else if (point.x < 0) {
            point.x = 0;
        }
        if (point.y >= this.bounds.height) {
            point.y = this.bounds.height - 1;
        } else if (point.y < 0) {
            point.y = 0;
        }
        TextPositionInfo textPositionInfo = this.positionForPoint(point.x, point.y, false);
        if (this._clickedRange != null) {
            object = this._runForIndex(textPositionInfo._absPosition);
            Hashtable hashtable = ((TextStyleRun)object).attributes();
            if (hashtable != null && hashtable.get((Object)LINK_KEY) != null && this.runUnderMouse((TextStyleRun)object, mouseEvent.x, mouseEvent.y)) {
                Range range = this.linkRangeForPosition(textPositionInfo._absPosition);
                if (!range.equals(this._clickedRange)) {
                    this.highlightLinkWithRange(this._clickedRange, false);
                    this._clickedRange = range;
                    this.highlightLinkWithRange(this._clickedRange, true);
                }
                return;
            }
            this.highlightLinkWithRange(this._clickedRange, false);
            this._clickedRange = null;
        }
        if (!this.isSelectable()) {
            return;
        }
        if (textPositionInfo == null) {
            return;
        }
        if (!this.containsPointInVisibleRect(mouseEvent.x, mouseEvent.y)) {
            Rect rect = TextView.newRect(textPositionInfo._x, textPositionInfo._y, 1, textPositionInfo._lineHeight);
            this.scrollRectToVisible(rect);
            TextView.returnRect(rect);
        }
        int n = this._anchorInfo._absPosition;
        boolean bl = this._upInfo != null && textPositionInfo._absPosition != this._upInfo._absPosition;
        this._upInfo = textPositionInfo;
        if (bl) {
            switch (this._clickCount) {
                case 0: 
                case 1: {
                    this._selection.setRange(n, this._upInfo._absPosition, this._upInfo, this.selectLineBreak);
                    this._selectionChanged();
                    return;
                }
                case 2: {
                    object = this.groupForIndex(this._upInfo._absPosition);
                    break;
                }
                default: {
                    object = this.paragraphForIndex(this._upInfo._absPosition);
                }
            }
            if (this._firstRange != null && !this._firstRange.isNullRange() && !((Range)object).isNullRange()) {
                ((Range)object).unionWith(this._firstRange);
                if (!((Range)object).equals(this.selectedRange())) {
                    this._selection.setRange(((Range)object).index, ((Range)object).lastIndex() + 1, null, this.selectLineBreak);
                    this._selectionChanged();
                }
            }
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this._mouseDownTextAttachment != null) {
            this._mouseDownTextAttachment.mouseUp(new MouseEvent(mouseEvent.timeStamp, mouseEvent.type, mouseEvent.x - this._mouseDownTextAttachmentOrigin.x, mouseEvent.y - this._mouseDownTextAttachmentOrigin.y, mouseEvent.modifiers));
            this._mouseDownTextAttachment = null;
            this._mouseDownTextAttachmentOrigin = null;
            return;
        }
        if (this._clickedRange != null) {
            TextPositionInfo textPositionInfo = this.positionForPoint(mouseEvent.x, mouseEvent.y, true);
            Range range = this.linkRangeForPosition(textPositionInfo._absPosition);
            this.highlightLinkWithRange(this._clickedRange, false);
            if (range != null && range.equals(this._clickedRange) && this._owner != null) {
                TextStyleRun textStyleRun = this._runForIndex(this._clickedRange.index);
                Hashtable hashtable = textStyleRun.attributes();
                String string = null;
                if (hashtable != null && (string = (String)hashtable.get((Object)LINK_KEY)) != null && this.runsUnderMouse(this.runsForRange(this._clickedRange), mouseEvent.x, mouseEvent.y)) {
                    this._owner.linkWasSelected(this, this._clickedRange, string);
                }
            }
            this._clickedRange = null;
        }
        if (!this.isSelectable()) {
            return;
        }
        if (this._upInfo == null || this._upInfo._absPosition == this._anchorInfo._absPosition) {
            this._selection.showInsertionPoint();
        }
        this._firstRange = null;
    }

    public int cursorForPoint(int n, int n2) {
        Hashtable hashtable;
        TextStyleRun textStyleRun;
        if (this.isEditable()) {
            return 2;
        }
        TextPositionInfo textPositionInfo = this.positionForPoint(n, n2, true);
        if (textPositionInfo != null && (textStyleRun = this._runForIndex(textPositionInfo._absPosition)) != null && (hashtable = textStyleRun.attributes()) != null && hashtable.get((Object)LINK_KEY) != null && this.runUnderMouse(textStyleRun, n, n2)) {
            return 12;
        }
        if (this.isSelectable()) {
            return 2;
        }
        return 0;
    }

    public void performCommand(String string, Object object) {
        if (string.equals("refreshBitmap")) {
            this.refreshBitmap(object);
        } else {
            if (string != null && string.equals("setFont")) {
                this.processSetFont((Font)object);
                return;
            }
            if (string.equals("cut")) {
                this.cut();
            } else if (string.equals("copy")) {
                this.copy();
            } else if (string.equals("paste")) {
                this.paste();
            } else if (!(object instanceof Timer)) {
                return;
            }
        }
        if (this._updateParagraph == null) {
            if (this._updateTimer != null) {
                this._updateTimer.stop();
                this._updateTimer = null;
            }
            return;
        }
        this._drawText = false;
        Rect rect = this._updateParagraph.rectForLine(this._updateLine);
        this.draw(rect);
        TextView.returnRect(rect);
        this._drawText = true;
        ++this._updateLine;
        if (this._updateLine >= this._updateParagraph._breakCount) {
            if (!this._drawNextParagraph) {
                this._updateParagraph = null;
            } else {
                int n = this._paragraphVector.indexOfIdentical((Object)this._updateParagraph) + 1;
                if (n == 0 || n >= this._paragraphVector.count()) {
                    this._updateParagraph = null;
                } else {
                    this._updateParagraph = (TextParagraph)this._paragraphVector.elementAt(n);
                    this._updateLine = 0;
                }
            }
        }
        if (this._updateParagraph == null && this._updateTimer != null) {
            this._updateTimer.stop();
            this._updateTimer = null;
        }
    }

    public boolean canPerformCommand(String string) {
        if (string.equals("setFont")) {
            return !this.usesSingleFont() && this.isEditable();
        }
        return string.equals("refreshBitmap") || string.equals("copy") || this.isEditable() && string.equals("cut") || this.isEditable() && string.equals("paste");
    }

    public void keyDown(KeyEvent keyEvent) {
        if (Application.application().handleExtendedKeyEvent() && JDK11AirLock.hasOneOneEvents()) {
            if (keyEvent.isPrintableKey() && !keyEvent.isDeleteKey()) {
                return;
            }
            if ((keyEvent.modifiers & 8) == 8) {
                return;
            }
            if (keyEvent.isBackspaceKey()) {
                return;
            }
        }
        this.processKey(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.processKey(keyEvent);
    }

    void processKey(KeyEvent keyEvent) {
        if (keyEvent.isPageUpKey()) {
            TextPositionInfo textPositionInfo;
            Rect rect = new Rect();
            this.computeVisibleRect(rect);
            rect.y -= rect.height - 1;
            if (rect.y < 0) {
                rect.y = 0;
            }
            if ((textPositionInfo = this.positionForPoint(rect.x, rect.y, true)) != null) {
                rect.y = textPositionInfo._y;
            }
            this.scrollRectToVisible(rect);
            return;
        }
        if (keyEvent.isPageDownKey()) {
            TextPositionInfo textPositionInfo;
            Rect rect = new Rect();
            this.computeVisibleRect(rect);
            TextPositionInfo textPositionInfo2 = this.positionForPoint(rect.x, rect.y, true);
            rect.y += rect.height - 1;
            if (rect.y > this.bounds.height - rect.height) {
                rect.y = this.bounds.height - rect.height;
            }
            if ((textPositionInfo = this.positionForPoint(rect.x, rect.y, true)) != null) {
                rect.y = textPositionInfo._y;
                if (textPositionInfo2 != null && textPositionInfo2._absPosition == textPositionInfo._absPosition) {
                    rect.y += textPositionInfo._lineHeight;
                }
            }
            this.scrollRectToVisible(rect);
            return;
        }
        if (!this.isEditable()) {
            return;
        }
        if (!this.hasSelection()) {
            return;
        }
        if (this._filter != null) {
            if (this._filter.acceptsEvent(this, keyEvent, this._eventVector)) {
                this._eventVector.addElement((Object)keyEvent);
            }
        } else {
            this._eventVector.addElement((Object)keyEvent);
        }
        this.application().eventLoop().filterEvents(this);
        while (!this._eventVector.isEmpty()) {
            this._keyDown();
        }
    }

    public DragDestination acceptsDrag(DragSession dragSession, int n, int n2) {
        String string = dragSession.dataType();
        if (this.isEditable() && this.hasSelection() && ("netscape.application.Color".equals(string) || "netscape.application.Image".equals(string))) {
            return this;
        }
        return null;
    }

    public boolean dragEntered(DragSession dragSession) {
        return true;
    }

    public boolean dragMoved(DragSession dragSession) {
        return true;
    }

    public void dragExited(DragSession dragSession) {
    }

    public boolean dragDropped(DragSession dragSession) {
        if (!this.isEditable() || !this.hasSelection()) {
            return false;
        }
        Object object = dragSession.data();
        if (object == null) {
            return false;
        }
        if (object instanceof Color) {
            Range range = this.selectedRange();
            if (range.length > 0) {
                this.addAttributeForRange(TEXT_COLOR_KEY, object, range);
            } else {
                this.addTypingAttribute(TEXT_COLOR_KEY, object);
            }
            return true;
        }
        if (object instanceof Image) {
            this.replaceRangeWithTextAttachment(this.selectedRange(), new ImageAttachment((Image)object));
            return true;
        }
        return false;
    }

    public void startFocus() {
        this._setEditing(true);
        this.showInsertionPoint();
        this._selection._startFlashing();
        if (this.isEditable() && this._owner != null) {
            this._owner.textEditingDidBegin(this);
        }
        if (this.hasSelection()) {
            Range range = this.selectedRange();
            if (range.length > 0) {
                this.dirtyRange(range);
                return;
            }
        } else {
            this.selectRange(new Range(0, 0));
        }
    }

    public void stopFocus() {
        this._selection._stopFlashing();
        this.hideInsertionPoint();
        this._setEditing(false);
        if (this.isEditable() && this._owner != null) {
            this._owner.textEditingDidEnd(this);
        }
        if (this.hasSelection()) {
            Range range = this.selectedRange();
            if (range.length > 0) {
                this.dirtyRange(range);
            }
        }
    }

    public void pauseFocus() {
        this._selection._stopFlashing();
        this.hideInsertionPoint();
    }

    public void resumeFocus() {
        this.showInsertionPoint();
        this._selection._startFlashing();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this._paragraphVector.count();
        while (n < n2) {
            stringBuffer.append(this._paragraphVector.elementAt(n).toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setFilter(TextFilter textFilter) {
        this._filter = textFilter;
    }

    public TextFilter filter() {
        return this._filter;
    }

    public void setOwner(TextViewOwner textViewOwner) {
        this._owner = textViewOwner;
    }

    public TextViewOwner owner() {
        return this._owner;
    }

    public void disableResizing() {
        ++this._resizeDisabled;
    }

    public void enableResizing() {
        --this._resizeDisabled;
        if (this._resizeDisabled < 0) {
            this._resizeDisabled = 0;
        }
    }

    public boolean isResizingEnabled() {
        return this._resizeDisabled == 0;
    }

    public void sizeToMinSize() {
        this.sizeBy(0, this.adjustCharCountsAndSpacing() - this.bounds.height);
    }

    public void scrollRangeToVisible(Range range) {
        if (range.index == 0 && range.length == 0) {
            this.scrollRectToVisible(new Rect(0, 0, 1, 1));
            return;
        }
        if (range.index >= this.length()) {
            this.scrollRectToVisible(new Rect(this.width() - 1, this.height() - 1, 1, 1));
            return;
        }
        if (range.length == 0) {
            TextPositionInfo textPositionInfo = this.positionInfoForIndex(range.index);
            this.scrollRectToVisible(new Rect(textPositionInfo._x, textPositionInfo._y + textPositionInfo._lineHeight, 1, textPositionInfo._lineHeight));
            return;
        }
        TextPositionInfo textPositionInfo = this.positionInfoForIndex(range.index);
        TextPositionInfo textPositionInfo2 = this.positionInfoForIndex(range.index + range.length);
        int n = textPositionInfo._y;
        int n2 = textPositionInfo2._y + textPositionInfo2._lineHeight;
        if (textPositionInfo._y == textPositionInfo2._y) {
            this.scrollRectToVisible(new Rect(textPositionInfo._x, n, textPositionInfo2._x - textPositionInfo._x, n2 - n));
            return;
        }
        this.scrollRectToVisible(new Rect(0, n, this.width(), n2 - n));
    }

    public void setUseSingleFont(boolean bl) {
        this._useSingleFont = bl;
    }

    public boolean usesSingleFont() {
        return this._useSingleFont;
    }

    public void setDefaultAttributes(Hashtable hashtable) {
        this._defaultAttributes = hashtable;
        if (hashtable.get((Object)FONT_KEY) != null) {
            this._defaultFontMetricsCache = null;
        }
        if (hashtable.get((Object)PARAGRAPH_FORMAT_KEY) == null) {
            TextParagraphFormat textParagraphFormat = new TextParagraphFormat();
            textParagraphFormat.setLeftMargin(3);
            textParagraphFormat.setRightMargin(3);
            textParagraphFormat.setJustification(0);
            this._defaultAttributes.put((Object)PARAGRAPH_FORMAT_KEY, (Object)textParagraphFormat);
        }
        this.reformatAll();
        Range range = TextView.allocateRange(0, this.length());
        this.dirtyRange(range);
        TextView.recycleRange(range);
    }

    public Hashtable defaultAttributes() {
        return this._defaultAttributes;
    }

    public void addTypingAttribute(String string, Object object) {
        Hashtable hashtable = new Hashtable();
        hashtable.put((Object)string, object);
        hashtable = TextView.attributesByRemovingStaticAttributes(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this._typingAttributes.put((Object)string2, hashtable.get((Object)string2));
        }
    }

    public Hashtable typingAttributes() {
        return this._typingAttributes;
    }

    public void setTypingAttributes(Hashtable hashtable) {
        if (hashtable == null) {
            this._typingAttributes = new Hashtable();
            return;
        }
        this._typingAttributes = TextView.attributesByRemovingStaticAttributes(hashtable);
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this._backgroundColor = color;
        }
    }

    public Color backgroundColor() {
        return this._backgroundColor;
    }

    public void setSelectionColor(Color color) {
        if (color != null) {
            this._selectionColor = color;
        }
    }

    public Color selectionColor() {
        return this._selectionColor;
    }

    public void setEditable(boolean bl) {
        if (this._editable != bl) {
            this._editable = bl;
            this.setSelectable(true);
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setSelectable(boolean bl) {
        if (this._selectable != bl) {
            this._selectable = bl;
            RootView rootView = this.rootView();
            if (rootView != null) {
                rootView.updateCursor();
            }
        }
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.addDefaultAttribute(FONT_KEY, font);
    }

    public Font font() {
        return (Font)this._defaultAttributes.get((Object)FONT_KEY);
    }

    public void setTextColor(Color color) {
        if (color != null) {
            this.addDefaultAttribute(TEXT_COLOR_KEY, color);
        }
    }

    public Color textColor() {
        Color color = (Color)this._defaultAttributes.get((Object)TEXT_COLOR_KEY);
        if (color == null) {
            return Color.black;
        }
        return color;
    }

    public void setCaretColor(Color color) {
        if (color != null) {
            this.addDefaultAttribute(CARET_COLOR_KEY, color);
        }
    }

    public Color caretColor() {
        Color color = (Color)this._defaultAttributes.get((Object)CARET_COLOR_KEY);
        if (color == null) {
            return Color.black;
        }
        return color;
    }

    public void replaceRangeWithString(Range range, String string) {
        boolean bl = true;
        if (this._owner != null) {
            this._owner.textWillChange(this, range);
        }
        if (range.equals(new Range(0, this.length()))) {
            this.replaceContentWithString(string);
            if (this._owner != null) {
                this._owner.textDidChange(this, new Range(0, this.length()));
            }
            return;
        }
        this.disableResizing();
        int n = this._paragraphIndexForIndex(range.index);
        this.deleteRange(range, null);
        if (string == null || string.equals("")) {
            this.enableResizing();
            if (n > 0) {
                this.sizeBy(0, this.adjustCharCountsAndSpacing(n - 1) - this.bounds.height);
            } else {
                this.sizeToMinSize();
            }
            if (this._owner != null) {
                this._owner.textDidChange(this, new Range(range.index, 0));
            }
            return;
        }
        this.disableAttachmentNotification();
        int n2 = range.index;
        int n3 = 0;
        int n4 = string.indexOf(10);
        if (n4 == -1) {
            this.insertString(string, n2);
            this.enableResizing();
            if (n > 0) {
                this.sizeBy(0, this.adjustCharCountsAndSpacing(n - 1) - this.bounds.height);
            } else {
                this.sizeToMinSize();
            }
            this.enableAttachmentNotification();
            if (this._owner != null) {
                this._owner.textDidChange(this, new Range(range.index, string.length()));
            }
            return;
        }
        this.insertString(string.substring(n3, n4), n2, true);
        this.insertReturn(n2 + (n4 - n3));
        n2 += n4 - n3 + 1;
        int n5 = string.length() - 1;
        while (n4 < n5) {
            n3 = n4 + 1;
            if ((n4 = string.indexOf(10, n3)) == -1) {
                n4 = n5 + 1;
                bl = false;
            }
            if (n4 > n3) {
                String string2 = string.substring(n3, n4);
                this.insertString(string2, n2, true);
                if (bl) {
                    this.insertReturn(n2 + (n4 - n3));
                }
                n2 += n4 - n3 + 1;
                continue;
            }
            this.insertReturn(n2);
            ++n2;
        }
        this.enableResizing();
        if (n > 0) {
            this.sizeBy(0, this.adjustCharCountsAndSpacing(n - 1) - this.bounds.height);
        } else {
            this.sizeToMinSize();
        }
        this.enableAttachmentNotification();
        if (this._owner != null) {
            this._owner.textDidChange(this, new Range(range.index, string.length()));
        }
    }

    public String stringForRange(Range range) {
        TextParagraph textParagraph = this._paragraphForIndex(range.index);
        TextParagraph textParagraph2 = this._paragraphForIndex(range.index + range.length);
        if (textParagraph == null) {
            return null;
        }
        if (textParagraph2 == null) {
            textParagraph2 = this.lastParagraph();
        }
        if (textParagraph == textParagraph2) {
            return textParagraph.stringForRange(range);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Range range2 = TextView.allocateRange();
        int n = this._paragraphVector.indexOfIdentical((Object)textParagraph);
        int n2 = this._paragraphVector.indexOfIdentical((Object)textParagraph2);
        while (n <= n2) {
            range2.index = range.index;
            range2.length = range.length;
            TextParagraph textParagraph3 = (TextParagraph)this._paragraphVector.elementAt(n);
            range2.intersectWith(textParagraph3.range());
            stringBuffer.append(textParagraph3.stringForRange(range2));
            ++n;
        }
        TextView.recycleRange(range2);
        return stringBuffer.toString();
    }

    public void setAttributesForRange(Hashtable hashtable, Range range) {
        Range range2 = this.paragraphsRangeForRange(range);
        int n = range2.index;
        int n2 = range2.index + range2.length;
        while (n < n2) {
            ((TextParagraph)this._paragraphVector.elementAt(n)).setFormat(null);
            ++n;
        }
        Vector vector = this.createAndReturnRunsForRange(range);
        n = 0;
        n2 = vector.count();
        while (n < n2) {
            TextStyleRun textStyleRun = (TextStyleRun)vector.elementAt(n);
            textStyleRun.setAttributes(null);
            ++n;
        }
        this.addAttributesForRange(hashtable, range);
    }

    public Hashtable attributesAtIndex(int n) {
        TextStyleRun textStyleRun = this._runForIndex(n);
        TextParagraph textParagraph = this._paragraphForIndex(n);
        if (textStyleRun != null && textParagraph != null) {
            Hashtable hashtable = textStyleRun.attributes();
            if (hashtable == null) {
                TextParagraphFormat textParagraphFormat = textParagraph.format();
                if (textParagraphFormat == null) {
                    return this._defaultAttributes;
                }
                Hashtable hashtable2 = (Hashtable)this._defaultAttributes.clone();
                hashtable2.put((Object)PARAGRAPH_FORMAT_KEY, (Object)textParagraphFormat);
                return hashtable2;
            }
            TextParagraphFormat textParagraphFormat = textParagraph.format();
            Hashtable hashtable3 = (Hashtable)hashtable.clone();
            if (textParagraphFormat != null) {
                hashtable3.put((Object)PARAGRAPH_FORMAT_KEY, (Object)textParagraphFormat);
            } else {
                hashtable3.put((Object)PARAGRAPH_FORMAT_KEY, this._defaultAttributes.get((Object)PARAGRAPH_FORMAT_KEY));
            }
            return hashtable3;
        }
        return this._defaultAttributes;
    }

    public int length() {
        return this._charCount - 1;
    }

    public String string() {
        Range range = TextView.allocateRange(0, this.length());
        String string = this.stringForRange(range);
        TextView.recycleRange(range);
        return string;
    }

    public void setString(String string) {
        Range range = TextView.allocateRange(0, this.length());
        this.replaceRangeWithString(range, string);
        TextView.recycleRange(range);
    }

    public Range appendString(String string) {
        Range range = TextView.allocateRange(this.length(), 0);
        this.replaceRangeWithString(range, string);
        range.length = string.length();
        return range;
    }

    public void replaceRangeWithTextAttachment(Range range, TextAttachment textAttachment) {
        this.replaceRangeWithString(range, TEXT_ATTACHMENT_STRING);
        Hashtable hashtable = new Hashtable();
        hashtable.put((Object)TEXT_ATTACHMENT_KEY, (Object)textAttachment);
        Range range2 = TextView.allocateRange(range.index, 1);
        this.addAttributesForRange(hashtable, range2);
        TextView.recycleRange(range2);
    }

    public void addAttributesForRange(Hashtable hashtable, Range range) {
        if (this._owner != null) {
            this._owner.attributesWillChange(this, range);
        }
        this.addAttributesForRangeWithoutNotification(hashtable, range);
        if (this._owner != null) {
            this._owner.attributesDidChange(this, range);
        }
    }

    public void addAttributeForRange(String string, Object object, Range range) {
        Hashtable hashtable = new Hashtable();
        hashtable.put((Object)string, object);
        this.addAttributesForRange(hashtable, range);
    }

    public void removeAttributeForRange(String string, Range range) {
        Vector vector = this.runsForRange(range);
        Range range2 = TextView.allocateRange();
        int n = 0;
        int n2 = vector.count();
        while (n < n2) {
            Range range3 = (Range)vector.elementAt(n);
            TextStyleRun textStyleRun = this._runForIndex(range3.index);
            Hashtable hashtable = textStyleRun.attributes();
            if (hashtable != null && hashtable.get((Object)string) != null) {
                Hashtable hashtable2 = (Hashtable)hashtable.clone();
                hashtable2.remove((Object)string);
                range2.index = range.index;
                range2.length = range.length;
                range2.intersectWith(range3);
                this.setAttributesForRange(hashtable2, range2);
            }
            ++n;
        }
    }

    public void addDefaultAttribute(String string, Object object) {
        Hashtable hashtable = this.defaultAttributes();
        hashtable.put((Object)string, object);
        this.setDefaultAttributes(hashtable);
    }

    public Vector runsForRange(Range range) {
        int n;
        TextStyleRun textStyleRun;
        Vector vector = new Vector();
        boolean bl = false;
        if (range.length == 0) {
            Range range2 = this.runForIndex(range.index);
            if (!range2.isNullRange()) {
                vector.addElement((Object)range2);
            }
            return vector;
        }
        TextStyleRun textStyleRun2 = this._runForIndex(range.index);
        if (textStyleRun2 == null) {
            textStyleRun2 = this._runForIndex(0);
        }
        if ((textStyleRun = this._runForIndex(range.index + range.length() - 1)) == null) {
            textStyleRun = this._runForIndex(this.length() - 1);
        }
        Vector vector2 = textStyleRun2.paragraph().runVector();
        if (textStyleRun2.paragraph() == textStyleRun.paragraph()) {
            n = vector2.indexOfIdentical((Object)textStyleRun) + 1;
            bl = true;
        } else {
            n = vector2.count();
            bl = false;
        }
        int n2 = vector2.indexOfIdentical((Object)textStyleRun2);
        while (n2 < n) {
            vector.addElement((Object)((TextStyleRun)vector2.elementAt(n2)).range());
            ++n2;
        }
        if (!bl) {
            n2 = this._paragraphVector.indexOfIdentical((Object)textStyleRun2.paragraph()) + 1;
            n = this._paragraphVector.indexOfIdentical((Object)textStyleRun.paragraph());
            while (n2 < n) {
                vector2 = ((TextParagraph)this._paragraphVector.elementAt(n2)).runVector();
                int n3 = 0;
                int n4 = vector2.count();
                while (n3 < n4) {
                    vector.addElement((Object)((TextStyleRun)vector2.elementAt(n3)).range());
                    ++n3;
                }
                ++n2;
            }
            vector2 = textStyleRun.paragraph().runVector();
            n2 = 0;
            n = vector2.indexOfIdentical((Object)textStyleRun);
            while (n2 <= n) {
                vector.addElement((Object)((TextStyleRun)vector2.elementAt(n2)).range());
                ++n2;
            }
        }
        return vector;
    }

    public Vector paragraphsForRange(Range range) {
        Range range2 = this.paragraphsRangeForRange(range);
        Vector vector = new Vector();
        int n = range2.index;
        int n2 = range2.index + range2.length;
        while (n < n2) {
            Range range3 = ((TextParagraph)this._paragraphVector.elementAt(n)).range();
            if (n == n2 - 1) {
                --range3.length;
            }
            vector.addElement((Object)range3);
            ++n;
        }
        return vector;
    }

    public Range runForIndex(int n) {
        TextStyleRun textStyleRun = this._runForIndex(n);
        if (textStyleRun == null) {
            return TextView.allocateRange();
        }
        return textStyleRun.range();
    }

    public Range paragraphForIndex(int n) {
        Range range = TextView.allocateRange(n, 0);
        Vector vector = this.paragraphsForRange(range);
        TextView.recycleRange(range);
        if (vector.count() > 0) {
            return (Range)vector.elementAt(0);
        }
        return TextView.allocateRange();
    }

    public Range paragraphForPoint(int n, int n2) {
        TextParagraph textParagraph = this._paragraphForPoint(n, n2);
        if (textParagraph != null) {
            return textParagraph.range();
        }
        return TextView.allocateRange();
    }

    public Range runForPoint(int n, int n2) {
        TextStyleRun textStyleRun;
        TextPositionInfo textPositionInfo = this.positionForPoint(n, n2, true);
        if (textPositionInfo != null && (textStyleRun = this._runForIndex(textPositionInfo._absPosition)) != null) {
            return textStyleRun.range();
        }
        return TextView.allocateRange();
    }

    public int indexForPoint(int n, int n2) {
        TextPositionInfo textPositionInfo = this.positionForPoint(n, n2, true);
        if (textPositionInfo != null) {
            return textPositionInfo._absPosition;
        }
        return -1;
    }

    public Vector rectsForRange(Range range) {
        return this.rectsForRange(range, null);
    }

    public Range selectedRange() {
        if (this._selectedRange == null) {
            this._selectedRange = TextView.allocateRange();
        }
        this._selectedRange.index = this._selection.selectionStart();
        if (this._selectedRange.index < 0) {
            return TextView.allocateRange();
        }
        this._selectedRange.length = this._selection.selectionEnd() - this._selection.selectionStart();
        return this._selectedRange;
    }

    public void selectRange(Range range) {
        if (range.isNullRange()) {
            this._selection.clearRange();
        } else {
            this._selection.setRange(range.index(), range.lastIndex() + 1);
        }
        this._selectionChanged();
    }

    public boolean hasSelection() {
        Range range = this.selectedRange();
        return !range.isNullRange();
    }

    public void insertHTMLElementsInRange(Vector vector, Range range, Hashtable hashtable) {
        int[] nArray = new int[vector.count()];
        int n = 0;
        int n2 = 0;
        Hashtable hashtable2 = new Hashtable();
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        if (hashtable == null) {
            hashtable = this.defaultAttributes();
        }
        Hashtable hashtable3 = TextView.attributesByRemovingStaticAttributes(hashtable);
        this.setDirty(true);
        this.disableResizing();
        fastStringBuffer.setDoublesCapacityWhenGrowing(true);
        int n3 = 0;
        int n4 = vector.count();
        while (n3 < n4) {
            ((TextViewHTMLElement)vector.elementAt(n3)).appendString(hashtable2, fastStringBuffer);
            if (n3 == 0) {
                n2 = nArray[0] = fastStringBuffer.length();
            } else {
                nArray[n3] = fastStringBuffer.length() - n2;
                n2 += nArray[n3];
            }
            ++n3;
        }
        this.replaceRangeWithString(range, fastStringBuffer.toString());
        this.disableFormatting();
        n3 = 0;
        n4 = vector.count();
        while (n3 < n4) {
            ((TextViewHTMLElement)vector.elementAt(n3)).setAttributesStartingAt(range.index + n, hashtable3, this, hashtable2);
            n += nArray[n3];
            ++n3;
        }
        this.enableFormatting();
        this.reformatAll();
        this.enableResizing();
        this.sizeToMinSize();
    }

    public void importHTMLInRange(InputStream inputStream, Range range, URL uRL) throws IOException, HTMLParsingException {
        this.importHTMLInRange(inputStream, range, uRL, this.defaultAttributes());
    }

    public void importHTMLInRange(InputStream inputStream, Range range, URL uRL, Hashtable hashtable) throws IOException, HTMLParsingException {
        Vector vector = new Vector();
        this.validateHTMLParsingRules();
        HTMLParser hTMLParser = new HTMLParser(inputStream, this._htmlParsingRules);
        try {
            HTMLElement hTMLElement;
            while ((hTMLElement = hTMLParser.nextHTMLElement()) != null) {
                vector.addElement((Object)hTMLElement);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new InconsistencyException("Cannot intantiate HTML storage");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InconsistencyException("Cannot access HTML storage classes");
        }
        this.setBaseURL(uRL);
        this.insertHTMLElementsInRange(vector, range, hashtable);
    }

    public void importHTMLFromURLString(String string) {
        Range range = TextView.allocateRange(0, this.length());
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            this.importHTMLInRange(inputStream, range, uRL, this.defaultAttributes());
            range.index = 0;
            range.length = 0;
            this.selectRange(range);
            this.scrollRangeToVisible(range);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL " + string);
        }
        catch (IOException iOException) {
            System.err.println("IOException while reading " + string);
        }
        catch (HTMLParsingException hTMLParsingException) {
            System.err.println("At line " + hTMLParsingException.lineNumber() + ":" + hTMLParsingException);
        }
        TextView.recycleRange(range);
    }

    public void setHTMLParsingRules(HTMLParsingRules hTMLParsingRules) {
        this._htmlParsingRules = hTMLParsingRules;
    }

    public HTMLParsingRules htmlParsingRules() {
        this.validateHTMLParsingRules();
        return this._htmlParsingRules;
    }

    public Range runWithLinkDestinationNamed(String string) {
        TextStyleRun textStyleRun = null;
        Range range = null;
        int n = 0;
        int n2 = this._paragraphVector.count();
        while (n < n2) {
            TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n);
            int n3 = 0;
            int n4 = textParagraph._runVector.count();
            while (n3 < n4) {
                String string2;
                textStyleRun = (TextStyleRun)textParagraph._runVector.elementAt(n3);
                if (textStyleRun._attributes != null && (string2 = (String)textStyleRun._attributes.get((Object)LINK_DESTINATION_KEY)) != null && string2.equals(string)) {
                    range = textStyleRun.range();
                    break;
                }
                ++n3;
            }
            if (range != null) break;
            ++n;
        }
        if (range == null) {
            return new Range();
        }
        if (textStyleRun != null) {
            Range range2 = range;
            while (range.length == 0) {
                if ((textStyleRun = this.runAfter(textStyleRun)) != null) {
                    range = textStyleRun.range();
                    continue;
                }
                range = range2;
                break;
            }
        }
        return range;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.TextView", 2);
        classInfo.addField(PARAGRAPHVECTOR_KEY, (byte)18);
        classInfo.addField(BACKGROUNDCOLOR_KEY, (byte)18);
        classInfo.addField(SELECTIONCOLOR_KEY, (byte)18);
        classInfo.addField(FILTER_KEY, (byte)18);
        classInfo.addField(DEFAULTATTRIBUTES_KEY, (byte)18);
        classInfo.addField(PARASPACING_KEY, (byte)8);
        classInfo.addField(USESINGLEFONT_KEY, (byte)0);
        classInfo.addField(EDITABLE_KEY, (byte)0);
        classInfo.addField(SELECTABLE_KEY, (byte)0);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
        classInfo.addField(HTML_PARSING_RULES_KEY, (byte)18);
        classInfo.addField(OWNER_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(PARAGRAPHVECTOR_KEY, this._paragraphVector);
        encoder.encodeObject(BACKGROUNDCOLOR_KEY, this._backgroundColor);
        encoder.encodeObject(SELECTIONCOLOR_KEY, this._selectionColor);
        encoder.encodeObject(FILTER_KEY, (Codable)this._filter);
        encoder.encodeObject(DEFAULTATTRIBUTES_KEY, this._defaultAttributes);
        encoder.encodeInt(PARASPACING_KEY, this._paragraphSpacing);
        encoder.encodeBoolean(USESINGLEFONT_KEY, this._useSingleFont);
        encoder.encodeBoolean(EDITABLE_KEY, this._editable);
        encoder.encodeBoolean(SELECTABLE_KEY, this._selectable);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        encoder.encodeObject(HTML_PARSING_RULES_KEY, this._htmlParsingRules);
        encoder.encodeObject(OWNER_KEY, this._owner);
    }

    public void decode(Decoder decoder) throws CodingException {
        int n = decoder.versionForClassName("netscape.application.TextView");
        super.decode(decoder);
        this._paragraphVector = (Vector)decoder.decodeObject(PARAGRAPHVECTOR_KEY);
        this._backgroundColor = (Color)decoder.decodeObject(BACKGROUNDCOLOR_KEY);
        this._selectionColor = (Color)decoder.decodeObject(SELECTIONCOLOR_KEY);
        this._filter = (TextFilter)decoder.decodeObject(FILTER_KEY);
        this._defaultAttributes = (Hashtable)decoder.decodeObject(DEFAULTATTRIBUTES_KEY);
        this._paragraphSpacing = decoder.decodeInt(PARASPACING_KEY);
        this._useSingleFont = decoder.decodeBoolean(USESINGLEFONT_KEY);
        this._editable = decoder.decodeBoolean(EDITABLE_KEY);
        this._selectable = decoder.decodeBoolean(SELECTABLE_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
        if (n >= 2) {
            this._htmlParsingRules = (HTMLParsingRules)decoder.decodeObject(HTML_PARSING_RULES_KEY);
            this._owner = (TextViewOwner)decoder.decodeObject(OWNER_KEY);
        }
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        this._defaultFontMetricsCache = null;
        int n = this._paragraphVector.count();
        while (n-- > 0) {
            TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n);
            textParagraph.setOwner(this);
        }
        this.reformatAll();
    }

    public int lineCount() {
        int n = 0;
        int n2 = 0;
        int n3 = this._paragraphVector.count();
        while (n2 < n3) {
            TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n2);
            n += textParagraph.lineCount();
            ++n2;
        }
        return n;
    }

    public void setBaseURL(URL uRL) {
        this._baseURL = uRL;
    }

    public URL baseURL() {
        return this._baseURL;
    }

    public boolean canBecomeSelectedView() {
        return this.isEditable() || this.isSelectable();
    }

    public void willBecomeSelected() {
        this.setFocusedView();
    }

    public static String stringWithoutCarriageReturns(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '\r' || n + 1 >= n2 || string.charAt(n + 1) != '\n') {
                fastStringBuffer.append(c);
            }
            ++n;
        }
        return fastStringBuffer.toString();
    }

    FontMetrics defaultFontMetrics() {
        if (this._defaultFontMetricsCache == null) {
            this._defaultFontMetricsCache = this.font().fontMetrics();
        }
        return this._defaultFontMetricsCache;
    }

    static Hashtable attributesByRemovingStaticAttributes(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        hashtable2.remove((Object)TEXT_ATTACHMENT_KEY);
        hashtable2.remove((Object)TEXT_ATTACHMENT_BASELINE_OFFSET_KEY);
        return hashtable2;
    }

    private void addParagraph(TextParagraph textParagraph) {
        if (textParagraph == null) {
            return;
        }
        textParagraph.setOwner(this);
        this._paragraphVector.addElement((Object)textParagraph);
    }

    synchronized void _setEditing(boolean bl) {
        this._editing = bl;
    }

    synchronized boolean isEditing() {
        return this._editing;
    }

    private void reformatAll() {
        Range range = this.selectedRange();
        int n = 0;
        this._charCount = 0;
        int n2 = this._paragraphVector.count();
        if (!this.formattingEnabled()) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n3);
            textParagraph._y = n;
            textParagraph._startChar = this._charCount;
            textParagraph.computeLineBreaksAndHeights(this.bounds.width);
            n += textParagraph._height + this._paragraphSpacing;
            this._charCount += textParagraph._charCount;
            ++n3;
        }
        this.sizeBy(0, n - this.bounds.height);
        this.notifyAttachmentsForRange(new Range(0, this.length()), true);
        this.selectRange(range);
    }

    void disableFormatting() {
        ++this._formattingDisabled;
    }

    void enableFormatting() {
        --this._formattingDisabled;
        if (this._formattingDisabled < 0) {
            this._formattingDisabled = 0;
        }
    }

    boolean formattingEnabled() {
        return this._formattingDisabled == 0;
    }

    private void formatParagraphAtIndex(int n) {
        TextParagraph textParagraph;
        int n2;
        Range range = new Range();
        if (!this.formattingEnabled()) {
            return;
        }
        if (n == -1) {
            return;
        }
        TextParagraph textParagraph2 = (TextParagraph)this._paragraphVector.elementAt(n);
        int n3 = n - 1;
        if (n3 < -1) {
            return;
        }
        if (n3 == -1) {
            this._charCount = 0;
            n2 = 0;
        } else {
            textParagraph = (TextParagraph)this._paragraphVector.elementAt(n3);
            this._charCount = textParagraph._startChar + textParagraph._charCount;
            n2 = textParagraph._y + textParagraph._height + this._paragraphSpacing;
        }
        textParagraph2.setY(n2);
        textParagraph2.setStartChar(this._charCount);
        textParagraph2.computeLineBreaksAndHeights(this.bounds.width);
        this._charCount += textParagraph2._charCount;
        n2 += textParagraph2._height + this._paragraphSpacing;
        int n4 = this._paragraphVector.count();
        int n5 = n + 1;
        while (n5 < n4) {
            textParagraph = (TextParagraph)this._paragraphVector.elementAt(n5);
            textParagraph.setY(n2);
            textParagraph.setStartChar(this._charCount);
            n2 += textParagraph._height + this._paragraphSpacing;
            this._charCount += textParagraph._charCount;
            ++n5;
        }
        range.index = textParagraph2._startChar;
        range.unionWith(this.lastParagraph().range());
        this.sizeBy(0, n2 - this.bounds.height);
        this.notifyAttachmentsForRange(range, true);
    }

    private void formatParagraph(TextParagraph textParagraph) {
        this.formatParagraphAtIndex(this._paragraphVector.indexOfIdentical((Object)textParagraph));
    }

    private int adjustCharCountsAndSpacing(int n) {
        TextParagraph textParagraph;
        this._charCount = 0;
        int n2 = 0;
        if (n > 0) {
            textParagraph = (TextParagraph)this._paragraphVector.elementAt(n - 1);
            n2 = textParagraph._y + textParagraph._height + this._paragraphSpacing;
            this._charCount = textParagraph._startChar + textParagraph._charCount;
        }
        int n3 = this._paragraphVector.count();
        int n4 = n;
        while (n4 < n3) {
            textParagraph = (TextParagraph)this._paragraphVector.elementAt(n4);
            textParagraph._y = n2;
            textParagraph._startChar = this._charCount;
            n2 += textParagraph._height + this._paragraphSpacing;
            this._charCount += textParagraph._charCount;
            ++n4;
        }
        return n2;
    }

    private int adjustCharCountsAndSpacing() {
        return this.adjustCharCountsAndSpacing(0);
    }

    int _paragraphIndexForIndex(int n) {
        int n2 = this._paragraphVector.count();
        if (n > this.length() / 2) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n3);
                if (n >= textParagraph._startChar && n < textParagraph._startChar + textParagraph._charCount) {
                    return n3;
                }
                --n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n4);
                if (n >= textParagraph._startChar && n < textParagraph._startChar + textParagraph._charCount) {
                    return n4;
                }
                ++n4;
            }
        }
        return -1;
    }

    TextParagraph _paragraphForIndex(int n) {
        int n2 = this._paragraphIndexForIndex(n);
        if (n2 != -1) {
            return (TextParagraph)this._paragraphVector.elementAt(n2);
        }
        return null;
    }

    private TextParagraph _paragraphForPoint(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
            n = 0;
        }
        int n3 = this._paragraphVector.count();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n5);
            int n6 = n4 + textParagraph._height;
            if (n2 >= n4 && n2 < n6) {
                return textParagraph;
            }
            n4 = n6;
            ++n5;
        }
        return null;
    }

    TextPositionInfo positionInfoForIndex(int n) {
        TextParagraph textParagraph = this._paragraphForIndex(n);
        if (textParagraph == null) {
            textParagraph = this.lastParagraph();
        }
        return textParagraph._infoForPosition(n);
    }

    private TextPositionInfo positionForPoint(int n, int n2, boolean bl) {
        TextParagraph textParagraph;
        if (n2 < 0) {
            n2 = 0;
            n = 0;
        }
        if ((textParagraph = this._paragraphForPoint(n, n2)) == null) {
            if (this._charCount == 0) {
                return this.lastParagraph().infoForPosition(this._charCount, n2);
            }
            return this.lastParagraph().infoForPosition(this._charCount - 1, n2);
        }
        return textParagraph.positionForPoint(n, n2, bl);
    }

    void drawInsertionPoint() {
        Rect rect = this._selection.insertionPointRect();
        this.addDirtyRect(rect);
        TextView.returnRect(rect);
    }

    private void insertString(String string, int n) {
        this.insertString(string, n, false);
    }

    private void insertString(String string, int n, boolean bl) {
        int n2 = 0;
        if (string == null) {
            return;
        }
        int n3 = this._paragraphIndexForIndex(n);
        if (n3 == -1) {
            return;
        }
        TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n3);
        if (textParagraph == null) {
            return;
        }
        TextParagraph textParagraph2 = this.lastParagraph();
        if (textParagraph2 != null) {
            int n4 = textParagraph2._y + textParagraph2._height;
        } else {
            boolean bl2 = false;
        }
        TextPositionInfo textPositionInfo = this.positionInfoForIndex(n);
        if (textPositionInfo == null) {
            textPositionInfo = textParagraph.infoForPosition(n, -1);
        }
        TextPositionInfo textPositionInfo2 = textParagraph.insertCharOrStringAt('\u0000', string, n);
        n2 = string.length();
        this._charCount += n2;
        if (textPositionInfo2 == null) {
            this._selection.showInsertionPoint();
            return;
        }
        if (this.isDirty() && this.dirtyRect == null) {
            Range range = new Range(textParagraph._startChar, this.length() - textParagraph._startChar);
            this.notifyAttachmentsForRange(range, true);
            return;
        }
        if (bl) {
            this.formatParagraphAtIndex(n3);
        }
        textPositionInfo2.setAbsPosition(n + n2);
        TextParagraphFormat textParagraphFormat = textParagraph.currentParagraphFormat();
        if (textPositionInfo2._redrawCurrentLineOnly && textParagraphFormat._justification == 0) {
            TextParagraph textParagraph3 = this._updateParagraph;
            int n5 = this._updateLine;
            this._updateParagraph = textParagraph;
            this._updateLine = textPositionInfo2._updateLine;
            this._drawText = false;
            Rect rect = textParagraph.rectForLine(textPositionInfo2._lineNumber);
            rect.setBounds(textPositionInfo._x, rect.y, rect.width - (textPositionInfo._x - rect.x), rect.height);
            this.addDirtyRect(rect);
            TextView.returnRect(rect);
            this._drawText = true;
            this._updateParagraph = textParagraph3;
            this._updateLine = n5;
            this.notifyAttachmentsForRange(textPositionInfo2.lineRange(), true);
            return;
        }
        if (textPositionInfo2._redrawCurrentParagraphOnly || textPositionInfo2._redrawCurrentLineOnly) {
            Range range = textParagraph.range();
            this.notifyAttachmentsForRange(range, true);
            this.dirtyRange(range);
            return;
        }
        Range range = new Range(textParagraph._startChar, this.length() - textParagraph._startChar);
        this.notifyAttachmentsForRange(range, true);
        this.dirtyRange(range);
    }

    private void fastDeleteChar(boolean bl) {
        TextPositionInfo textPositionInfo;
        TextParagraph textParagraph;
        if (!this.isEditing()) {
            return;
        }
        int n = this._selection.insertionPoint();
        if (!bl && n == 0) {
            return;
        }
        if (bl && n == this.length()) {
            return;
        }
        if (bl) {
            ++n;
        }
        if ((textParagraph = this._paragraphForIndex(n)) == null) {
            return;
        }
        this.notifyAttachmentsForRange(new Range(n, 1), false);
        TextParagraph textParagraph2 = this.lastParagraph();
        if (textParagraph2 != null) {
            int n2 = textParagraph2._y + textParagraph2._height;
        } else {
            boolean bl2 = false;
        }
        if (textParagraph._startChar == n && !this.isOnlyParagraph(textParagraph)) {
            int n3 = this._paragraphVector.indexOfIdentical((Object)textParagraph);
            TextParagraph textParagraph3 = (TextParagraph)this._paragraphVector.elementAt(n3 - 1);
            if (textParagraph3 != null) {
                textParagraph3.subsumeParagraph(textParagraph);
                this._paragraphVector.removeElement((Object)textParagraph);
                textParagraph = textParagraph3;
                this.formatParagraph(textParagraph);
            }
            textPositionInfo = n == 0 ? textParagraph.infoForPosition(0, -1) : textParagraph.infoForPosition(n - 1, -1);
        } else {
            textPositionInfo = textParagraph.removeCharAt(n);
            --this._charCount;
        }
        TextPositionInfo textPositionInfo2 = textPositionInfo;
        int n4 = this.adjustCharCountsAndSpacing();
        this.sizeBy(0, n4 - this.bounds.height);
        if (textPositionInfo == null) {
            this._selection.showInsertionPoint();
            return;
        }
        this.notifyAttachmentsForRange(textPositionInfo._textRun._paragraph.range(), true);
        if (!bl) {
            if (n == 0) {
                textPositionInfo.setAbsPosition(0);
            } else {
                textPositionInfo.setAbsPosition(n - 1);
            }
            this._selection.setInsertionPoint(textPositionInfo);
            this._selectionChanged();
        } else {
            this._selection.setInsertionPoint(textPositionInfo);
        }
        TextParagraphFormat textParagraphFormat = textParagraph.currentParagraphFormat();
        if (textPositionInfo._redrawCurrentLineOnly && textParagraphFormat._justification == 0) {
            TextParagraph textParagraph4 = this._updateParagraph;
            int n5 = this._updateLine;
            this._updateParagraph = textParagraph;
            this._updateLine = textPositionInfo._updateLine;
            this._drawText = false;
            Rect rect = textParagraph.rectForLine(textPositionInfo._lineNumber);
            rect.setBounds(textPositionInfo2._x, rect.y, rect.width - (textPositionInfo2._x - rect.x), rect.height);
            this.addDirtyRect(rect);
            TextView.returnRect(rect);
            this._drawText = true;
            this._updateParagraph = textParagraph4;
            this._updateLine = n5;
            return;
        }
        if (textPositionInfo._redrawCurrentParagraphOnly || textPositionInfo._redrawCurrentLineOnly) {
            this.dirtyRange(textParagraph.range());
            return;
        }
        Range range = TextView.allocateRange(textParagraph._startChar, this.length() - textParagraph._startChar);
        this.dirtyRange(range);
        TextView.recycleRange(range);
    }

    private Rect insertReturn() {
        if (this._selection.isARange()) {
            this.deleteSelection();
        }
        int n = this._selection.insertionPoint();
        Rect rect = this.insertReturn(n);
        this._selection.setRange(n + 1, n + 1);
        this._selectionChanged();
        return rect;
    }

    private Rect insertReturn(int n) {
        TextParagraph textParagraph;
        int n2 = this._paragraphIndexForIndex(n);
        if (n2 == -1) {
            n2 = this._paragraphVector.count() - 1;
        }
        TextParagraph textParagraph2 = textParagraph = (TextParagraph)this._paragraphVector.elementAt(n2);
        textParagraph = textParagraph.createNewParagraphAt(n);
        this.formatParagraphAtIndex(n2);
        ++this._charCount;
        this._paragraphVector.insertElementAt((Object)textParagraph, n2 + 1);
        this.formatParagraphAtIndex(n2 + 1);
        return TextView.newRect(0, textParagraph2._y, this.bounds.width, this.bounds.height - textParagraph2._y);
    }

    private TextStyleRun _runForIndex(int n) {
        int n2 = this.length();
        if (n2 > 0 && n >= n2) {
            return this._runForIndex(n2 - 1);
        }
        if (n >= 0) {
            TextParagraph textParagraph = this._paragraphForIndex(n);
            if (textParagraph != null) {
                return textParagraph.runForCharPosition(n);
            }
            return null;
        }
        return null;
    }

    private boolean equalsAttributesHint(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == hashtable2) {
            return true;
        }
        if (hashtable == null || hashtable2 == null) {
            return false;
        }
        return false;
    }

    private void _keyDown() {
        Object object;
        Event event = (Event)this._eventVector.removeFirstElement();
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)event;
        if (keyEvent.key == 1022) {
            return;
        }
        this._selection.disableInsertionPoint();
        int n = this._selection.insertionPoint();
        TextParagraph textParagraph = this._paragraphForIndex(n);
        boolean bl = true;
        if (keyEvent.isReturnKey()) {
            object = new Range(this.selectedRange());
            if (this._owner != null) {
                this._owner.textWillChange(this, (Range)object);
            }
            Rect rect = this.insertReturn();
            if (this._owner != null) {
                ((Range)object).length = 1;
                this._owner.textDidChange(this, (Range)object);
            }
            this.draw(rect);
            TextView.returnRect(rect);
        } else if (keyEvent.isLeftArrowKey()) {
            if (keyEvent.isShiftKeyDown()) {
                int n2 = this._selection.orderedSelectionEnd() - 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                this._selection.setRange(this._selection.orderedSelectionStart(), n2, true);
            } else if (n == -1) {
                this._selection.setRange(this._selection.selectionStart(), this._selection.selectionStart(), true);
            } else {
                int n3 = n - 1;
                if (n3 < 0) {
                    n3 = 0;
                }
                this._selection.setRange(n3, n3, true);
            }
            this._selectionChanged();
        } else if (keyEvent.isRightArrowKey()) {
            if (keyEvent.isShiftKeyDown()) {
                this._selection.setRange(this._selection.orderedSelectionStart(), this._selection.orderedSelectionEnd() + 1, false);
            } else if (n == -1) {
                this._selection.setRange(this._selection.selectionEnd(), this._selection.selectionEnd());
            } else {
                this._selection.setRange(n + 1, n + 1, false);
            }
            this._selectionChanged();
        } else if (keyEvent.isUpArrowKey()) {
            TextPositionInfo textPositionInfo = this._selection.orderedSelectionEndInfo();
            TextPositionInfo textPositionInfo2 = this.positionForPoint(textPositionInfo._x, textPositionInfo._y - 1, false);
            if (textPositionInfo2 != null) {
                textPositionInfo2.representCharacterBeforeEndOfLine();
                if (keyEvent.isShiftKeyDown()) {
                    if (textPositionInfo2._absPosition == textPositionInfo._absPosition && textPositionInfo2._absPosition > 0) {
                        this._selection.setRange(this._selection.orderedSelectionStart(), textPositionInfo2._absPosition - 1, null, false, true);
                    } else {
                        this._selection.setRange(this._selection.orderedSelectionStart(), textPositionInfo2._absPosition, textPositionInfo2, false, true);
                    }
                } else if (textPositionInfo._lineNumber != 0 || textPositionInfo._textRun._paragraph != this._paragraphVector.elementAt(0)) {
                    this._selection.setInsertionPoint(textPositionInfo2);
                }
                this._selectionChanged();
            }
        } else if (keyEvent.isDownArrowKey()) {
            TextPositionInfo textPositionInfo = this._selection.orderedSelectionEndInfo();
            textPositionInfo.representCharacterBeforeEndOfLine();
            TextPositionInfo textPositionInfo3 = this.positionForPoint(textPositionInfo._x, textPositionInfo._y + textPositionInfo._lineHeight + 1, false);
            if (textPositionInfo3 != null) {
                if (keyEvent.isShiftKeyDown()) {
                    this._selection.setRange(this._selection.orderedSelectionStart(), textPositionInfo3._absPosition, textPositionInfo3, false, false);
                } else if (textPositionInfo3._textRun._paragraph != textPositionInfo._textRun._paragraph || textPositionInfo3._y != textPositionInfo._y) {
                    this._selection.setInsertionPoint(textPositionInfo3);
                }
                this._selectionChanged();
            }
        } else if (keyEvent.isHomeKey()) {
            this.selectedRange();
            object = this._selection.orderedSelectionEndInfo();
            Range range = this.lineForPosition((TextPositionInfo)object);
            TextPositionInfo textPositionInfo = this.positionInfoForIndex(range.index);
            if (textPositionInfo != null) {
                if (textPositionInfo._y != ((TextPositionInfo)object)._y) {
                    textPositionInfo.representCharacterAfterEndOfLine();
                }
                if (keyEvent.isShiftKeyDown()) {
                    if (textPositionInfo._absPosition != ((TextPositionInfo)object)._absPosition) {
                        this._selection.setRange(this._selection.orderedSelectionStart(), textPositionInfo._absPosition, textPositionInfo, false, false);
                    }
                } else {
                    this._selection.setInsertionPoint(textPositionInfo);
                }
            }
            this._selectionChanged();
        } else if (keyEvent.isEndKey()) {
            this.selectedRange();
            object = this._selection.orderedSelectionEndInfo();
            Range range = this.lineForPosition((TextPositionInfo)object);
            TextPositionInfo textPositionInfo = this.positionInfoForIndex(range.index + range.length);
            if (textPositionInfo != null) {
                if (textPositionInfo._y != ((TextPositionInfo)object)._y) {
                    textPositionInfo.representCharacterAfterEndOfLine();
                }
                if (keyEvent.isShiftKeyDown()) {
                    if (textPositionInfo._absPosition != ((TextPositionInfo)object)._absPosition) {
                        this._selection.setRange(this._selection.orderedSelectionStart(), textPositionInfo._absPosition, textPositionInfo, false, false);
                    }
                } else {
                    this._selection.setInsertionPoint(textPositionInfo);
                }
            }
            this._selectionChanged();
        } else if (keyEvent.isBackspaceKey()) {
            object = new Range(this.selectedRange());
            if (this._selection.isARange()) {
                if (this._owner != null) {
                    this._owner.textWillChange(this, (Range)object);
                }
                this.deleteSelection();
                if (this._owner != null) {
                    ((Range)object).length = 0;
                    this._owner.textDidChange(this, (Range)object);
                }
            } else {
                if (this._owner != null) {
                    --((Range)object).index;
                    ((Range)object).length = 1;
                    this._owner.textWillChange(this, (Range)object);
                }
                this.fastDeleteChar(false);
                if (this._owner != null) {
                    ((Range)object).length = 0;
                    this._owner.textDidChange(this, (Range)object);
                }
            }
        } else if (keyEvent.isDeleteKey()) {
            object = this.selectedRange();
            if (this._selection.isARange()) {
                if (this._owner != null) {
                    this._owner.textWillChange(this, (Range)object);
                }
                this.deleteSelection();
                if (this._owner != null) {
                    ((Range)object).length = 0;
                    this._owner.textDidChange(this, (Range)object);
                }
            } else if (((Range)object).index < this.length()) {
                ((Range)object).length = 1;
                if (this._owner != null) {
                    this._owner.textWillChange(this, (Range)object);
                }
                this.fastDeleteChar(true);
                ((Range)object).length = 0;
                if (this._owner != null) {
                    this._owner.textDidChange(this, (Range)object);
                }
            }
        } else if (keyEvent.isPrintableKey()) {
            object = this.selectedRange();
            Range range = TextView.allocateRange();
            if (keyEvent.isExtendedKeyEvent()) {
                this.replaceRangeWithString((Range)object, String.valueOf(keyEvent.keyChar()));
            } else {
                this.replaceRangeWithString((Range)object, String.valueOf((char)keyEvent.key));
            }
            if (this._typingAttributes.count() > 0) {
                range.index = ((Range)object).index;
                range.length = 1;
                this.addAttributesForRangeWithoutNotification(this._typingAttributes, range);
                this.clearTypingAttributes();
            }
            range.index = ((Range)object).index + 1;
            range.length = 0;
            this.selectRange(range);
            TextView.recycleRange(range);
        } else if (keyEvent.isTabKey()) {
            object = this.selectedRange();
            Range range = TextView.allocateRange();
            this.replaceRangeWithString((Range)object, "\t");
            range.index = ((Range)object).index + 1;
            range.length = 0;
            this.selectRange(range);
            TextView.recycleRange(range);
        } else {
            bl = false;
        }
        if (bl) {
            object = new Range(this._selection.orderedSelectionEnd(), 0);
            if (((Range)object).index > 0) {
                --((Range)object).index;
                ++((Range)object).length;
            }
            this.scrollRangeToVisible((Range)object);
        }
        this._selection.enableInsertionPoint();
    }

    private Range paragraphsRangeForRange(Range range) {
        Range range2 = TextView.allocateRange();
        boolean bl = false;
        int n = this._paragraphVector.count();
        int n2 = range.index + range.length;
        int n3 = 0;
        while (n3 < n) {
            TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n3);
            if (!bl && range.index >= textParagraph._startChar && range.index < textParagraph._startChar + textParagraph._charCount) {
                range2.index = n3;
                bl = true;
            }
            if (bl && n2 >= textParagraph._startChar && n2 < textParagraph._startChar + textParagraph._charCount) {
                range2.length = n3 - range2.index + 1;
                break;
            }
            ++n3;
        }
        return range2;
    }

    private Vector createAndReturnRunsForRange(Range range) {
        int n;
        TextStyleRun textStyleRun;
        TextParagraph textParagraph;
        boolean bl;
        int n2 = range.index;
        int n3 = range.index + range.length;
        TextParagraph textParagraph2 = this._paragraphForIndex(n2);
        boolean bl2 = bl = textParagraph2 == (textParagraph = this._paragraphForIndex(n3));
        if (range.length == 0) {
            TextStyleRun textStyleRun2 = textParagraph2.createNewRunAt(n2);
            if (textStyleRun2.charCount() > 0) {
                textStyleRun2 = textParagraph2.createNewRunAt(n2);
            }
            Vector vector = TextView.newVector();
            vector.addElement((Object)textStyleRun2);
            return vector;
        }
        TextStyleRun textStyleRun3 = textParagraph2.runForCharPosition(n2);
        if (textStyleRun3.rangeIndex() != n2) {
            textStyleRun3 = textParagraph2.createNewRunAt(n2);
        }
        if (n3 <= (textStyleRun = textParagraph.runForCharPosition(n3)).rangeIndex() + textStyleRun.charCount() - 1) {
            textStyleRun = textParagraph.createNewRunAt(n3);
            textStyleRun = textParagraph.runBefore(textStyleRun);
        }
        if (bl) {
            if (textStyleRun3 == textStyleRun) {
                Vector vector = new Vector();
                vector.addElement((Object)textStyleRun3);
                return vector;
            }
            Vector vector = textParagraph2.runsFromTo(textStyleRun3, textStyleRun);
            return vector;
        }
        Vector vector = TextView.newVector();
        vector.addElement((Object)textStyleRun3);
        Vector vector2 = textParagraph2.runsAfter(textStyleRun3);
        vector.addElementsIfAbsent(vector2);
        TextView.returnVector(vector2);
        int n4 = n = this._paragraphVector.indexOfIdentical((Object)textParagraph2) + 1;
        int n5 = this._paragraphVector.indexOfIdentical((Object)textParagraph);
        while (n < n5) {
            TextParagraph textParagraph3 = (TextParagraph)this._paragraphVector.elementAt(n);
            vector.addElementsIfAbsent(textParagraph3.runVector());
            ++n;
        }
        vector2 = textParagraph.runsBefore(textStyleRun);
        vector2.addElement((Object)textStyleRun);
        vector.addElementsIfAbsent(vector2);
        TextView.returnVector(vector2);
        return vector;
    }

    private void processSetFont(Font font) {
        Range range = this.selectedRange();
        if (range.length > 0) {
            Hashtable hashtable = new Hashtable();
            hashtable.put((Object)FONT_KEY, (Object)font);
            this.addAttributesForRange(hashtable, range);
            return;
        }
        this.addTypingAttribute(FONT_KEY, font);
    }

    private void deleteSelection(Vector vector) {
        Range range = this.selectedRange();
        this.deleteRange(range, vector);
        this._selection.setRange(range.index, range.index);
        this._selectionChanged();
    }

    private void deleteRange(Range range, Vector vector) {
        TextStyleRun textStyleRun;
        Vector vector2;
        TextParagraph textParagraph = null;
        if (range.length == 0) {
            return;
        }
        Range range2 = TextView.allocateRange(range.index, this.length() - range.index);
        this.dirtyRange(range2);
        TextView.recycleRange(range2);
        this.notifyAttachmentsForRange(range, false);
        TextPositionInfo textPositionInfo = this.positionInfoForIndex(range.index);
        TextPositionInfo textPositionInfo2 = this.positionInfoForIndex(range.index + range.length);
        TextParagraph textParagraph2 = textPositionInfo._textRun._paragraph;
        TextParagraph textParagraph3 = textPositionInfo2._textRun._paragraph;
        boolean bl = textParagraph2 == textParagraph3;
        TextStyleRun textStyleRun2 = textPositionInfo._textRun;
        if (textStyleRun2.rangeIndex() != textPositionInfo._absPosition) {
            textStyleRun2 = textParagraph2.createNewRunAt(textPositionInfo._absPosition);
        }
        if (!bl) {
            vector2 = textParagraph2.runsAfter(textStyleRun2);
            textParagraph2.removeRun(textStyleRun2);
            textParagraph2.removeRuns(vector2);
            if (vector != null) {
                textParagraph = new TextParagraph(this);
                textParagraph.setFormat(textParagraph2._format);
                textParagraph.addRun(textStyleRun2);
                textParagraph.addRuns(vector2);
                vector.addElement((Object)textParagraph);
            }
            vector2.removeAllElements();
            TextView.returnVector(vector2);
        }
        if ((textStyleRun = textPositionInfo2._textRun).rangeIndex() != textPositionInfo2._absPosition) {
            textStyleRun = textParagraph3.createNewRunAt(textPositionInfo2._absPosition);
        }
        if (bl) {
            vector2 = textParagraph2.runsFromTo(textStyleRun2, textStyleRun);
            vector2.removeElement((Object)textStyleRun);
            textParagraph2.removeRuns(vector2);
            if (vector != null) {
                textParagraph = new TextParagraph(this);
                textParagraph.setFormat(textParagraph2._format);
                textParagraph.addRuns(vector2);
                vector.addElement((Object)textParagraph);
            }
            vector2.removeAllElements();
            TextView.returnVector(vector2);
        } else {
            int n;
            int n2 = n = this._paragraphVector.indexOfIdentical((Object)textParagraph2) + 1;
            int n3 = this._paragraphVector.indexOfIdentical((Object)textParagraph3);
            while (n < n3) {
                TextParagraph textParagraph4 = (TextParagraph)this._paragraphVector.removeElementAt(n2);
                if (vector != null) {
                    vector.addElement((Object)textParagraph4);
                }
                ++n;
            }
            vector2 = textParagraph3.runsBefore(textStyleRun);
            textParagraph3.removeRuns(vector2);
            if (vector != null) {
                textParagraph = new TextParagraph(this);
                textParagraph.setFormat(textParagraph2._format);
                textParagraph.addRuns(vector2);
                vector.addElement((Object)textParagraph);
            }
            vector2.removeAllElements();
            TextView.returnVector(vector2);
            textParagraph2.subsumeParagraph(textParagraph3);
            this._paragraphVector.removeElement((Object)textParagraph3);
        }
        this.formatParagraph(textParagraph2);
    }

    private void deleteSelection() {
        this.deleteSelection(null);
    }

    boolean isOnlyParagraph(TextParagraph textParagraph) {
        return this._paragraphVector.count() == 1 && this._paragraphVector.contains((Object)textParagraph);
    }

    int selectionStart() {
        return this._selection.selectionStart();
    }

    TextPositionInfo selectionStartInfo() {
        return this._selection.selectionStartInfo();
    }

    int selectionEnd() {
        return this._selection.selectionEnd();
    }

    TextPositionInfo selectionEndInfo() {
        return this._selection.selectionEndInfo();
    }

    boolean hasSelectionRange() {
        return this._selection.isARange();
    }

    TextParagraph lastParagraph() {
        return (TextParagraph)this._paragraphVector.lastElement();
    }

    char characterAt(int n) {
        if (n < 0 || n > this._charCount) {
            return '\u0000';
        }
        TextParagraph textParagraph = this._paragraphForIndex(n);
        if (textParagraph == null) {
            textParagraph = this.lastParagraph();
        }
        return textParagraph.characterAt(n);
    }

    int _positionOfPreviousWord(int n) {
        char c;
        boolean bl = false;
        if (n == 0) {
            return 0;
        }
        if ((c = this.characterAt(n--)) == '\n') {
            return n + 1;
        }
        if (c == ' ' || c == '\t') {
            do {
                boolean bl2 = bl = (c = this.characterAt(n--)) != ' ' && c != '\t' || c == '\n';
            } while (n > -1 && !bl);
        } else {
            do {
                boolean bl3 = bl = (c = this.characterAt(n--)) == ' ' || c == '\t' || c >= '!' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '\'' || c >= '{' && c <= '~' || c == '\n';
            } while (n > -1 && !bl);
        }
        if (bl) {
            return n + 2;
        }
        return 0;
    }

    int _positionOfNextWord(int n) {
        char c;
        char c2;
        boolean bl = false;
        if (n >= this._charCount) {
            return this._charCount;
        }
        if (n > 0 && (c2 = this.characterAt(n - 1)) == '\n') {
            return n - 1;
        }
        if ((c = this.characterAt(n++)) == ' ' || c == '\t') {
            do {
                c2 = c;
                boolean bl2 = bl = (c = this.characterAt(n++)) != ' ' && c != '\t' || c == '\n';
            } while (n < this._charCount && !bl);
        } else {
            do {
                c2 = c;
                boolean bl3 = bl = (c = this.characterAt(n++)) == ' ' || c == '\t' || c >= '!' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '\'' || c >= '{' && c <= '~' || c == '\n';
            } while (n < this._charCount && !bl);
        }
        if (bl) {
            return n - 1;
        }
        return this._charCount;
    }

    private void hideInsertionPoint() {
        if (this.insertionPointVisible) {
            this.insertionPointVisible = false;
        }
    }

    private void showInsertionPoint() {
        if (!this.insertionPointVisible) {
            this.insertionPointVisible = true;
        }
    }

    static Rect newRect(int n, int n2, int n3, int n4) {
        Rect rect;
        Vector vector = _rectCache;
        synchronized (vector) {
            if (!_shouldCache || _rectCache.isEmpty()) {
                Rect rect2 = new Rect(n, n2, n3, n4);
                Object var7_6 = null;
                return rect2;
            }
            rect = (Rect)_rectCache.removeLastElement();
        }
        rect.setBounds(n, n2, n3, n4);
        return rect;
    }

    static Rect newRect(Rect rect) {
        Rect rect2;
        Vector vector = _rectCache;
        synchronized (vector) {
            if (!_shouldCache || _rectCache.isEmpty()) {
                Rect rect3 = new Rect(rect);
                Object var4_3 = null;
                return rect3;
            }
            rect2 = (Rect)_rectCache.removeLastElement();
        }
        rect2.setBounds(rect);
        return rect2;
    }

    static Rect newRect() {
        return TextView.newRect(0, 0, 0, 0);
    }

    static void returnRect(Rect rect) {
        if (rect == null) {
            return;
        }
        if (!_shouldCache) {
            return;
        }
        Vector vector = _rectCache;
        synchronized (vector) {
            if (_rectCache.count() < 50) {
                _rectCache.addElement((Object)rect);
            }
            return;
        }
    }

    static void returnRects(Vector vector) {
        if (vector == null || !_shouldCache) {
            return;
        }
        int n = vector.count();
        while (n-- > 0) {
            TextView.returnRect((Rect)vector.elementAt(n));
        }
        vector.removeAllElements();
    }

    static void setShouldCacheRects(boolean bl) {
        Vector vector = _rectCache;
        synchronized (vector) {
            _shouldCache = bl;
            if (!_shouldCache) {
                _rectCache.removeAllElements();
            }
            return;
        }
    }

    static Vector newVector() {
        Vector vector;
        Vector vector2 = _vectorCache;
        synchronized (vector2) {
            if (!_shouldCache || _vectorCache.isEmpty()) {
                Vector vector3 = new Vector();
                Object var3_2 = null;
                return vector3;
            }
            vector = (Vector)_vectorCache.removeLastElement();
        }
        return vector;
    }

    static void returnVector(Vector vector) {
        if (!_shouldCache) {
            return;
        }
        Vector vector2 = _vectorCache;
        synchronized (vector2) {
            if (vector != null && _vectorCache.count() < 15) {
                vector.removeAllElements();
                _vectorCache.addElement((Object)vector);
            }
            return;
        }
    }

    static void setShouldCacheVectors(boolean bl) {
        Vector vector = _vectorCache;
        synchronized (vector) {
            _shouldCache = bl;
            if (!_cacheVectors) {
                _vectorCache.removeAllElements();
            }
            return;
        }
    }

    private void _selectionChanged() {
        int n = this._selection.selectionStart();
        int n2 = this._selection.selectionEnd();
        if (n == this._wasSelectedRange.index && n2 - n == this._wasSelectedRange.length) {
            return;
        }
        this._wasSelectedRange.index = n;
        this._wasSelectedRange.length = n2 - n;
        this.clearTypingAttributes();
        if (this._owner != null) {
            this._owner.selectionDidChange(this);
        }
    }

    void dirtyRange(Range range) {
        if (this.isDirty() && this.dirtyRect == null) {
            return;
        }
        Range range2 = TextView.allocateRange(range);
        Rect rect = new Rect();
        this.computeVisibleRect(rect);
        range2.intersectWith(0, this.length());
        if (this._superview != null && range2 != null && !range2.isNullRange() && range2.length > 0) {
            Vector vector = this.rectsForRange(range2, rect);
            int n = 0;
            int n2 = vector.count();
            while (n < n2) {
                Rect rect2 = (Rect)vector.elementAt(n);
                rect2.x = 0;
                rect2.width = this.bounds.width;
                if (rect2.width > 0 && rect2.height > 0) {
                    this.addDirtyRect(rect2);
                }
                ++n;
            }
        }
        TextView.recycleRange(range2);
    }

    private TextParagraphFormat _formatForTextPositionInfo(TextPositionInfo textPositionInfo) {
        TextParagraphFormat textParagraphFormat = textPositionInfo._textRun.paragraph().format();
        if (textParagraphFormat == null) {
            textParagraphFormat = (TextParagraphFormat)this._defaultAttributes.get((Object)PARAGRAPH_FORMAT_KEY);
        }
        return textParagraphFormat;
    }

    private TextPositionInfo positionInfoForNextLine(TextPositionInfo textPositionInfo) {
        int n = textPositionInfo._textRun.paragraph().characterStartingLine(textPositionInfo._lineNumber + 1);
        if (n == -1) {
            int n2 = this._paragraphVector.indexOfIdentical((Object)textPositionInfo._textRun.paragraph()) + 1;
            if (n2 < this._paragraphVector.count()) {
                TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n2);
                return this.positionInfoForIndex(textParagraph._startChar);
            }
            return null;
        }
        TextPositionInfo textPositionInfo2 = this.positionInfoForIndex(n);
        return textPositionInfo2;
    }

    private TextStyleRun runBefore(TextStyleRun textStyleRun) {
        int n;
        TextStyleRun textStyleRun2 = textStyleRun.paragraph().runBefore(textStyleRun);
        if (textStyleRun2 == null && (n = this._paragraphVector.indexOfIdentical((Object)textStyleRun.paragraph())) > 0) {
            return ((TextParagraph)this._paragraphVector.elementAt(n - 1)).lastRun();
        }
        return textStyleRun2;
    }

    private TextStyleRun runAfter(TextStyleRun textStyleRun) {
        int n;
        TextStyleRun textStyleRun2 = textStyleRun.paragraph().runAfter(textStyleRun);
        if (textStyleRun2 == null && (n = this._paragraphVector.indexOfIdentical((Object)textStyleRun.paragraph())) < this._paragraphVector.count() - 1) {
            return ((TextParagraph)this._paragraphVector.elementAt(n + 1)).firstRun();
        }
        return textStyleRun2;
    }

    private Range linkRangeForPosition(int n) {
        String string;
        TextStyleRun textStyleRun = this._runForIndex(n);
        Hashtable hashtable = textStyleRun.attributes();
        if (hashtable != null && (string = (String)hashtable.get((Object)LINK_KEY)) != null) {
            TextStyleRun textStyleRun2;
            TextStyleRun textStyleRun3;
            TextStyleRun textStyleRun4 = textStyleRun3 = textStyleRun;
            while ((textStyleRun4 = this.runBefore(textStyleRun4)) != null && (hashtable = textStyleRun4.attributes()) != null && string.equals((String)hashtable.get((Object)LINK_KEY))) {
                textStyleRun3 = textStyleRun4;
            }
            textStyleRun4 = textStyleRun2 = textStyleRun;
            while ((textStyleRun4 = this.runAfter(textStyleRun4)) != null && (hashtable = textStyleRun4.attributes()) != null && string.equals((String)hashtable.get((Object)LINK_KEY))) {
                textStyleRun2 = textStyleRun4;
            }
            Range range = textStyleRun3.range();
            range.unionWith(textStyleRun2.range());
            return range;
        }
        return null;
    }

    private void highlightLinkWithRange(Range range, boolean bl) {
        if (bl) {
            this.addAttributeForRange(LINK_IS_PRESSED_KEY, "", range);
        } else {
            this.removeAttributeForRange(LINK_IS_PRESSED_KEY, range);
        }
        Range range2 = this.paragraphsRangeForRange(range);
        int n = range2.index;
        int n2 = range2.index + range2.length;
        while (n < n2) {
            ((TextParagraph)this._paragraphVector.elementAt(n)).collectEmptyRuns();
            ++n;
        }
    }

    private boolean runUnderMouse(TextStyleRun textStyleRun, int n, int n2) {
        Vector vector = this.rectsForRange(textStyleRun.range());
        int n3 = 0;
        int n4 = vector.count();
        while (n3 < n4) {
            if (((Rect)vector.elementAt(n3)).contains(n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean runsUnderMouse(Vector vector, int n, int n2) {
        int n3 = 0;
        int n4 = vector.count();
        while (n3 < n4) {
            Range range = (Range)vector.elementAt(n3);
            TextStyleRun textStyleRun = this._runForIndex(range.index);
            if (this.runUnderMouse(textStyleRun, n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    boolean lastParagraphIsEmpty() {
        return this.lastParagraph()._charCount == 0;
    }

    char charAt(int n) {
        String string = this.stringForRange(new Range(n, 1));
        if (string != null && string.length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    boolean isWordCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    Range groupForIndex(int n) {
        int n2 = this.length();
        int n3 = n;
        char c = this.charAt(n3);
        if (c == '\n') {
            return new Range(n3, 1);
        }
        if (c == ' ' || c == '\t') {
            while (n3 > 0) {
                c = this.charAt(n3);
                if (c != ' ' && c != '\t') break;
                --n3;
            }
            int n4 = n3 + 1;
            n3 = n;
            while (n3 < this.length()) {
                c = this.charAt(n3);
                if (c != ' ' && c != '\t') break;
                ++n3;
            }
            int n5 = n3 - 1;
            return new Range(n4, n5 - n4 + 1);
        }
        if (!this.isWordCharacter(c)) {
            return new Range(n, 1);
        }
        int n6 = n3;
        while (n6 > 0) {
            c = this.charAt(n6 - 1);
            if (!this.isWordCharacter(c)) break;
            --n6;
        }
        int n7 = n3;
        while (n7 < n2 - 1) {
            c = this.charAt(n7 + 1);
            if (!this.isWordCharacter(c)) break;
            ++n7;
        }
        return new Range(n6, n7 - n6 + 1);
    }

    Range lineForPosition(TextPositionInfo textPositionInfo) {
        TextParagraph textParagraph = textPositionInfo._textRun._paragraph;
        if (textParagraph != null) {
            int n = textPositionInfo._lineNumber == 0 ? textParagraph._startChar : textParagraph._startChar + textParagraph._lineBreaks[textPositionInfo._lineNumber - 1];
            int n2 = textParagraph._startChar + textParagraph._lineBreaks[textPositionInfo._lineNumber] - 1;
            return new Range(n, n2 - n + 1);
        }
        return new Range();
    }

    void replaceContentWithString(String string) {
        TextStyleRun textStyleRun;
        TextParagraph textParagraph;
        this.notifyAttachmentsForRange(new Range(0, this.length()), false);
        this._paragraphVector.removeAllElements();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            int n4;
            int n5 = string.indexOf(10, n);
            if (n5 == -1) {
                n4 = n;
                n3 = n2;
                n = n2;
            } else {
                n4 = n;
                n3 = n5;
                n = n5 + 1;
            }
            textParagraph = new TextParagraph(this);
            textStyleRun = new TextStyleRun(textParagraph, string, n4, n3, null);
            textParagraph.addRun(textStyleRun);
            this._paragraphVector.addElement((Object)textParagraph);
        }
        if (this._paragraphVector.count() == 0 || string.charAt(n2 - 1) == '\n') {
            textParagraph = new TextParagraph(this);
            textStyleRun = new TextStyleRun(textParagraph, "", null);
            textParagraph.addRun(textStyleRun);
            this._paragraphVector.addElement((Object)textParagraph);
        }
        this.setDirty(true);
        this.reformatAll();
    }

    Vector rectsForRange(Range range, Rect rect) {
        Rect rect2;
        Range range2 = TextView.allocateRange(range.index, range.length);
        Vector vector = new Vector();
        range2.intersectWith(0, this.length());
        if (range2.length == 0 || range2.isNullRange()) {
            TextView.recycleRange(range2);
            return vector;
        }
        TextPositionInfo textPositionInfo = this.positionInfoForIndex(range2.index);
        if (textPositionInfo._endOfLine && !textPositionInfo._endOfParagraph) {
            textPositionInfo.representCharacterAfterEndOfLine();
        }
        TextPositionInfo textPositionInfo2 = this.positionInfoForIndex(range2.index + range2.length());
        if (textPositionInfo == null || textPositionInfo2 == null) {
            TextView.recycleRange(range2);
            return vector;
        }
        if (textPositionInfo._textRun.paragraph() == textPositionInfo2._textRun.paragraph() && textPositionInfo._lineNumber == textPositionInfo2._lineNumber) {
            TextParagraphFormat textParagraphFormat = this._formatForTextPositionInfo(textPositionInfo);
            if (textPositionInfo2._endOfLine) {
                TextParagraph textParagraph = textPositionInfo._textRun.paragraph();
                int n = textParagraph._lineRemainders[textPositionInfo._lineNumber];
                switch (textParagraphFormat._justification) {
                    case 1: {
                        vector.addElement((Object)new Rect(textPositionInfo._x, textPositionInfo._y, this.bounds.width - textParagraphFormat._rightMargin - textPositionInfo._x - n / 2, textPositionInfo._lineHeight));
                        break;
                    }
                    case 2: {
                        vector.addElement((Object)new Rect(textPositionInfo._x, textPositionInfo._y, this.bounds.width - textParagraphFormat._rightMargin - textPositionInfo._x, textPositionInfo._lineHeight));
                        break;
                    }
                    default: {
                        vector.addElement((Object)new Rect(textPositionInfo._x, textPositionInfo._y, this.bounds.width - textParagraphFormat._rightMargin - textPositionInfo._x - n, textPositionInfo._lineHeight));
                        break;
                    }
                }
            } else {
                vector.addElement((Object)new Rect(textPositionInfo._x, textPositionInfo._y, textPositionInfo2._x - textPositionInfo._x, textPositionInfo._lineHeight));
            }
            TextView.recycleRange(range2);
            return vector;
        }
        TextParagraphFormat textParagraphFormat = this._formatForTextPositionInfo(textPositionInfo);
        TextParagraph textParagraph = textPositionInfo._textRun.paragraph();
        int n = textParagraph._lineRemainders[textPositionInfo._lineNumber];
        switch (textParagraphFormat._justification) {
            case 1: {
                rect2 = new Rect(textPositionInfo._x, textPositionInfo._y, this.bounds.width - textParagraphFormat._rightMargin - textPositionInfo._x - n / 2, textPositionInfo._lineHeight);
                break;
            }
            case 2: {
                rect2 = new Rect(textPositionInfo._x, textPositionInfo._y, this.bounds.width - textParagraphFormat._rightMargin - textPositionInfo._x, textPositionInfo._lineHeight);
                break;
            }
            default: {
                rect2 = new Rect(textPositionInfo._x, textPositionInfo._y, this.bounds.width - textParagraphFormat._rightMargin - textPositionInfo._x - n, textPositionInfo._lineHeight);
            }
        }
        if (rect2.height > 0) {
            vector.addElement((Object)rect2);
        }
        rect2 = new Rect(0, 0, 0, 0);
        TextPositionInfo textPositionInfo3 = textPositionInfo;
        boolean bl = false;
        int n2 = -1;
        while (!bl) {
            if ((textPositionInfo3 = this.positionInfoForNextLine(textPositionInfo3)) == null) break;
            if (textPositionInfo3._endOfLine && !textPositionInfo3._endOfParagraph) {
                textPositionInfo3.representCharacterAfterEndOfLine();
            }
            if (textPositionInfo3._y <= n2) break;
            n2 = textPositionInfo3._y;
            if (rect != null) {
                if (textPositionInfo3._y < rect.y) continue;
                if (textPositionInfo3._y > rect.y + rect.height) {
                    bl = true;
                    break;
                }
            }
            textParagraphFormat = this._formatForTextPositionInfo(textPositionInfo3);
            if (textPositionInfo3._textRun.paragraph() != textPositionInfo2._textRun.paragraph() || textPositionInfo3._lineNumber < textPositionInfo2._lineNumber) {
                rect2.x = textPositionInfo3._x;
                rect2.y = textPositionInfo3._y;
                textParagraph = textPositionInfo3._textRun.paragraph();
                n = textParagraph._lineRemainders[textPositionInfo3._lineNumber];
                switch (textParagraphFormat._justification) {
                    case 1: {
                        rect2.width = this.bounds.width - textParagraphFormat._rightMargin - rect2.x - n / 2;
                        break;
                    }
                    case 2: {
                        rect2.width = this.bounds.width - textParagraphFormat._rightMargin - rect2.x;
                        break;
                    }
                    default: {
                        rect2.width = this.bounds.width - textParagraphFormat._rightMargin - rect2.x - n;
                    }
                }
                rect2.height = textPositionInfo3._lineHeight;
            } else {
                rect2.x = textPositionInfo3._x;
                rect2.y = textPositionInfo3._y;
                rect2.width = textPositionInfo2._x - rect2.x;
                rect2.height = textPositionInfo3._lineHeight;
                bl = true;
            }
            if (rect2.height <= 0) continue;
            Rect rect3 = (Rect)vector.lastElement();
            if (rect3 != null && rect3.x == rect2.x && rect3.width == rect2.width) {
                rect3.height = rect2.y + rect2.height - rect3.y;
                continue;
            }
            vector.addElement((Object)new Rect(rect2));
        }
        TextView.recycleRange(range2);
        return vector;
    }

    Vector rangesOfVisibleAttachmentsWithBitmap(Bitmap bitmap) {
        Vector vector = new Vector();
        Rect rect = new Rect();
        this.computeVisibleRect(rect);
        TextPositionInfo textPositionInfo = this.positionForPoint(rect.x, rect.y, true);
        int n = textPositionInfo == null ? 0 : (textPositionInfo._absPosition > 0 ? textPositionInfo._absPosition - 1 : 0);
        textPositionInfo = this.positionForPoint(rect.x + rect.width, rect.y + rect.height, true);
        int n2 = textPositionInfo == null ? this.length() - 1 : (textPositionInfo._absPosition < this.length() - 1 ? textPositionInfo._absPosition + 1 : this.length() - 1);
        TextStyleRun textStyleRun = this._runForIndex(n);
        while (textStyleRun != null) {
            TextAttachment textAttachment;
            Hashtable hashtable = textStyleRun.attributes();
            if (hashtable != null && (textAttachment = (TextAttachment)hashtable.get((Object)TEXT_ATTACHMENT_KEY)) != null && textAttachment instanceof ImageAttachment && ((ImageAttachment)textAttachment).image() == bitmap) {
                vector.addElement((Object)textStyleRun.range());
            }
            if ((textStyleRun = this.runAfter(textStyleRun)).rangeIndex() > n2) break;
        }
        return vector;
    }

    void refreshBitmap(Object object) {
        Bitmap bitmap = (Bitmap)object;
        Vector vector = this.rangesOfVisibleAttachmentsWithBitmap(bitmap);
        int n = 0;
        int n2 = vector.count();
        while (n < n2) {
            Range range = (Range)vector.elementAt(n);
            if (!range.isNullRange()) {
                Vector vector2 = this.rectsForRange(range);
                Rect rect = bitmap.updateRect();
                if (vector2.count() > 0) {
                    Rect rect2 = (Rect)vector2.elementAt(0);
                    int n3 = 1;
                    int n4 = vector2.count();
                    while (n3 < n4) {
                        rect2.unionWith((Rect)vector2.elementAt(n3));
                        ++n3;
                    }
                    rect2.x = 0;
                    rect2.width = this.bounds.width;
                    rect2.y += rect.y;
                    rect2.height = rect.height;
                    this.addDirtyRect(rect2);
                }
            }
            ++n;
        }
    }

    boolean attributesChangingFormatting(Hashtable hashtable) {
        if (hashtable != null) {
            Vector vector = hashtable.keysVector();
            int n = 0;
            int n2 = vector.count();
            while (n < n2) {
                if (attributesChangingFormatting.indexOf(vector.elementAt(n)) != -1) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    void clearTypingAttributes() {
        if (this._typingAttributes != null) {
            this._typingAttributes.clear();
        }
    }

    void addAttributesForRangeWithoutNotification(Hashtable hashtable, Range range) {
        Range range2;
        TextStyleRun textStyleRun;
        TextParagraph textParagraph;
        int n;
        int n2;
        Range range3;
        TextParagraphFormat textParagraphFormat;
        Range range4 = this.selectedRange();
        Range range5 = TextView.allocateRange();
        Vector vector = new Vector();
        if (hashtable == null) {
            TextView.recycleRange(range5);
            return;
        }
        TextAttachment textAttachment = (TextAttachment)hashtable.get((Object)TEXT_ATTACHMENT_KEY);
        if (textAttachment != null) {
            textAttachment.setOwner(this);
        }
        if ((textParagraphFormat = (TextParagraphFormat)hashtable.get((Object)PARAGRAPH_FORMAT_KEY)) != null) {
            range3 = this.paragraphsRangeForRange(range);
            n2 = range3.index;
            n = range3.index + range3.length;
            while (n2 < n) {
                textParagraph = (TextParagraph)this._paragraphVector.elementAt(n2);
                textParagraph.setFormat(textParagraphFormat);
                vector.addElementIfAbsent((Object)textParagraph);
                range5.unionWith(textParagraph.range());
                ++n2;
            }
            if (hashtable.count() == 1) {
                n2 = 0;
                n = vector.count();
                while (n2 < n) {
                    this.formatParagraph((TextParagraph)vector.elementAt(n2));
                    ++n2;
                }
                this.dirtyRange(range5);
                if (this.formattingEnabled()) {
                    this._selection.setRange(range4.index, range4.index + range4.length);
                }
                TextView.recycleRange(range5);
                TextView.recycleRange(range3);
                return;
            }
            TextView.recycleRange(range3);
        }
        if ((textStyleRun = this._runForIndex(range.index)) != null) {
            range2 = textStyleRun.range();
            if (range.equals(range2)) {
                textStyleRun.appendAttributes(hashtable);
                range5.unionWith(textStyleRun.range());
                if (this.attributesChangingFormatting(hashtable)) {
                    vector.addElementIfAbsent((Object)this._paragraphForIndex(range.index));
                }
                n2 = 0;
                n = vector.count();
                while (n2 < n) {
                    textParagraph = (TextParagraph)vector.elementAt(n2);
                    this.formatParagraph(textParagraph);
                    range5.unionWith(textParagraph.range());
                    ++n2;
                }
                this.dirtyRange(range5);
                if (this.formattingEnabled()) {
                    this._selection.setRange(range4.index, range4.index + range4.length);
                }
                TextView.recycleRange(range5);
                TextView.recycleRange(range2);
                return;
            }
            if (range.index >= range2.index && range.index + range.length <= range2.index + range2.length && this.equalsAttributesHint(hashtable, textStyleRun.attributes())) {
                TextView.recycleRange(range5);
                TextView.recycleRange(range2);
                return;
            }
        }
        Vector vector2 = this.createAndReturnRunsForRange(range);
        n2 = 0;
        n = vector2.count();
        while (n2 < n) {
            textStyleRun = (TextStyleRun)vector2.elementAt(n2);
            textStyleRun.appendAttributes(hashtable);
            range2 = textStyleRun.range();
            range5.unionWith(range2);
            TextView.recycleRange(range2);
            ++n2;
        }
        if (this.attributesChangingFormatting(hashtable)) {
            range3 = this.paragraphsRangeForRange(range);
            n2 = range3.index;
            n = range3.index + range3.length;
            while (n2 < n) {
                vector.addElementIfAbsent(this._paragraphVector.elementAt(n2));
                ++n2;
            }
            TextView.recycleRange(range3);
        }
        n2 = 0;
        n = vector.count();
        while (n2 < n) {
            textParagraph = (TextParagraph)vector.elementAt(n2);
            this.formatParagraph(textParagraph);
            Range range6 = textParagraph.range();
            range5.unionWith(range6);
            TextView.recycleRange(range6);
            ++n2;
        }
        this.dirtyRange(range5);
        if (this.formattingEnabled()) {
            this._selection.setRange(range4.index, range4.index + range4.length);
        }
        TextView.recycleRange(range5);
    }

    void validateHTMLParsingRules() {
        if (this._htmlParsingRules == null) {
            String[] stringArray = new String[]{"BODY", "H1", "H2", "H3", "H4", "H5", "H6", "B", "STRONG", "CENTER", "EM", "I", "PRE", "A", "OL", "UL", "LI", "ADDRESS", "BLOCKQUOTE", "DIR", "MENU", "TT", "SAMP", "CODE", "KBD", "VAR", "CITE", "DL", "DT", "DD", "TITLE", "P"};
            String[] stringArray2 = new String[]{"BR", "HR", "IMG"};
            this._htmlParsingRules = new HTMLParsingRules();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                this._htmlParsingRules.setClassNameForMarker("netscape.application.TextViewHTMLContainerImp", stringArray[n]);
                ++n;
            }
            n = 0;
            n2 = stringArray2.length;
            while (n < n2) {
                this._htmlParsingRules.setClassNameForMarker("netscape.application.TextViewHTMLMarkerImp", stringArray2[n]);
                ++n;
            }
            this._htmlParsingRules.setStringClassName("netscape.application.TextViewHTMLString");
        }
    }

    void disableAttachmentNotification() {
        ++this.notifyAttachmentDisabled;
    }

    void enableAttachmentNotification() {
        --this.notifyAttachmentDisabled;
        if (this.notifyAttachmentDisabled < 0) {
            this.notifyAttachmentDisabled = 0;
        }
        if (this.notifyAttachmentDisabled == 0 && this.invalidAttachmentRange != null) {
            this.notifyAttachmentsForRange(this.invalidAttachmentRange, true);
            this.invalidAttachmentRange = null;
        }
    }

    void _notifyAttachmentsForRange(Range range, boolean bl) {
        int n = this._paragraphIndexForIndex(range.index);
        int n2 = range.index;
        int n3 = range.index + range.length;
        if (n == -1) {
            return;
        }
        TextParagraph textParagraph = (TextParagraph)this._paragraphVector.elementAt(n);
        int n4 = textParagraph.runIndexForCharPosition(n2);
        if (n4 == -1) {
            return;
        }
        TextStyleRun textStyleRun = (TextStyleRun)textParagraph._runVector.elementAt(n4);
        n2 = textStyleRun.rangeIndex();
        while (n2 < n3) {
            TextAttachment textAttachment;
            Hashtable hashtable = textStyleRun.attributes();
            if (hashtable != null && (textAttachment = (TextAttachment)hashtable.get((Object)TEXT_ATTACHMENT_KEY)) != null) {
                if (bl) {
                    TextPositionInfo textPositionInfo = textStyleRun._paragraph._infoForPosition(textStyleRun.rangeIndex());
                    if (textPositionInfo != null) {
                        textPositionInfo.representCharacterAfterEndOfLine();
                        Rect rect = textStyleRun.textAttachmentBoundsForOrigin(textPositionInfo._x, textPositionInfo._y, textStyleRun._paragraph._baselines[textPositionInfo._lineNumber]);
                        textAttachment._willShowWithBounds(rect);
                    }
                } else {
                    textAttachment._willHide();
                }
            }
            n2 += textStyleRun.charCount();
            if (++n4 < textParagraph._runVector.count()) {
                textStyleRun = (TextStyleRun)textParagraph._runVector.elementAt(n4);
                continue;
            }
            ++n2;
            if (++n >= this._paragraphVector.count()) break;
            textParagraph = (TextParagraph)this._paragraphVector.elementAt(n);
            n4 = 0;
            if (textParagraph._runVector.count() <= 0) break;
            textStyleRun = (TextStyleRun)textParagraph._runVector.elementAt(n4);
        }
    }

    void notifyAttachmentsForRange(Range range, boolean bl) {
        if (!bl) {
            this._notifyAttachmentsForRange(range, false);
            return;
        }
        if (this.notifyAttachmentDisabled > 0) {
            if (this.invalidAttachmentRange != null) {
                this.invalidAttachmentRange.unionWith(range);
                return;
            }
            this.invalidAttachmentRange = new Range(range);
            return;
        }
        this._notifyAttachmentsForRange(range, true);
    }

    boolean isLeftHalfOfCharacter(int n, int n2) {
        TextPositionInfo textPositionInfo = this.positionForPoint(n, n2, false);
        TextPositionInfo textPositionInfo2 = this.positionForPoint(n, n2, true);
        if (textPositionInfo == null || textPositionInfo2 == null) {
            return true;
        }
        return textPositionInfo._absPosition == textPositionInfo2._absPosition;
    }

    static Range allocateRange() {
        return TextView.allocateRange(Range.nullRange().index, Range.nullRange().length);
    }

    static Range allocateRange(Range range) {
        return TextView.allocateRange(range.index, range.length);
    }

    static Range allocateRange(int n, int n2) {
        Range range = (Range)rangePool.allocateObject();
        range.index = n;
        range.length = n2;
        return range;
    }

    static void recycleRange(Range range) {
        rangePool.recycleObject(range);
    }

    public void copy() {
        Application.setClipboardText((String)this.stringForRange(this.selectedRange()));
    }

    public void cut() {
        if (this.isEditable()) {
            Range range = this.selectedRange();
            Application.setClipboardText((String)this.stringForRange(range));
            this.replaceRangeWithString(range, "");
            this.selectRange(new Range(range.index(), 0));
        }
    }

    public void paste() {
        if (this.isEditable()) {
            Range range = this.selectedRange();
            String string = Application.clipboardText();
            if (range == null || range.index == -1 || string == null) {
                return;
            }
            this._selection.disableInsertionPoint();
            this.replaceRangeWithString(range, string);
            range = new Range(range.index() + string.length(), 0);
            this.selectRange(range);
            this.scrollRangeToVisible(range);
            this._selection.enableInsertionPoint();
        }
    }

    public String formElementText() {
        return this.string();
    }

    static {
        attributesChangingFormatting.addElement((Object)TEXT_ATTACHMENT_KEY);
        attributesChangingFormatting.addElement((Object)TEXT_ATTACHMENT_BASELINE_OFFSET_KEY);
        attributesChangingFormatting.addElement((Object)FONT_KEY);
        attributesChangingFormatting.addElement((Object)PARAGRAPH_FORMAT_KEY);
        _rectCache = new Vector();
        _vectorCache = new Vector();
        hashtablePool = new ObjectPool("netscape.util.Hashtable", 32);
        rangePool = new ObjectPool("netscape.application.Range", 32);
    }
}

