/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import java.text.MessageFormat;
import netscape.security.AppletSecurity;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.softupdate.InstallObject;
import netscape.softupdate.SoftUpdateException;
import netscape.softupdate.SoftwareUpdate;
import netscape.softupdate.Strings;
import netscape.softupdate.VersionRegistry;

class UninstallObject
extends InstallObject {
    private String regName;
    private String userName;

    UninstallObject(SoftwareUpdate softwareUpdate, String string) throws SoftUpdateException {
        super(softwareUpdate);
        this.regName = string;
        if (this.regName == null || this.regName.length() == 0) {
            throw new SoftUpdateException("", -208);
        }
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        privilegeManager.enablePrivilege(target);
        Target target2 = Target.findTarget("SoftwareInstall");
        privilegeManager.enablePrivilege(target2, this.softUpdate.GetPrincipal());
        this.userName = VersionRegistry.getUninstallUserName(this.regName);
        if (this.userName == null) {
            throw new SoftUpdateException("", -213);
        }
    }

    protected void Complete() throws SoftUpdateException {
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        privilegeManager.enablePrivilege(target);
        Target target2 = Target.findTarget("SoftwareInstall");
        privilegeManager.enablePrivilege(target2, this.softUpdate.GetPrincipal());
        int n = this.NativeComplete(this.regName);
        privilegeManager.revertPrivilege(target2);
        if (n != 0) {
            n = -223;
            throw new SoftUpdateException(String.valueOf(Strings.error_Unexpected()) + this.regName, n);
        }
    }

    protected void Prepare() throws SoftUpdateException {
    }

    protected void Abort() {
    }

    private native int NativeComplete(String var1) throws SoftUpdateException;

    public String toString() {
        Object[] objectArray = new Object[]{this.userName};
        return MessageFormat.format(Strings.details_Uninstall(), objectArray);
    }

    protected boolean CanUninstall() {
        return false;
    }

    protected boolean RegisterPackageNode() {
        return false;
    }
}

