_traceback = 1;
% mkdoc.sl ---- load this file from JED_ROOT/lib!!!!
%
%  Extract documentation from .sl and .c files
%  For this to work, a strict format must be followed.
%  In .c files, add_intrinsic and add_variable statements are checked. The
%  syntax prototype is:
%
%        MAKE_INTRINSIC("name", function, TYPE, n)%
%        /* This is a function called name which returns TYPE
%           and takes n arguments. */
%
%  Note that it is assummed that comments cannot be nested.
%  For .sl files, the syntax follows:
%
%     %!% This function pops an integer n off the stack and an object s.
%     %!% It returns n copies of s on the stack.
%     define dupn (n, s)
%     {
%        loop (n) { s; } 
%     }
%
%  Here I search for '%!%' in column 1 which make indicate a doc string and 
%  then search for 'define' preceed by only whitespace.  The '%!%' must start in 
%  column 1.
%
%  There is no ambiguity as long as the doc strings are placed BEFORE the 
%  object they describe.


%!% Extracts doc string from FILE and appends it to BUFFER.
%!% Returns number of items processed
define mkdoc_process_sl_file (file, doc_buf)
{
   variable cbuf, doc_ind = "%!%", chars = "a-zA-Z0-9_$!";
   variable c, ctrla = 1, name;
   variable has_proto;
   variable num;
   
   !if (read_file(file)) return -1;
   cbuf = whatbuf ();

   bob ();

   setbuf (doc_buf);
   eob ();
   !if (bolp()) newline ();
   insert_char (ctrla); insert (file); newline ();
   push_spot ();
   setbuf (cbuf);
   
   num = 0;
   while (bol_fsearch (doc_ind))
     {
	setbuf (doc_buf);
	eob ();
	!if (bolp()) newline ();
	push_spot ();
	setbuf (cbuf);

	go_right (3); push_mark ();
	skip_white (); 
	has_proto = looking_at ("Prototype: ");
	while (down_1 () and looking_at (doc_ind));
	
	copy_region (doc_buf);
	
	% now look for what this documents
	forever 
	  {
	     bol (); skip_chars (" \t\n"); c = what_char ();
	     if (looking_at ("variable"))
	       {
		  go_right (strlen("variable"));
		  skip_white (); push_mark ();
		  skip_chars (chars);
		  name = Sprintf ("V%s ", bufsubstr(), 1);
		  break;
	       }
	     
	     if (looking_at ("define"))
	       {
		  go_right (strlen ("define"));
		  skip_white ();
		  push_mark ();
		  skip_chars (chars);
		  !if (has_proto) if (ffind_char (')')) go_right_1 ();
		  name = strcat ("F", bufsubstr ());
		  break;
	       }
	     

	     !if (down_1 ()) error (strcat ("Error parsing ", file));
	  }
	
	%% now we have the name with the appropriate prefix.  Insert it and
	%% replace newlines with ctrla
	setbuf (doc_buf);
	pop_spot (); insert (name);
	insert_char (ctrla);
	while (eol, not(eobp()))
	  {
	     del (); insert_char (ctrla);
	     if (looking_at (doc_ind)) deln (3);
	  }
	
	newline ();
	setbuf (cbuf);
	num++;
     }
   
   return num;
}

. %% same routine for C files.  Looks for MAKE_INTRINSIC and MAKE_VARIABLE
. %% macros.
. (
.   [file doc_buf cbuf] =doc_buf =file
.   [f v name ctrla c] 1 char =ctrla
.   [num]
.   
.   file read_file {-1 return} !if
.   whatbuf =cbuf
.   
.     doc_buf setbuf 
.     eob
.     bolp {newline} !if
.     ctrla insert file insert newline   
.     cbuf setbuf

.   bob
.   0 =num
.   { 
.     0 =f 0 =v
.     "MAKE_" fsearch
.       {
.         "MAKE_INTRINSIC" looking_at =f
. 	"MAKE_VARIABLE" looking_at =v
.       }{break} else
.      
.     POINT bol_skip_white
.     POINT - {eol continue} if %%continue if in middle of line
.     %% found
.     
.     doc_buf setbuf 
.     eob
.     bolp {newline} !if
.     cbuf setbuf 
. 
.     %% formats are MAKE_INTRINSIC(".fun", cfun, TYPE, n)
.     %% and         MAKE_VARIABLE(".var", &c_var, TYPE, flag)
.     %%   where the & may not be present for string variables
.     
.     "\"." ffind {"Corrupt file." error} !if
.     2 right pop push_mark 
.     "\"" ffind {"Corrupt file." error} !if
.     bufsubstr " " strcat =name
.     1 right pop
.     
.     %% if it is a function, get the c function info as well
.     f { 
.         "F" name strcat ":" strcat =name      %%Ffun:
.         ",\t " skip_chars
.         push_mark "$_A-Za-z0-9" skip_chars 
. 	name bufsubstr strcat ":" strcat      %%Ffun:cfun:
. 	",\t " skip_chars 
. 	what_char char strcat ":" strcat      %%Ffun:cfun:T:
. 	"," ffind pop  %% assume ok
. 	", \t" skip_chars push_mark "0-9" skip_chars
. 	bufsubstr strcat =name  %%Whew!!      %%Ffun:cfun:T:0
.       }{
. 	"V" name strcat =name
.       }
.     else
.     
.     doc_buf setbuf name insert push_spot
.     cbuf setbuf
.     
.     %% look for documentation
.     {down_1}
.     {
.         bol_skip_white eolp {continue} if
. 	"/*" looking_at {break} !if
. 	2 go_right skip_white
.       what_column =c   
. 	push_mark
. 	"*/" fsearch pop  %% I assume it compiled 
. 	
. 	doc_buf copy_region
. 	doc_buf setbuf
. 	pop_spot 
.       push_spot

.        {down_1}
.        { 
.           bol_skip_white 
.           "*" looking_at {del skip_white} if
.           what_column bol trim c - {" " insert} loop 
.        }
.        while
   
. 	pop_spot 
. 	ctrla insert
	
. 	{eol eobp not}
.        {del ctrla insert} while
. 	newline
. 	cbuf setbuf
. 	break
.     } while
.     num 1 + =num
.   } forever 
.   num
. ) mkdoc_process_c_file
. 
.


define mkdoc_sort (docbuf)
{
   variable cbuf = whatbuf ();
   setbuf (docbuf);
   goto_column (32);
   push_mark ();
   push_mark ();
   !if (bol_bsearch_char (1))
     {
	pop_mark (0);
	pop_mark (0);
	error ("Error finding sort boundary.");
	return;
     }
   go_down_1 ();
   narrow ();
   sort ();
   trim_buffer ();
   eob ();
   widen ();
   setbuf (cbuf);
}

%%% Make documentation for set of files.  Function takes as top argument
%%% the name of docfile to be produced followed by number n of files
%%% then followed by the n filenames.
define mkdoc (argc, docfile)
{
   variable argv, cbuf = whatbuf ();
   variable type, docbuf, num;
   
   setbuf (docfile); erase_buffer ();
   docbuf = whatbuf ();
   setbuf (cbuf);
   
   loop (argc)
     { 
	argv = ();
	type = strlow (file_type (argv));
	flush (strcat ("processing ", argv));
	
	switch (type)
	  {
	   case "c":
	     num = mkdoc_process_c_file (argv, docbuf);
	  }
	  {
	   case "sl":
	     num = mkdoc_process_sl_file (argv, docbuf);
	  }
	  {
	     pop ();
	     verror ("File type %s not supported!", type, 1);
	  }
	
	if (num == -1)
	  error (strcat (argv, " could not be processed!"));

	if (strcmp (whatbuf(), docbuf)) delbuf (whatbuf ());
	if (num > 1)
	  mkdoc_sort (docbuf);
     }
   
   setbuf (docbuf);
   !if (write_buffer (docfile))
     error ("Unable to write doc file!");
   set_buffer_modified_flag (0);
   delbuf (docbuf);
   setbuf (cbuf);
}


!if (is_defined ("__load__mkdoc__only__"))
{

. _stkdepth =$1
. "site.sl" "buf.sl" "help.sl" "util.sl" "dired.sl" "most.sl" "fortran.sl" 
. "misc.sl" "tex.sl" "cmode.sl" "slmode.sl" "cmisc.sl" "untab.sl" "html.sl"
. "../src/intrin.c" "../src/xterm.c" "../src/replace.c"
% . "../src/mswin.c"
. "../../slang/src/slstd.c"  
. "../../slang/src/slmath.c"
. "../../slang/src/slunix.c"
. _stkdepth $1 -
.  % number of files listed above   

. "jed_funs.hlp" mkdoc
quit_jed ();
}


