% This file defines syntax highlighting for perl.
% The original author is Lars Marowsky-Bree <lmb@pointer.in-minden.de>

% Create and initialize the syntax tables.
$1 = "PERL";

create_syntax_table ($1);
define_syntax ("#", "#", '%', $1);
define_syntax ("([{<", ")]}>", '(', $1);
define_syntax ('"', '"', $1);
define_syntax ('\'', '\'', $1);
define_syntax ('\\', '\\', $1);
define_syntax ("$0-9a-zA-Z_", 'w', $1);        % words
define_syntax ("-+0-9a-fA-F.xXL", '0', $1);   % Numbers
define_syntax (",;.?:", ',', $1);
define_syntax ("%-+/&*=<>|!~^", '+', $1);
set_syntax_flags ($1, 4);

() = define_keywords ($1, "endhostentendserventgethostentgetserventgetsockoptsethostentsetserventsetsockoptsocketpair", 10);
() = define_keywords ($1, "endprotoentgetpeernamegetprioritygetprotoentgetsocknamesetprioritysetprotoent", 11);
() = define_keywords ($1, "getnetbyaddrgetnetbyname", 12);
() = define_keywords ($1, "gethostbyaddrgethostbynamegetservbynamegetservbyport", 13);
() = define_keywords ($1, "getprotobyname", 14);
() = define_keywords ($1, "getprotobynumber", 16);
() = define_keywords ($1, "-Xdoiflcm/mynoq/s/ucy/", 2);
() = define_keywords ($1, "abschrcosdieeofexphexintlogmapoctordpopposqq/qw/qx/refsintietr/usevec", 3);
() = define_keywords ($1, "bindchopdumpeachevalexecexitforkgetcglobgotogrepjoinkeyskilllastlinknextopenpackpipepushrandreadrecvredoseeksendsortsqrtstattelltimewaitwarn", 4);
() = define_keywords ($1, "alarmatan2blesschdirchmodchompchownclosecryptelsiffcntlflockindexioctllocallstatmkdirprintresetrmdirsemopshiftsleepsplitsrandstudytimesumaskundefuntieuntilutimewhilewrite", 5);
() = define_keywords ($1, "acceptcallerchrootdeleteexistsfilenogmtimeimportlengthlistenmsgctlmsggetmsgrcvmsgsndprintfrenamereturnrindexscalarselectsemctlsemgetshmctlshmgetsocketsplicesubstrsystemunlinkunpackvalues", 6);
() = define_keywords ($1, "binmodeconnectdbmopendefinedgetpgrpgetppidlcfirstopendirreaddirrequirereverseseekdirsetpgrpshmreadsprintfsymlinksyscallsysreadtelldirucfirstunshiftwaitpid", 7);
() = define_keywords ($1, "closedirdbmcloseendgrentendpwentformlinegetgrentgetgrgidgetgrnamgetlogingetpwentgetpwnamgetpwuidreadlinksetgrentsetpwentshmwriteshutdownsyswritetruncate", 8);
() = define_keywords ($1, "endnetentgetnetentlocaltimequotemetarewinddirsetnetentwantarray", 9);

define perl_mode ()
{
   variable kmap = "PERL";
   use_syntax_table (kmap);
   runhooks("perl_mode_hook");
}
