/*
 *  linux/ibcs/map.h
 *
 *  Copyright (C) 1994  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 * $Id: map.h,v 1.5 1998/06/24 20:34:21 jaggy Exp $
 * $Source: /u/CVS/ibcs/include/ibcs/map.h,v $
 */

struct map_segment {
	int start, end;
	unsigned char *map;
};


extern struct map_segment *af_map[];
extern struct map_segment *type_map[];
extern struct map_segment *sopt_map[];

extern long map_bitvec(unsigned long vec, long map[]);
extern unsigned long map_sigvec_from_kernel(sigset_t vec, unsigned long map[]);
extern sigset_t map_sigvec_to_kernel(unsigned long vec, unsigned long map[]);
extern int map_value(struct map_segment *m[], int val, int def);
