/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#include "global.h"

/*
 * Globals
 */


/*********************************************************
 * name:	makeIconBar
 * description:	erzeugt eine Liste mit Iconbuttons, die
 *		entweder angeklick oder
 *		auf die Programme mittels Graboperation
 *		gezogen werden koennen
 * input:	Widget	parent	- Zeiger auf die Menuleiste
 * output:	none
 * author:	Ove Kalkan
 * date:	24.6.93
 *********************************************************/
void	makeIconBar(Folder_Glyph *fo, Widget parent, Widget left, Boolean HIDE, 
		    Boolean buttons)
{
	Widget	b;

	b = left;
	if (HIDE) {
		b = XtVaCreateManagedWidget("hide_but", iconBWidgetClass, parent,
						XtNleft, XawChainLeft,
						XtNright, XawChainLeft,
						XtNbottom, XawChainTop,
						XtNtop, XawChainTop,
						XtNfromHoriz, left,
						XtNimageWidth, 32,
						XtNimageHeight, 32,
						XtNimage, Icon_Hide_PM,
						NULL);
		XtAddCallback(b,XtNcallback,(XtCallbackProc) hideFolder,(XtPointer) fo);
	}

	if (buttons) {
		b = XtVaCreateManagedWidget("move_but", iconBWidgetClass, parent,
						XtNleft, XawChainLeft,
						XtNright, XawChainLeft,
						XtNbottom, XawChainTop,
						XtNtop, XawChainTop,
						XtNfromHoriz, b,
						XtNhorizDistance, 20,
						XtNimageWidth, 32,
						XtNimageHeight, 32,
						XtNimage, Icon_Move_PM,
						NULL);
		XtAddCallback(b,XtNcallback,(XtCallbackProc) start_move, NULL);

		b = XtVaCreateManagedWidget("copy_but", iconBWidgetClass, parent,
						XtNleft, XawChainLeft,
						XtNright, XawChainLeft,
						XtNbottom, XawChainTop,
						XtNtop, XawChainTop,
						XtNfromHoriz, b,
						XtNimageWidth, 32,
						XtNimageHeight, 32,
						XtNimage, Icon_Copy_PM,
						NULL);
		XtAddCallback(b,XtNcallback,(XtCallbackProc) start_copy, NULL);

		b = XtVaCreateManagedWidget("del_but", iconBWidgetClass, parent,
						XtNleft, XawChainLeft,
						XtNright, XawChainLeft,
						XtNbottom, XawChainTop,
						XtNtop, XawChainTop,
						XtNfromHoriz, b,
						XtNimageWidth, 32,
						XtNimageHeight, 32,
						XtNimage, Icon_Delete_PM,
						NULL);
		XtAddCallback(b,XtNcallback,(XtCallbackProc) start_delete, NULL);

		b = XtVaCreateManagedWidget("dir_but", iconBWidgetClass, parent,
						XtNleft, XawChainLeft,
						XtNright, XawChainLeft,
						XtNbottom, XawChainTop,
						XtNtop, XawChainTop,
						XtNfromHoriz, b,
						XtNimageWidth, 32,
						XtNimageHeight, 32,
						XtNimage, Icon_Newdir_PM,
						NULL);
		XtAddCallback(b,XtNcallback,(XtCallbackProc) start_newdir, NULL);

		b = XtVaCreateManagedWidget("dir_but", iconBWidgetClass, parent,
						XtNleft, XawChainLeft,
						XtNright, XawChainLeft,
						XtNbottom, XawChainTop,
						XtNtop, XawChainTop,
						XtNfromHoriz, b,
						XtNimageWidth, 32,
						XtNimageHeight, 32,
						XtNimage, Icon_Info_PM,
						XtNhorizDistance, 20,
						NULL);
		XtAddCallback(b,XtNcallback,(XtCallbackProc) start_info, NULL);


		if (HIDE || !defaults.multi_window) {
			b = XtVaCreateManagedWidget("dir_but", iconBWidgetClass, parent,
							XtNleft, XawChainLeft,
							XtNright, XawChainLeft,
							XtNbottom, XawChainTop,
							XtNtop, XawChainTop,
							XtNfromHoriz, b,
							XtNimageWidth, 32,
							XtNimageHeight, 32,
							XtNimage, Icon_Filter_PM,
							NULL);
			XtAddCallback(b,XtNcallback,(XtCallbackProc) start_filter,
					(XtPointer) fo);
		}
	}
	else {	/* Fuer Tar */
		b = XtVaCreateManagedWidget("extract_but", iconBWidgetClass, parent,
						XtNleft, XawChainLeft,
						XtNright, XawChainLeft,
						XtNbottom, XawChainTop,
						XtNtop, XawChainTop,
						XtNfromHoriz, b,
						XtNimageWidth, 32,
						XtNimageHeight, 32,
						XtNimage, Icon_Unpack_PM,
						XtNhorizDistance, 20,
						NULL);
		XtAddCallback(b,XtNcallback,(XtCallbackProc) start_extract, NULL);
	}
}




