/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#ifndef COHERENT
#include "global.h"

/*
 * Global variables
 */


/*********************************************************
 * name:	init_link
 * description:	erzeugt ein Fenster mit 2 texten zum Linken
 * input:	char *from, char *to;
 * output:	none
 * date:	10.5.93
 *********************************************************/
void	init_link (char *from, char *to)
{
	Widget	but;

	/*
	 * Das Dialogfenster erzeugen
	 */
	NO_MULTI = TRUE;
	but = makeDialog(2,"Linkname :","Linktarget :",from,to,"Symbolic Link Creator",TRUE,FALSE,Icon_Link_PM);
	XtAddCallback(but,XtNcallback,(XtCallbackProc) exec_link_cb,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);

	/*
	 * Max und Minsize setzen
	 */
	setSize();
}


/*********************************************************
 * name:	exec_copy_cb
 * description:	Link-Funktion ausfuehren
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
void	exec_link_cb (void)
{
	char	*from, *to;
	Arg	args[1];

	/*
	 * Die Texte der beiden Textfelder holen
	 */
	XtSetArg(args[0],XtNstring,&from);
	XtGetValues(text_1,args,1);

	XtSetArg(args[0],XtNstring,&to);
	XtGetValues(text_2,args,1);

	/*
	 * Ueberpruefen ob in beiden ein Text steht, sonst
	 * Warnung ausgeben
	 */
	if (!strlen(from) || !strlen(to)) {
		WARNING ("Insuffisant Arguments.\nOperation aborted.");
		return;
	}
	exec_link(from,to);
}


/*********************************************************
 * name:	exec_link
 * description:	einen symbolischen Link erzeugen
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
void	exec_link (char *from, char *to)
{
	char	buf[1024];

	/*
	 * Befehl generieren und ausfuehren
	 */
	sprintf(buf,"%s %s %s",LINK_CMD,to,from);
	system(buf);
	{
		/*
		 * Dialogfenster loeschen
		 */
		if (dialog)
			XtDestroyWidget(dialog);
		dialog = NULL;

		/*
		 * Hier muss ein Update der veranderten Felder kommen
		 * Bisher unvollstaendig
		 */
		/* Zielfolder und Dir refreshen, falls vorhanden */
		refreshFolderByPathname (from);
#ifdef	HAS_QUOTA
		showQuota(quota_label);
#endif
	}
}


#endif
