'\" t
.\" ** The above line should force tbl to be used as a preprocessor **
.\"
.\" Man page for fetchmail
.\"
.\" For license terms, see the file COPYING in this directory.
.TH fetchmail 1
.SH NAME
fetchmail \- fetch mail from a POP, IMAP, or ETRN-capable server

.SH SYNOPSIS
\fBfetchmail\fR [\fIoptions\fR] [\fImailserver...\fR]

.SH DESCRIPTION
.I fetchmail
is a mail-retrieval and forwarding utility; it fetches
mail from remote mailservers and forwards it to your local (client)
machine's delivery system.  You can then handle the retrieved mail
using normal mail user agents such as \fIelm\fR(1) or \fIMail\fR(1).
The \fBfetchmail\fR utility can be run in a daemon mode to repeatedly
poll one or more systems at a specified interval.
.PP
The
.I fetchmail
program can gather mail from servers supporting any of the common
mail-retrieval protocols: POP2, POP3, IMAP2bis, and IMAP4.  It can
also use the ESMTP ETRN extension.  (The RFCs describing all these
protocols are listed at the end of this document.)
.PP
While
.I fetchmail
is primarily intended to be used over on-demand TCP/IP links (such as
SLIP or PPP connections), it may also be useful as a message transfer
agent for sites which refuse for security reasons to permit
(sender-initiated) SMTP transactions with sendmail.
.PP
As each message is retrieved \fIfetchmail\fR normally delivers it via SMTP to
port 25 on the machine it is running on (localhost), just as though it
were being passed in over a normal TCP/IP link.  The mail will then be
delivered locally via your system's MDA (Mail Delivery Agent, usually
\fIsendmail\fR(8) but your system may use a different one such
as \fIsmail\fR, \fImmdf\fR, or \fIqmail\fR).  All the delivery-control
mechanisms (such as \fI.forward\fR files) normally available through
your system MDA and local delivery agents will therefore work.
.PP
The behavior of
.I fetchmail
is controlled by command-line options and a run control file,
\fI~/.fetchmailrc\fR, the syntax of which we describe below.  Command-line
options override
.I ~/.fetchmailrc
declarations.
.PP
Each server name that you specify following the options on the
command line will be queried.  If you don't specify any servers
on the command line, each server in your 
.I ~/.fetchmailrc
file will be queried.
.PP
To facilitate the use of
.I fetchmail
In scripts, pipelines, etc., it returns an appropriate exit code upon 
termination -- see EXIT CODES below.

.SH OPTIONS
The following options modify the behavior of \fIfetchmail\fR.  It is
seldom necessary to specify any of these once you have a
working \fI.fetchmailrc\fR file set up.
.PP
Almost all options have a corresponding keyword which can be used to
declare them in a 
.I fetchmailrc
file.
.PP
Some special options are not covered here, but are documented insttead
in sections on AUTHENTICATION and DAEMON MODE which follows.
.SS General Options
.TP
.B \-V, --version
Displays the version information for your copy of 
.I fetchmail.
No mail fetch is performed.
Instead, for each server specified, all option information
that would be computed if
.I fetchmail.
were connecting to that server is displayed.  Any non-printables in
passwords or other string names are shown as backslashed C-like
escape sequences.  This option is useful for verifying that your
options are set the way you want them.
.TP
.B \-c, --check
Return a status code to indicate whether there is mail waiting,
without actually fetching or deleting mail (see EXIT CODES below).
This option turns off daemon mode (in which it would be useless).  It
doesn't play well with queries to multiple sites, and doesn't work
with ETRN.  It will return a false positive if you leave read but
undeleted mail in your server mailbox and your fetch protocol can't
tell kept messages from new ones.  This means it will work with IMAP,
not work with POP2, and may occasionally flake out under POP3.
.TP
.B \-s, --silent
Silent mode.  Suppresses all progress/status messages that are normally
echoed to standard error during a fetch.  The --verbose option
overrides this.
.TP
.B \-v, --verbose
Verbose mode.  All control messages passed between 
.I fetchmail
and the mailserver are echoed to stderr.  Overrides --silent.
.SS Disposal Options
.TP
.B \-a, --all
(Keyword: fetchall)
Retrieve both old (seen) and new messages from the mailserver.  The
default is to fetch only messages the server has not marked seen.
Note that POP2 retrieval behaves as though --all is always on (see
RETRIEVAL FAILURE MODES below) and this option does not work with ETRN.
.TP
.B \-k, --keep
(Keyword: keep)
Keep retrieved messages on the remote mailserver.  Normally, messages 
are deleted from the folder on the mailserver after they have been retrieved.
Specifying the 
.B keep 
option causes retrieved messages to remain in your folder on the
mailserver.  This option does not work with ETRN.
.TP
.B \-K, --nokeep
(Keyword: nokeep)
Delete retrieved messages from the remote mailserver.  This
option forces retrieved mail to be deleted.  It may be useful if
you have specified a default of \fBkeep\fR in your
\&\fI.fetchmailrc\fR.  This option is forced on with ETRN.
.TP
.B \-F, --flush
POP3/IMAP only.  Delete old (previously retrieved) messages from the mailserver
before retrieving new messages. This option does not work with ETRN.
Warning: if your local MTA hangs and fetchmail is aborted, the next
time you run fetchmail, it will delete mail that was never delivered to you.
What you probably want is the default setting: if you don't specify `-k', then
fetchmail will automatically delete messages after successful delivery.
.SS Protocol and Query Options
.TP
.B \-p, \--protocol proto
(Keyword: proto[col])
Specify the protocol to used when communicating with the remote 
mailserver.  If no protocol is specified,
.I fetchmail
will try each of the supported protocols in turn, terminating after
any successful attempt.
.I proto 
may be one of the following:
.RS
.IP POP2
Post Office Protocol 2
.IP POP3
Post Office Protocol 3
.IP APOP
Use POP3 with MD5 authentication.
.IP RPOP
Use POP3 with RPOP authentication.
.IP KPOP
Use POP3 with Kerberos V4 authentication on port 1109.
.IP IMAP
IMAP2bis, IMAP4, or IMAP4rev1 (\fIfetchmail\fR autodetects their capabilities).
.IP IMAP-K4
IMAP4, or IMAP4rev1 (\fIfetchmail\fR autodetects their capabilities)
with RFC 1731 Kerberos v4 authentication.
.IP IMAP-GSS
IMAP4, or IMAP4rev1 (\fIfetchmail\fR autodetects their capabilities)
with RFC 1731 GSSAPI authentication.
.IP ETRN
Use the ESMTP ETRN option.
.RE
All these alternatives work in basically the same way (communicating
with standard server daemons to fetch mail already delivered to a
mailbox on the server) except ETRN.  The ETRN mode allows you to ask a
compliant ESMTP server (such as BSD sendmail at release 8.8.0 or
higher) to immediately open a sender-SMTP connection to your
client machine and begin forwarding any items addressed to your client
machine in the server's queue of undelivered mail.
.TP
.B \-U, --uidl
(Keyword: uidl)
Force UIDL use (effective only with POP3).  Force client-side tracking
of `newness' of messages (UIDL stands for ``unique ID listing'' and is
described in RFC1725).  Use with `keep' to use a mailbox as a baby
news drop for a group of users.
.TP
.B \-P, --port
(Keyword: port)
The  option permits you to specify a TCP/IP port to connect on. 
This option will seldom be necessary as all the supported protocols have
well-established default port numbers.
.TP
.B \-r folder, --folder folder
(Keyword: folder[s])
Causes a specified non-default mail folder on the mailserver (or
comma-separated list of folders) to be retrieved.  The syntax of the
folder name is server-dependent.  This option is not available under
POP3 or ETRN.
.SS Delivery Control Options
.TP
.B \-S host, --smtphost host
(Keyword: smtp[host])
Specify a hunt list of hosts to forward mail to (one or more
hostnames, comma-separated).  In ETRN mode, set the host that the
mailserver is asked to ship mail to.  Hosts are tried in list order;
the first one that is up becomes the forwarding or ETRN target for the
current run.  Each hostname may have a '/'-delimited suffix specifying
a port or service to forward to; the default is 25 (or "smtp" under
IPv6). 
.TP
.B \-D domain, --smtpaddress domain
(Keyword: smtpaddress) 
Specify the domain to be put in RCPT TO lines shipped to SMTP. The
name of the SMTP server (as specified by --smtphost, or defaulted to
"localhost") is used when this is not specified.
.TP
.B \-Z nnn, --antispam nnn
(Keyword: antispam) 
Specifies the numeric SMTP error that is to be interpreted as a
spam-block response from the listener.  A value of -1 disables
this option.
.TP
.B \-m, \--mda
(Keyword: mda)
You can force mail to be passed to an MDA directly (rather than
forwarded to port 25) with the -mda or -m option.  If \fIfetchmail\fR
is running as root, it sets its userid to that of the target user
while delivering mail through an MDA.  Some possible MDAs are
"/usr/sbin/sendmail -oem", "/usr/lib/sendmail -oem",
"/usr/bin/formail", and "/usr/bin/deliver".  Local delivery addresses
will be inserted into the MDA command wherever you place a %T; the
mail message's From address will be inserted where you place an %F.  Do
\fInot\fR use an MDA invocation like
"sendmail -oem -t" that dispatches on the contents of To/Cc/Bcc, it
will create mail loops and bring the just wrath of many postmasters
down upon your head.
.SS Resource Limit Control Options
.TP
.B \-l, --limit
(Keyword: limit)
Takes a maximum octet size argument.  Messages larger than this size
will not be fetched, not be marked seen, and will be left on the
server (in foreground sessions, the progress messages will note that
they are "oversized").  An explicit --limit of 0 overrides any limits set
in your run control file. This option is intended for those needing to
strictly control fetch time in interactive mode.  It may not be used
with daemon mode, as users would never receive a notification that
messages were waiting.  This option does not work with ETRN.
.TP
.B -b, --batchlimit
(Keyword: batchlimit)
Specify the maximum number of messages that will be shipped to an SMTP
listener before the connection is deliberately torn down and rebuilt
(defaults to 0, meaning no limit).  An explicit --batchlimit of 0
overrides any limits set in your run control file.  While
\fBsendmail\fR(8) normally initiates delivery of a message immediately
after receiving the message terminator, some SMTP listeners are not so
prompt.  MTAs like \fIqmail\fR(8) and \fIsmail\fR(8) may wait till the
delivery socket is shut down to deliver.  This may produce annoying
delays when
.IR fetchmail (8)
is processing very large batches.  Setting the batch limit to some
nonzero size will prevent these delays.
This option does not work with ETRN.
.TP
.B -B, --fetchlimit
(Keyword: fetchlimit)
Limit the number of messages accepted from a given server in a single
poll.  By default there is no limit. An explicit --fetchlimit of 0
overrides any limits set in your run control file.
This option does not work with ETRN.
.TP
.B -e, --expunge
(keyword: expunge)
When talking to an IMAP server, 
.I fetchmail
normally issues an EXPUNGE command after each deletion in order to
force the deletion to be done immediately.  This is safest when your
connection to the server is flaky and expensive, as it avoids
resending duplicate mail after a line hit.  However, on large
mailboxes the overhead of re-indexing after every message can slam the
server pretty hard, so if your connection is reliable it is good to do
expunges less frequently.  If you specify this option to an integer N,
it tells
.I fetchmail
to only issue expunges on every Nth delete.  An argument
of zero suppresses expunges entirely (so no expunges at all will be
done until the end of run). 
This option does not work with ETRN, POP2, or POP3.
.SS Authentication Options
.TP
.B \-u name, --username name
(Keyword: user[name])
Specifies the user identification to be used when logging in to the mailserver.
The appropriate user identification is both server and user-dependent.  
The default is your login name on the client machine that is running 
.I fetchmail.
See USER AUTHENTICATION below for a complete description.
.TP
.B \-I specification, --interface specification
(Keyword: interface)
Require that a specific interface device be up and have a specific local
IP address (or range) before polling.  Frequently
.I fetchmail
is used over a transient point-to-point TCP/IP link established directly
to a mailserver via SLIP or PPP.  That is a relatively secure channel.
But when other TCP/IP routes to the mailserver exist (e.g. when the link
is connected to an alternate ISP), your username and password may be
vulnerable to snooping (especially when daemon mode automatically polls
for mail, shipping a clear password over the net at predictable
intervals).  The --interface option may be used to prevent this.  When
the specified link is not up or is not connected to a matching IP
address, polling will be skipped.  The format is:
.sp
	interface/iii.iii.iii.iii/mmm.mmm.mmm.mmm
.sp
The field before the first slash is the interface name (i.e. sl0, ppp0
etc.).  The field before the second slash is the acceptable IP address.
The field after the second slash is a mask which specifies a range of
IP addresses to accept.  If no mask is present 255.255.255.255 is
assumed (i.e. an exact match).  This option is currently only supported
under Linux.
.TP
.B \-M interface, --monitor interface
(Keyword: monitor)
Daemon mode can cause transient links which are automatically taken down
after a period of inactivity (e.g. PPP links) to remain up
indefinitely.  This option identifies a system TCP/IP interface to be
monitored for activity.  After each poll interval, if the link is up but
no other activity has occurred on the link, then the poll will be
skipped.  This option is currently only supported under Linux.
.TP
.B \-A, --auth
(Keyword: auth[enticate]) 
This option permits you to specify a preauthentication type (see USER
AUTHENTICATION below for details).  The possible values are
\&`\fBpassword\fR', `\fBkerberos_v5\fR' and `\fBkerberos\fR' (or, for
excruciating exactness, `\fBkerberos_v4\fR').  This option is provided
primarily for developers; choosing KPOP protocol automatically selects
Kerberos preauthentication, and all other alternatives use password
authentication (though APOP uses a generated one-time key as the
password and IMAP-K4 uses RFC1731 Kerberos v4 authentication).  This
option does not work with ETRN.
.SS Miscellaneous Options
.TP
.B \-f pathname, --fetchmailrc pathname
Specify a non-default name for the 
.I .fetchmailrc
run control file.  Unless the --version option is also on, the file must have
permissions no more open than  0600 (u=rw,g=,o=) or else be /dev/null.
.TP
.B \-i pathname, --idfile pathname
Specify an alternate name for the .fetchids file used to save POP3
UIDs. 
.TP
.B \-n, --norewrite
(Keyword: no rewrite)
Normally,
.I fetchmail
edits RFC-822 address headers (To, From, Cc, Bcc, and Reply-To) in
fetched mail so that any mail IDs local to the server are expanded to
full addresses (@ and the mailserver hostname are appended).  This enables 
replies on the client to get addressed correctly (otherwise your
mailer might think they should be addressed to local users on the
client machine!).  This option disables the rewrite.  (This option is
provided to pacify people who are paranoid about having an MTA edit
mail headers and want to know they can prevent it, but it is generally
not a good idea to actually turn off rewrite.)
When using ETRN, the rewrite option is ineffective.
.TP
.B -E, --envelope
(Keyword: envelope)
This option changes the header 
.I fetchmail
assumes will carry a copy of the mail's envelope address.  Normally
this is `X-Envelope-To' but as this header is not standard, practice
varies. See the discussion of multidrop address handling below.  As a
special case, `envelope "Received"' enables parsing of sendmail-style
Received lines.  This is the default, and it should not be necessary
unless you have globally disabled Received parsing with `no envelope'
in the \fI.fetchmailrc\fR file.
.TP
.B -Q, --qvirtual
(Keyword: qvirtual)
The string assigned to this option will be removed from the user
name found in the header specified with the \fIenvelope\fR option.
This option is useful if you are using  
.I fetchmail
to collect the mail for an entire domain and your ISP (or your mail
redirection provider) is using qmail.
One of the basic features of qmail is the
.sp
\&`Delivered-To:'
.sp
message header.  Whenever qmail delivers a message to a local mailbox
it puts the username and hostname of the envelope recipient on this
line.  The major reason for this is to prevent mail loops.  To set up
qmail to batch mail for a disconnected site the ISP-mailhost will have
normally put that site in its `Virtualhosts' control file so it will
add a prefix to all mail addresses for this site. This results in mail
sent to 'username@userhost.userdom.dom.com' having a
\&`Delivered-To:' line of the form:
.sp
Delivered-To: mbox-userstr-username@userhost.userdom.dom.com
.sp
The ISP can make the 'mbox-userstr-' prefix anything they choose
but a string matching the user host name is likely.
By using the option `envelope Delivered-To:' you can make fetchmail reliably
identify the original envelope recipient, but you have to strip the
`mbox-userstr-' prefix to deliver to the correct user.
This is what this option is for.

.SH USER AUTHENTICATION AND ENCRYPTION
Every mode except ETRN requires authentication of the client.
Normal user authentication in 
.I fetchmail
is very much like the authentication mechanism of 
.IR ftp (1).
The correct user-id and password depend upon the underlying security
system at the mailserver.  
.PP
If the mailserver is a Unix machine on which you have an ordinary user 
account, your regular login name and password are used with 
.I fetchmail.
If you use the same login name on both the server and the client machines,
you needn't worry about specifying a user-id with the 
.B \-u
option \-\- 
the default behavior is to use your login name on the client machine as the 
user-id on the server machine.  If you use a different login name
on the server machine, specify that login name with the
.B \-u
option.  e.g. if your login name is 'jsmith' on a machine named 'mailgrunt',
you would start 
.I fetchmail 
as follows:
.IP
fetchmail -u jsmith mailgrunt
.PP
The default behavior of 
.I fetchmail
is to prompt you for your mailserver password before the connection is
established.  This is the safest way to use 
.I fetchmail
and ensures that your password will not be compromised.  You may also specify
your password in your
.I ~/.fetchmailrc
file.  This is convenient when using 
.I fetchmail
in daemon mode or with scripts.
.PP
If you do not specify a password, and
.I fetchmail
cannot extract one from your
.I .fetchmailrc
file, it will look for a 
.I .netrc
file in your home directory before requesting one interactively; if an
entry matching the mailserver is found in that file, the password will
be used.  See the
.IR ftp (1)
man page for details of the syntax of the
.I .netrc
file.  (This feature may allow you to avoid duplicating password
information in more than one file.)
.PP
On mailservers that do not provide ordinary user accounts, your user-id and 
password are usually assigned by the server administrator when you apply for 
a mailbox on the server.  Contact your server administrator if you don't know 
the correct user-id and password for your mailbox account.
.PP
Early versions of POP3 (RFC1081, RFC1225) supported a crude form of
independent authentication using the
.I rhosts
file on the mailserver side.  Under this RPOP variant, a fixed
per-user ID equivalent to a password was sent in clear over a link to
a reserved port, with the command RPOP rather than PASS to alert the
server that it should do special checking.  RPOP is supported
by
.I fetchmail
(you can specify `protocol RPOP' to have the program send `RPOP'
rather than `PASS') but its use is strongly discouraged.  This
facility was vulnerable to spoofing and was withdrawn in RFC1460.
.PP
RFC1460 introduced APOP authentication.  In this variant of POP3,
you register an APOP password on your server host (the program
to do this with on the server is probably called \fIpopauth\fR(8)).  You
put the same password in your 
.I .fetchmailrc
file.  Each time 
.I fetchmail
logs in, it sends a cryptographically secure hash of your password and
the server greeting time to the server, which can verify it by
checking its authorization database. 
.PP
If your \fIfetchmail\fR was built with Kerberos support and you specify 
Kerberos preauthentication (either with --auth or the \fI.fetchmailrc\fR
option \fBauthenticate kerberos_v4\fR) it will try to get a Kerberos
ticket from the mailserver at the start of each query. 
.PP
If you use IMAP-K4, \fIfetchmail\fR will expect the IMAP server to have
RFC1731-conformant AUTHENTICATE KERBEROS_V4 capability, and will use it.
.PP
If you use IMAP-GSS, \fIfetchmail\fR will expect the IMAP server to have
RFC1731-conformant AUTHENTICATE GSSAPI capability, and will use it. 
Currently this has only been tested over Kerberos V, so you're expected
to already have a ticket-granting ticket. You may pass a username different
from your principal name using the standard \fB--user\fR command or by
the \fI.fetchmailrc\fR option \fBuser\fR.
.PP
If you are using POP3, and the server issues a one-time-password
challenge conforming to RFC1938, \fIfetchmail\fR will use your
password as a pass phrase to generate the required response. This
avoids sending secrets over the net unencrypted.
.PP
Compuserve's RPA authentication (similar to APOP) is supported.  If
you are using POP3, and the RPA code has been compiled into your
binary, and you query a server in the Compuserve csi.com domain,
\fIfetchmail\fR will try to perform an RPA pass-phrase authentication
instead of sending over the password en clair.
.PP
If you are using IPsec, the -T (--netsec) option can be used to pass
an IP security request to be used when outgoing IP connections are
initialized.  You can also do this using the `netsec' server option
in the .fetchmailrc file.  In either case, the option value is a
string in the format accepted by the net_security_strtorequest() 
function of the inet6_apps library.

.SH DAEMON MODE
The 
.B --daemon
or
.B -d 
option runs 
.I fetchmail
in daemon mode.  You must specify a numeric argument which is a
polling interval in seconds.
.PP
In daemon mode, 
.I fetchmail
puts itself in background and runs forever, querying each specified
host and then sleeping for the given polling interval.
.PP
Simply invoking
.IP
fetchmail -d 900
.PP
will, therefore, poll all the hosts described in your 
.I ~/.fetchmailrc
file (except those explicitly excluded with the `skip' verb) once
every fifteen minutes.
.PP
It is possible to set a polling interval 
in your
.I ~/.fetchmailrc
file by saying `set daemon <interval>', where <interval> is an
integer number of seconds.  If you do this, fetchmail will always
start in daemon mode unless you override it with the command-line
option --daemon 0 or -d0.
.PP
Only one daemon process is permitted per user; in daemon mode,
.I fetchmail
makes a per-user lockfile to guarantee this.
.PP
Normally, calling fetchmail with a daemon in the background sends a
wakeup signal to the daemon, forcing it to poll mailservers
immediately.  (The wakeup signal is SIGHUP if fetchmail is running as
root, SIGUSR1 otherwise.)
.PP
The option
.B --quit
will kill a running daemon process instead of waking it up (if there
is no such option, 
.I fetchmail
notifies you).  If the --quit option is the only command-line option,
that's all there is to it.
.PP
The quit option may also be mixed with other command-line options; its
effect is to kill any running daemon before doing what the other
options specify in combination with the rc file.
.PP
The 
.B -t
or
.B --timeout
option (keyword: timeout) allows you to set a server-nonresponse
timeout in seconds.  If a mailserver does not send a greeting message
or respond to commands for the given number of seconds,
\fIfetchmail\fR will hang up on it.  Without such a timeout
\fIfetchmail\fR might hang up indefinitely trying to fetch mail from a
down host.  This would be particularly annoying for a \fIfetchmail\fR
running in background.  There is a default timeout which fetchmail -V
will report.
.PP
The
.B -L
or
.B --logfile
option (keyword: set logfile) allows you to redirect status messages
emitted while detached into a specified logfile (follow the
option with the logfile name).  The logfile is opened for append, so
previous messages aren't deleted.  This is primarily useful for
debugging configurations.
.PP
The
.B --syslog
option (keyword: syslog) allows you to redirect status and error
messages emitted to the
.IR syslog (3)
system daemon if available.
Messages are logged with an id of \fBfetchmail\fR, the facility \fBLOG_MAIL\fR,
and priorities \fBLOG_ERR\fR, \fBLOG_ALERT\fR or \fBLOG_INFO\fR.
This option is intended for logging status and error messages which
indicate the status of the daemon and the results while fetching mail
from the server(s).
Error messages for command line options and parsing the \fI.fetchmailrc\fR
file are still written to stderr, or the specified log file if the
.B -L
or
.B --logfile
option was used.
.PP
The 
.B --invisible
option tries to make fetchmail invisible.  Normally, fetchmail behaves
like any other MTA would -- it generates a Received header into each
message describing its place in the chain of transmission, and tells
the MTA it forwards to that the mail came from the machine fetchmail
itself is running on.  If the invisible option is on, the Received
header is suppressed and fetchmail tries to spoof the MTA it forwards
to into thinking it came directly from the mailserver host.
.PP
The 
.B \-N
or --nodetach option suppresses backgrounding and detachment of the
daemon process from its control terminal.  This is primarily useful
for debugging.  Note that this also causes the logfile option to be
ignored (though perhaps it shouldn't).
.PP
Note that while running in daemon mode polling a POP2 or POP3 server,
transient errors (such as DNS failures or sendmail delivery refusals)
may force the fetchall option on for the duration of the next polling
cycle.  This is a robustness feature.  It means that if a message is
fetched (and thus marked seen by the mailserver) but not delivered
locally due to some transient error, it will be re-fetched during the
next poll cycle.  (The IMAP logic doesn't delete messages until
they're delivered, so this problem does not arise.)

.SH RETRIEVAL FAILURE MODES
The protocols \fIfetchmail\fR uses to talk to mailservers are next to
bulletproof.  In normal operation forwarding to port 25, no message is
ever deleted (or even marked for deletion) on the host until the SMTP
listener on the client has acknowledged to \fIfetchmail\fR that the
message has been accepted for delivery.  When forwarding to an MDA,
however, there is more possibility of error (because there's no way
for fetchmail to get a reliable positive acknowledgement from the MDA).
.PP
The normal mode of \fIfetchmail\fR is to try to download only `new'
messages, leaving untouched (and undeleted) messages you have already
read directly on the server (or fetched with a previous \fIfetchmail
--keep\fR).  But you may find that messages you've already read on the
server are being fetched (and deleted) even when you don't specify
--all.  There are several reasons this can happen.
.PP
One could be that you're using POP2.  The POP2 protocol includes no
representation of `new' or `old' state in messages, so \fIfetchmail\fR
must treat all messages as new all the time.  But POP2 is obsolete, so
this is unlikely.
.PP
Under POP3, blame RFC1725.  That version of the POP3 protocol
specification removed the LAST command, and some POP servers follow it
(you can verify this by invoking \fIfetchmail -v\fR to the mailserver
and watching the response to LAST early in the query).  The
\fIfetchmail\fR code tries to compensate by using POP3's UID feature,
storing the identifiers of messages seen in each session until the
next session, in the \fI.fetchids\fR file.  But this doesn't track
messages seen with other clients, or read directly with a mailer on
the host but not deleted afterward.  A better solution would be to
switch to IMAP.
.PP
Another potential POP3 problem might be servers that insert messages
in the middle of mailboxes (some VMS implementations of mail are
rumored to do this).  The \fIfetchmail\fR code assumes that new
messages are appended to the end of the mailbox; when this is not true
it may treat some old messages as new and vice versa.  The only 
real fix for this problem is to  switch to IMAP.
.PP
The IMAP code uses the presence or absence of the server flag \eSeen
to decide whether or not a message is new.  Under Unix, it counts on
your IMAP server to notice the BSD-style Status flags set by mail user
agents and set the \eSeen flag from them when appropriate.  All Unix
IMAP servers we know of do this, though it's not specified by the IMAP
RFCs.  If you ever trip over a server that doesn't, the symptom will
be that messages you have already read on your host will look new to
the server.  In this (unlikely) case, only messages you fetched with
\fIfetchmail --keep\fR will be both undeleted and marked old.
.PP
In ETRN mode, \fIfetchmail\fR does not actually retrieve messages;
instead, it asks the server's SMTP listener to start a queue flush
to the client via SMTP.  Therefore it sends only undelivered messages.

.SH SPAM FILTERING
Many SMTP listeners allow administrators to set up `spam filters' that
block unsolicited email from specified domains.  A MAIL FROM line that
triggers this feature will elicit an SMTP response which
(unfortunately) varies according to the listener.
.PP
Newer versions of 
.I sendmail
return an error code of 571.  This return value
is blessed by RFC1893 as "Delivery not authorized, message refused".
.PP
According to current drafts of the replacement for RFC821, the correct
thing to return in this situation is 550 "Requested action not taken:
mailbox unavailable" (the draft adds "[E.g., mailbox not found, no
access, or command rejected for policy reasons].").
.PP
The
.I exim
MTA returns 501 "Syntax error in parameters or arguments" , but will
move to 550 soon.
.PP
The
.I fetchmail
code recognizes and discards the message on a code that defaults to
sendmail's 571 but can be set with the `antispam' option.  This is the
.I only
circumstance under which fetchmail ever discards mail.
.P
If
.I fetchmail
is fetching from an IMAP server, the antispam response will be detected and
the message rejected immediately after the headers have been fetched,
without reading the message body.  Thus, you won't pay for downloading 
spam message bodies.

.SH THE RUN CONTROL FILE
The preferred way to set up fetchmail is to write a
\&\fI.fetchmailrc\fR file in your home directory.  When there is a
conflict between the command-line arguments and the arguments in this
file, the command-line arguments take precedence.
.PP
To protect the security of your passwords, when --version is not on
your \fI~/.fetchmailrc\fR may not have more than 0600 (u=rw,g=,o=) permissions;
.I fetchmail
will complain and exit otherwise.
.PP
You may read the \fI.fetchmailrc\fR file as a list of commands to 
be executed when 
.I fetchmail
is called with no arguments.
.SS Run Control Syntax
.PP
Comments begin with a '#' and extend through the end of the line.
Otherwise the file consists of a series of server entries or global
option statements in a free-format, token-oriented syntax.
.PP
There are four kinds of tokens: grammar keywords, numbers
(i.e. decimal digit sequences), unquoted strings, and quoted strings.
A quoted string is bounded by double quotes and may contain
whitespace (and quoted digits are treated as a string).  An unquoted
string is any whitespace-delimited token that is neither numeric, string
quoted nor contains the special characters `,', `;', `:', or `='.
.PP
Any amount of whitespace separates tokens in server entries, but is
otherwise ignored. You may use standard C-style escapes (\en, \et,
\eb, octal, and hex) to embed non-printable characters or string
delimiters in strings.
.PP
Each server entry consists of one of the keywords `poll' or `skip',
followed by a server name, followed by server options, followed by any
number of user descriptions.  Note: the most common cause of syntax
errors is mixing up user and server options.
.PP
For backward compatibility, the word `server' is a synonym for `poll'.
.PP
You can use the noise keywords `and', `with',
\&`has', `wants', and `options' anywhere in an entry to make
it resemble English.  They're ignored, but but can make entries much
easier to read at a glance.  The punctuation characters ':', ';' and
\&',' are also ignored.
.PP
.SS Poll vs. Skip
The `poll' verb tells fetchmail to query this host when it is run with
no arguments.  The `skip' verb tells
.I fetchmail 
not to poll this host unless it is explicitly named on the command
line.  (The `skip' verb allows you to experiment with test entries
safely, or easily disable entries for hosts that are temporarily down.)
.PP
.SS Keyword/Option Summary
Here are the legal server options.  Keyword suffixes enclosed in
square brackets are optional.  Those corresponding to command-line
options are followed by `-' and the appropriate option letter.

.TS
l l lw34.
Keyword  	Opt	Function
_
via      	\&	T{
Specify DNS name of mailserver, overriding poll name
T}
proto[col]	-p	T{
Specify protocol (case insensitive):
POP2, POP3, IMAP, IMAP-K4, IMAP-GSS, APOP, KPOP
T}
port    	-P	T{
Specify TCP/IP service port
T}
auth[enticate]	-A	T{
Set preauthentication type (default `password')
T}
timeout  	-t	T{
Server inactivity timout in seconds (default 300)
T}
envelope	-E	T{
Specify envelope-address header name
T}
no envelope	\&	T{
Disable looking for envelope address
T}
qvirtual	-Q	T{
Qmail virtual domain prefix to remove from user name
T}
aka      	\&	T{
Specify alternate DNS names of mailserver
T}
interface	-I	T{
specify IP interface(s) that must be up for server poll to take place
T}
monitor   	-M	T{
Specify IP address to monitor for activity
T}
dns     	\&	T{
Enable DNS lookup for multidrop (default)
T}
no dns   	\&	T{
Disable DNS lookup for multidrop
T}
uidl    	-U	T{
Force POP3 to use client-side UIDLs
T}
no uidl   	\&	T{
Turn off POP3 use of client-side UIDLs (default)
T}
.TE

Here are the legal user options:

.TS
l l lw34.
Keyword  	Opt	Function
_
user[name]	-u	T{
Set remote user name 
(local user name if name followed by `here') 
T}
is      	\&	T{
Connect local and remote user names
T}
to      	\&	T{
Connect local and remote user names
T}
pass[word]	\&	T{
Specify remote account password
T}
folder  	-r	T{
Specify remote folder to query
T}
smtphost	-S	T{
Specify smtp host(s) to forward to
T}
smtpaddress	-D	T{
Specify the domain to be put in RCPT TO lines
T}
antispam	-Z	T{
Specify what SMTP return is interpreted as a spam-policy block
T}
mda     	-m	T{
Specify MDA for local delivery
T}
preconnect	\&	T{
Command to be executed before each connection
T}
postconnect	\&	T{
Command to be executed after each connection
T}
keep     	-k	T{
Don't delete seen messages from server
T}
flush   	-F	T{
Flush all seen messages before querying
T}
fetchall	-a	T{
Fetch all messages whether seen or not
T}
rewrite    	\&	T{
Rewrite destination addresses for reply (default)
T}
stripcr  	\&	T{
Strip carriage returns from ends of lines
T}
forcecr  	\&	T{
Force carriage returns at ends of lines
T}
pass8bits	\&	T{
Force BODY=8BITMIME to ESMTP listener
T}
dropstatus	\&	T{
Strip Status and X-Mozilla-Status lines out of incoming mail
T}
mimedecode	\&	T{
Convert quoted-printable to 8-bit in MIME messages (default)
T}
no keep  	-K	T{
Delete seen messages from server (default)
T}
no flush	\&	T{
Don't flush all seen messages before querying (default)
T}
no fetchall	\&	T{
Retrieve only new messages (default)
T}
no rewrite	\&	T{
Don't rewrite headers
T}
no stripcr	\&	T{
Don't strip carriage returns (default)
T}
no forcecr	\&	T{
Don't force carriage returns at EOL (default)
T}
no pass8bits	\&	T{
Don't force BODY=8BITMIME to ESMTP listener (default)
T}
no dropstatus	\&	T{
Don't drop Status headers (default)
T}
no mimedecode	\&	T{
Don't convert quoted-printable to 8-bit in MIME messages
T}
limit   	-l	T{
Set message size limit
T}
batchlimit	-b	T{
Max # messages to fetch in single connect
T}
fetchlimit	-B	T{
Max # messages to forward in single connect
T}
expunge 	-e	T{
Perform an expunge on every #th message (IMAP only)
T}
syslog  	\&	T{
Do error logging through syslog(3).
T}
.TE
.PP
Remember that all user options must \fIfollow\fR all server options.
.PP
In the .fetchmailrc file, the `envelope' string argument may be
preceded by a whitespace-separated number.  This number, if specified,
is the number of such headers to skip (that is, an argument of 1
selects the second header of the given type).  This is sometime useful
for ignoring bogus Received headers created by an ISP's local delivery
agent.
.SS Keywords Not Corresponding To Option Switches
.PP
The `folder' and `smtphost' options (unlike their command-line
equivalents) can take a space- or comma-separated list of names
following them.
.PP
All options correspond to the obvious command-line arguments, except
the following: `via', `interval', `aka', `is', `to', `dns'/`no dns',
\&`password', \&`preconnect', \&`postconnect', `localdomains',
\&`stripcr'/`no stripcr', \&`forcecr'/`no forcecr', `pass8bits'/`no
pass8bits' `dropstatus/no dropstatus', `mimedecode/no mimedecode',
and `no envelope'.
.PP
The `via' option is for use with ssh, or if you want to have more
than one configuration pointing at the same site.  If it is present,
the string argument will be taken as the actual DNS name of the 
mailserver host to query.
This will override the argument of poll, which can then simply be a
distinct label for the configuration (e.g. what you would give on the
command line to explicitly query this host).
If the `via' name is `localhost', the poll name will also still be
used as a possible match in multidrop mode; otherwise the `via' name
will be used instead and the poll name will be purely a label.
.PP
The `interval' option (which takes a numeric argument) allows you to poll a
server less frequently than the basic poll interval.  If you say
\&`interval N' the server this option is attached to will only be
queried every N poll intervals. 
.PP
The `is' or `to' keywords associate the following local (client)
name(s) (or server-name to client-name mappings separated by =) with
the mailserver user name in the entry.  If an is/to list has `*' as
its last name, unrecognized names are simply passed through.
.PP
A single local name can be used to support redirecting your mail when
your username on the client machine is different from your name on the
mailserver.  When there is only a single local name, mail is forwarded
to that local username regardless of the message's Received, To, Cc,
and Bcc headers.  In this case 
.I fetchmail
never does DNS lookups.
.PP
When there is more than one local name (or name mapping) the
\fIfetchmail\fR code does look at the Received, To, Cc, and Bcc
headers of retrieved mail (this is `multidrop mode').  It looks for
addresses with hostname parts that match your poll name or your `via',
`aka' or `localdomains' options, and usually also for hostname parts
which DNS tells it are aliases of the mailserver.  See the discussion
of `dns', `localdomains', and `aka' for details on how matching
addresses are handled.  If \fIfetchmail\fR cannot match any mailserver
usernames or localdomain addresses, the default recipient is the
calling user (as set by the USER or LOGNAME variable in the
environment; you could use this to redirect to an alias like postmaster).
.PP
The `dns' option (normally on) controls the way addresses from
multidrop mailboxes are checked.  On, it enables logic to check each
host address that doesn't match an `aka' or `localdomains' declaration
by looking it up with DNS.  When a mailserver username is recognized
attached to a matching hostname part, its local mapping is added to
the list of local recipients.
.PP
The `aka' option is for use with multidrop mailboxes.  It allows you
to pre-declare a list of DNS aliases for a server.  This is an
optimization hack that allows you to trade space for speed.  When
.IR fetchmail ,
while processing a multidrop mailbox, grovels through message headers
looking for names of the mailserver, pre-declaring common ones can
save it from having to do DNS lookups.
.PP
The `localdomains' option allows you to declare a list of domains
which fetchmail should consider local.  When fetchmail is parsing
address lines in multidrop modes, and a trailing segment of a host
name matches a declared local domain, that address is passed through
to the listener or MDA unaltered (local-name mappings are \fInot\fR
applied).
.PP
If you are using `localdomains', you may also need to specify \&`no
envelope', which disables \fIfetchmail\fR's normal attempt to deduce
an envelope address from the Received line or X-Envelope-To header or
whatever header has been previously set by `envelope'.  If you set `no
envelope' in the defaults entry it is possible to undo that in
individual entries by using `envelope <string>'.  As a special case,
\&`envelope "Received"' restores the default parsing of
Received lines.
.PP
The \fBpassword\fR option requires a string argument, which is the password
to be used with the entry's server.
.PP
The `preconnect' keyword allows you to specify a shell command to be
executed just before each time
.I fetchmail
establishes a mailserver connection.  This may be useful if you are 
attempting to set up secure POP connections with the aid of
.IR ssh (1).
If the command returns a nonzero status, the poll of that mailserver
will be aborted.
.PP
Similarly, the `postconnect' keyword similarly allows you to specify a
shell command to be executed just after each time a mailserver
connection is taken down.
.PP
The `forcecr' option controls whether lines terminated by LF only are
given CRLF termination before forwarding.  Strictly speaking RFC821
requires this, but few MTAs enforce the requirement it so this option
is normally off (only one such MTA, qmail, is in significant use at
time of writing).  
.PP
The `stripcr' option controls whether carriage returns are stripped
out of retrieved mail before it is forwarded.  It is normally not
necessary to set this, because it defaults to `on' (CR stripping
enabled) when there is an MDA declared but `off' (CR stripping
disabled) when forwarding is via SMTP.  If `stripcr' and `forcecr' are
both on, `stripcr' will override.
.PP
The `pass8bits' option exists to cope with Microsoft mail programs that
stupidly slap a "Content-Transfer-Encoding: 7bit" on everything.  With
this option off (the default) and such a header present, 
.I fetchmail
declares BODY=7BIT to an ESMTP-capable listener; this causes problems for
messages actually using 8-bit ISO or KOI-8 character sets, which will
be garbled by having the high bits of all characters stripped.  If
\&`pass8bits' is on, 
.I fetchmail
is forced to declare BODY=8BITMIME to any ESMTP-capable listener.  If
the listener is 8-bit-clean (as all the major ones now are) the right
thing will probably result.
.PP
The `dropstatus' option controls whether nonempty Status and
X-Mozilla-Status lines are retained in fetched mail (the default) or
discarded.  Retaining them allows your MUA to see what messages (if
any) were marked seen on the server.  On the other hand, it can
confuse some new-mail notifiers, which assume that anything with a
Status line in it has been seen.  (Note: the empty Status lines
inserted by some buggy POP servers are unconditionally discarded.)
.PP
The `mimedecode' option controls whether MIME messages using the
quoted-printable encoding are automatically converted into pure
8-bit data. If you are delivering mail to an ESMTP-capable,
8-bit-clean listener (that includes all of the major programs
like sendmail), then this will automatically convert quoted-printable
message headers and data into 8-bit data, making it easier to
understand when reading mail. If your e-mail programs know how to
deal with MIME messages, then this option is not needed.
.PP
.SS Miscellaneous Run Control Options
The words `here' and `there' have useful English-like
significance.  Normally `user eric is esr' would mean that 
mail for the remote user `eric' is to be delivered to `esr',
but you can make this clearer by saying `user eric there is esr here',
or reverse it by saying `user esr here is eric there'
.PP
Legal protocol identifiers for use with the `protocol' keyword are:

    auto (or AUTO)
    pop2 (or POP2)
    pop3 (or POP3)
    imap (or IMAP)
    imap-k4 (or IMAP-K4)
    imap-gss (or IMAP-GSS)
    apop (or APOP)
    kpop (or KPOP)

.PP
Legal authentication types are `password' or `kerberos'.  The former
specifies authentication by normal transmission of a password (the
password may be plaintext or subject to protocol-specific encryption
as in APOP); the second tells \fIfetchmail\fR to try to get a Kerberos
ticket at the start of each query instead, and send an arbitrary
string as the password.
.PP
Specifying `kpop' sets POP3 protocol over port 1109 with Kerberos V4
preauthentication.  These defaults may be overridden by later options.
.PP
There are currently three global option statements; `set logfile'
followed by a string sets the same global specified by --logfile.  A
command-line --logfile option will override this.  Also, `set daemon'
sets the poll interval as --daemon does.  This can be overridden by
a command-line --daemon option; in particular --daemon 0 can be used 
to force foreground operation. Finally, `set syslog' sends log
messages to syslogd(8).

.SH INTERACTION WITH RFC 822
When trying to detertmine the originating address of a message,
fetchmail looks through headers in the following order: 

        Return-Path:
        Resent-Sender:
        Sender:
        Resent-From:
        From:
        Reply-To:
        Apparently-From:

The originating address is used for logging, and to set the MAIL FROM
address when forwarding to SMTP.  This order is intended to cope
gracefully with receiving mailing list messages in multidrop mode. The
intent is that if a local address doesn't exist, the bounce message
won't be returned blindly to the author or to the list itself, but
rather to the list manager (which is less annoying).

In multidrop mode, destination headers are processed as follows:
First, fetchmail looks for the Received: header (or whichever one is
specified by the `envelope' option) to determine the local
recipient adress. If the mail is addressed to more than one recipient,
the Received line won't contain any information regarding recipient adresses.

Then fetchmail looks for the Resent-To:, Resent-Cc:, and Resent-Bcc:
lines.  If they exists, they should contain the final recipients and
have precedence over their To:/Cc:/Bcc: counterparts.  If the Resent-*
lines doesn't exist, the To:, Cc:, Bcc: and Apparently-To: lines are
looked for. (The presence of a Resent-To: is taken to impluy that the
person referred by the To: address has already received the original
copy of the mail).

.SH CONFIGURATION EXAMPLES
Basic format is:

.nf
  poll SERVERNAME protocol PROTOCOL username NAME password PASSWORD 
.fi
.PP
Example:

.nf
  poll pop.provider.net protocol pop3 username jsmith password secret1
.fi
.PP
Or, using some abbreviations:

.nf
  poll pop.provider.net proto pop3 user jsmith password secret1
.fi
.PP
Multiple servers may be listed:

.nf
  poll pop.provider.net proto pop3 user jsmith pass secret1
  poll other.provider.net proto pop2 user John.Smith pass My^Hat
.fi

Here's a version of those two with more whitespace and some noise words: 

.nf
  poll pop.provider.net proto pop3
      user jsmith, with password secret1, is jsmith here;
  poll other.provider.net proto pop2:
      user John.Smith, with password My^Hat, is John.Smith here;
.fi

This version is much easier to read and doesn't cost significantly
more (parsing is done only once, at startup time).

.PP
If you need to include whitespace in a parameter string, enclose the
string in double quotes.  Thus:

.nf
  poll mail.provider.net with proto pop3:
        user jsmith there has password "u can't krak this"
                    is jws here and wants mda "/bin/mail"
.fi

You may have an initial server description headed by the keyword
`defaults' instead of `poll' followed by a name.  Such a record
is interpreted as defaults for all queries to use. It may be overwritten
by individual server descriptions.  So, you could write:

.nf
  defaults proto pop3
        user jsmith
  poll pop.provider.net
        pass secret1
  poll mail.provider.net
        user jjsmith there has password secret2
.fi

It's possible to specify more than one user per server (this is only
likely to be useful when running fetchmail in daemon mode as root).
The `user' keyword leads off a user description, and every user specification
in a multi-user entry must include it.  Here's an example:

.nf
  poll pop.provider.net proto pop3 port 3111
        user jsmith with pass secret1 is smith here
        user jones with pass secret2 is jjones here
.fi

This associates the local username `smith' with the pop.provider.net
username `jsmith' and the local username `jjones' with the
pop.provider.net username `jones'.
.PP
Here's what a simple retrieval configuration for a multi-drop mailbox
looks like:

.nf
  poll pop.provider.net:
        user maildrop with pass secret1 to golux hurkle=happy snark here
.fi

This says that the mailbox of account `maildrop' on the server is a
multi-drop box, and that messages in it should be parsed for the
server user names `golux', `hurkle', and `snark'.  It further
specifies that `golux' and `snark' have the same name on the
client as on the server, but mail for server user `hurkle' should be
delivered to client user `happy'.
.PP
Here's an example of another kind of multidrop connection:

.nf
  poll pop.provider.net localdomains loonytoons.org:
        user maildrop with pass secret1 to esr * here
.fi

This also says that the mailbox of account `maildrop' on the server is
a multi-drop box.  It tells fetchmail that any address in the
loonytoons.org domain (including subdomain addresses like
`joe@daffy.loonytoons.org') should be passed through to the local SMTP
listener without modification.  Be careful of mail loops if you do this!
.PP
Here's an example configuration using ssh.  The queries go through an
ssh connecting local port 1234 to port 110 on mailhost.net; the
preconnect command sets up the ssh.

.nf
poll mailhost.net via localhost port 1234 with proto pop3:
        preconnect "ssh -f -L 1234:mailhost.net:110
		mailhost.net sleep 20 </dev/null >/dev/null";
.fi

.SH THE USE AND ABUSE OF MULTIDROP MAILBOXES
Use the multiple-local-recipients feature with caution -- it can bite.
Also note that all multidrop features are ineffective in ETRN mode.

.SS Header vs. Envelope addresses 
The fundamental problem is that by having your mailserver toss several
peoples' mail in a single maildrop box, you may have thrown away
potentially vital information about who each piece of mail was
actually addressed to (the `envelope address', as opposed to the
header addresses in the RFC822 To/Cc/Bcc headers).  This `envelope
address' is the address you need in order to reroute mail properly.
.PP
Sometimes 
.I fetchmail
can deduce the envelope address.  If the mailserver MTA is
.I sendmail
and the item of mail had just one recipient, the MTA will have written
a `by/for' clause that gives the envelope addressee into its Received
header. But this doesn't work reliably for other MTAs, nor if there is
more than one recipient.  By default, \fIfetchmail\fR looks for
envelope addresses in these lines; you can restore this default with
-E "Received" or \&`envelope Received'.
.PP
Alternatively, some SMTP listeners and/or mail servers insert a header
in each message containing a copy of the envelope addresses.  This
header (when it exists) is often `X-Envelope-To'.  Fetchmail's
assumption about this can be changed with the -E or `envelope' option.
Note that writing an envelope header of this kind exposes the names of
recipients (including blind-copy recopients) to all receivers of the
messages; it is therefore regarded by some administrators as a
security/privacy problem.
.PP
A slight variation of the `X-Envelope-To' header is the `Delivered-To' put
by qmail to avoid mail loops. It will probably prefix the user name with a
string that normally matches the user's domain. To remove this prefix you
can use the -Q or `qvirtual' option.
.PP
Sometimes, unfortunately, neither of these methods works.  When they
all fail, fetchmail must fall back on the contents of To/Cc/Bcc
headers to try to determine recipient addressees -- and these are not
reliable.  In particular, mailing-list software often ships mail with
only the list broadcast address in the To header.
.PP
When
.I fetchmail
cannot deduce a recipient address that is local, and the intended
recipient address was anyone other than fetchmail's invoking user,
mail will get lost.  This is what makes the multidrop feature risky.
.PP
A related problem is that when you blind-copy a mail message, the Bcc
information is carried \fIonly\fR as envelope address (it's not put
in the headers fetchmail can see unless there is an X-Envelope
header).  Thus, blind-copying to someone who gets mail over a
fetchmail link will fail unless the the mailserver host routinely
writes X-Envelope or an equivalent header into messages in your maildrop.

.SS Good Ways To Use Multidrop Mailboxes
Multiple local names can be used to administer a mailing list from the
client side of a \fIfetchmail\fR collection.  Suppose your name is
\&`esr', and you want to both pick up your own mail and maintain a mailing
list called (say) "fetchmail-friends", and you want to keep the alias
list on your client machine.
.PP
On your server, you can alias \&`fetchmail-friends' to `esr'; then, in
your \fI.fetchmailrc\fR, declare \&`to esr fetchmail-friends here'.
Then, when mail including `fetchmail-friends' as a local address
gets fetched, the list name will be appended to the list of
recipients your SMTP listener sees.  Therefore it will undergo alias
expansion locally.  Be sure to include `esr' in the local alias
expansion of fetchmail-friends, or you'll never see mail sent only to
the list.  Also be sure that your listener has the "me-too" option set
(sendmail's -oXm command-line option or OXm declaration) so your name
isn't removed from alias expansions in messages you send.
.PP
This trick is not without its problems, however.  You'll begin to see
this when a message comes in that is addressed only to a mailing list
you do \fInot\fR have declared as a local name.  Each such message
will feature an `X-Fetchmail-Warning' header which is generated
because fetchmail cannot find a valid local name in the recipient
addresses.  Such messages default (as was described above) to being
sent to the local user running
.IR fetchmail ,
but the program has no way to know that that's actually the right thing.

.SS Bad Ways To Abuse Multidrop Mailboxes
Multidrop mailboxes and 
.I fetchmail
serving multiple users in daemon mode do not mix.  The problem, again, is
mail from mailing lists, which typically does not have an individual
recipient address on it.   Unless 
.I fetchmail
can deduce an envelope address, such mail will only go to the account
running fetchmail (probably root).  Also, blind-copied users are very
likely never to see their mail at all.
.PP
If you're tempted to use 
.I fetchmail 
to retrieve mail for multiple users from a single mail drop via POP or
IMAP, think again (and reread the section on header and envelope
addresses above).  It would be smarter to just let the mail sit in the
mailserver's queue and use fetchmail's ETRN mode to trigger SMTP sends
periodically (of course, this means you have to poll more frequently
than the mailserver's expiry period).  If you can't arrange this, try
setting up a UUCP feed.
.PP
If you absolutely \fImust\fR use multidrop for this purpose, make sure
your mailserver writes an envelope-address header that fetchmail can
see.  Otherwise you \fIwill\fR lose mail and it \fIwill\fR come back
to haunt you.

.SS Speeding Up Multidrop Checking
Normally, when multiple user are declared 
.I fetchmail
extracts recipient addresses as described above and checks each host
part with DNS to see if it's an alias of the mailserver.  If so, the
name mappings described in the to ... here declaration are done and
the mail locally delivered.
.PP
This is the safest but also slowest method.  To speed it up,
pre-declare mailserver aliases with `aka'; these are checked before
DNS lookups are done.  If you're certain your aka list contains
.B all
DNS aliases of the mailserver (and all MX names pointing at it) 
you can declare `no dns' to suppress DNS lookups entirely and
\fIonly\fR match against the aka list.

.SH EXIT CODES
To facilitate the use of 
.I fetchmail
in shell scripts, an exit code is returned to give an indication
of what occurred during a given connection.
.PP
The exit codes returned by 
.I fetchmail
are as follows:
.IP 0
One or more messages were successfully retrieved.
.IP 1
There was no mail awaiting retrieval.  (There may have been old mail still
on the server but not selected for retrieval.)
.IP 2
An error was encountered when attempting to open a socket for the POP 
connection.  If you don't know what a socket is, don't worry about it --
just treat this as an 'unrecoverable error'.
.IP 3
The user authentication step failed.  This usually means that a bad 
user-id, password, or APOP id was specified.
.IP 4
Some sort of fatal protocol error was detected.
.IP 5
There was a syntax error in the arguments to 
.I fetchmail.
.IP 6
The run control file had bad permissions.
.IP 7
There was an error condition reported by the server.  Can also
fire if
.I fetchmail
timed out while waiting for the server.
.IP 8
Client-side exclusion error.  This means 
.I fetchmail
either found another copy of itself already running, or failed in such
a way that it isn't sure whether another copy is running.
.IP 9
The user authentication step failed because the server responded "lock
busy".  Try again after a brief pause!  This error is not implemented
for all protocols, nor for all servers.  If not implemented for your
server, "3" will be returned instead, see above.  May be returned when
talking to qpopper or other servers that can respond with "lock busy"
or some similar text containing the word "lock".
.IP 10
The 
.I fetchmail.
run failed while trying to do an SMTP port open or transaction.
.IP 11
Fatal DNS error.  Fetchmail encountered an error while performing
a DNS lookup at startup and could not proceed.
.IP 11
Internal error.  You should see a message on standard error with
details.
.PP
When
.I fetchmail
queries more than one host, return status is 0 if \fIany\fR query
successfully retrieved mail. Otherwise the returned error status is
that of the last host queried.

.SH AUTHOR
Eric S. Raymond <esr@snark.thyrsus.com>.  
This program is descended from and replaces 
.IR popclient , 
by Carl Harris <ceharris@mal.com>; the internals are quite different, 
but some of its interface design is directly traceable to that
ancestral program.

.SH FILES
.TP 5
~/.fetchmailrc
default run control file
.TP 5
~/.fetchids
default location of file associating hosts with last message IDs seen
(used only with newer RFC1725-compliant POP3 servers supporting the
UIDL command).
.TP 5
~/.netrc 
your FTP run control file, which (if present) will be searched for
passwords as a last resort before prompting for one interactively.
.TP 5
~/.fetchmail.pid
lock file to help prevent concurrent runs (non-root mode).
.TP 5
/var/run/fetchmail.pid
lock file to help prevent concurrent runs (root mode, Linux systems).
.TP 5
/etc/fetchmail.pid
lock file to help prevent concurrent runs (root mode, systems without /var/run).

.SH ENVIRONMENT
For correct initialization, 
.I fetchmail
requires either that both the USER and HOME environment variables are
correctly set, or that \fBgetpwuid\fR(3) be able to retrieve a password
entry from your user ID.

.SH SIGNALS
If a
.I fetchmail
daemon is running as root, SIGHUP wakes it up from its sleep phase and
forces a poll of all non-skipped servers (this is in accordance with
the usual conventions for system daemons).
.PP
If
.I fetchmail
is running in daemon mode as non-root, use SIGUSR1 to wake it (this is
so SIGHUP due to logout can retain the default action of killing it).
.PP
Running
.I fetchmail
in foreground while a background fetchmail is running will do
whichever of these is appropriate to wake it up.

.SH BUGS AND KNOWN PROBLEMS
The RFC822 address parser used in multidrop mode chokes on some
@-addresses that are technically legal but bizarre.  Strange uses of
quoting and embedded comments are likely to confuse it.
.PP
Use of any of the supported protocols other than POP3 with OTP or RPA, APOP,
KPOP, IMAP-K4, IMAP-GSS, or ETRN requires that the program send unencrypted
passwords over the TCP/IP connection to the mailserver.  This creates
a risk that name/password pairs might be snaffled with a packet
sniffer or more sophisticated monitoring software.  Under Linux, the
--interface option can be used to restrict polling to availability of
a specific interface device with a specific local IP address, but
snooping is still possible if (a) either host has a network device
that can be opened in promiscuous mode, or (b) the intervening network
link can be tapped.
.PP
Use of the %F or %T escapes in an mda option could open a security
hole, because they pass text manipulable by an attacker to a shell
command.  The hole is reduced by the fact that fetchmail temporarily
discards any suid privileges it may have while running the MDA.  To
avoid potential problems, (1) enclose the %F and %T escapes in single
quotes within the option, and (2) never use an mda command containing
%F or %T when fetchmail is run from the root account itself.
.PP
Send comments, bug reports, gripes, and the like to Eric S. Raymond
<esr@thyrsus.com>.  An HTML FAQ is available at the fetchmail home
page; surf to http://www.ccil.org/~esr/fetchmail or do a WWW search
for pages with `fetchmail' in their titles.

.SH SEE ALSO
elm(1), mail(1), sendmail(8), popd(8), imapd(8)
.SH APPLICABLE STANDARDS
.TP 5
SMTP/ESMTP:
RFC 821, RFC 1869, RFC 1652, RFC 1870, RFC1983, RFC 1985
.TP 5
mail:
RFC 822
.TP 5
POP2:
RFC 937
.TP 5
POP3:
RFC 1081, RFC 1225, RFC 1460, RFC 1725, RFC 1939
.TP 5
APOP:
RFC 1460, RFC 1725, RFC 1939
.TP 5
RPOP:
RFC 1081, RFC 1225
.TP 5
IMAP2/IMAP2BIS:
RFC 1176, RFC 1732
.TP 5
IMAP4:
RFC 1730, RFC 1731, RFC 1732, RFC 2060, RFC 2061
.TP 5
ETRN:
RFC 1985
.TP 5
OTP:
RFC 1938
