/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.peer.TextFieldPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.XEvent;

public class MTextFieldPeer
extends MComponentPeer
implements TextFieldPeer {
    native void create(MComponentPeer var1);

    void initialize() {
        TextField textField = (TextField)this.target;
        this.setText(textField.getText());
        if (textField.echoCharIsSet()) {
            this.setEchoCharacter(textField.getEchoChar());
        }
        this.select(textField.getSelectionStart(), textField.getSelectionEnd());
        this.setEditable(textField.isEditable());
        super.initialize();
    }

    public MTextFieldPeer(TextField textField) {
        super(textField);
    }

    public void setEditable(boolean bl) {
        this.pSetEditable(bl);
        this.setBackground(this.target.getBackground());
    }

    public void setBackground(Color color) {
        TextField textField = (TextField)this.target;
        if (textField.isEditable()) {
            color = color.brighter();
        }
        super.setBackground(color);
    }

    public native void pSetEditable(boolean var1);

    public native void select(int var1, int var2);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native void setText(String var1);

    public native void dispose();

    public native String getText();

    public native void setEchoCharacter(char var1);

    public Dimension minimumSize() {
        X11FontMetrics x11FontMetrics = (X11FontMetrics)this.getFontMetrics(this.target.getFont());
        Dimension dimension = x11FontMetrics.stringExtent(((TextField)this.target).getText());
        dimension.width += 20;
        dimension.height += 15;
        return dimension;
    }

    public Dimension preferredSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.charWidth('0') * n + 20, fontMetrics.getHeight() + 15);
    }

    public void action() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 1001, ((TextField)this.target).getText()), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 1004, null));
    }
}

