/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.ConsumerQueue;
import sun.awt.image.GifImageDecoder;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetchable;
import sun.awt.image.ImageFetcher;
import sun.awt.image.JPEGImageDecoder;
import sun.awt.image.PixelStore;
import sun.awt.image.XbmImageDecoder;

public abstract class InputStreamImageSource
implements ImageProducer,
ImageFetchable {
    PixelStore pixelstore;
    private ConsumerQueue consumers;
    private boolean awaitingFetch = false;
    private Thread latestFetcher;
    private ImageDecoder decoder;

    abstract boolean checkSecurity(Object var1, boolean var2);

    synchronized int countConsumers() {
        ConsumerQueue consumerQueue = this.consumers;
        int n = 0;
        while (consumerQueue != null) {
            ++n;
            consumerQueue = consumerQueue.next;
        }
        return n;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, false);
    }

    synchronized void addConsumer(ImageConsumer imageConsumer, boolean bl) {
        this.checkSecurity(null, false);
        ConsumerQueue consumerQueue = this.consumers;
        while (consumerQueue != null && consumerQueue.consumer != imageConsumer) {
            consumerQueue = consumerQueue.next;
        }
        if (consumerQueue == null) {
            consumerQueue = new ConsumerQueue(this, imageConsumer);
            consumerQueue.next = this.consumers;
            this.consumers = consumerQueue;
        } else {
            if (!consumerQueue.secure) {
                Object object = null;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    object = securityManager.getSecurityContext();
                }
                if (consumerQueue.securityContext == null) {
                    consumerQueue.securityContext = object;
                } else if (consumerQueue.securityContext != object) {
                    this.errorConsumer(consumerQueue);
                    throw new SecurityException("Applets are trading image data!");
                }
            }
            consumerQueue.interested = true;
        }
        if (bl && consumerQueue.feeder == null && !this.awaitingFetch) {
            this.startProduction();
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        ConsumerQueue consumerQueue = this.consumers;
        while (consumerQueue != null) {
            if (consumerQueue.consumer == imageConsumer) {
                return true;
            }
            consumerQueue = consumerQueue.next;
        }
        return false;
    }

    synchronized void errorConsumer(ConsumerQueue consumerQueue) {
        consumerQueue.consumer.imageComplete(1);
        this.removeConsumer(consumerQueue.consumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        ConsumerQueue consumerQueue = this.consumers;
        ConsumerQueue consumerQueue2 = null;
        while (consumerQueue != null) {
            if (consumerQueue.consumer == imageConsumer) {
                if (consumerQueue2 == null) {
                    this.consumers = consumerQueue.next;
                } else {
                    consumerQueue2.next = consumerQueue.next;
                }
                consumerQueue.interested = false;
                return;
            }
            consumerQueue2 = consumerQueue;
            consumerQueue = consumerQueue.next;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, true);
    }

    private synchronized void startProduction() {
        if (!this.awaitingFetch) {
            ImageFetcher.add(this);
            this.awaitingFetch = true;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        PixelStore pixelStore;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            pixelStore = this.pixelstore;
        }
        if (pixelStore != null) {
            pixelStore.replay(this, imageConsumer, false);
        }
    }

    protected abstract ImageDecoder getDecoder();

    protected ImageDecoder decoderForType(InputStream inputStream, String string) {
        return null;
    }

    protected ImageDecoder getDecoder(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            inputStream.mark(6);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            inputStream.read();
            inputStream.read();
            inputStream.reset();
            inputStream.mark(-1);
            if (n == 71 && n2 == 73 && n3 == 70 && n4 == 56) {
                return new GifImageDecoder(this, inputStream);
            }
            if (n == 255 && n2 == 216 && n3 == 255) {
                return new JPEGImageDecoder(this, inputStream);
            }
            if (n == 35 && n2 == 100 && n3 == 101 && n4 == 102) {
                return new XbmImageDecoder(this, inputStream);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    /*
     * Exception decompiling
     */
    public void doFetch() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateFromStore(Thread thread) {
        ConsumerQueue consumerQueue;
        PixelStore pixelStore;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            pixelStore = this.pixelstore;
            if (pixelStore == null) {
                return false;
            }
            consumerQueue = this.consumers;
        }
        while (true) {
            InputStreamImageSource inputStreamImageSource2;
            block18: {
                if (consumerQueue == null) {
                    return true;
                }
                inputStreamImageSource2 = this;
                synchronized (inputStreamImageSource2) {
                    block17: {
                        if (consumerQueue.feeder == null) {
                            if (!this.checkSecurity(consumerQueue.securityContext, true)) {
                                this.errorConsumer(consumerQueue);
                            } else {
                                consumerQueue.feeder = thread;
                            }
                        }
                        if (consumerQueue.feeder != thread) {
                            consumerQueue = consumerQueue.next;
                            inputStreamImageSource = null;
                            break block17;
                        }
                        break block18;
                    }
                    continue;
                }
            }
            if (!pixelStore.replay(this, consumerQueue.consumer)) {
                return false;
            }
            inputStreamImageSource2 = this;
            synchronized (inputStreamImageSource2) {
                consumerQueue = consumerQueue.next;
            }
        }
    }

    private synchronized void setDecoder(ImageDecoder imageDecoder, Thread thread) {
        ConsumerQueue consumerQueue = this.consumers;
        while (consumerQueue != null) {
            if (consumerQueue.feeder == thread) {
                if (!this.checkSecurity(consumerQueue.securityContext, true)) {
                    this.errorConsumer(consumerQueue);
                } else {
                    consumerQueue.decoder = imageDecoder;
                }
            }
            consumerQueue = consumerQueue.next;
        }
        if (this.latestFetcher == thread) {
            this.decoder = imageDecoder;
        }
    }

    private synchronized int latchConsumers(Thread thread) {
        this.latestFetcher = thread;
        this.awaitingFetch = false;
        ConsumerQueue consumerQueue = this.consumers;
        int n = 0;
        while (consumerQueue != null) {
            if (consumerQueue.feeder == null) {
                if (!this.checkSecurity(consumerQueue.securityContext, true)) {
                    this.errorConsumer(consumerQueue);
                } else {
                    consumerQueue.feeder = thread;
                    ++n;
                }
            }
            consumerQueue = consumerQueue.next;
        }
        return n;
    }

    private synchronized void unlatchConsumers(ImageDecoder imageDecoder, Thread thread) {
        ConsumerQueue consumerQueue = this.consumers;
        ConsumerQueue consumerQueue2 = null;
        while (consumerQueue != null) {
            if (consumerQueue.feeder == thread) {
                if (consumerQueue2 == null) {
                    this.consumers = consumerQueue.next;
                } else {
                    consumerQueue2.next = consumerQueue.next;
                }
            } else {
                if (consumerQueue.feeder == null) {
                    this.startProduction();
                }
                consumerQueue2 = consumerQueue;
            }
            consumerQueue = consumerQueue.next;
        }
    }

    private ConsumerQueue nextConsumer(ConsumerQueue consumerQueue, Thread thread) {
        ImageDecoder imageDecoder = null;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            consumerQueue = consumerQueue == null ? this.consumers : consumerQueue.next;
            while (consumerQueue != null) {
                if (consumerQueue.interested) {
                    if (consumerQueue.feeder == thread) {
                        ConsumerQueue consumerQueue2 = consumerQueue;
                        Object var6_8 = null;
                        return consumerQueue2;
                    }
                    if (consumerQueue.feeder == null && this.latestFetcher == thread) {
                        imageDecoder = this.decoder;
                        break;
                    }
                }
                consumerQueue = consumerQueue.next;
            }
        }
        if (consumerQueue != null) {
            block19: {
                if (imageDecoder != null && imageDecoder.catchupConsumer(this, consumerQueue.consumer)) {
                    inputStreamImageSource = this;
                    synchronized (inputStreamImageSource) {
                        if (consumerQueue.interested) {
                            if (!this.checkSecurity(consumerQueue.securityContext, true)) {
                                this.errorConsumer(consumerQueue);
                            } else {
                                consumerQueue.feeder = thread;
                                consumerQueue.decoder = imageDecoder;
                                ConsumerQueue consumerQueue3 = consumerQueue;
                                Object var6_9 = null;
                                return consumerQueue3;
                            }
                        }
                        break block19;
                    }
                }
                InputStreamImageSource inputStreamImageSource2 = this;
                synchronized (inputStreamImageSource2) {
                    if (this.latestFetcher == thread) {
                        this.latestFetcher = null;
                        this.decoder = null;
                    }
                    this.startProduction();
                }
            }
            consumerQueue = this.nextConsumer(consumerQueue, thread);
        }
        return consumerQueue;
    }

    synchronized void flush() {
        ConsumerQueue consumerQueue = this.consumers;
        this.consumers = null;
        while (consumerQueue != null) {
            block4: {
                consumerQueue.interested = false;
                try {
                    if (consumerQueue.feeder == null) break block4;
                    consumerQueue.feeder.interrupt();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    break;
                }
            }
            if (consumerQueue.decoder != null) {
                consumerQueue.decoder.close();
            }
            consumerQueue = consumerQueue.next;
        }
        this.pixelstore = null;
    }

    synchronized void setPixelStore(PixelStore pixelStore) {
        this.pixelstore = pixelStore;
    }

    int setDimensions(int n, int n2) {
        ConsumerQueue consumerQueue = null;
        Thread thread = Thread.currentThread();
        int n3 = 0;
        while ((consumerQueue = this.nextConsumer(consumerQueue, thread)) != null) {
            consumerQueue.consumer.setDimensions(n, n2);
            ++n3;
        }
        return n3;
    }

    int setProperties(Hashtable hashtable) {
        ConsumerQueue consumerQueue = null;
        Thread thread = Thread.currentThread();
        int n = 0;
        while ((consumerQueue = this.nextConsumer(consumerQueue, thread)) != null) {
            consumerQueue.consumer.setProperties(hashtable);
            ++n;
        }
        return n;
    }

    int setColorModel(ColorModel colorModel) {
        ConsumerQueue consumerQueue = null;
        Thread thread = Thread.currentThread();
        int n = 0;
        while ((consumerQueue = this.nextConsumer(consumerQueue, thread)) != null) {
            consumerQueue.consumer.setColorModel(colorModel);
            ++n;
        }
        return n;
    }

    int setHints(int n) {
        ConsumerQueue consumerQueue = null;
        Thread thread = Thread.currentThread();
        int n2 = 0;
        while ((consumerQueue = this.nextConsumer(consumerQueue, thread)) != null) {
            consumerQueue.consumer.setHints(n);
            ++n2;
        }
        return n2;
    }

    int setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        ConsumerQueue consumerQueue = null;
        Thread thread = Thread.currentThread();
        if (thread.getPriority() > 5) {
            SecurityManager.enablePrivilege("UniversalThreadAccess");
            thread.setPriority(5);
            SecurityManager.revertPrivilege();
        }
        int n7 = 0;
        while ((consumerQueue = this.nextConsumer(consumerQueue, thread)) != null) {
            consumerQueue.consumer.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
            ++n7;
        }
        return n7;
    }

    int setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        ConsumerQueue consumerQueue = null;
        Thread thread = Thread.currentThread();
        if (thread.getPriority() > 5) {
            SecurityManager.enablePrivilege("UniversalThreadAccess");
            thread.setPriority(5);
            SecurityManager.revertPrivilege();
        }
        int n7 = 0;
        while ((consumerQueue = this.nextConsumer(consumerQueue, thread)) != null) {
            consumerQueue.consumer.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
            ++n7;
        }
        return n7;
    }

    int imageComplete(int n) {
        ConsumerQueue consumerQueue = null;
        Thread thread = Thread.currentThread();
        int n2 = 0;
        while ((consumerQueue = this.nextConsumer(consumerQueue, thread)) != null) {
            consumerQueue.consumer.imageComplete(n);
            ++n2;
        }
        return n2;
    }
}

