/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.PixelStore8;

public class GifImageDecoder
extends ImageDecoder {
    private static final boolean verbose = false;
    private static final int IMAGESEP = 44;
    private static final int EXBLOCK = 33;
    private static final int EX_GRAPHICS_CONTROL = 249;
    private static final int EX_COMMENT = 254;
    private static final int EX_APPLICATION = 255;
    private static final int TERMINATOR = 59;
    private static final int TRANSPARENCYMASK = 1;
    private static final int INTERLACEMASK = 64;
    private static final int COLORMAPMASK = 128;
    private static final int DISPOSAL_NONE = 0;
    private static final int DISPOSAL_SAVE = 1;
    private static final int DISPOSAL_BGCOLOR = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static IndexColorModel trans_model;
    PixelStore8 store;
    boolean cancatchup = true;
    int num_global_colors;
    byte[] global_colormap;
    int trans_pixel = -1;
    IndexColorModel global_model;
    Hashtable props = new Hashtable();
    byte[] saved_image;
    IndexColorModel saved_model;
    int disposal_method;
    int global_width;
    int global_height;
    int global_bgpixel;
    boolean firstframe = true;
    int nloops = -1;
    int delay = -1;
    private static final int normalflags = 30;
    private static final int interlaceflags = 29;
    private short[] prefix = new short[4096];
    private byte[] suffix = new byte[4096];
    private byte[] outCode = new byte[4097];

    public GifImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }

    public synchronized boolean catchupConsumer(InputStreamImageSource inputStreamImageSource, ImageConsumer imageConsumer) {
        return this.cancatchup && (this.store == null || this.store.replay(inputStreamImageSource, imageConsumer));
    }

    public synchronized void makeStore(int n, int n2) {
        if (this.cancatchup) {
            this.store = new PixelStore8(n, n2);
        }
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    private int readBytes(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            try {
                int n3 = this.input.read(byArray, n, n2);
                if (n3 < 0) break;
                n += n3;
                n2 -= n3;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return n2;
    }

    private static final int ExtractByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    private static final int ExtractWord(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void produceImage() throws IOException, ImageFormatException {
        block47: {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    try {
                                        this.readHeader();
                                        int n = 0;
                                        int n2 = 0;
                                        block25: while (true) {
                                            int n3 = this.input.read();
                                            switch (n3) {
                                                case 33: {
                                                    n3 = this.input.read();
                                                    switch (n3) {
                                                        case 249: {
                                                            byte[] byArray = new byte[6];
                                                            if (this.readBytes(byArray, 0, 6) != 0) {
                                                                Object var2_10 = null;
                                                                break block41;
                                                            }
                                                            if (byArray[0] != 4) break block42;
                                                            if (byArray[5] != 0) {
                                                                break block42;
                                                            } else {
                                                                this.delay = GifImageDecoder.ExtractWord(byArray, 2) * 10;
                                                                if (this.delay > 0) {
                                                                    this.cancatchup = false;
                                                                    this.store = null;
                                                                    ImageFetcher.startingAnimation();
                                                                }
                                                                this.disposal_method = byArray[1] >> 2 & 7;
                                                                if ((byArray[1] & 1) != 0) {
                                                                    this.trans_pixel = GifImageDecoder.ExtractByte(byArray, 4);
                                                                    continue block25;
                                                                }
                                                                this.trans_pixel = -1;
                                                                continue block25;
                                                            }
                                                        }
                                                        default: {
                                                            int n4;
                                                            boolean bl = false;
                                                            String string = "";
                                                            while ((n4 = this.input.read()) > 0) {
                                                                byte[] byArray = new byte[n4];
                                                                if (this.readBytes(byArray, 0, n4) != 0) {
                                                                    break block43;
                                                                }
                                                                if (n3 == 254) {
                                                                    string = String.valueOf(string) + new String(byArray, 0);
                                                                    continue;
                                                                }
                                                                if (n3 != 255) continue;
                                                                if (bl) {
                                                                    if (n4 == 3 && byArray[0] == 1) {
                                                                        this.nloops = GifImageDecoder.ExtractWord(byArray, 1);
                                                                    } else {
                                                                        bl = false;
                                                                    }
                                                                }
                                                                if (!"NETSCAPE2.0".equals(new String(byArray, 0))) continue;
                                                                bl = true;
                                                            }
                                                            if (n3 == 254) {
                                                                this.props.put("comment", string);
                                                            }
                                                            if (!bl) continue block25;
                                                            this.input.mark(1000000);
                                                            this.cancatchup = false;
                                                            this.store = null;
                                                            ImageFetcher.startingAnimation();
                                                            continue block25;
                                                        }
                                                        case -1: {
                                                            break;
                                                        }
                                                    }
                                                    break block44;
                                                }
                                                case 44: {
                                                    try {
                                                        if (!this.readImage(n == 0)) {
                                                            this.cancatchup = false;
                                                            break block45;
                                                        }
                                                    }
                                                    catch (Exception exception) {
                                                        Object var2_15 = null;
                                                        try {
                                                            this.input.close();
                                                            return;
                                                        }
                                                        catch (IOException iOException) {}
                                                        return;
                                                    }
                                                    ++n2;
                                                    ++n;
                                                    this.firstframe = false;
                                                    continue block25;
                                                }
                                                default: {
                                                    if (n2 != 0) break;
                                                    break block46;
                                                }
                                                case 59: 
                                            }
                                            if (this.nloops != 0 && this.nloops-- < 0) break;
                                            try {
                                                this.input.reset();
                                                this.saved_image = null;
                                                this.saved_model = null;
                                                this.firstframe = true;
                                                n2 = 0;
                                                continue;
                                            }
                                            catch (IOException iOException) {}
                                            break;
                                        }
                                        if (this.store != null) {
                                            this.store.imageComplete();
                                            if (this.store.getBitState() != 2) {
                                                this.source.setPixelStore(this.store);
                                            }
                                        }
                                        this.source.imageComplete(3);
                                        break block47;
                                    }
                                    catch (Throwable throwable) {
                                        Object var2_18 = null;
                                        try {}
                                        catch (IOException iOException) {
                                            throw throwable;
                                        }
                                        this.input.close();
                                        throw throwable;
                                    }
                                }
                                try {}
                                catch (IOException iOException) {}
                                this.input.close();
                                return;
                            }
                            Object var2_11 = null;
                            try {}
                            catch (IOException iOException) {}
                            this.input.close();
                            return;
                        }
                        Object var2_12 = null;
                        try {}
                        catch (IOException iOException) {}
                        this.input.close();
                        return;
                    }
                    Object var2_13 = null;
                    try {}
                    catch (IOException iOException) {}
                    this.input.close();
                    return;
                }
                Object var2_14 = null;
                try {}
                catch (IOException iOException) {}
                this.input.close();
                return;
            }
            Object var2_16 = null;
            try {}
            catch (IOException iOException) {}
            this.input.close();
            return;
        }
        Object var2_17 = null;
        try {}
        catch (IOException iOException) {}
        this.input.close();
        return;
    }

    private void readHeader() throws IOException, ImageFormatException {
        byte[] byArray = new byte[13];
        if (this.readBytes(byArray, 0, 13) != 0) {
            throw new IOException();
        }
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70) {
            GifImageDecoder.error("not a GIF file.");
        }
        this.global_width = GifImageDecoder.ExtractWord(byArray, 6);
        this.global_height = GifImageDecoder.ExtractWord(byArray, 8);
        int n = GifImageDecoder.ExtractByte(byArray, 10);
        if ((n & 0x80) == 0) {
            GifImageDecoder.error("no global colormap in GIF file.");
        }
        this.num_global_colors = 1 << (n & 7) + 1;
        this.global_bgpixel = GifImageDecoder.ExtractByte(byArray, 11);
        if (byArray[12] != 0) {
            this.props.put("aspectratio", String.valueOf((double)(GifImageDecoder.ExtractByte(byArray, 12) + 15) / 64.0));
        }
        this.global_colormap = new byte[this.num_global_colors * 3];
        if (this.readBytes(this.global_colormap, 0, this.num_global_colors * 3) != 0) {
            throw new IOException();
        }
    }

    private native boolean parseImage(int var1, int var2, int var3, int var4, boolean var5, int var6, byte[] var7, byte[] var8, IndexColorModel var9);

    /*
     * Unable to fully structure code
     */
    private int sendPixels(int var1_1, int var2_2, int var3_3, int var4_4, byte[] var5_5, ColorModel var6_6) {
        if (var2_2 < 0) {
            var4_4 += var2_2;
            var2_2 = 0;
        }
        if (var2_2 + var4_4 > this.global_height) {
            var4_4 = this.global_height - var2_2;
        }
        if (var4_4 <= 0) {
            return 1;
        }
        if (var1_1 < 0) {
            var7_7 = -var1_1;
            var3_3 += var1_1;
            var9_8 = 0;
        } else {
            var7_7 = 0;
            var9_8 = var1_1;
        }
        if (var9_8 + var3_3 > this.global_width) {
            var3_3 = this.global_width - var9_8;
        }
        if (var3_3 <= 0) {
            return 1;
        }
        var8_9 = var7_7 + var3_3;
        var10_10 = var2_2 * this.global_width + var9_8;
        if (this.trans_pixel < 0 || this.firstframe) ** GOTO lbl54
        if (this.saved_image != null && this.saved_model == var6_6) {
            var11_11 = var7_7;
            while (var11_11 < var8_9) {
                var12_13 = var5_5[var11_11];
                if ((var12_13 & 255) == this.trans_pixel) {
                    var5_5[var11_11] = this.saved_image[var10_10];
                } else if (this.disposal_method == 1) {
                    this.saved_image[var10_10] = var12_13;
                }
                ++var11_11;
                ++var10_10;
            }
        } else {
            var11_12 = -1;
            var12_14 = 1;
            var13_15 = var7_7;
            while (var13_15 < var8_9) {
                var14_16 = var5_5[var13_15];
                if ((var14_16 & 255) == this.trans_pixel) {
                    if (var11_12 >= 0 && (var12_14 = this.source.setPixels(var1_1 + var11_12, var2_2, var13_15 - var11_12, var4_4, var6_6, var5_5, var11_12, 0)) == 0) break;
                    var11_12 = -1;
                } else {
                    if (var11_12 < 0) {
                        var11_12 = var13_15;
                    }
                    if (this.disposal_method == 1) {
                        this.saved_image[var10_10] = var14_16;
                    }
                }
                ++var13_15;
                ++var10_10;
            }
            if (var11_12 >= 0) {
                var12_14 = this.source.setPixels(var1_1 + var11_12, var2_2, var8_9 - var11_12, var4_4, var6_6, var5_5, var11_12, 0);
            }
            return var12_14;
lbl54:
            // 1 sources

            if (this.disposal_method == 1) {
                System.arraycopy(var5_5, var7_7, this.saved_image, var10_10, var3_3);
            }
        }
        var11_11 = this.source.setPixels(var9_8, var2_2, var3_3, var4_4, var6_6, var5_5, var7_7, 0);
        if (this.store != null && this.store.setPixels(var9_8, var2_2, var3_3, var4_4, var5_5, var7_7, 0)) {
            ++var11_11;
        }
        return var11_11;
    }

    private boolean readImage(boolean bl) throws IOException {
        byte[] byArray;
        int n;
        long l = 0L;
        byte[] byArray2 = new byte[259];
        if (this.readBytes(byArray2, 0, 10) != 0) {
            throw new IOException();
        }
        int n2 = GifImageDecoder.ExtractWord(byArray2, 0);
        int n3 = GifImageDecoder.ExtractWord(byArray2, 2);
        int n4 = GifImageDecoder.ExtractWord(byArray2, 4);
        int n5 = GifImageDecoder.ExtractWord(byArray2, 6);
        boolean bl2 = (byArray2[8] & 0x40) != 0;
        IndexColorModel indexColorModel = this.global_model;
        if ((byArray2[8] & 0x80) != 0) {
            n = 1 << (byArray2[8] & 7) + 1;
            byArray = new byte[n * 3];
            byArray[0] = byArray2[9];
            if (this.readBytes(byArray, 1, n * 3 - 1) != 0) {
                throw new IOException();
            }
            if (this.readBytes(byArray2, 9, 1) != 0) {
                throw new IOException();
            }
            indexColorModel = new IndexColorModel(8, n, byArray, 0, false, this.trans_pixel);
        } else if (indexColorModel == null || this.trans_pixel != indexColorModel.getTransparentPixel()) {
            this.global_model = indexColorModel = new IndexColorModel(8, this.num_global_colors, this.global_colormap, 0, false, this.trans_pixel);
        }
        if (bl) {
            this.makeStore(this.global_width, this.global_height);
            if (this.store != null) {
                this.store.setProperties(this.props);
                this.store.setColorModel(indexColorModel);
            }
            this.source.setDimensions(this.global_width, this.global_height);
            this.source.setProperties(this.props);
            this.source.setColorModel(indexColorModel);
        } else if (this.store != null && indexColorModel != this.store.getColorModel()) {
            this.cancatchup = false;
            this.store = null;
        }
        if (this.disposal_method == 1 && this.saved_image == null) {
            this.saved_image = new byte[this.global_width * this.global_height];
        }
        n = bl2 ? 29 : 30;
        this.source.setHints(n);
        if (this.store != null) {
            this.store.setHints(n);
        }
        byArray = new byte[n4];
        boolean bl3 = this.parseImage(n2, n3, n4, n5, bl2, GifImageDecoder.ExtractByte(byArray2, 9), byArray2, byArray, indexColorModel);
        if (bl3) {
            this.source.imageComplete(2);
            if (this.delay > 0) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            if (n2 < 0) {
                n4 += n2;
                n2 = 0;
            }
            if (n2 + n4 > this.global_width) {
                n4 = this.global_width - n2;
            }
            if (n4 <= 0) {
                this.disposal_method = 0;
            } else {
                if (n3 < 0) {
                    n5 += n3;
                    n3 = 0;
                }
                if (n3 + n5 > this.global_height) {
                    n5 = this.global_height - n3;
                }
                if (n5 <= 0) {
                    this.disposal_method = 0;
                }
            }
            switch (this.disposal_method) {
                case 3: {
                    if (this.saved_image == null) break;
                    this.source.setPixels(n2, n3, n4, n5, (ColorModel)this.saved_model, this.saved_image, n3 * this.global_width + n2, this.global_width);
                    if (this.store == null) break;
                    this.store.setPixels(n2, n3, n4, n5, this.saved_image, n3 * this.global_width + n2, this.global_width);
                    break;
                }
                case 2: {
                    byte by;
                    if (indexColorModel.getTransparentPixel() < 0) {
                        this.cancatchup = false;
                        this.store = null;
                        indexColorModel = trans_model;
                        if (indexColorModel == null) {
                            trans_model = indexColorModel = new IndexColorModel(8, 1, new byte[4], 0, true);
                        }
                        by = 0;
                    } else {
                        by = (byte)indexColorModel.getTransparentPixel();
                    }
                    int n6 = 0;
                    while (n6 < n4) {
                        byArray[n6] = by;
                        ++n6;
                    }
                    this.source.setPixels(n2, n3, n4, n5, (ColorModel)indexColorModel, byArray, 0, 0);
                    if (this.store == null) break;
                    this.store.setPixels(n2, n3, n4, n5, byArray, 0, 0);
                    break;
                }
                case 1: {
                    this.saved_model = indexColorModel;
                }
            }
        }
        return bl3;
    }
}

