/*
 * Decompiled with CFR 0.152.
 */
package netscape.net;

public class SSLSecurityStatus {
    int status;
    String cipher;
    int sessionKeySize;
    int sessionSecretSize;
    String issuer;
    String subject;
    String serialNumber;
    public final int STATUS_NOOPT = -1;
    public final int STATUS_OFF = 0;
    public final int STATUS_ON_HIGH = 1;
    public final int STATUS_ON_LOW = 2;
    public final int STATUS_FORTEZZA = 3;

    public SSLSecurityStatus(int n, String string, int n2, int n3, String string2, String string3, String string4) {
        this.status = n;
        this.cipher = string;
        this.sessionKeySize = n2;
        this.sessionSecretSize = n3;
        this.issuer = "no certificate".equals(string2) ? null : string2;
        this.subject = "no certificate".equals(string3) ? null : string3;
        this.serialNumber = string4;
    }

    public boolean isSecurityOn() {
        return this.status > 0;
    }

    public int getSecurityStatus() {
        return this.status;
    }

    public String getCipher() {
        return this.cipher;
    }

    public int getSessionKeySize() {
        return this.sessionKeySize;
    }

    public int getSessionSecretSize() {
        return this.sessionSecretSize;
    }

    public String getRemoteIssuer() {
        return this.issuer;
    }

    public String getRemoteSubject() {
        return this.subject;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String toString() {
        String string;
        switch (this.status) {
            case -1: {
                string = "NOOPT";
                break;
            }
            case 0: {
                string = "OFF";
                break;
            }
            case 1: {
                string = "ON HIGH";
                break;
            }
            case 2: {
                string = "ON LOW";
                break;
            }
            case 3: {
                string = "FORTEZZA";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return "Status: " + string + "\n" + "Cipher: " + this.cipher + "\n" + "Session key size: " + this.sessionKeySize + "\n" + "Session secret size: " + this.sessionSecretSize + "\n" + "Issuer: " + this.issuer + "\n" + "Subject: " + this.subject + "\n" + "Serial number: " + this.serialNumber + "\n";
    }
}

