/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.peer.MenuPeer;
import java.util.Vector;

public class Menu
extends MenuItem
implements MenuContainer {
    Vector items = new Vector();
    boolean tearOff;
    boolean isHelpMenu;

    public Menu(String string) {
        this(string, false);
    }

    public Menu(String string, boolean bl) {
        super(string);
        this.tearOff = bl;
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = Toolkit.getDefaultToolkit().createMenu(this);
        }
        int n = this.countItems();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = this.getItem(n2);
            menuItem.parent = this;
            menuItem.addNotify();
            ++n2;
        }
    }

    public synchronized void removeNotify() {
        int n = this.countItems();
        int n2 = 0;
        while (n2 < n) {
            this.getItem(n2).removeNotify();
            ++n2;
        }
        super.removeNotify();
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int countItems() {
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        return (MenuItem)this.items.elementAt(n);
    }

    public synchronized MenuItem add(MenuItem menuItem) {
        if (menuItem.parent != null) {
            menuItem.parent.remove(menuItem);
        }
        this.items.addElement(menuItem);
        menuItem.parent = this;
        if (this.peer != null) {
            menuItem.addNotify();
            ((MenuPeer)this.peer).addItem(menuItem);
        }
        return menuItem;
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    public void addSeparator() {
        this.add("-");
    }

    public synchronized void remove(int n) {
        MenuItem menuItem = this.getItem(n);
        this.items.removeElementAt(n);
        MenuPeer menuPeer = (MenuPeer)this.peer;
        if (menuPeer != null) {
            menuItem.removeNotify();
            menuItem.parent = null;
            menuPeer.delItem(n);
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        int n = this.items.indexOf(menuComponent);
        if (n >= 0) {
            this.remove(n);
        }
    }
}

