/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Window;
import java.awt.peer.FramePeer;

public class Frame
extends Window
implements MenuContainer {
    public static final int DEFAULT_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    String title = "Untitled";
    Image icon;
    MenuBar menuBar;
    boolean resizable = true;
    Image cursorImage;
    int cursorType = 0;
    Color cursorFg;
    Color cursorBg;

    public Frame() {
        this.visible = false;
        this.setLayout(new BorderLayout());
    }

    public Frame(String string) {
        this();
        this.title = string;
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createFrame(this);
        }
        if (this.menuBar != null) {
            this.menuBar.addNotify();
            ((FramePeer)this.peer).setMenuBar(this.menuBar);
        }
        super.addNotify();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setTitle(string);
        }
    }

    public Image getIconImage() {
        return this.icon;
    }

    public void setIconImage(Image image) {
        this.icon = image;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setIconImage(image);
        }
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public synchronized void setMenuBar(MenuBar menuBar) {
        if (this.menuBar == menuBar) {
            return;
        }
        if (menuBar.parent != null) {
            menuBar.parent.remove(menuBar);
        }
        if (this.menuBar != null) {
            this.remove(this.menuBar);
        }
        this.menuBar = menuBar;
        this.menuBar.parent = this;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            this.menuBar.addNotify();
            framePeer.setMenuBar(this.menuBar);
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        if (menuComponent == this.menuBar) {
            FramePeer framePeer = (FramePeer)this.peer;
            if (framePeer != null) {
                this.menuBar.removeNotify();
                this.menuBar.parent = null;
                framePeer.setMenuBar(null);
            }
            this.menuBar = null;
        }
    }

    public synchronized void dispose() {
        if (this.menuBar != null) {
            this.remove(this.menuBar);
            this.menuBar = null;
        }
        super.dispose();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setResizable(bl);
        }
    }

    public void setCursor(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        this.cursorType = n;
        if (this.peer != null) {
            ((FramePeer)this.peer).setCursor(n);
        }
    }

    public int getCursorType() {
        return this.cursorType;
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.resizable) {
            string = String.valueOf(string) + ",resizable";
        }
        if (this.title != null) {
            string = String.valueOf(string) + ",title=" + this.title;
        }
        return string;
    }
}

