/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.io.Serializable;

public abstract class FontMetrics
implements Serializable {
    protected Font font;

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLeading() {
        return 0;
    }

    public int getAscent() {
        return this.font.getSize();
    }

    public int getDescent() {
        return 0;
    }

    public int getHeight() {
        return this.getLeading() + this.getAscent() + this.getDescent();
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int charWidth(int n) {
        return this.charWidth((char)n);
    }

    public int charWidth(char c) {
        if (c < '\u0100') {
            return this.getWidths()[c];
        }
        char[] cArray = new char[]{c};
        return this.charsWidth(cArray, 0, 1);
    }

    public int stringWidth(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.charsWidth(cArray, 0, n);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.stringWidth(new String(cArray, n, n2));
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        return this.stringWidth(new String(byArray, 0, n, n2));
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        char c = '\u0000';
        while (c < '\u0100') {
            nArray[c] = this.charWidth(c);
            c = (char)(c + '\u0001');
        }
        return nArray;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[font=" + this.getFont() + "ascent=" + this.getAscent() + ", descent=" + this.getDescent() + ", height=" + this.getHeight() + "]";
    }
}

