/**************************************************************************************************

    SPELLCHK
    Spelling checker.

    Written and copyright by Brian J Quinion 1995.

    Version for Microsoft Windows.
    Version:  3.00
    Date:     13 July 1995
    Module:   SPELL.H

**************************************************************************************************/

//#if !defined(__DIR_H)
//#include <dir.h>
//#endif

#if !defined(__WINDOWS_H)
#include <windows.h>
#endif

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */

/*************************************************************************

    There are two ways to access the DLLs.  This first method is the
full interface It is quite complicated but allows full control of the
DLL.  Its design is based on that used for the common dialog boxes.
The functions mentioned are contained in spellch3.dll.

    See the developers help file and the example code.

***************************************************************************/

#define MAXPATH				   128
#define MAXDICTITLE            20
#define MAXSPELL               255
typedef WORD HUNDO;

// Custom dictionaries
    // Structure
    typedef struct
    {
        char            DicFile[MAXPATH];
        char            DicTitle[MAXDICTITLE];
        char            DicLanguage[13];
        BYTE            Options;
            #define CD_READONLY        1
            #define CD_DISABLED        2
            #define CD_CHANGED         4
            #define CD_BYLANGUAGE      8
    // Reserved
        HGLOBAL         hDic;
        LPSTR           lpDic;
        WORD            Size;
    } CUSTDIC, far * LPCUSTDIC;


// Main options block
    // Structure
    typedef struct
    {
        WORD                wSizeOfBlock;
        HWND                hWndParent,
                            hWndDlg;
        DWORD               CheckWordOptions;
            #define CWO_ALLOWCHANGE            1
            #define CWO_AUTOSUGGEST            2
            #define CWO_SUGGESTCUST            4
            #define CWO_NOOPTIONS              8
            #define CWO_UNDO                   16
            #define CWO_NOHELP                 32

            #define CWO_USEMAINHOOK            64
            #define CWO_USEOPTIONSHOOK         128
            #define CWO_USECUSTOMMAINDLG       256
            #define CWO_USECUSTOMOPTIONSDLG    512
            #define CWO_SENDMSGTOMAINHOOK      1024
            #define CWO_SENDMSGTOOPTIONSHOOK   2048
            #define CWO_CHECKMULTIPLE          4096
            #define CWO_DONTUSEFULL            8192

            #define CWO_USEASCIIACCENTS        16384
            #define CWO_PUNCTUATIONCANBREAK    (32768L)
            #define CWO_DEBUGLOG               (65536L)

        char                szLanguage[13];
        HGLOBAL             hCustomDics;
        BYTE                NumCustom;
        BYTE                CurCustom;

        HFILE               hDebugLog;

        HINSTANCE           hInstance;
        DLGPROC             fpMainHook;
        DLGPROC             fpOptionsHook;
        LPSTR               lpMainDlg;
        LPSTR               lpOptionsDlg;

        DWORD               dwCustData;
        DWORD               dwCustData2;

        char                ToCheck[MAXSPELL];
        char                Changed[MAXSPELL];
        BOOL                bCurWordChanged;

        char                PrevWord[MAXSPELL];
        WORD                wFunctionType;
            #define WORD_NOTFOUND             1
            #define WORD_REPEATED             2

        BYTE                CurPosCheck;
        BYTE                CurPosChanged;
        char                CurWord[MAXSPELL];

// All private - will be marked as reserved on final
        HFILE               hDic;
        HGLOBAL             hIndexBlock;
        LPSTR               lpLoadedBlock;
        LPSTR               lpIndexBlock;
        HGLOBAL             hWordsBlock;
        DWORD               dwWordsSize;
        BOOL                bExpandWordsBlock;
        HGLOBAL             hIgnoreAll;
        LPSTR               lpIgnoreAll;
        LPCUSTDIC           lpCustomDics;
    } CHECKWORD, FAR * LPCHECKWORD;

WORD WINAPI SPCHK_Version(void);
void WINAPI SPCHK_GetValidLettersBlock(LPSTR);
BOOL WINAPI SPCHK_CheckWord(LPCHECKWORD);
void WINAPI SPCHK_Options(LPCHECKWORD);
    #define SPELL_GETNEXT                (WM_USER+240)
    #define SPELL_WORDNOTFOUND           (WM_USER+241)
    #define SPELL_WORDREPEATED           (WM_USER+251)
    #define SPELL_WORDCHANGED            (WM_USER+242)
    #define SPELL_CANUNDO                (WM_USER+243)
    #define SPELL_STOREUNDO              (WM_USER+244)
        #define UNDO_FAIL           0
        #define UNDO_IGNORE         1
        #define UNDO_IGNOREALL      2
        #define UNDO_CHANGE         3
        #define UNDO_ADD            4
        // >= 4 means an ADD
    #define SPELL_UNDOLAST               (WM_USER+245)
    #define SPELL_GETCUSTOMDEFPATH       (WM_USER+246)
    #define SPELL_LANGUAGECHANGED        (WM_USER+247)
    #define SPELL_HELPMAIN               (WM_USER+248)
    #define SPELL_HELPOPTIONS            (WM_USER+249)
    #define SPELL_HELPEDITDIC            (WM_USER+250)

/************************************************************************************************

    This second method is far simpler, and simply allow your program to call the existing code
    as if the keyboard hot key had been pressed (in fact exactly the same routines are used).
    The functions mentioned are contained in spelledt.dll. 

    See the help file and the exapmle code.

************************************************************************************************/
WORD CALLBACK SPEDT_Version(void);
BOOL CALLBACK SPEDT_CheckEdit(HWND);
BOOL CALLBACK SPEDT_CheckEditCustom(HWND, HINSTANCE, LPSTR, LPSTR);

BOOL CALLBACK SPEDT_CheckEditClip(HWND);
WORD CALLBACK SPEDT_CheckClipboard(HWND);

WORD CALLBACK SPEDT_CheckGlobal(HWND, HGLOBAL far *, WORD, HWND);
WORD CALLBACK SPEDT_CheckGlobalCustom(HWND, HGLOBAL far *, WORD, HINSTANCE, LPSTR, LPSTR, HWND);
    #define CHECKGLOBAL_UNRECOVERABLEERROR  1
    #define CHECKGLOBAL_FORMATNOTKNOWN      2
    #define CHECKGLOBAL_CHANGED             4
    #define CHECKGLOBAL_FINISHED            8

void CALLBACK SPEDT_SetupBox(HWND);
void CALLBACK SPEDT_SetupBoxLimited(HWND);
void CALLBACK SPEDT_SetupCustom(HWND, HINSTANCE, LPSTR);

BOOL CALLBACK SPEDT_GetParameter(WORD, LPVOID);
BOOL CALLBACK SPEDT_SetParameter(WORD, LPVOID);
    #define SPEDT_LANGUAGE              1
    #define SPEDT_XPOS                  2
    #define SPEDT_YPOS                  3
    #define SPEDT_STOREWINPOS           4
    #define SPEDT_AUTOSUGGEST           5
    #define SPEDT_SUGGESTFROMCUSTOM     6
    #define SPEDT_ASCIITOANSI           7
    #define SPEDT_IGNORELINES           8
    #define SPEDT_DOAFTER               9
    #define SPEDT_ONPUNCTUATION         10
    #define SPEDT_DEBUG                 11
    #define SPEDT_PROGRESSINDICATOR     12

#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif  /* __cplusplus */
