/* rexx */
/*
 * This is slightly different from the method employed by the
 * standard c-client library linkage.
 *
 * Instead of generating a "linkage.c" which links the mail
 * drivers by reference to their definitions in the c-client
 * library, we instead call the os2_cclient_link() function
 * which does that on our behalf. This way, the drivers
 * themselves remain internal to the library and there is
 * no need to worry about having to export the data from
 * the c-client .dll.
 *
 * In the linkage.[ch] files, we simply specify a prototype
 * and generate a call to the exported init function.
 */
'@echo off'
/* erase old driver linkage */
'rm -f linkage.* os2_link.*'
today=date('N')
parse arg default args
n=words(args)
h_file='linkage.h'
c_file='os2_link.c'
call stream h_file, 'C', 'open write'
call stream c_file, 'C', 'open write'
call lineout h_file, '/* c-client drivers for OS/2 -' today '*/'
call lineout h_file, ''
call lineout h_file, '#define DEFAULTPROTO' default'proto'
call lineout h_file, 'extern MAILSTREAM' default'proto;'
call lineout h_file, ''
call lineout h_file, 'struct mm_callbacks {'
call lineout h_file, '  void (*searched)(MAILSTREAM*s,long n);'
call lineout h_file, '  void (*exists)(MAILSTREAM*s,long n);'
call lineout h_file, '  void (*expunged)(MAILSTREAM*s,long n);'
call lineout h_file, '  void (*flags)(MAILSTREAM*s,long n);'
call lineout h_file, '  void (*mailbox)(char *s);'
call lineout h_file, '  void (*bboard)(char *s);'
call lineout h_file, '  void (*log)(char *s, long errflg);'
call lineout h_file, '  void (*dlog)(char *s);'
call lineout h_file, '  void (*login)(char *host,char *user,char *pwd,long trial);'
call lineout h_file, '  void (*notify)(MAILSTREAM *s,char *m,long e);'
call lineout h_file, '  void (*critical)(MAILSTREAM *s);'
call lineout h_file, '  void (*nocritical)(MAILSTREAM *s);'
call lineout h_file, '  long (*diskerror)(MAILSTREAM *s,long err,long serious);'
call lineout h_file, '  void (*fatal)(char *s);'
call lineout h_file, '};'
call lineout h_file, ''
call lineout h_file, 'extern void os2_cclient_link(struct mm_callbacks *mmcb);'
call lineout c_file, ''
call lineout c_file, '  /* link in c-client drivers for OS/2 -' today '*/'
call lineout c_file, ''
call lineout c_file, '#include <stdio.h>'
call lineout c_file, '#include "mail.h" /* this includes linkage.h */'
call lineout c_file, ''
/*
 * Drop in the mm_* callbacks
 */
call lineout c_file, 'static struct mm_callbacks MM;'
call lineout c_file, ''
call lineout c_file, '/* Redirect internal calls to program callbacks */'
call lineout c_file, ''
call lineout c_file, '#ifdef OMF /* only used in an omf .dll */'
call lineout c_file, 'void mm_searched(MAILSTREAM*s,long n)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.searched) MM.searched(s,n);'
call lineout c_file, '}'
call lineout c_file, 'void mm_exists(MAILSTREAM*s,long n)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.exists) MM.exists(s,n);'
call lineout c_file, '}'
call lineout c_file, 'void mm_expunged(MAILSTREAM*s,long n)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.expunged) MM.expunged(s,n);'
call lineout c_file, '}'
call lineout c_file, 'void mm_flags(MAILSTREAM*s,long n)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.flags) MM.flags(s,n);'
call lineout c_file, '}'
call lineout c_file, 'void mm_mailbox(char *s)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.mailbox) MM.mailbox(s);'
call lineout c_file, '}'
call lineout c_file, 'void mm_bboard(char *s)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.bboard) MM.bboard(s);'
call lineout c_file, '}'
call lineout c_file, 'void mm_log(char *s,long e)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.log) MM.log(s, e);'
call lineout c_file, '}'
call lineout c_file, 'void mm_dlog(char *s)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.dlog) MM.dlog(s);'
call lineout c_file, '}'
call lineout c_file, 'void mm_login(char *host,char *user,char *pwd,long trial)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.login) MM.login(host,user,pwd,trial);'
call lineout c_file, '}'
call lineout c_file, 'void mm_notify(MAILSTREAM *s,char *m,long e)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.notify) MM.notify(s, m, e);'
call lineout c_file, '}'
call lineout c_file, 'void mm_critical(MAILSTREAM *s)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.critical) MM.critical(s);'
call lineout c_file, '}'
call lineout c_file, 'void mm_nocritical(MAILSTREAM *s)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.nocritical) MM.nocritical(s);'
call lineout c_file, '}'
call lineout c_file, 'long mm_diskerror(MAILSTREAM *s,long err,long serious)'
call lineout c_file, '{'
call lineout c_file, '  return (MM.diskerror) ? MM.diskerror(s,err,serious) : 0;'
call lineout c_file, '}'
call lineout c_file, 'void mm_fatal(char *s)'
call lineout c_file, '{'
call lineout c_file, '  if (MM.fatal) MM.fatal(s);'
call lineout c_file, '}'
call lineout c_file, '#endif'
call lineout c_file, ''
call lineout c_file, 'void os2_cclient_link(struct mm_callbacks *cb)'
call lineout c_file, '{'
call lineout c_file, '  /* init callbacks */'
call lineout c_file, '  MM = *cb;'
call lineout c_file, ''
do i=1 to n
  arg=word(args,i)
  call lineout h_file, 'extern DRIVER '||arg||'driver;'
  call lineout c_file, '  mail_link(&'arg'driver);	/* link in' arg 'driver */'
  end
call lineout c_file, '}'
call stream h_file, 'C', 'close'
call stream c_file, 'C', 'close'
/*
 * Now, let's generate our linkage.* files for the client apps
 */
c_file='linkage.c'
call stream c_file, 'C', 'open write'
call lineout c_file, '  /* link in c-client drivers for OS/2 -' today '*/'
call lineout c_file, '  {'
call lineout c_file, '    static struct mm_callbacks os2callbacks = {'
call lineout c_file, '      mm_searched,'
call lineout c_file, '      mm_exists,'
call lineout c_file, '      mm_expunged,'
call lineout c_file, '      mm_flags,'
call lineout c_file, '      mm_mailbox,'
call lineout c_file, '      mm_bboard,'
call lineout c_file, '      mm_log,'
call lineout c_file, '      mm_dlog,'
call lineout c_file, '      mm_login,'
call lineout c_file, '      mm_notify,'
call lineout c_file, '      mm_critical,'
call lineout c_file, '      mm_nocritical,'
call lineout c_file, '      mm_diskerror,'
call lineout c_file, '      mm_fatal'
call lineout c_file, '    };'
call lineout c_file, '    os2_cclient_link(&os2callbacks);'
call lineout c_file, '  }'
call stream c_file, 'C', 'close'
exit 0
