# nngrab -- quick news retrieval by keyword
#
# From: James A. Woods (ames!jaw), NASA Ames Research Center
#
# Naturally, you're running fast e?grep (GNU-style) or this is all for
# naught.


trap "rm -f $TMP/nngrab$$" 0 1 2 15

FOLDCASE=""
if [ x"$1" = x"-c" ] ; then
	FOLDCASE="-i"
	shift
fi

if [ ! $# -eq 1 ] ; then
	echo "usage: $0 [-c] keyword-pattern"
	exit 1
fi

KW="`echo "$1" | tr '[A-Z]' '[a-z]'`"

if [ -s $DB/subjects ] ; then
	egrep "^[^:]*:.*${KW}" $DB/subjects |
	sed 's/^\([^:]*\):.*/\1/' |
	uniq > $TMP/nngrab$$

	if [ ! -s $TMP/nngrab$$ ] ; then
		echo "Pattern '$1' not found in any subjects"
		exit
	fi

	$BIN/nn -Q -mxX $FOLDCASE -s/"$1" -G `cat $TMP/nngrab$$`
else
	$BIN/nn -Q -mxX $FOLDCASE -s/"$1" all
fi
