/*****************************************************************************/
/*									     */
/*									     */
/*	CP/M emulator version 0.1					     */
/*									     */
/*	written by Michael Bischoff (mbi@mo.math.nat.tu-bs.de)		     */
/*	June-1994							     */
/*									     */
/*	This file is distributed under the GNU COPYRIGHT		     */
/*	see COPYRIGHT.GNU for Copyright details				     */
/*									     */
/*									     */
/*****************************************************************************/
#include "cpmemu.h"

/* read a character from input */
/* if the character is ctrl-@, it is interpreted as BREAK */

int conin(void) {
    int c;
    if (!(c = getch())) {
	debug = 2;
	longjmp(mainloop, 1);
    }
    return c < 0 ? 0 : c;
}
int getdig(int mindig) {
    int c;
    fflush(stdout);
    do {
	c = conin();
    } while (c < mindig || c > '9');
    putchar(c);
    fflush(stdout);
    return c;
}
char *rdcmdline(int max, int ctrl_c_enable) {
    int i, c;
    static char s[258];

    fflush(stdout);
    max &= 0xff;
    i = 1;      /* number of next character */
loop:
    c = conin();
    if (c < ' ' || c == 0x7f) {
        switch (c) {
	case 3:
	    if (ctrl_c_enable) {
		putch('^');
		putch('C');
		z80regs.pc = BIOS+3;
		s[0] = 0;
		return s;
	    }
	    break;
        case 8:
	case 0x7f:
	    if (i > 1) {
		--i;
		printf("\b \b");
		fflush(stdout);
	    }
	    break;
        case '\n':
        case '\r':
	    s[0] = i-1;
	    if (i <= max)
		s[i] = '\r';
	    return s;
        }
        goto loop;
    } else if (i <= max) {
        s[i++] = c;
        putchar(c);
	fflush(stdout);
    }
    goto loop;
}
unsigned gethex(void) {
    unsigned u;
    char *s;
    fflush(stdout);
    s = rdcmdline(4, 0);
    putchar('\r'); putchar('\n');
    fflush(stdout);
    s[s[0]+1] = '\0';
    if (!s[0])
	return z80regs.pc;
    sscanf(s+1, "%x", &u);
    return u;
}
