/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include "global.h"


/*
 * Global variables
 */


/*********************************************************
 * name:	fillTar
 * description:	Einlesen eine Tar-Files und fuellen eines Folders
 * input:	Folder_Glyph	*folder
 * output:	none
 * author:	Ove Kalkan
 * date:	24.Aug.1993
 *********************************************************/
void	fillTar (Folder_Glyph *folder)
{
	FILE	*pipe;
	char	s[1024];
	char	*got = getPath(folder->dir);

	folder->file_count = 0;
	sprintf(s,"tar -tvf %s",got);
	free(got);
	if (!(pipe = popen(s,"r")))
		return;
	readTar(folder,pipe);
	pclose(pipe);
}


/*********************************************************
 * name:	fillCTar
 * description:	Einlesen eine CTar-Files und fuellen eines Folders
 * input:	Folder_Glyph	*folder
 * output:	none
 * author:	Ove Kalkan
 * date:	24.Aug.1993
 *********************************************************/
void	fillCTar (Folder_Glyph *folder)
{
	FILE	*pipe;
	char	s[1024];
	char	*got = getPath(folder->dir);

	folder->file_count = 0;
	sprintf(s,"zcat < '%s' | tar -tvf -",got);
	free(got);
	if (!(pipe = popen(s,"r")))
		return;
	readTar(folder,pipe);
	pclose(pipe);
}


/*********************************************************
 * name:	readTar
 * description:	Auslesen des Tar-Listings von einer Pipe
 * input:	Folder_Glyph *folder
 *		FILE *pipe
 * output:	none
 * author:	Ove Kalkan
 * date:	24.Aug.1993
 *********************************************************/
void	readTar (Folder_Glyph *folder, FILE *pipe)
{
	char	s[1024];

#ifdef DEBUG
	debug("tar.c: readTar - start\n");
#endif
	if (folder->file_count) {
		int	i;
		for (i = 0; i < folder->file_count; i++) {
			if (folder->file[i]) {
				if (folder->file[i]->name)
					free(folder->file[i]->name);
				free(folder->file[i]);
			}
		}
	}
	folder->size = 0;
	folder->total_count = 0;
	folder->file_count = 0;
	folder->file = NULL;

	/*
	 * Neuen Folder erstellen
	 */
	s[1023] = '\0';
	if (!defaults.multi_window) {	/* Erster Eintrag = root_dir */
		File_Glyph	*nf;

		/*
		 * Zunaechst einmal das File-Feld erweitern
		 */
		if (!folder->file) {
			if (!(folder->file = (File_Glyph **) malloc(sizeof(File_Glyph *))))
				FATAL_ERROR("readTar: malloc failed");
		}
		else {
			if (!(folder->file = (File_Glyph **) realloc((void *) folder->file,
								sizeof(File_Glyph *))))
				FATAL_ERROR("readTar: realloc failed");
		}
		if (!(nf = (File_Glyph *) malloc(sizeof(File_Glyph))))
			FATAL_ERROR("readTar: alloc failed");
		folder->file[0] = nf;

		if (!(nf->name = (char *) malloc(3)))
			FATAL_ERROR("readTar: alloc error");
		sprintf(nf->name,"..");
		nf->prog_type = FILE_ROOT;
		nf->size = 0;
		nf->mode = 0;
		nf->uid = 0;
		nf->gid = 0;
		folder->file_count++;
	}
#ifdef DEBUG
	debug("Pipe open, starting read\n");
#endif
	while (fgets(s,1023,pipe)) {
		File_Glyph	*nf;
		char		*a;

		/*
		 * Zunaechst einmal das File-Feld erweitern
		 */
		if (!folder->file) {
			if (!(folder->file = (File_Glyph **) malloc(sizeof(File_Glyph *))))
				FATAL_ERROR("readTar: malloc failed");
		}
		else {
			if (!(folder->file = (File_Glyph **) realloc((void *) folder->file,
								sizeof(File_Glyph *) * (folder->file_count+1))))
				FATAL_ERROR("readTar: realloc failed");
		}
		if (!(nf = (File_Glyph *) malloc(sizeof(File_Glyph))))
			FATAL_ERROR("readTar: alloc failed");
		folder->file[folder->file_count] = nf;
		folder->file_count++;		

		/*
		 * Neuen File-entry fuellen
		 */
		a = strrchr(s,' ');	/* Name */
		a++;
		if (!(nf->name = (char *) malloc(strlen(a)+1)))
			FATAL_ERROR("readTar: Malloc failed");
		sprintf(nf->name,"%s",a);
		nf->name[strlen(a)-1] = '\0';
#ifdef DEBUG
		debug("%d: (%s)\n",folder->file_count,nf->name);
#endif
		a -= 19;	/* This depends on how tar -tv prints it's list */
		*a = '\0';
		a = strrchr(s,' ');	/* Size */
		nf->size = atoi(a);
		if (!nf->size) {
			nf->prog_type = FILE_DIR;
			folder->size += 1024;
			folder->total_count++;
		}
		else {
			nf->prog_type = FILE_PLAIN;
			folder->size += nf->size;
		}
		nf->mode = 0;
		if (s[0] == 'r')
			nf->mode |= S_IRUSR;
		if (s[1] == 'w')
			nf->mode |= S_IWUSR;
		if (s[2] == 'x')
			nf->mode |= S_IXUSR;
		if (s[3] == 'r')
			nf->mode |= S_IRGRP;
		if (s[4] == 'w')
			nf->mode |= S_IWGRP;
		if (s[5] == 'x')
			nf->mode |= S_IXGRP;
		if (s[6] == 'r')
			nf->mode |= S_IROTH;
		if (s[7] == 'w')
			nf->mode |= S_IWOTH;
		if (s[8] == 'x')
			nf->mode |= S_IXOTH;
		
		nf->uid = 0;
		nf->gid = 0;
	}
	/*
	 * Infofeld setzen
	 */
	{	Arg	args[1];
		char	s[100];

		sprintf(s,"%d Files (%d Directories)     Unpacked Size: %d KBytes",
						folder->file_count - (defaults.multi_window ? 0 : 1),
						folder->total_count,
						folder->size/1024);
		XtSetArg(args[0],XtNlabel,s);
		XtSetValues(folder->info,args,1);
	}
#ifdef DEBUG
	debug("readTar - end\n");
#endif
}



/*********************************************************
 * name:	start_extract
 * description:	Files aus Tar-Files heraus extrahieren
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	27.Aug.1993
 *********************************************************/
void	start_extract (void)
{
	if (selc_fo && selc_fo->fs_type != FS_NORMAL) {
		char	*got;
		char	*cd_path;
		char	*file;
		char	s[1024];

		if (selc_f == 16000 || selc_fo->file[selc_f]->prog_type == FILE_ROOT)
			return;
		got = getPath(selc_fo->dir);	/* Das Archive-File */
		cd_path = getPath(selc_fo->dir->parent);
		file = selc_fo->file[selc_f]->name;
		if (selc_fo->fs_type == FS_TAR)
			sprintf(s,"cd %s; tar -xf %s %s",cd_path,got,file);
		else if (selc_fo->fs_type == FS_CTAR)
			sprintf(s,"cd %s; zcat %s | tar -xf - %s",cd_path,got,file);
		else {
			free(got);
			free(cd_path);
			return;
		}
		system(s);
		refreshFolderByPathname (cd_path);
		free(got);
		free(cd_path);
	}
	else if (multi_fo && multi_fo->fs_type != FS_NORMAL) {
		char	*mark,*pmark;
		char	*got;
		char	*cd_path;
		char	*file = NULL;
		char	s[4096];
		int	i;
		int	j = 1;

		if (multi_vs == 16000 || multi_fo->file[multi_vs]->prog_type == FILE_ROOT)
			return;
		got = getPath(multi_fo->dir);	/* Das Archive-File */
		cd_path = getPath(multi_fo->dir->parent);

		for (i = multi_vs; i <= multi_ve; i++) {
			j = j + strlen(multi_fo->file[i]->name) + 1;
			if (!file) {
				if (!(file = (char *) malloc (j)))
					FATAL_ERROR("start_extract: malloc failed.");
				file[0] = '\0';
			}
			else {
				if (!(file = (char *) realloc ((void *) file,j)))
					FATAL_ERROR("start_extract: malloc failed.");
			}
			sprintf(file,"%s%s ",file,multi_fo->file[i]->name);
		}

		if (multi_fo->fs_type == FS_TAR)
			sprintf(s,"cd %s; tar -xf %s %s",cd_path,got,file);
		else if (multi_fo->fs_type == FS_CTAR)
			sprintf(s,"cd %s; zcat %s | tar -xf - %s",cd_path,got,file);
		else {
			free(got);
			free(cd_path);
			free(file);
			return;
		}
		system(s);
		refreshFolderByPathname (cd_path);
		free(got);
		free(file);
		free(cd_path);
	}
}
