.\" $Id: xboard.man,v 1.37 1995/03/09 00:43:28 mann Exp $
.TH xboard 6 "$Date: 1995/03/09 00:43:28 $" "GNU"
.SH NAME
xboard \- X user interface for GNU Chess, the Internet Chess Server (ICS),
and electronic mail correspondence chess.
.SH SYNOPSIS
To run with GNU Chess:
.B xboard [options]
.br
To run with the ICS:
.B xboard -ics [options]
.br
To play email chess: See
.IR cmail (6).
.br
To run standalone:
.B xboard -ncp [options]
.SH DESCRIPTION
.IR xboard
is a graphical chessboard that can serve as a
user interface for GNU Chess, for the Internet Chess Server, 
or for electronic mail correspondence chess.
.IR xboard 
can also be used by itself.
.PP
As an interface to GNU Chess,
.IR xboard
lets you play a game against the machine,
set up arbitrary positions,
force variations, or watch
a game between two machines.
.PP
As an interface to the Internet Chess Server (ICS),
.I xboard -ics
lets you play against other ICS users,
observe games they are playing, or review
games that have recently finished.
.PP
As an interface to electronic mail correspondence chess,
.IR xboard
works with the
.IR cmail (6)
program.  See its manual page for instructions.
.PP
You can also use
.IR xboard
as a chessboard to play through games.
It will read and write game files and allow you to play 
through variations manually.
You can use it to browse games off the net
or review GNU Chess, ICS, and correspondence games you have saved.  
These features are available at all times; even if you do not have
access to GNU Chess or the ICS, you can use them by giving the command
.IR "xboard -ncp" .
.PP
After starting
.IR xboard ,
you make moves by dragging pieces with the mouse.  
Press mouse button 1 while the cursor is on one of your pieces, then
move the cursor to another square and release the button.
.PP
When
.IR xboard
is iconized, its graphical icon is a white knight if it is White's turn to
move, a black knight if it is Black's turn.  (See 
.B Iconize
below if you have problems getting this feature to work.)
.SH OPTIONS
Most of the 
.IR xboard
options have both a long name and a short name.
To turn a boolean option on or off from the command line, either give
its long name followed by the value True or False
.RI ( -longOptionName
True), or give
just the short name to turn the option on
.RI ( -opt ),
or the short name preceded by "x" to turn the option off
.RI ( - x opt ).
For options that take strings or numbers as values, you can use the long or
short option names interchangeably.
.PP
Each option corresponds to an X resource
with the same name, so you can set options in your
.IR \&.Xdefaults
file if you like.
For options that have two names, the longer
one is the name of the corresponding X resource; the short name is not
recognized in \&.Xdefaults.
To turn a boolean option on or off in your \&.Xdefaults
file, give its long name followed by the value True or False 
.RI (XBoard* longOptionName :
True).

.SH GNU Chess Options
.TP 8
.B -tc or -timeControl minutes[:seconds]
.PD 0
.TP 8
.B -mps or -movesPerSession moves
Each player begins with the specified amount of time on his clock.
If a player makes the specified number of moves before his clock runs out,
.IR xboard
adds the specified amount of time to his clock.
Default: 40 moves in 5 minutes.  
.PD
.TP 8
.B -clock or -clockMode
Determines whether or not to display the chess clocks.
If clockMode is False, the clocks are not shown, but the
side that is to play next is still highlighted.  Also, unless 
searchTime or searchDepth is set, GNU Chess still keeps track of the
clock time and uses it to determine how fast to make its moves.
.TP 8
.B -st or -searchTime minutes[:seconds]
Tells GNU Chess to spend at most the given amount of time searching
for each of its moves.  Without this option, GNU Chess chooses
its search time based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets clockMode to False.
.TP 8
.B -sd or -searchDepth number
Tells GNU Chess to look ahead at most the given number of moves when searching
for a move to make.  Without this option, GNU Chess chooses
its search depth based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets clockMode to False.
.TP 8
.B -thinking or -showThinking
If this option is set, GNU Chess's notion of the score and best line of play
from the current position is displayed as it is thinking.  The score indicates
how many pawns ahead (or if negative, behind) GNU Chess thinks it is.  In
matches between two machines, the score is prefixed by W or B to indicate
whether it is showing White's thinking or Black's.
.TP 8
.B -mm or -matchMode
Automatically runs a game between two chess programs.
If the loadGameFile or loadPositionFile option is set, 
.IR xboard
starts the game with the given opening moves or the given
position; 
otherwise, the game starts with the standard initial chess position.
If the saveGameFile 
option is set, a move record for the match
is appended to the specified file.
If the savePositionFile 
option is set, the final position reached in the match
is appended to the specified file.
When the match is over, 
.IR xboard
exits.
Default: False.
.TP 8
.B -fcp or -firstChessProgram program
Name of first chess program.
In matches between two machines, this program plays Black.
Default: "gnuchessx".
.TP 8
.B -scp or -secondChessProgram program
Name of second chess program, if needed.
In matches between two machines, this program plays White; otherwise
it is not started.
Default: "gnuchessx".
.TP 8
.B -fh or -firstHost host
.PD 0
.TP 8
.B -sh or -secondHost host
Hosts on which the chess programs are to run.  
The default for each is "localhost".
If you specify another host, 
.IR xboard
uses 
.IR rsh (1)
to run the chess program there.
(You can substitute a different remote shell program for rsh using the
remoteShell option described below.)
.PD
.TP 8
.B -initString string
The string that is sent to initialize the chess program.
Default: "new\\nbeep\\nrandom\\neasy\\n".

If you change this option, don't remove the "new" and "beep" commands.
You can remove the "random" command if you
like; including it causes GNU Chess to randomize its move selection slightly so
that it doesn't play the same moves in every game.  
(Even without "random", GNU Chess
randomizes its choice of moves from its opening book.)
You can also remove "easy" if you like; including it toggles easy mode
off, causing GNU Chess to think on your time.
That is, if "easy" is 
.IR included
in the initString, GNU Chess thinks
on your time; if not, it does not.  
(Yes, this does seem backwards, doesn't it!)
You can also try adding other commands to the initString; 
see the GNU Chess documentation for details.
.TP 8
.B -whiteString string
.PD 0
.TP 8
.B -blackString string
These options control what is sent when the Machine White and Machine Black
buttons are selected.  This is mostly for compatibility with obsolete versions
of GNU Chess.
.PD
.SH Internet Chess Server Options
.TP 8
.B -ics or -internetChessServerMode
Connect with an Internet Chess Server to play chess against
its other users, observe games they are playing, or
review games that have recently finished.  Default: False.

To use xboard in ICS mode, run it in the foreground, and use the
terminal you started it from to type commands and receive text responses
from the chess server.  Useful ICS commands include
.IR who
to see who is logged on,
.IR games
to see what games are being played,
.IR match
to challenge another player to a game,
.IR observe
to observe an ongoing game,
.IR examine
or
.IR oldmoves
to review a recently completed game,
and of course
.IR help .
Whenever you ask to observe an ongoing game, review a completed game, or
resume an adjourned game,
.IR xboard
retrieves and parses the list of past moves from the ICS, so
you can review them with the Forward and Backward commands
or save them with Save Game.
Some special 
.IR xboard
features are activated when you are in 
.IR examine 
mode on ICS.  See the descriptions of the menu commands
Forward, Backward, Pause, ICS Client, and Stop Examining below.
.TP 8
.B -icslogon or -internetChessServerLogonScript file-name
Whenever
.IR xboard
connects to the Internet Chess Server, if it finds a file with
the name given in this option,
it feeds the file's contents to the ICS as commands.
The default file name is ".icsrc".
Usually the first two lines of the file should be your ICS user name
and password.
The file can be either in $CHESSDIR, in 
.IR xboard 's
working directory if CHESSDIR is not set, or in your home directory.
.TP 8
.B -autoflag or -autoCallFlag
If autoCallFlag is True and your opponent runs out of time
before you do,
.IR xboard
will automatically call his flag, claiming a win on time (or a draw
if you do not have mating material).
Default: False.
.TP 8
.B -autobs or -autoObserve
If autoObserve is True and you add a player to your "gnotify" list on ICS,
.IR xboard
will automatically observe all of that player's games, unless you are
doing something else (such as observing or playing a game of your own) when
one starts.
Default: False.
.TP 8
.B -quiet or -quietPlay
If this option is True, 
.IR xboard
will automatically issue a "set shout 0" command whenever you start an ICS
game and a "set shout 1" command whenever you finish one.  Default: False.
.TP 8
.B -icshost or -internetChessServerHost host
The Internet host name or address of the chess server to connect 
to when in ICS mode.  
Default: chess.lm.com.
See the file "ics-addresses" in the 
.IR xboard
source distribution for a list of other addresses to try.  See
also the output of the command "finger chess@ics.onenet.net".
If your site doesn't have a working Internet name server, try 
specifying the host address in numeric form.  The address for chess.lm.com
is 192.231.221.16.
.TP 8
.B -icsport or -internetChessServerPort port-number
The port number to use when connecting to a chess server in ICS mode.
Default: 5000.
.TP 8
.B -gateway host-name
If this option is set to a host name,
.IR xboard
uses
.IR rsh (1)
to run the 
.IR telnet (1)
program on the given host to communicate with the Internet
Chess Server instead of opening a direct TCP connection.
(You can substitute a different remote shell program for rsh using the
remoteShell option described below.)

This option is useful if your machine is unable
to connect directly to the ICS but is able
to rsh to a gateway host that can connect to the ICS.
As an example, suppose the gateway host is
called gate.ralph.com, and you set options as
follows:
.EX 4
xboard -ics -gateway gate.ralph.com -icshost chess.lm.com
.EE
Or in your \&.Xdefaults file:
.EX 4
XBoard*gateway: gate.ralph.com
XBoard*internetChessServerHost: chess.lm.com
.EE
Then when you run
.IR xboard
in ICS mode, it will connect to the ICS by using rsh
to run the command "telnet chess.lm.com 5000" on
host gate.ralph.com.
.TP 8
.B -telnet or -useTelnet
If this option is set to True,
.IR xboard 
runs the 
.IR telnet (1)
program to communicate with the Internet Chess
Server.  If the option is False (the default),
.IR xboard
opens a TCP socket to communicate with the ICS.

One case where this option is useful is if your machine cannot connect
directly to the ICS, but can telnet to a gateway host that can connect to 
the ICS.  It is more general than the gateway 
option, because you may be able to telnet to a host that 
you cannot rsh to, but it's not as convenient to use.
As an example, suppose the gateway host is
called gate.ralph.com, and you set command-line options as
follows:
.EX 4
xboard -ics -telnet -icshost gate.ralph.com -icsport 23
.EE
Or in your \&.Xdefaults file:
.EX 4
XBoard*useTelnet: true
XBoard*internetChessServerHost: gate.ralph.com
XBoard*internetChessServerPort: 23
.EE
Then when you run
.IR xboard
in ICS mode, you will be prompted to log in to the gateway host.
Then telnet to ICS (using a command like
telnet chess.lm.com 5000").  See also LIMITATIONS below.

The recipe above works because the option "-icsport 23" causes 
.IR xboard 
to connect to the gateway host's standard incoming telnet service (port 23)
instead of 
trying to connect to a chess server running on the gateway host (port 5000).
.TP 8
.B -telnetProgram prog-name
This option gives the name of the telnet program to be used with the 
gateway and useTelnet options.  The default is "telnet".  The 
telnet program 
is invoked with the value of internetChessServerHost as its first argument
and the value of internetChessServerPort as its second argument.

One case where this option is useful is if your machine
cannot make a direct TCP connection
to the ICS but can telnet there through a proxy server.
As an example, suppose that your proxy telnet program is called ptelnet.
You should then set command-line options as follows:
.EX 4
xboard -ics -telnet -telnetProgram ptelnet
.EE
Or in your \&.Xdefaults file:
.EX 4
XBoard*useTelnet: true
XBoard*telnetProgram: ptelnet
.EE
Then when you run
.IR xboard
in ICS mode, it will issue the command "ptelnet chess.lm.com 5000" to
connect to the ICS.
.TP 8
.B -internetChessServerCommPort or -icscomm dev-name
If this option is set, 
.IR xboard
communicates with the ICS through the given character I/O device
instead of opening a TCP connection.
Use this option if your system
does not have any kind of Internet connection itself (not
even a SLIP or PPP connection), but you do have dialup access 
(or a hardwired terminal line) to an Internet
service provider from which you can telnet to the ICS.

The support for this option in 
.IR xboard
is minimal.  You need to set all communication parameters and tty modes
before you enter
.IR xboard .

Use a script something like this:
.EX 4
stty raw -echo 9600 > /dev/tty00
xboard -ics -icscomm /dev/tty00
.EE
Here replace "/dev/tty00" with the name of the device that your
modem is connected to.  
You might have to add several more options to these stty commands.  See the
man pages for 
.IR stty (1)
and
.IR tty (4)
if you run into problems.  Also, on many systems
stty works on its standard input instead of standard output, so you
have to use "<" instead of ">".

If you are using linux, try starting with the script below.  Change it as
necessary for your installation.
.EX 4
####################################################
#!/bin/sh -f
# configure modem and fire up xboard

# configure modem
(
stty 2400 ; stty raw ; stty hupcl ; stty -clocal 
stty ignbrk ; stty ignpar ; stty ixon ; stty ixoff 
stty -iexten ; stty -echo
) < /dev/modem

xboard -ics -icscomm /dev/modem
####################################################
.EE
After you start
.IR xboard
in this way, type whatever commands are necessary to dial out to
your Internet provider and log in.
Then telnet to ICS (using a command like
"telnet chess.lm.com 5000").  See also LIMITATIONS below.
.SH Load and Save Options
.TP 8
.B -lgf or -loadGameFile file
.PD 0
.TP 8
.B -lgi or -loadGameIndex index
If the loadGameFile option is set,
.IR xboard
loads the specified game file at startup.
The file name "-" specifies the standard input.
If the loadGameIndex option is set to N, 
the
.IR N th
game found in the file is loaded; otherwise the first game is loaded.
.PD
.TP 8
.B -td or -timeDelay seconds
Time delay between moves during "Load Game".
Fractional seconds are allowed; try -td 0.4.  
A time delay value of -1 tells
.IR xboard
not to step through game files automatically.
Default: 1 second.
.TP 8
.B -sgf or -saveGameFile file
If this option is set, 
.IR xboard 
appends a record of every game played to the specified file.
The file name "-" specifies the standard output.
.TP 8
.B -autosave or -autoSaveGames
If this option is True, at the end of every game
.IR xboard
prompts you for a file name and appends a record
of the game to the file you specify.  Ignored if saveGameFile is set.
.TP 8
.B -lpf or -loadPositionFile file
.PD 0
.TP 8
.B -lpi or -loadPositionIndex index
If the loadPositionFile option is set,
.IR xboard
loads the specified position file at startup.
The file name "-" specifies the standard input.
If the loadPositionIndex option is set to N, 
the
.IR N th
position found in the file is loaded; otherwise the first position is loaded.
.PD
.TP 8
.B -spf or -savePositionFile file
If this option is set, 
.IR xboard 
appends the final position reached in
every game played to the specified file.
The file name "-" specifies the standard output.
.TP 8
.B -oldsave or -oldSaveStyle
If this option is False (the default), 
.IR xboard
saves games in PGN (portable game notation) and positions in FEN
(Forsythe-Edwards notation).  If the option is True, 
a save style that is compatible with older versions of
.IR xboard
is used instead.
.SH User Interface Options
.TP 8
.B standard Xt options
.IR xboard
accepts standard Xt options like -display, -geometry, and -iconic.
.TP 8
.B -bell or -ringBellAfterMoves
If this option is True,
.IR xboard
alerts you by ringing the terminal bell after each
of your opponent's moves (or after every move if
you are observing a game on the Internet Chess Server).
The bell is not rung after moves you make 
or moves read from a saved game file.  Default: False.

If you turn on this option when using
.IR xboard
with the Internet Chess Server, you will probably want to
give the "set bell 0" command to the ICS, since otherwise the ICS
will ring the bell itself after every move (not just yours).
.TP 8
.B -queen or -alwaysPromoteToQueen
If this option is False (the default),
.IR xboard
brings up a dialog box whenever you move a pawn to the last rank,
asking what piece you want to promote it to.  
If the option is True, your pawns are always promoted to
queens.  (Your opponent can still underpromote, however.)
.TP 8
.B -size or -boardSize "(Large | Medium | Small)"
Determines how large the board will be and what built-in piece bitmaps
will be used.  On a large board (the default), 
pieces are 80x80 pixels, on a medium board 64x64 pixels, and
on a small board 40x40 pixels.
.TP 8
.B -coords or -showCoords
If this option is True,
.IR xboard
displays algebraic coordinates along the board's left and bottom edges.
The default is False.  The
.IR coordFont
option specifies what font to use.  
.TP 8
.B -flip or -flipView
If you are
playing a game on the ICS, the board is always
oriented at the start of the game so that your 
pawns move from the bottom of the window towards the top.
Otherwise, the starting is determined by the flipView option; if it is
False (the default), White's pawns move from bottom to top at the
start of each game; if it is True, Black's pawns move from bottom to top.
.TP 8
.B -title or -titleInWindow 
If this option is True, 
.IR xboard
displays player names (for ICS games) and game file names (for Load
Game) inside its main window.  If the option is False (the default),
this information is displayed only in the window banner.  You probably
won't want to set this option unless the information is not showing up
in the banner, as happens with a few X window managers.
.TP 8
.B -mono or -monoMode
Determines whether
.IR xboard
displays its pieces and squares with two colors (True) or four (False).
You shouldn't have to specify monoMode;
.IR xboard
will determine if it is necessary.
.TP 8
.B -borderXoffset
.PD 0
.TP 8
.B -borderYoffset
These options are part of a kludge 
that helps position the Comment and Edit Comment
windows in the same place on the screen when they are closed and reopened.
They should be set equal to the width and height of the borders that
your X window manager adds to windows when it displays them.  The
defaults are correct for 
.IR tvtwm (1).
.PD
.TP 8
.B -clockFont
The font used for the clocks.
If the option
value is a pattern that does not specify the font size, 
.IR xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -coordFont
The font used for rank and file coordinate labels if 
.IR showCoords
is True.
If the option
value is a pattern that does not specify the font size, 
.IR xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -font
The font used for popup dialogs, menus, comments, etc.
Default: -*-helvetica-medium-r-normal--14-*-*-*-*-*-*-*.
.PP
.TP 8
.B -bitmapDirectory or -bm
By default, 
.IR xboard
uses a set of compiled-in bitmaps for its pieces.  
If the
.IR bitmapDirectory
option is set at runtime,
piece bitmaps are taken from files in the specified directory instead.
The first character of a bitmap name gives the piece it represents (p, n, b,
r, q, or k); the next characters give 
the size in pixels (80, 64, or 40), and the
following character indicates whether the piece is solid or outline (s or o).
Bitmap file names have the extension ".bm".
The outline bitmaps are used only in monochrome mode.

Two sets of bitmaps are distributed with
.IR xboard .
Those in the directory
.B bitmaps
are normally compiled in as the default.
Those in the
.B bitmaps.xchess
directory can be selected at runtime with the bitmapDirectory option.
If you want to compile in the latter set as the default, rename the
.B bitmaps 
directory to "bitmaps.fselch" and the
.B bitmaps.xchess
directory to "bitmaps"; then recompile
.IR xboard .
.TP 8
.B -whitePieceColor
Color specification for white pieces,
suitable for
.IR XParseColor (3X11).
Default: #FFFFCC.
These colors look good on a DEC workstation.
If you need different colors, try using the
.IR xcolors
application.  Source for
.IR xcolors
can be found in the X11 contrib directory.
.TP 8
.B -blackPieceColor
Same for black pieces.
Default: #202020.
.TP 8
.B -lightSquareColor
Same for light squares.
Default: #C8C365.
.TP 8
.B -darkSquareColor
Same for dark squares.
Default: #77A26D.
.PP
If you are using a grayscale monitor, try setting the colors to:
.EX 4
-whitePieceColor     gray100
-blackPieceColor     gray0
-lightSquareColor    gray80
-darkSquareColor     gray60
.EE
.SH Other Options
.TP 8
.B -ncp or -noChessProgram
If this option is True,
.IR xboard
acts as a passive chessboard; it does not
start a chess program at all.
Turning on this option also turns off clockMode.
Default: False.
.TP 8
.B -debug or -debugMode
Turns on debugging printout.
.TP 8
.B -rsh or -remoteShell shell-name
Name of the command used to run programs remotely.  
The default is "rsh" or "remsh", determined when
.IR xboard
is configured and compiled.
.TP 8
.B -ruser or -remoteUser user-name
User name on the remote system when running programs with the remoteShell.
The default is your local user name.
.SH MENU COMMANDS, BUTTONS, AND KEYS
All 
.IR xboard
commands are available on menus.  The most frequently used
commands also have shortcut keys or on-screen buttons.
.SH File Menu
.TP 8
.B Reset
Resets
.IR xboard
and GNU Chess to the beginning of a new chess game.
The "r" key is a keyboard equivalent.
In Internet Chess Server mode, clears the current state of 
.IR xboard ,
then resynchronizes with ICS by sending a 
.IR refresh
command.
If you want to stop playing, observing, or examining a game 
on ICS, use an appropriate command from the 
Action menu, not Reset.
.TP 8
.B Load Game
Plays a game from a record file.
A popup dialog prompts you for the file name.
If the file contains more than one game, and you want
to load the 
.IR N th
one, type the number 
.IR N 
after the file name, separated by a space.
The "g" key is a keyboard equivalent.

The game file parser will accept PGN (portable game notation), or
in fact almost any file that contains moves in algebraic notation.
If the file includes a PGN position (FEN tag), or an 
.IR xboard
position diagram
bracketed by "[--" and "--]" before the
first move, the game starts from that position.
Text enclosed in parentheses, square brackets, or curly braces 
is assumed to be commentary and is displayed in a pop-up window.
Any other text in the file is ignored.  PGN variations (enclosed in 
parentheses) are treated as comments; 
.IR xboard
is not able to walk variation trees.
.TP 8
.B Load Next Game
Loads the next game from the last game record file you loaded.
The shifted "N" key is a keyboard equivalent.
.TP 8
.B Load Previous Game
Loads the previous game from the last game record file you loaded.
The shifted "P" key is a keyboard equivalent.
.TP 8
.B Reload Same Game
Reloads the last game you loaded.
.TP 8
.B Load Position
Sets up a position from a position file.
A popup dialog prompts you for the file name.
If the file contains more than one saved position, and you want
to load the 
.IR N th
one, type the number 
.IR N 
after the file name, separated by a space.
Position files must be in FEN (Forsythe-Edwards notation), or in the format
that the Save Position command writes when oldSaveStyle is turned on.
.TP 8
.B Save Game
Appends a record of the current game to a file.
A popup dialog prompts you for the file name.
If the game did not begin with the standard starting position,
the game file includes the starting position used.
Games are saved in the PGN (portable game notation) format,
unless the oldSaveStyle option is
True, in which case they are saved in an older format that is specific to 
.IR xboard .
Both formats are human-readable, and both can be read back by the Load Game 
command. 
.TP 8
.B Save Position
Appends a diagram of the current position to a file.
A popup dialog prompts you for the file name.
Positions are saved in FEN (Forsythe-Edwards notation) format unless
the oldSaveStyle option is True, in which case they are saved in an older,
human-readable format that is specific to 
.IR xboard .
Both formats can be read back by the Load Position command.
.TP 8
.B Mail Move
.PD 0
.TP 8
.B Reload CMail Message
See the manual page for
.IR cmail (6).
.PD
.TP 8
.B Exit
Exits from
.IR xboard .
The "q" key is a keyboard equivalent.
.SH Mode Menu
.TP 8
.B Pause
Pauses updates to the board, and if you are playing
against GNU Chess, also pauses your clock.
To continue, select Pause again, and the display will automatically
update to the latest position.
The [P] button and keyboard "p" key are equivalents.

If you select Pause when you are playing against GNU Chess and
it is not your move, GNU Chess's clock
will continue to run and it will eventually make a move, at which point
both clocks will stop.  Since board updates are paused, however,
you will not see the move until you exit from Pause mode (or select Forward).
This behavior is meant to simulate adjournment with a sealed move.

If you select Pause while you are in 
.IR examine
mode on ICS, you can step
backward and forward in the current history of the examined game without
affecting the other observers and examiners.  Select Pause again to reconnect
yourself to the current state of the game on ICS.

If you select Pause while you are loading a game, the 
game stops loading.
You can load more moves manually by selecting Forward, or resume automatic
loading by selecting Pause again.
.TP 8
.B Edit Comment
Adds or modifies a comment on the current position.  Comments are
saved by Save Game and are displayed by Load Game, Forward, and Backward.
.TP 8
.B Machine White
Forces GNU Chess to play White.  GNU Chess mode only.
.TP 8
.B Machine Black
Forces GNU Chess to play Black.  GNU Chess mode only.
.TP 8
.B Two Machines
Plays a game between two computer programs.  GNU Chess mode only.
.TP 8
.B ICS Client
ICS mode only.  Takes 
.IR xboard
out of the Edit Game or Edit Position state.

While you are examining a game on the ICS,
you can issue the ICS position-editing commands with the mouse.  
(Do this with ICS Client selected on the Mode menu, not Edit Position; the
latter edits only your local copy of the position.)
To drop a new piece on a square, press mouse button 2 or 3
over the square.  This brings up a menu of white pieces (button 2) or black
pieces (button 3).  Additional menu choices let you empty the square or
clear the board.
You cannot set the side to play or drag pieces to arbitrary squares while
examining on ICS, however; the ICS permits only legal moves in this mode.
.TP 8
.B Edit Game
Allows you to make moves for both Black and White, and
to change moves after backing up with the Backward command.
The clocks do not run.

In GNU Chess mode, GNU chess continues to check moves for
legality but does not participate in the game.  You can bring GNU
Chess back into the game by selecting Machine White, Machine Black, 
or Two Machines.

In ICS mode, the moves are not sent to the ICS:
Edit Game takes 
.IR xboard
out of ICS Client mode and lets you edit games locally.
If you want to edit
games on ICS in a way that other ICS users can see,
use the ICS
.IR examine
command or start an ICS match against yourself.
.TP 8
.B Edit Position
Lets you set up an arbitrary board position.
Use mouse button 1 to drag pieces to new squares, or to
delete a piece by dragging it off the board or dragging an empty square
on top of it.  To drop a new piece on a square, press mouse button 2 or 3
over the square.  This brings up a menu of white pieces (button 2) or black
pieces (button 3).  Additional menu choices let you empty the square or
clear the board.  You can set the side to play next
by clicking on the White or Black indicator at the top of the screen.
Selecting Edit Position causes 
.IR xboard
to discard all remembered moves in the current game.

In ICS mode, changes made to the position by Edit Position
are not sent to the ICS:  Edit Position takes 
.IR xboard
out of ICS Client mode and lets you edit positions locally.
If you want to edit
positions on ICS in a way that other ICS users can see,
use the ICS
.IR examine
command, or start an ICS match against yourself.  
(See also the ICS Client topic above.)
.SH Action Menu
.TP 8
.B Accept
Accepts a pending match offer.
If there is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.  (ICS mode only)
.TP 8
.B Decline
Declines a pending offer (match, draw, adjourn, etc.).
If there is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.  (ICS mode only)
.TP 8
.B Call Flag
Calls your opponent's flag, claiming a win on time, or claiming a draw
if you are both out of time.  You can also call your opponent's flag
by clicking on his clock or by pressing the keyboard "t" key.
.TP 8
.B Draw
Offers a draw to your opponent, accepts a pending draw offer
from your opponent, or claims a draw by repetition or the 50-move 
rule, as appropriate.  The "d" key is a keyboard equivalent.  (Not available
in GNU Chess mode.)
.TP 8
.B Adjourn
Asks your opponent to agree to adjourning the current game, or
agrees to a pending adjournment offer from your opponent.  (ICS mode only)
.TP 8
.B Abort
Asks your opponent to agree to aborting the current game, or
agrees to a pending abort offer from your opponent.
An aborted game ends immediately without affecting either player's rating.
.TP 8
.B Resign
Resigns the game to your opponent.  The shifted "R" key is a keyboard
equivalent. 
.TP 8
.B Stop Observing
Ends your participation in observing a game, by issuing the ICS
.IR observe
command with no arguments.  (ICS mode only)
.TP 8
.B Stop Examining
Ends your participation in examining a game, by issuing the ICS
.IR unexamine
command.  (ICS mode only)
.SH Step Menu
.TP 8
.B Backward
Steps backward through a series of remembered moves.
The [<] button and the "b" key are equivalents.

In most modes, Backward only lets you look back at 
old positions; it does not retract moves.
This is the case if you are playing against GNU Chess, playing or
observing a game on the ICS, or loading a game.  If you select Backward in any
of these situations, you will not be allowed to make a different move.
Use Retract Move or Edit Game if you want to change past moves.

If you are examining a game on ICS, the behavior of
Backward depends on whether 
.IR xboard
is in Pause mode.
If Pause mode is off, Backward issues the ICS 
.IR backward
command, which
backs up everyone's view of the game and allows you to make a different move.
If Pause mode is on, Backward only backs up your local view.
.TP 8
.B Forward
Steps forward through a series of remembered moves (undoing the effect of
Backward) or forward through a game file.
The [>] button and the f key are equivalents.

If you are examining a game on ICS, the behavior of
Forward depends on whether 
.IR xboard
is in Pause mode.
If Pause mode is off, Forward issues the ICS 
.IR forward
command, which
moves everyone's view of the game forward along the current line.
If Pause mode is on, Forward only moves your local view forward, and it
will not go past the position that the game was in when you paused.
.TP 8
.B Back to Start
Jumps backward to the first remembered position in the game.
The [<<] button and the shifted "B" key are equivalents.

In most modes, Back to Start only lets you look back at 
old positions; it does not retract moves.
This is the case if you are playing against GNU chess, playing or
observing a game on the ICS, or loading a game.  If you select Back to
Start in any
of these situations, you will not be allowed to make different moves.
Use Retract Move or Edit Game if you want to change past moves; or
use Reset to start a new game.

If you are examining a game on ICS, the behavior of
Back to Start depends on whether 
.IR xboard
is in Pause mode.
If Pause mode is off, Back to Start issues the ICS 
.I backward 999999
command, which
backs up everyone's view of the game to the start and allows you to make
different moves.
If Pause mode is on, Back to Start only backs up your local view.
.TP 8
.B Forward to End
Jumps forward to the last remembered position in the game.
The [>>] button and the shifted "F" key are equivalents.

If you are examining a game on ICS, the behavior of
Forward to End depends on whether 
.IR xboard
is in Pause mode.
If Pause mode is off, Forward to End issues the ICS 
.I forward 999999
command, which moves everyone's view of the game forward to the end
of the current line.  
If Pause mode is on, Forward to End only moves your local view forward, and it
will not go past the position that the game was in when you paused.
.TP 8
.B Revert
If you are examining a game on ICS and Pause mode is off, 
issues the ICS command
.IR revert .
.TP 8
.B Truncate Game
Discards all remembered moves of the game beyond the current position.
Puts 
.IR xboard
into Edit Game mode if it was not there already.
.TP 8
.B Move Now
Forces GNU Chess to move immediately.  (GNU Chess mode only)
.TP 8
.B Retract Move
Retracts your last move.  
In GNU Chess mode, you can do this only after GNU Chess has replied to
your move; if GNU Chess is still thinking, use Move Now first.
In ICS mode, Retract Move issues the command 
.I takeback 1
or
.I takeback 2
depending on whether it is your opponent's move or yours.
.SH Options Menu
.TP 8
.B Always Queen
Toggles the alwaysPromoteToQueen option.
.TP 8
.B Auto Flag
Toggles the autoCallFlag option.
.TP 8
.B Auto Observe
Toggles the autoObserve option.
.TP 8
.B Auto Save
Toggles the autoSaveGames option.  Disabled if the saveGameFile
option is set, as in that case all games are saved to the specified file.
.TP 8
.B Bell
Toggles the ringBellAfterMoves option.
.TP 8
.B Flip View
Inverts your view of the chess board for the duration of the current
game.  Starting a new game returns the board to normal.  

If you are
playing a game on the ICS, the board is always
oriented at the start of the game so that your 
pawns move from the bottom of the window towards the top.
Otherwise, the starting orientation is determined by the flipView command line
option; if it is False (the default), White's pawns move from bottom
to top at the start of each game; if it is True, Black's pawns move
from bottom to top.
.TP 8
.B Old Save Style
Toggles the oldSaveStyle option.
.TP 8
.B Quiet Play
Toggles the quietPlay option.
.TP 8
.B Show Coords
Toggles the showCoords option.
.TP 8
.B Show Thinking
Toggles the showThinking option.
.SH Help Menu
.TP 8
.B Hint
Displays a move hint from GNU Chess.  GNU Chess mode only.
.TP 8
.B Book
Displays a list of possible moves from GNU Chess's opening book.
The first column gives moves, the second column gives one possible response
for each move, and the third column shows the number of lines in the
book that include the move from the first column.  If you select this option
and nothing happens, GNU Chess is out of its book.  GNU Chess mode only.
.TP 8
.B About Game
Displays information about the current game, in the form of PGN 
(portable game notation) tags.
.TP 8
.B About XBoard
Shows the current 
.IR xboard
version number.
.SH Other shortcut keys
.TP 8
.B Iconize
Pressing the i or c key iconizes
.IR xboard .
The graphical icon displays a white knight if it is White's move, or a
black knight if it is Black's move.  If your X window manager displays only
text icons, not graphical ones, check its documentation; there is probably a
way to enable graphical icons.  If you are running the Motif window manager 
.IR mwm (1),
add these lines to your \&.Xdefaults file and restart mwm:
.EX 4
Mwm*iconDecoration: activelabel label image
Mwm*XBoard*iconImageBackground: White
Mwm*XBoard*iconImageForeground: Black
.EE
The first line above enables graphical icons in 
.IR mwm ;
you don't need it if you already have them.
The next two lines force the white knights to come out white and the black
knights black.  Unfortunately these resources can't be set from inside 
.IR xboard ;
you have to set them in your \&.Xdefaults.
.PP
You can add (or remove)
.IR xboard
shortcut keys
using the X resource 
.IR form.translations .
Here is an example of what would go in your \&.Xdefaults file:
.EX 4
XBoard*form.translations: Shift<Key>?: AboutGameProc() \\n \\
    <Key>y: AcceptProc() \\n \\
    <Key>n: DeclineProc() \\n \\
    <Key>i: NothingProc()
.EE
Binding a key to NothingProc makes it do nothing, thus removing it as a
shortcut key.
The 
.IR xboard
functions that can be bound to keys are: 
AbortProc,
AboutGameProc,
AboutProc,
AcceptProc,
AdjournProc,
AlwaysQueenProc,
AutoflagProc,
AutobsProc,
AutosaveProc,
BackwardProc,
BellProc,
BookProc,
CallFlagProc,
DeclineProc,
DrawProc,
EditGameProc,
EditPositionProc,
FlipViewProc,
ForwardProc,
HintProc,
IcsClientProc,
LoadGameProc,
LoadNextGameProc,
LoadPositionProc,
LoadPrevGameProc,
MachineBlackProc,
MachineWhiteProc,
MailMoveProc,
MoveNowProc,
OldSaveStyleProc,
PauseProc,
QuietPlayProc,
QuitProc,
ReloadGameProc,
ResetProc,
ResignProc,
RetractMoveProc,
RevertProc,
SaveGameProc,
SavePositionProc,
ShowCoordsProc,
ShowThinkingProc,
StopExaminingProc,
StopObservingProc,
ToEndProc,
ToStartProc,
TruncateGameProc, and
TwoMachinesProc.
.SH ENVIRONMENT
Game and position files
are found in the directory named by the CHESSDIR environment
variable.  If this variable is not set, the current working
directory is used.
If CHESSDIR is set,
.IR xboard
actually changes its working directory to $CHESSDIR, so GNU Chess listing
files will be stored there as well.
.SH SEE ALSO
.IR gnuchess (6),
.IR cmail (6).
.SH LIMITATIONS
There is no way for two people running copies of
.IR xboard
to play each other without going through the Internet Chess Server.  
.PP
The game parser recognizes only algebraic notation.
.PP
The internal move legality tester does not look at the game history,
so in some cases it misses illegal castling or en passant captures.
However, if you attempt such a move when using
GNU Chess (or the ICS), it will reject the move, and
.IR xboard
will undo it and let you try another.
Also, FEN positions saved by 
.IR xboard
do not include correct information about whether castling or en passant
are legal.
.PP
In ICS mode, 
.IR xboard
cannot handle observing (and/or playing) more than one game at
a time.  It may get confused if you try to do this, though it
tries to recover gracefully.  Select Reset from the File menu
if you have problems.
.PP
Your password may get echoed when you log on to the ICS.
.PP
If you are connecting to the ICS by running telnet on an Internet provider
or firewall host, you may find that each line you type is echoed back an extra
time after you hit Return.  If your Internet provider is a Unix system, you
can probably turn its echo off by typing "stty -echo" after you log in, and/or
by typing ^E-Return (control-E followed by the Return key) to the telnet
program after you have logged into ICS.  It is a good idea to do this if you
can, because otherwise the extra echo can occasionally confuse
.IR xboard 's
parsing routines.
.PP
The .icsrc file does not work properly when you 
connect to ICS through a Unix gateway host with useTelnet mode.
The Unix login process apparently discards type-ahead.
.PP
Some
.IR xboard
functions may not work with versions of GNU Chess earlier 
than 4.0, patchlevel 73. 
.SH AUTHORS AND CONTRIBUTORS
Tim Mann has been responsible for 
.IR xboard
versions 1.3 through 3.2.
Chris Sears and Dan Sears wrote the original 
.IR xboard ;
they were responsible for versions 1.0 through 1.2.
.PP
Elmar Bartel contributed the new piece bitmaps for version 3.2.
Evan Welsh wrote
.IR cmail.
John Chanak contributed the initial implementation of ICS mode.
The color scheme and the old 80x80 piece bitmaps were taken from
Wayne Christopher's 
.IR XChess
program.
.PP
Send bug reports to <bug-gnu-chess@prep.ai.mit.edu>.  Please use the
.IR script (1)
program to start a typescript, run
.IR xboard
with the debug option, and include the typescript output in your message.
Also tell us what kind of machine and what operating system version you are
using.  The command "uname -a" will usually tell you this.
.SH COPYRIGHT
Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
Enhancements Copyright 1992-95 Free Software Foundation, Inc.
.PP
XBoard's alternative piece bitmaps (bitmaps.xchess) are derived from the
bitmaps in the XChess program, which was written and is copyrighted by Wayne
Christopher. 
.PP
The following terms apply to Digital Equipment Corporation's copyright
interest in XBoard:
.PP
.RS
All Rights Reserved
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.PP
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
.RE
.PP
The following terms apply to this enhanced version of XBoard distributed
by the Free Software Foundation:
.PP
.RS
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.RE
