 
#ifndef lint
static char sccsid[] = "@(#)ball.c	3.11h 96/09/30 xlockmore";
 
#endif
 
/*-
 * ball.c - bouncing balls for xlock,
 *           the X Window System lockscreen.
 *
 * Copyright (c) 1995 by Heath Rice <rice@asl.dl.nec.com>.
 *
 * See xlock.c for copying information.
 *
 */

/*-
 * Bouncing balls kind of mode.  You can specify
 * the drawing function for the balls and the trail
 * left by the balls.  This one looks pretty cool
 * if you pick good functions.  You can also specify
 * specific colors or random.
 * Ooops, it seems that this no longer works.  It gives a blank screen for me.
 */

#include <signal.h>
#include <ctype.h>
#include <math.h>
#include <sys/time.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>

#include "xlock.h"

#define NONE	0		/* not in a window */
#define V	1		/* vertical */
#define H	2		/* horizontal */
#define B	3		/* ball */

#define MOUSEH	24
#define MOUSEW	24

#define DEFRAD	16		/* default diameter */
#define DEFNO	6
#define SPEED	156
#define SQLIMIT	(SPEED*SPEED/(30*30))	/* square of lower speed limit */
#define RATE    600

ModeSpecOpt ball_opts =
{0, NULL, 0, NULL, NULL};

static GC  *GcF, *GcB;
static XImage *wholescreen, *smallscreen;
static int  wholewidth, wholeheight;

static int  bounce = 85, size = 64, reqbg = 0, reqfg = 0, ballfnct = 0,
            trailfnct = 0;
static char *trailcolor = "random", *ballcolor = "random";
static unsigned long ballbg = 0, ballfg = 0;
static int  balln;
static int  dispx, dispy;
static int  inwin(int x, int y, int *n, int rad);
extern unsigned long allocPixel(Display * dpy, Colormap, char *, char *);

typedef struct ball_struct {
	int         x, y;	/* x and y coords */
	int         dx, dy;	/* x and y velocity */
	int         rad;
	int         bounce;
	int         dyold;
	int         started;
	int         def;
} BALL;

static BALL *bp;

static void
BallsColors(Display * dpy, Colormap cmap)
{
	if (strcmp(ballcolor, "random")) {
		reqfg = 1;
		ballfg = allocPixel(dpy, cmap, ballcolor, "White");
	}
	if (strcmp(trailcolor, "random")) {
		reqbg = 1;
		ballbg = allocPixel(dpy, cmap, trailcolor, "Black");
	}
}

static void
getsmallscreen(ModeInfo * mi)
{
	unsigned long pix;
	int         x, y, x_inc, y_inc;

	if (smallscreen == NULL) {
		smallscreen = XGetImage(MI_DISPLAY(mi), MI_WINDOW(mi),
				     0, 0, dispx, dispy, AllPlanes, ZPixmap);
	}
	x_inc = wholewidth / dispx;
	y_inc = wholeheight / dispy;

	for (x = 0; x < dispx; x++) {
		for (y = 0; y < dispy; y++) {
			pix = XGetPixel(wholescreen, x * x_inc, y * y_inc);
			XPutPixel(smallscreen, x, y, pix);
		}
	}
}


static void
collided(ModeInfo * mi, int i, int n, int *dx, int *dy, int td)
{
	int         rx1, ry1, rx2, ry2;
	int         Vx1, Vy1, Vx2, Vy2;
	int         NVx1, NVy1, NVx2, NVy2;

	float       Ux1, Uy1, Ux2, Uy2;
	float       mag1, mag2, imp;

	rx1 = bp[i].x;
	ry1 = bp[i].y;
	Vx1 = bp[i].dx;
	Vy1 = bp[i].dy;

	rx2 = bp[n].x;
	ry2 = bp[n].y;
	Vx2 = bp[n].dx;
	Vy2 = bp[n].dy;

	Ux1 = rx1 - rx2;
	Uy1 = ry1 - ry2;
	mag1 = sqrt(((Ux1 * Ux1) + (Uy1 * Uy1)));
	Ux1 = Ux1 / mag1;
	Uy1 = Uy1 / mag1;

	Ux2 = rx2 - rx1;
	Uy2 = ry2 - ry1;
	mag2 = sqrt(((Ux2 * Ux2) + (Uy2 * Uy2)));
	Ux2 = Ux2 / mag2;
	Uy2 = Uy2 / mag2;

	imp = ((Vx1 * Ux2) + (Vy1 * Uy2)) + ((Vx2 * Ux1) + (Vy2 * Uy1));

	NVx1 = Vx1 + (int) (imp * Ux1);
	NVy1 = Vy1 + (int) (imp * Uy1);

	NVx2 = Vx2 + (int) (imp * Ux2);
	NVy2 = Vy2 + (int) (imp * Uy2);

	bp[i].dx = NVx1;
	bp[i].dy = NVy1;

	bp[n].dx = NVx2;
	bp[n].dy = NVy2;

	XFillArc(MI_DISPLAY(mi), MI_WINDOW(mi), GcB[n],
		 bp[n].x - (bp[n].rad / 2), bp[n].y - (bp[n].rad / 2),
		 bp[n].rad, bp[n].rad, 0, 360 * 64);
	if (dispx > 100) {
		*dx = (td * bp[n].dx) / RATE;
		*dy = (td * bp[n].dy) / RATE;
	} else {
		*dx = (td * bp[n].dx) / 150;
		*dy = (td * bp[n].dy) / 150;
	}

	bp[n].x += (*dx / 2);
	bp[n].y += (*dy / 2);
	XFillArc(MI_DISPLAY(mi), MI_WINDOW(mi), GcF[n],
		 bp[n].x - (bp[n].rad / 2), bp[n].y - (bp[n].rad / 2),
		 bp[n].rad, bp[n].rad, 0, 360 * 64);

	if (dispx > 100) {
		*dx = (td * bp[i].dx) / RATE;
		*dy = (td * bp[i].dy) / RATE;
	} else {
		*dx = (td * bp[i].dx) / 150;
		*dy = (td * bp[i].dy) / 150;
	}

	bp[i].x += (*dx / 2);
	bp[i].y += (*dy / 2);
}

static void
randomball(ModeInfo * mi, int i)
{
	Display    *display = MI_DISPLAY(mi);
	int         x, y, bn;
	int         dum;
	int         attempts;
	unsigned long randbg = 1;

	attempts = 0;
	if (bounce == -2)
		bn = 30 + NRAND(69L);
	else
		bn = bounce;

	if (bn > 100)
		bn = 100;
	if (bn < 0)
		bn = 0;
	bn = (0 - bn);

	if (dispx > 100) {
		bp[i].dx = NRAND(2L * SPEED) + SPEED;
		bp[i].dy = NRAND(2L * SPEED) + (SPEED / 2);
	} else {
		bp[i].dx = NRAND(4L * SPEED) + (SPEED / 20);
		bp[i].dy = NRAND(2L * SPEED) + (SPEED / 40);
	}

	switch (NRAND(9L) % 2) {
		case 0:
			break;
		case 1:
			bp[i].dx = (0 - bp[i].dx);
			break;
	}

	if (dispx > 100) {
		bp[i].rad = size;
		if (bp[i].rad > 200)
			bp[i].rad = DEFRAD;
		if (bp[i].rad <= 0)
			bp[i].rad = DEFRAD;
	} else {
		bp[i].rad = 4;
	}

	bp[i].bounce = bn;
	bp[i].dyold = 0;

	do {
		dum = i;
		x = NRAND((long) dispx);
		y = 0;
		attempts++;
		if (attempts > 5) {
			bp[i].def = 0;
			return;
		}
	}

	while ((inwin(x, y, &dum, bp[i].rad) != NONE) ||
	       (inwin(bp[i].dx + x, bp[i].dy + y, &dum, bp[i].rad) != NONE));

	bp[i].def = 1;
	bp[i].x = x;
	bp[i].y = y;

	/* set background color for ball */

	if (MI_NPIXELS(mi) > 2 && (!reqbg)) {
		randbg = MI_PIXEL(mi, NRAND(MI_NPIXELS(mi)));
	} else if (MI_NPIXELS(mi) <= 2) {
		randbg = (unsigned long) MI_WIN_BLACK_PIXEL(mi);
	} else if (reqbg) {
		randbg = ballbg;
	}
	XSetForeground(display, GcB[i], randbg);

	/* set foreground color for ball */

	if (MI_NPIXELS(mi) > 2 && (!reqfg)) {
		randbg = MI_PIXEL(mi, NRAND(MI_NPIXELS(mi)));
	} else if (MI_NPIXELS(mi) <= 2) {
		randbg = (unsigned long) MI_WIN_WHITE_PIXEL(mi);
	} else if (reqfg) {
		randbg = ballfg;
	}
	XSetForeground(display, GcF[i], randbg);

	XFillArc(display, MI_WINDOW(mi),
		 GcB[i], bp[i].x - (bp[i].rad / 2), bp[i].y - (bp[i].rad / 2),
		 bp[i].rad, bp[i].rad, 0, 360 * 64);
}

static int
inwin(int x, int y, int *n, int rad)
{
	int         i, diffx, diffy;

	if ((x < 0) || (x > dispx)) {
		return (V);
	}
	if ((y < 0) || (y > dispy)) {
		return (H);
	}
	if (dispx > 100) {
		for (i = 0; i < balln; i++) {
			if ((i == (*n)) || (!bp[i].def))
				continue;
			diffx = (bp[i].x - x);
			diffy = (bp[i].y - y);
			if ((diffx * diffx + diffy * diffy) <
			    (((rad / 2) * (rad / 2) * 2) +
			     ((bp[i].rad / 2) * (bp[i].rad / 2) * 2))) {
				(*n) = i;
				return (B);
			}
		}
	}
	return (NONE);
}

void
draw_ball(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);
	int         i, n;
	int         td;
	int         dx, dy;
	int         redo;

	td = 10;

	for (i = 0; i < balln; i++) {
		if (!bp[i].def)
			randomball(mi, i);
	}

	for (i = 0; i < balln; i++) {
		if (!bp[i].def) {
			continue;
		}
		XFillArc(display, window, GcB[i],
			 bp[i].x - (bp[i].rad / 2), bp[i].y - (bp[i].rad / 2),
			 bp[i].rad, bp[i].rad, 0, 360 * 64);
		redo = 0;
		if (((bp[i].dx * bp[i].dx + bp[i].dy * bp[i].dy) < SQLIMIT) && (bp[i].y >= (dispy - 3))) {
			redo = 25;
		}
		do {
			if (dispx > 100) {
				dx = (td * bp[i].dx) / RATE;
				dy = (td * bp[i].dy) / RATE;
			} else {
				dx = (td * bp[i].dx) / 150;
				dy = (td * bp[i].dy) / 150;
			}

			if (redo > 5) {
				redo = 0;
				randomball(mi, i);
				if (!bp[i].def)
					continue;
				XFillArc(display, window, GcF[i],
					 bp[i].x - (bp[i].rad / 2), bp[i].y - (bp[i].rad / 2),
					 bp[i].rad, bp[i].rad, 0, 360 * 64);
			}
			n = i;
			switch (inwin(dx + bp[i].x, dy + bp[i].y, &n, bp[i].rad)) {
				case NONE:
					bp[i].x += dx;
					bp[i].y += dy;
					redo = 0;
					break;
				case V:
					bp[i].dx = (int) (((float) bp[i].bounce * (float) bp[i].dx) / (float) 100);
					redo++;
					break;
				case H:
					bp[i].dy = (int) (((float) bp[i].bounce * (float) bp[i].dy) / (float) 100);
					if (bp[i].bounce != 100) {
						if ((bp[i].y >= (dispy - 3)) && (bp[i].dy > -250) && (bp[i].dy < 0)) {
							redo = 15;
						}
						if ((bp[i].y >= (dispy - 3)) && (bp[i].dy == bp[i].dyold)) {
							redo = 10;
						}
						bp[i].dyold = bp[i].dy;
					}
					redo++;
					break;
				case B:
					if (redo > 5) {
						if (bp[i].y >= (dispy - 3)) {
							randomball(mi, i);
							redo = 0;
						} else if (bp[n].y >= (dispy - 3)) {
							randomball(mi, n);
							redo = 0;
						} else
							redo = 0;
					} else {
						collided(mi, i, n, &dx, &dy, td);
						redo = 0;
					}
					break;
			}
		}
		while (redo);
		bp[i].dy += td;

		if (bp[i].def)
			XFillArc(display, window, GcF[i],
			bp[i].x - (bp[i].rad / 2), bp[i].y - (bp[i].rad / 2),
				 bp[i].rad, bp[i].rad, 0, 360 * 64);
	}

	XFlush(display);
}

void
init_ball(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	Window      window = MI_WINDOW(mi);
	int         i;
	int         GcLp;
	Screen     *scr = ScreenOfDisplay(display, MI_SCREEN(mi));
	Colormap    cmap = DefaultColormapOfScreen(scr);

	BallsColors(display, cmap);

	balln = MI_BATCHCOUNT(mi);
	if (balln > 20)
		balln = DEFNO;
	if (balln <= 0)
		balln = DEFNO;

	if (bp == NULL) {
		bp = (BALL *) malloc(sizeof (BALL) * balln);
		if (bp == NULL) {
			(void) fprintf(stderr,
			"Failed to malloc %d bytes\n", sizeof (BALL) * balln);
			exit(1);
		}
	}
	/* clearballs */
	XClearWindow(display, window);
	XFlush(display);

	if (balln == 0)
		exit(0);

	if (GcB == NULL) {
		GcB = (GC *) malloc(sizeof (GC) * balln);
		if (GcB == NULL) {
			(void) fprintf(stderr,
				       "Failed to malloc %d bytes for GcB\n", sizeof (GcB) * balln);
			exit(1);
		}
		GcF = (GC *) malloc(sizeof (GC) * balln);
		if (GcF == NULL) {
			(void) fprintf(stderr,
				       "Failed to malloc %d bytes for GcF\n", sizeof (GcF) * balln);
			exit(1);
		}
		for (GcLp = 0; GcLp < balln; GcLp++) {
			GcB[GcLp] = XCreateGC(display, window, 0L, (XGCValues *) 0);
			if ((trailfnct >= 0) && (trailfnct <= 15))
				XSetFunction(display, GcB[GcLp], trailfnct);

			GcF[GcLp] = XCreateGC(display, window, 0L, (XGCValues *) 0);
			if ((ballfnct >= 0) && (ballfnct <= 15))
				XSetFunction(display, GcF[GcLp], ballfnct);
		}
	}
	dispx = MI_WIN_WIDTH(mi);
	dispy = MI_WIN_HEIGHT(mi);

	if (wholescreen == NULL) {
		wholescreen = XGetImage(display, window, 0, 0, dispx, dispy, AllPlanes, ZPixmap);
		wholewidth = dispx;
		wholeheight = dispy;
	} else {
		if (dispx > 100) {
			XPutImage(display, window, MI_GC(mi), wholescreen, 0, 0, 0, 0, dispx, dispy);
		} else {
			if (smallscreen == NULL)
				getsmallscreen(mi);
			XPutImage(display, window, MI_GC(mi), smallscreen, 0, 0, 0, 0, dispx, dispy);
		}
	}

	XFlush(display);
	for (i = 0; i < balln; i++) {
		randomball(mi, i);
	}
}

void
release_ball(ModeInfo * mi)
{
}
