#include <rpc/types.h>
#include <rpc/xdr.h>
#include <rpcsvc/yp_prot.h>

bool_t
xdr_domainname_ypbind(XDR *xdrs, char *objp)
{
  if (!xdr_string(xdrs, &objp, YPMAXDOMAIN))
    {
      return (FALSE);
    }
  return (TRUE);
}

bool_t
xdr_ypbind_resptype(XDR *xdrs, enum ypbind_resptype *objp)
{
  if (!xdr_enum(xdrs, (enum_t *)objp))
    {
      return (FALSE);
    }
  return (TRUE);
}

bool_t
xdr_ypbind_binding(XDR *xdrs, struct ypbind_binding *objp)
{
  if (!xdr_opaque(xdrs, (caddr_t) &objp->ypbind_binding_addr, 4))
    {
      return (FALSE);
    }
  if (!xdr_opaque(xdrs, (caddr_t) &objp->ypbind_binding_port, 2))
    {
      return (FALSE);
    }
  return (TRUE);
}

bool_t
xdr_ypbind_resp(XDR *xdrs, struct ypbind_resp *objp)
{
  if (!xdr_ypbind_resptype(xdrs, &objp->ypbind_status))
    {
      return (FALSE);
    }
  switch (objp->ypbind_status) {
  case YPBIND_FAIL_VAL:
    if (!xdr_u_long(xdrs, &objp->ypbind_respbody.ypbind_error))
      {
        return (FALSE);
      }
    break;
  case YPBIND_SUCC_VAL:
    if (!xdr_ypbind_binding(xdrs, &objp->ypbind_respbody.ypbind_bindinfo))
      {
        return (FALSE);
      }
    break;
  default:
    return (FALSE);
  }
  return (TRUE);
}

bool_t
xdr_ypbind_setdom(XDR *xdrs, struct ypbind_setdom *objp)
{
  if (!xdr_domainname_ypbind(xdrs, objp->ypsetdom_domain))
    {
      return (FALSE);
    }
  if (!xdr_ypbind_binding(xdrs, &objp->ypsetdom_binding))
    {
      return (FALSE);
    }
  if (!xdr_u_short(xdrs, &objp->ypsetdom_vers))
    {
      return (FALSE);
    }
  return (TRUE);
}
