/*
 *  mem_op.h 1.2 1996/06/10 16:12:51 (David Hinds)
 */

#ifndef _LINUX_MEM_OP_H
#define _LINUX_MEM_OP_H

/*
   If UNSAFE_MEMCPY is defined, we use the (optimized) system routines
   to copy between a card and kernel memory.  These routines do 32-bit
   operations which may not work with all PCMCIA controllers.  The
   safe versions defined here will do only 8-bit and 16-bit accesses.
*/

#ifdef UNSAFE_MEMCPY

#define memcpy_frompc memcpy_fromio
#define memcpy_topc memcpy_toio

extern inline void memcpy_frompc_tofs(void *to, const void *from, size_t n)
{
    size_t odd = (n & 3);
    n -= odd;
    while (n) {
	put_fs_long(readl(from), to);
	from += 4; to += 4; n -= 4;
    }
    while (odd--)
	put_fs_byte(readb(from++), to++);
}

extern inline void memcpy_fromfs_topc(void *to, const void *from, size_t n)
{
    size_t odd = (n & 3);
    n -= odd;
    while (n) {
	writel(get_fs_long(from), to);
	to += 4; from += 4; n -= 4;
    }
    while (odd--)
	writeb(get_fs_byte(from++), to++);
}

#else /* UNSAFE_MEMCPY */

extern inline void memcpy_frompc(void *to, const void *from, size_t n)
{
    size_t odd = (n & 1);
    n -= odd;
    while (n) {
	*(u_short *)to = readw(from);
	to += 2; from += 2; n -= 2;
    }
    if (odd)
	*(u_char *)to = readb(from);
}

extern inline void memcpy_topc(void *to, const void *from, size_t n)
{
    size_t odd = (n & 1);
    n -= odd;
    while (n) {
	writew(*(u_short *)from, to);
	to += 2; from += 2; n -= 2;
    }
    if (odd)
	writeb(*(u_char *)from, to);
}

extern inline void memcpy_frompc_tofs(void *to, const void *from, size_t n)
{
    size_t odd = (n & 1);
    n -= odd;
    while (n) {
	put_fs_word(readw(from), to);
	to += 2; from += 2; n -= 2;
    }
    if (odd)
	put_fs_byte(readb(from), to);
}

extern inline void memcpy_fromfs_topc(void *to, const void *from, size_t n)
{
    size_t odd = (n & 1);
    n -= odd;
    while (n) {
	writew(get_fs_word(from), to);
	to += 2; from += 2; n -= 2;
    }
    if (odd)
	writeb(get_fs_byte(from), to);
}

#endif /* UNSAFE_MEMCPY */

#endif /* _LINUX_MEM_OP_H */
