#include <stdio.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/************************************************************************
 *
 * Function:    setbuf
 *
 * Description:
 *    Ensure that the file has a buffer when one is needed. This function
 *    is obsolete, even for iBCS. You should use setvbuf which allows for
 *    a buffer of a size other than BUFSIZ.
 *
 * Entry:
 *    stream    - Pointer to the file stream
 *    pvBuffer  - Pointer to the buffer of BUFSIZ or NULL for unbuffered.
 *
 * Returns:
 *    none.
 */

void setbuf (FILE *stream, void *pvBuffer)
    {
    FUNC_ENTRY ("setbuf");
/*
 *  Flush the buffer and release the previous buffer data.
 */
    fflush   (stream);
    _freebuf (stream);
/*
 *  If the file is unbuffered then reset the indicator flags
 */
    stream->_flag &= ~(_IOFREEBF | _IONBF);
    if (!pvBuffer)
        {
        stream->_flag   |= _IONBF;
        stream->_ptr     =
	stream->_base    = NULL;
        set_buf_size(stream, 0);
        }
/*
 *  There is a buffer for the file.
 */
    else
        {
        _cflush++;  /* force library pre-termination procedure */
        stream->_ptr      =
        stream->_base     = pvBuffer;
        set_buf_size(stream, BUFSIZ);
        }
/*
 *  Reset the count of characters in the buffers and return.
 */
    stream->_cnt = 0;
    FUNC_EXIT ("setbuf");
    }
