#include <sys/stat.h>
#include <stdlib.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <dirent.h>

/*
 * opendir just makes an open() call - it return NULL if it fails
 * (open sets errno), otherwise it returns a DIR * pointer.
 */
DIR * _opendir(const char * name)
{
  int fd;
  struct stat statbuf;
  struct dirent *buf;
  DIR *ptr;

  if (stat(name,&statbuf)) return NULL;
  if (!S_ISDIR(statbuf.st_mode)) {
    errno = ENOTDIR;
    return NULL;
  }
  if ((fd = _open(name,O_RDONLY)) < 0)
    return NULL;
  /* According to POSIX, directory streams should be closed when
   * exec. From "Anna Pluzhnikov" <besp@midway.uchicago.edu>.
   */
  if (_fcntl(fd, F_SETFD, FD_CLOEXEC) < 0)
    return NULL;
  if (!(ptr=malloc(sizeof(*ptr)))) {
    _close(fd);
    errno = ENOMEM;
    return NULL;
  }
  if (!(buf=malloc(DIRBUF))) {
    _close(fd);
    free(ptr);
    errno = ENOMEM;
    return NULL;
  }
  ptr->dd_fd = fd;
  ptr->dd_loc = ptr->dd_size = 0;
  ptr->dd_buf = (char *) buf;
  return ptr;
}

#ifdef ELF_LIBRARY
__asm__(".weak opendir; opendir = _opendir");
#endif
