#! /bin/csh -f
#
# Fig2ps2tex - generate a TeX file for including a PostScript file
#		 involves calculating the bounding box from fig2ps output
#
set bbox = `grep "^%%BoundingBox:" $1`

set xsp = `echo "3k $bbox[4] $bbox[2] - 72 / p" | dc`
set ysp = `echo "3k $bbox[5] $bbox[3] - 72 / p" | dc`

echo "\makebox[${xsp}in][l]{"
echo "  \vbox to ${ysp}in{"
echo "    \vfill"
echo "    \special{psfile=$1}"
echo "  }"
echo "  \vspace{-\baselineskip}"
echo "}"
