
NAME:
	setstatus - set the lpq status message

SYNOPSIS:
	setstatus 'printer' ``'message'''

DESCRIPTION:
    	This tool is part of the Public Line Printer spooler system (PLP).
	It is used to set the status of a printer from outside
	the Line Printer spooler system; for example, in response to
	a "syslog"(8) message.

	When an "lpq" command is issued, this printer's status file will
	be read, and the message therein will be displayed.

	The "printer" argument is the name of a printer described in
	the "printcap"(5) file.

	The "message" argument will be placed into this printer's status
	file.

	It is not necessary to run this command on the queue's server
	host; as long as "setstatus" can write to the status file as
	the daemon user, and can read the appropriate printcap file,
	this will work.

EXAMPLE:
	The HP 4Mplus printer "exception" is set up to log its error
	messages, via syslog, to the UNIX machine, "overload".

	"overload" has a perl script which follows /var/log/notice
	(the syslog output file; see "syslog.conf"(5)), using
	``tail -f''; this script contains the following perl block:
.KF
.DT
.in +1i
.L
.SM
.nf

	    if (/ exception  printer: (.*) *$/) {
		system ("setstatus hp4m-ps \"$1.\"");
	    }
.LG
.in -1i
.KE
.PP
	Now, whenever a diagnostic is received from the printer, it
	will be available to users of "lpq".

FILES:
.nf
	/etc/printcap       to determine printer characteristics
	/var/spool/*        the spooling directory
	/var/spool/*/status the status file, as read by `lpq'
.fi

SEE ALSO:
.nf
	lpq(1), lpd(8), printcap(5)
.fi
	PLP - The Public Line Printer Spooler , by  Patrick  Powell,
	San Diego State University, et al.

HISTORY:
	PLP is a reverse engineered version of the  Berkeley  4.3BSD
	Line  Printer Spooler system. It has many advanced features,
	which are described in PLP - The Public Line Printer Spooler
	by Patrick Powell, San Diego State University
	(papowell@sdsu.edu), et al.

